/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.sf.amateras.mirage.annotation.Transient;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.exception.BeanDescException;
import jp.sf.amateras.mirage.util.ReflectionUtil;

public class PropertyDescImpl
implements PropertyDesc {
    private BeanDesc parent;
    private String name;
    private Class<?> type;
    private Method getterMethod;
    private Method setterMethod;
    private Field field;

    public PropertyDescImpl(BeanDesc parent, String name, Class<?> type, Field field, Method getterMethod, Method setterMethod) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.field = field;
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
    }

    @Override
    public Object getValue(Object obj) {
        try {
            if (this.getterMethod != null) {
                return this.getterMethod.invoke(obj, (Object[])null);
            }
            return this.field.get(obj);
        }
        catch (Exception ex) {
            throw new BeanDescException(ex);
        }
    }

    @Override
    public void setValue(Object obj, Object value) {
        try {
            if (this.setterMethod != null) {
                this.setterMethod.invoke(obj, value);
            } else {
                this.field.set(obj, value);
            }
        }
        catch (Exception ex) {
            throw new BeanDescException(ex);
        }
    }

    @Override
    public boolean isReadable() {
        return this.getterMethod != null || this.field != null;
    }

    @Override
    public boolean isWritable() {
        return this.setterMethod != null || this.field != null;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.type;
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        Field field;
        T ann = null;
        if (this.field != null) {
            ann = this.field.getAnnotation(type);
        }
        if (ann == null && this.setterMethod != null) {
            ann = this.setterMethod.getAnnotation(type);
        }
        if (ann == null && this.getterMethod != null) {
            ann = this.getterMethod.getAnnotation(type);
        }
        if (ann == null && this.field == null && (field = ReflectionUtil.getField(this.parent.getType(), this.getPropertyName())) != null) {
            ann = field.getAnnotation(type);
        }
        return ann;
    }

    @Override
    public boolean isTransient() {
        Transient ann = this.getAnnotation(Transient.class);
        if (ann != null) {
            return true;
        }
        if (this.field != null) {
            return Modifier.isTransient(this.field.getModifiers());
        }
        Field field = ReflectionUtil.getField(this.parent.getType(), this.getPropertyName());
        if (field != null) {
            return Modifier.isTransient(field.getModifiers());
        }
        return false;
    }
}

