/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.exception.SQLRuntimeException;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.JdbcUtil;

public class SqlExecutor {
    private static final Logger logger = Logger.getLogger(SqlExecutor.class.getName());
    private NameConverter nameConverter;
    private ConnectionProvider connectionProvider;
    private List<ValueType> valueTypes = new ArrayList<ValueType>();

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void addValueType(ValueType valueType) {
        this.valueTypes.add(valueType);
    }

    private static void printParameters(Object[] params) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            logger.info(String.format("params[%d]=%s", i, params[i]));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> getResultList(Class<T> clazz, String sql, Object[] params) {
        ArrayList<T> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            ArrayList<T> list = new ArrayList<T>();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
            while (rs.next()) {
                T entity = this.createEntity(clazz, rs, meta, columnCount, beanDesc);
                list.add(entity);
            }
            arrayList = list;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
                catch (RuntimeException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getSingleResult(Class<T> clazz, String sql, Object[] params) throws SQLRuntimeException {
        T t;
        ResultSet rs;
        PreparedStatement stmt;
        block8: {
            T entity;
            stmt = null;
            rs = null;
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
            if (!rs.next()) break block8;
            T t2 = entity = this.createEntity(clazz, rs, meta, columnCount, beanDesc);
            JdbcUtil.close(rs);
            JdbcUtil.close(stmt);
            return t2;
        }
        try {
            t = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
                catch (RuntimeException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return t;
    }

    public int executeUpdateSql(String sql, Object[] params) throws SQLRuntimeException {
        int n;
        PreparedStatement stmt = null;
        try {
            int result;
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                SqlExecutor.printParameters(params);
            }
            stmt = conn.prepareStatement(sql);
            this.setParameters(stmt, params);
            n = result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return n;
    }

    protected void setParameters(PreparedStatement stmt, Object[] vars) throws SQLException {
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) {
                stmt.setObject(i + 1, null);
                continue;
            }
            Class<?> varType = vars[i].getClass();
            for (ValueType valueType : this.valueTypes) {
                if (!valueType.isSupport(varType)) continue;
                valueType.set(varType, stmt, vars[i], i + 1);
            }
        }
    }

    protected <T> T createEntity(Class<T> clazz, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc) throws InstantiationException, IllegalAccessException, SQLException {
        for (ValueType valueType : this.valueTypes) {
            if (!valueType.isSupport(clazz)) continue;
            return (T)valueType.get(clazz, rs, 1);
        }
        HashMap entity = null;
        entity = clazz == Map.class ? new HashMap() : (HashMap)clazz.newInstance();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = meta.getColumnName(i + 1);
            String propertyName = this.nameConverter.columnToProperty(columnName);
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            if (pd == null) continue;
            Class<?> fieldType = pd.getPropertyType();
            for (ValueType valueType : this.valueTypes) {
                if (!valueType.isSupport(fieldType)) continue;
                pd.setValue(entity, valueType.get(fieldType, rs, columnName));
            }
        }
        return (T)entity;
    }
}

