/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.GroupRequest;
import tk.eclipse.plugin.jsf.editors.ConnectoinBendpoint;
import tk.eclipse.plugin.jsf.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.jsf.editors.models.AbstractModel;

public abstract class AbstractNavigationConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new NavigationBendpointEditPolicy());
    }

    public void activate() {
        super.activate();
        ((AbstractModel)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ((AbstractModel)this.getModel()).removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class BendpointCommand
    extends Command {
        protected int index = 0;
        protected Point location = null;
        protected AbstractConnectionModel connectionModel = null;
        private Dimension d1 = null;
        private Dimension d2 = null;

        private BendpointCommand() {
        }

        protected Dimension getFirstRelativeDimension() {
            return this.d1;
        }

        protected Dimension getSecondRelativeDimension() {
            return this.d2;
        }

        protected int getIndex() {
            return this.index;
        }

        protected Point getLocation() {
            return this.location;
        }

        protected AbstractConnectionModel getConnectionModel() {
            return this.connectionModel;
        }

        public void redo() {
            this.execute();
        }

        public void setRelativeDimensions(Dimension dim1, Dimension dim2) {
            this.d1 = dim1;
            this.d2 = dim2;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void setLocation(Point p) {
            this.location = p;
        }

        public void setConnectionModel(AbstractConnectionModel connection) {
            this.connectionModel = connection;
        }
    }

    private class CreateBendpointCommand
    extends BendpointCommand {
        private CreateBendpointCommand() {
        }

        public void execute() {
            ConnectoinBendpoint rbp = new ConnectoinBendpoint(this.getFirstRelativeDimension(), this.getSecondRelativeDimension());
            this.getConnectionModel().addBendpoint(this.getIndex(), rbp);
            super.execute();
        }

        public void undo() {
            super.undo();
            this.getConnectionModel().removeBendpoint(this.getIndex());
        }
    }

    private class DeleteBendpointCommand
    extends BendpointCommand {
        private ConnectoinBendpoint bendpoint = null;

        private DeleteBendpointCommand() {
        }

        public void execute() {
            this.bendpoint = (ConnectoinBendpoint)this.getConnectionModel().getBendpoints().get(this.getIndex());
            this.getConnectionModel().removeBendpoint(this.getIndex());
            super.execute();
        }

        public void undo() {
            super.undo();
            this.getConnectionModel().addBendpoint(this.getIndex(), this.bendpoint);
        }
    }

    private class DeleteCommand
    extends Command {
        private AbstractConnectionModel model;

        private DeleteCommand() {
        }

        public void setModel(AbstractConnectionModel model) {
            this.model = model;
        }

        public void execute() {
            this.model.detachSource();
            this.model.detachTarget();
        }

        public void undo() {
            this.model.attachSource();
            this.model.attachTarget();
        }
    }

    private class EntityComponentEditPolicy
    extends ComponentEditPolicy {
        private EntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setModel((AbstractConnectionModel)AbstractNavigationConnectionEditPart.this.getModel());
            return command;
        }
    }

    private class MoveBendpointCommand
    extends BendpointCommand {
        private ConnectoinBendpoint oldBendpoint = null;

        private MoveBendpointCommand() {
        }

        public void execute() {
            ConnectoinBendpoint bp = new ConnectoinBendpoint(this.getFirstRelativeDimension(), this.getSecondRelativeDimension());
            this.setOldBendpoint((ConnectoinBendpoint)this.getConnectionModel().getBendpoints().get(this.getIndex()));
            this.getConnectionModel().replaceBendpoint(this.getIndex(), bp);
            super.execute();
        }

        protected ConnectoinBendpoint getOldBendpoint() {
            return this.oldBendpoint;
        }

        public void setOldBendpoint(ConnectoinBendpoint bp) {
            this.oldBendpoint = bp;
        }

        public void undo() {
            super.undo();
            this.getConnectionModel().replaceBendpoint(this.getIndex(), this.getOldBendpoint());
        }
    }

    private class NavigationBendpointEditPolicy
    extends BendpointEditPolicy {
        private NavigationBendpointEditPolicy() {
        }

        protected Command getCreateBendpointCommand(BendpointRequest request) {
            CreateBendpointCommand command = new CreateBendpointCommand();
            Point p = request.getLocation();
            Connection conn = this.getConnection();
            conn.translateToRelative((Translatable)p);
            command.setLocation(p);
            Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
            Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)ref1);
            conn.translateToRelative((Translatable)ref2);
            command.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
            command.setConnectionModel((AbstractConnectionModel)request.getSource().getModel());
            command.setIndex(request.getIndex());
            return command;
        }

        protected Command getDeleteBendpointCommand(BendpointRequest request) {
            DeleteBendpointCommand command = new DeleteBendpointCommand();
            Point p = request.getLocation();
            command.setLocation(p);
            command.setConnectionModel((AbstractConnectionModel)request.getSource().getModel());
            command.setIndex(request.getIndex());
            return command;
        }

        protected Command getMoveBendpointCommand(BendpointRequest request) {
            MoveBendpointCommand command = new MoveBendpointCommand();
            Point p = request.getLocation();
            Connection conn = this.getConnection();
            conn.translateToRelative((Translatable)p);
            command.setLocation(p);
            Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
            Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)ref1);
            conn.translateToRelative((Translatable)ref2);
            command.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
            command.setConnectionModel((AbstractConnectionModel)request.getSource().getModel());
            command.setIndex(request.getIndex());
            return command;
        }
    }
}

