/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractNavigationEditPart;
import tk.eclipse.plugin.jsf.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.jsf.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.jsf.editors.models.AbstractModel;
import tk.eclipse.plugin.jsf.editors.models.RootModel;

public abstract class AbstractEntityEditPart
extends AbstractNavigationEditPart
implements NodeEditPart {
    private IFile file;

    public AbstractEntityEditPart(IFile file) {
        this.file = file;
    }

    protected IFile getFile() {
        return this.file;
    }

    protected void refreshVisuals() {
        Object model = this.getModel();
        if (model instanceof AbstractEntityModel) {
            Rectangle constraint = ((AbstractEntityModel)model).getConstraint();
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeEditPolicy());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_constraint")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("_source_connection")) {
            this.refreshSourceConnections();
        } else if (evt.getPropertyName().equals("_target_connection")) {
            this.refreshTargetConnections();
        }
    }

    protected List getModelSourceConnections() {
        return ((AbstractEntityModel)this.getModel()).getModelSourceConnections();
    }

    protected List getModelTargetConnections() {
        return ((AbstractEntityModel)this.getModel()).getModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    private class CreateConnectionCommand
    extends Command {
        private AbstractEntityModel source;
        private AbstractEntityModel target;
        private AbstractConnectionModel connection;

        private CreateConnectionCommand() {
        }

        public AbstractConnectionModel getConnectionModel() {
            return this.connection;
        }

        public boolean canExecute() {
            return this.source != null && this.target != null;
        }

        public void execute() {
            this.connection.attachSource();
            this.connection.attachTarget();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractConnectionModel)model;
        }

        public void setSource(Object model) {
            this.source = (AbstractEntityModel)model;
            this.connection.setSource(this.source);
        }

        public void setTarget(Object model) {
            this.target = (AbstractEntityModel)model;
            this.connection.setTarget(this.target);
        }

        public void undo() {
            this.connection.detachSource();
            this.connection.detachTarget();
        }
    }

    private class DeleteCommand
    extends Command {
        private RootModel root;
        private AbstractModel model;
        private List sourceConnections = new ArrayList();
        private List targetConnections = new ArrayList();

        private DeleteCommand() {
        }

        public void execute() {
            AbstractConnectionModel model;
            this.sourceConnections.addAll(((AbstractEntityModel)this.model).getModelSourceConnections());
            this.targetConnections.addAll(((AbstractEntityModel)this.model).getModelTargetConnections());
            int i = 0;
            while (i < this.sourceConnections.size()) {
                model = (AbstractConnectionModel)this.sourceConnections.get(i);
                model.detachSource();
                model.detachTarget();
                ++i;
            }
            i = 0;
            while (i < this.targetConnections.size()) {
                model = (AbstractConnectionModel)this.targetConnections.get(i);
                model.detachSource();
                model.detachTarget();
                ++i;
            }
            this.root.removeChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setTargetModel(Object model) {
            this.model = (AbstractModel)model;
        }

        public void undo() {
            AbstractConnectionModel model;
            this.root.addChild(this.model);
            int i = 0;
            while (i < this.sourceConnections.size()) {
                model = (AbstractConnectionModel)this.sourceConnections.get(i);
                model.attachSource();
                model.attachTarget();
                ++i;
            }
            i = 0;
            while (i < this.targetConnections.size()) {
                model = (AbstractConnectionModel)this.targetConnections.get(i);
                model.attachSource();
                model.attachTarget();
                ++i;
            }
            this.sourceConnections.clear();
            this.targetConnections.clear();
        }
    }

    private class EntityComponentEditPolicy
    extends ComponentEditPolicy {
        private EntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setRootModel(this.getHost().getParent().getModel());
            command.setTargetModel(this.getHost().getModel());
            return command;
        }
    }

    private class NodeEditPolicy
    extends GraphicalNodeEditPolicy {
        private NodeEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            AbstractConnectionModel conn = ((CreateConnectionCommand)request.getStartCommand()).getConnectionModel();
            AbstractEntityModel model = (AbstractEntityModel)this.getHost().getModel();
            if (!model.canTarget(conn)) {
                return null;
            }
            CreateConnectionCommand command = (CreateConnectionCommand)request.getStartCommand();
            command.setTarget(model);
            return command;
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            AbstractConnectionModel conn = (AbstractConnectionModel)request.getNewObject();
            AbstractEntityModel model = (AbstractEntityModel)this.getHost().getModel();
            if (!model.canSource(conn)) {
                return null;
            }
            CreateConnectionCommand command = new CreateConnectionCommand();
            command.setConnection(conn);
            command.setSource(model);
            request.setStartCommand((Command)command);
            return command;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            AbstractConnectionModel conn = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
            AbstractEntityModel model = (AbstractEntityModel)this.getHost().getModel();
            if (!model.canTarget(conn)) {
                return null;
            }
            ReconnectTargetCommand command = new ReconnectTargetCommand();
            command.setConnection(conn);
            command.setTarget(model);
            return command;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            AbstractConnectionModel conn = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
            AbstractEntityModel model = (AbstractEntityModel)this.getHost().getModel();
            if (!model.canSource(conn)) {
                return null;
            }
            ReconnectSourceCommand command = new ReconnectSourceCommand();
            command.setConnection(conn);
            command.setSource(model);
            return command;
        }
    }

    private class ReconnectSourceCommand
    extends Command {
        private AbstractEntityModel source;
        private AbstractEntityModel oldSource;
        private AbstractConnectionModel connection;

        private ReconnectSourceCommand() {
        }

        public void execute() {
            this.connection.detachSource();
            this.connection.setSource(this.source);
            this.connection.attachSource();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractConnectionModel)model;
            this.oldSource = this.connection.getSource();
        }

        public void setSource(Object model) {
            this.source = (AbstractEntityModel)model;
        }

        public boolean canExecute() {
            return this.connection.getTarget() != null && this.source != null;
        }

        public void undo() {
            this.connection.detachSource();
            this.connection.setSource(this.oldSource);
            this.connection.attachSource();
        }
    }

    private class ReconnectTargetCommand
    extends Command {
        private AbstractEntityModel target;
        private AbstractEntityModel oldTarget;
        private AbstractConnectionModel connection;

        private ReconnectTargetCommand() {
        }

        public void execute() {
            this.connection.detachTarget();
            this.connection.setTarget(this.target);
            this.connection.attachTarget();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractConnectionModel)model;
            this.oldTarget = this.connection.getTarget();
        }

        public void setTarget(Object model) {
            this.target = (AbstractEntityModel)model;
        }

        public boolean canExecute() {
            return this.connection.getSource() != null && this.target != null;
        }

        public void undo() {
            this.connection.detachTarget();
            this.connection.setTarget(this.oldTarget);
            this.connection.attachTarget();
        }
    }
}

