/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.ManagedBeanProperty;
import tk.eclipse.plugin.jsf.editors.models.PageModel;
import tk.eclipse.plugin.jsf.wizards.JSPWizard;
import tk.eclipse.plugin.jsf.wizards.ManagedBeanWizard;

public class Util {
    public static void openJSPWizard(Object container, String fileName) {
        JSPWizard wizard = new JSPWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setFileName(fileName);
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openManagedBeanWizard(Object container, String className) {
        ManagedBeanWizard wizard = new ManagedBeanWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setClassName(className);
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openErrorDialog(Throwable ex) {
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.jsf", 0, ex.toString(), ex);
        ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
        Shell shell = Display.getCurrent().getActiveShell();
        ErrorDialog.openError((Shell)shell, (String)resource.getString("errorDialog.caption"), (String)resource.getString("errorDialog.message"), (IStatus)status);
        Util.logException(ex);
    }

    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "tk.eclipse.plugin.jsf", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public static void logDebug(String message) {
        ILog log = JSFPlugin.getDefault().getLog();
        Status status = new Status(1, "tk.eclipse.plugin.jsf", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logError(String message) {
        ILog log = JSFPlugin.getDefault().getLog();
        Status status = new Status(4, "tk.eclipse.plugin.jsf", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logException(Throwable ex) {
        ILog log = JSFPlugin.getDefault().getLog();
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.jsf", 0, ex.toString(), ex);
        log.log(status);
        ex.printStackTrace();
    }

    public static String createMessage(String message, String[] params) {
        int i = 0;
        while (i < params.length) {
            message = message.replaceAll("\\{" + i + "\\}", params[i]);
            ++i;
        }
        return message;
    }

    public static void openAlertDialog(String message) {
        ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        box.setMessage(message);
        box.setText(resource.getString("errorDialog.caption"));
        box.open();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ManagedBean evalPropertyBinding(String[] dim, JSFProject project) {
        ManagedBean result = Util.getFirstBean(dim[0], project);
        if (result == null) {
            return null;
        }
        try {
            int i = 1;
            while (true) {
                if (i >= dim.length - 1) {
                    return result;
                }
                ManagedBeanProperty[] props = result.getProperties();
                boolean flag = false;
                int j = 0;
                while (j < props.length) {
                    if (props[j].getPropertyName().equals(dim[i])) {
                        result = props[j].toManagedBean();
                        flag = true;
                        break;
                    }
                    ++j;
                }
                if (!flag) {
                    return null;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static ManagedBean getFirstBean(String beanName, JSFProject project) {
        ManagedBean result = null;
        ManagedBean[] beans = project.getManagedBeans();
        int i = 0;
        while (i < beans.length) {
            if (beans[i].getBeanName().equalsIgnoreCase(beanName)) {
                result = beans[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public static String[] splitManagedBean(String el) {
        String[] dim = el.trim().split("\\.|\\[");
        if (!el.endsWith(".")) {
            return dim;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < dim.length) {
            list.add(dim[i]);
            ++i;
        }
        list.add("");
        return list.toArray(new String[list.size()]);
    }

    public static String joinManagedBean(String[] dim) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dim.length - 1) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(dim[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String getWeekString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("EEE");
        return format.format(date);
    }

    public static String getMonthString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("MMMM");
        return format.format(date);
    }

    public static void openPage(IProject project, PageModel target) {
        try {
            HTMLProjectParams params = new HTMLProjectParams(project);
            String webappRoot = params.getRoot();
            String path = target.getPath();
            if (path == null || path.equals("")) {
                Util.openAlertDialog(JSFPlugin.getResourceString("error.noJspPath"));
                return;
            }
            IFile file = project.getFile(String.valueOf(webappRoot) + path);
            if (file.exists()) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
            } else {
                Util.openJSPWizard(file.getParent(), file.getName());
            }
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
    }
}

