/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.io.InputStream;
import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.Converter;
import tk.eclipse.plugin.jsf.IManagedBeanProvider;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.Validator;

public class JSFProject {
    private IJavaProject project;
    private ManagedBean[] managedBeans;
    private HTMLProjectParams params;
    private Converter[] converters;
    private Validator[] validators;
    private static final Converter[] STANDARD_CONVERTERS = new Converter[]{new Converter("javax.faces.BigDecimal", "javax.faces.convert.BigDecimalConverter"), new Converter("javax.faces.BigInteger", "javax.faces.convert.BigIntegerConverter"), new Converter("javax.faces.Boolean", "javax.faces.convert.BooleanConverter"), new Converter("javax.faces.Byte", "javax.faces.convert.ByteConverter"), new Converter("javax.faces.Character", "javax.faces.convert.CharacterConverter"), new Converter("javax.faces.DateTime", "javax.faces.convert.DateTimeConverter"), new Converter("javax.faces.Double", "javax.faces.convert.DoubleConverter"), new Converter("javax.faces.Float", "javax.faces.convert.FloatConverter"), new Converter("javax.faces.Integer", "javax.faces.convert.IntegerConverter"), new Converter("javax.faces.Long", "javax.faces.convert.LongConverter"), new Converter("javax.faces.Number", "javax.faces.convert.NumberConverter"), new Converter("javax.faces.Short", "javax.faces.convert.ShortConverter")};
    private static final Validator[] STANDARD_VALIDATORS = new Validator[]{new Validator("javax.faces.DoubleRange", "javax.faces.validator.DoubleRangeValidator"), new Validator("javax.faces.Length", "javax.faces.validator.LengthValidator"), new Validator("javax.faces.LongRange", "javax.faces.validator.LongRangeValidator")};

    public JSFProject(IJavaProject project) {
        this.project = project;
        try {
            this.params = new HTMLProjectParams(project.getProject());
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    private void load() {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        ArrayList<Object> validators = new ArrayList<Object>();
        int i = 0;
        while (i < STANDARD_CONVERTERS.length) {
            converters.add(STANDARD_CONVERTERS[i]);
            ++i;
        }
        i = 0;
        while (i < STANDARD_VALIDATORS.length) {
            validators.add(STANDARD_VALIDATORS[i]);
            ++i;
        }
        try {
            IFile[] files = this.getFacesConfigXML();
            ArrayList<ManagedBean> list = new ArrayList<ManagedBean>();
            int j = 0;
            while (j < files.length) {
                InputStream in = files[j].getContents();
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(new String(FuzzyXMLUtil.readStream((InputStream)in)));
                in.close();
                FuzzyXMLNode[] beanNodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/managed-bean");
                int i2 = 0;
                while (i2 < beanNodes.length) {
                    String name = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)beanNodes[i2]), (String)"/managed-bean-name");
                    String clazz = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)beanNodes[i2]), (String)"/managed-bean-class");
                    String scope = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)beanNodes[i2]), (String)"/managed-bean-scope");
                    if (name != null && !name.equals("") && clazz != null && !clazz.equals("")) {
                        list.add(new ManagedBean(this.project, clazz, name, scope));
                    }
                    ++i2;
                }
                FuzzyXMLNode[] converterNodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/converter");
                int i3 = 0;
                while (i3 < converterNodes.length) {
                    String converterId = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)converterNodes[i3]), (String)"/converter-id");
                    String converterClass = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)converterNodes[i3]), (String)"/converter-class");
                    if (converterId != null && converterId.length() != 0 && converterClass != null && converterClass.length() != 0) {
                        converters.add(new Converter(converterId, converterClass));
                    }
                    ++i3;
                }
                FuzzyXMLNode[] validatorNodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/validator");
                int i4 = 0;
                while (i4 < validatorNodes.length) {
                    String validatorId = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)validatorNodes[i4]), (String)"/validator-id");
                    String validatorClass = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)validatorNodes[i4]), (String)"/validator-class");
                    if (validatorId != null && validatorId.length() != 0 && validatorClass != null && validatorClass.length() != 0) {
                        validators.add(new Converter(validatorId, validatorClass));
                    }
                    ++i4;
                }
                ++j;
            }
            IManagedBeanProvider[] contributedProviders = JSFPlugin.getDefault().getManagedBeanProviders();
            int i5 = 0;
            while (i5 < contributedProviders.length) {
                ManagedBean[] beans = contributedProviders[i5].getManagedBean(this.project, this.params.getRoot());
                int j2 = 0;
                while (j2 < beans.length) {
                    list.add(beans[j2]);
                    ++j2;
                }
                ++i5;
            }
            this.managedBeans = list.toArray(new ManagedBean[list.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.managedBeans = new ManagedBean[0];
        }
        this.converters = converters.toArray(new Converter[converters.size()]);
        this.validators = validators.toArray(new Validator[validators.size()]);
    }

    public ManagedBean[] getManagedBeans() {
        if (this.managedBeans == null) {
            this.load();
        }
        return this.managedBeans;
    }

    public Converter[] getConverters() {
        if (this.converters == null) {
            this.load();
        }
        return this.converters;
    }

    public Validator[] getValidators() {
        if (this.validators == null) {
            this.load();
        }
        return this.validators;
    }

    public ManagedBean getManagedBean(String beanName) {
        ManagedBean[] beans = this.getManagedBeans();
        int i = 0;
        while (i < beans.length) {
            if (beans[i].getBeanName().equals(beanName)) {
                return beans[i];
            }
            ++i;
        }
        return null;
    }

    public IFile[] getFacesConfigXML() {
        IFile file;
        IPath path2;
        String root = this.params.getRoot();
        try {
            FuzzyXMLDocument doc;
            String value;
            path2 = new Path(root).append("/WEB-INF/web.xml");
            file = this.project.getProject().getFile(path2);
            if (file != null && file.exists() && (value = HTMLUtil.getXPathValue((FuzzyXMLElement)(doc = new FuzzyXMLParser().parse(file.getContents())).getDocumentElement(), (String)"/web-app/context-param[param-name='javax.faces.CONFIG_FILES']/param-value")) != null) {
                String[] names = value.split(",");
                ArrayList<IFile> files = new ArrayList<IFile>();
                int i = 0;
                while (i < names.length) {
                    path2 = new Path(root).append(names[i].trim());
                    file = this.project.getProject().getFile(path2);
                    if (file != null && file.exists()) {
                        files.add(file);
                    }
                    ++i;
                }
                return files.toArray(new IFile[files.size()]);
            }
        }
        catch (Exception path2) {
            // empty catch block
        }
        path2 = new Path(root).append("/WEB-INF/faces-config.xml");
        file = this.project.getProject().getFile(path2);
        if (file != null && file.exists()) {
            return new IFile[]{file};
        }
        return new IFile[0];
    }
}

