/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.faces.component.UIComponent;

public class ViewIterator
implements Iterator {
    private UIComponent _next = null;
    private boolean _mayHaveNext = true;
    private UIComponent _current = null;
    private Stack _stack = new Stack();

    public ViewIterator(UIComponent root) {
        this._next = root;
        this._current = null;
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._current = this._next;
        this._next = null;
        return this._current;
    }

    private UIComponent getNext() {
        if (this._next == null && this._mayHaveNext) {
            Iterator children = this._current.getFacetsAndChildren();
            if (children.hasNext()) {
                this._next = (UIComponent)children.next();
                this._stack.push(children);
            } else {
                while (true) {
                    if (this._stack.empty()) {
                        this._next = null;
                        this._mayHaveNext = false;
                        break;
                    }
                    Iterator currentSiblings = (Iterator)this._stack.peek();
                    if (currentSiblings.hasNext()) {
                        this._next = (UIComponent)currentSiblings.next();
                        break;
                    }
                    this._stack.pop();
                }
            }
        }
        return this._next;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
    }
}

