/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;

public class TagFileParser {
    private static final Pattern ATTRIBUTE = Pattern.compile("<%@\\s*attribute\\s+(.+?)%>", 32);
    private static final Pattern NAME = Pattern.compile("name\\s*=\\s*\"(.+?)\"");
    private static final Pattern REQUIRED = Pattern.compile("required\\s*=\\s*\"(.+?)\"");

    public static TagInfo parseTagFile(String prefix, String tagName, InputStream in) throws Exception {
        TagInfo tag = new TagInfo(String.valueOf(prefix) + ":" + tagName, true);
        byte[] buf = HTMLUtil.readStream(in);
        Matcher matcher = ATTRIBUTE.matcher(new String(buf));
        while (matcher.find()) {
            String content = matcher.group(1);
            String name = TagFileParser.getAttribute(content, NAME);
            boolean required = TagFileParser.getBooleanValue(TagFileParser.getAttribute(content, REQUIRED));
            tag.addAttributeInfo(new AttributeInfo(name, true, 0, required));
        }
        return tag;
    }

    public static TagInfo parseTagFile(String prefix, File file) throws Exception {
        String fileName = file.getName();
        return TagFileParser.parseTagFile(prefix, fileName.substring(0, fileName.lastIndexOf(46)), new FileInputStream(file));
    }

    private static boolean getBooleanValue(String value) {
        return value.equals("true");
    }

    private static String getAttribute(String source, Pattern pattern) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

