/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jseditor.editors.additional.AdditionalJavaScriptCompleterManager;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLibraryTable;

public class JavaScriptPropertyPage
extends PropertyPage {
    private HTMLProjectParams params;
    private TabFolder tabFolder;
    private JavaScriptLibraryTable tableViewer;
    private Table additionalCompleters;

    public JavaScriptPropertyPage() {
        this.setDescription(HTMLPlugin.getResourceString("JavaScriptPropertyPage.Description"));
    }

    protected Control createContents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tableViewer = new JavaScriptLibraryTable((Composite)this.tabFolder);
        TabItem tab1 = new TabItem(this.tabFolder, 0);
        tab1.setText("Libraries");
        tab1.setControl(this.tableViewer.getControl());
        TabItem tab2 = new TabItem(this.tabFolder, 0);
        tab2.setText("Code Completion");
        this.additionalCompleters = new Table((Composite)this.tabFolder, 2080);
        this.additionalCompleters.setLayoutData((Object)new GridData(1808));
        String[] names = AdditionalJavaScriptCompleterManager.getAdditionalJavaScriptCompleterNames();
        int i = 0;
        while (i < names.length) {
            new TableItem(this.additionalCompleters, 0).setText(names[i]);
            ++i;
        }
        tab2.setControl((Control)this.additionalCompleters);
        try {
            this.params = new HTMLProjectParams(this.getProject());
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        this.fillControls();
        return this.tabFolder;
    }

    private void fillControls() {
        List tableModel = this.tableViewer.getModel();
        tableModel.clear();
        String[] javaScripts = this.params.getJavaScripts();
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < javaScripts.length) {
            if (javaScripts[i].startsWith("entry:")) {
                IResource resource = wsroot.findMember(javaScripts[i].substring("entry:".length()));
                if (resource != null && resource instanceof IFile && resource.exists()) {
                    tableModel.add((IFile)resource);
                }
            } else {
                tableModel.add(new File(javaScripts[i]));
            }
            ++i;
        }
        this.tableViewer.refresh();
        String[] javaScriptCompleters = this.params.getJavaScriptCompleters();
        int i2 = 0;
        while (i2 < javaScriptCompleters.length) {
            TableItem[] items = this.additionalCompleters.getItems();
            int j = 0;
            while (j < items.length) {
                if (items[j].getText().equals(javaScriptCompleters[i2])) {
                    items[j].setChecked(true);
                }
                ++j;
            }
            ++i2;
        }
    }

    protected void performDefaults() {
        this.params = new HTMLProjectParams();
        this.fillControls();
    }

    public boolean performOk() {
        try {
            this.params = new HTMLProjectParams(this.getProject());
            List tableModel = this.tableViewer.getModel();
            String[] javaScripts = new String[tableModel.size()];
            int i = 0;
            while (i < tableModel.size()) {
                Object obj = tableModel.get(i);
                if (obj instanceof File) {
                    javaScripts[i] = ((File)obj).getAbsolutePath();
                } else if (obj instanceof IFile) {
                    javaScripts[i] = "entry:" + ((IFile)obj).getFullPath().toString();
                }
                ++i;
            }
            this.params.setJavaScripts(javaScripts);
            TableItem[] items = this.additionalCompleters.getItems();
            ArrayList<String> javaScriptCompleters = new ArrayList<String>();
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].getChecked()) {
                    javaScriptCompleters.add(items[i2].getText());
                }
                ++i2;
            }
            this.params.setJavaScriptCompleters(javaScriptCompleters.toArray(new String[javaScriptCompleters.size()]));
            this.params.save(this.getProject());
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return false;
        }
        return true;
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }
}

