package net.java.amateras.db.visual.generate;

import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import net.java.amateras.db.visual.model.RootModel;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class HTMLGenerator implements IGenerator {

	private static ResourceBundle bundle = ResourceBundle.getBundle(HTMLGenerator.class.getName());
	private static Map messages = new HashMap();
	static {
		for(Enumeration e = bundle.getKeys();e.hasMoreElements();){
			String key = (String) e.nextElement();
			messages.put(key, bundle.getString(key));
		}
	}
	
	public void execute(IProject project, RootModel root) {
		try {
			FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), SWT.SAVE);
			dialog.setFileName(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle() + ".html");
			String file = dialog.open();
			if(file!=null){
				Velocity.init();
				VelocityContext context = new VelocityContext();
				context.put("model", root);
				context.put("util", new VelocityUtils());
				context.put("msg", messages);
				StringWriter writer = new StringWriter();
				Velocity.evaluate(context, writer, null, 
						new InputStreamReader(HTMLGenerator.class.getResourceAsStream("table.html"), "UTF-8"));
				
				FileOutputStream out = new FileOutputStream(file);
				out.write(writer.getBuffer().toString().getBytes("UTF-8"));
				out.close();
			}
		} catch(Exception ex){
			ex.printStackTrace();
		}
	}

	public String getGeneratorName() {
		return "HTML";
	}

}
