package net.java.amateras.db.visual.generate;

import java.io.File;
import java.util.ArrayList;

import net.java.amateras.db.DBPlugin;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FolderSelectWizardPage extends WizardPage {
	
	private IProject project;
	private Text txtOutputFolder;
	
	public FolderSelectWizardPage(IProject project, String pageName) {
		super(pageName);
		setTitle(pageName);
		this.project = project;
	}
	
	public IResource getOutputFolderResource(){
		String outputDir = txtOutputFolder.getText();
		if(outputDir.startsWith("/")){
			outputDir = outputDir.substring(1);
		}
		if(outputDir.endsWith("/")){
			outputDir = outputDir.substring(0, outputDir.length()-1);
		}
		return project.findMember(outputDir);
	}
	
	public File getOutputFolder(){
		IResource resource = getOutputFolderResource();
		if(resource instanceof IContainer){
			File file = ((IContainer)resource).getLocation().makeAbsolute().toFile();
			return file;
		}
		return null;
	}
	
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(3, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Label label = new Label(composite, SWT.NULL);
		label.setText(DBPlugin.getResourceString("wizard.generate.folder"));
		txtOutputFolder = new Text(composite, SWT.BORDER);
		txtOutputFolder.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Button button = new Button(composite, SWT.PUSH);
		button.setText(DBPlugin.getResourceString("button.browse"));
		button.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e){
				selectFolder();
			}
		});
		
		setControl(composite);
	}
	
	private void selectFolder() {
		try {
			IProject currProject = project.getProject();
			IResource init = null;
			if(!txtOutputFolder.getText().equals("")){
				init = currProject.findMember(txtOutputFolder.getText());
			}
			Class[] acceptedClasses = new Class[] { IProject.class, IFolder.class };
			ISelectionStatusValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
			
			IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
			IProject[] allProjects = wsroot.getProjects();
			
			ArrayList rejectedElements = new ArrayList(allProjects.length);
			for (int i = 0; i < allProjects.length; i++) {
				if (!allProjects[i].equals(currProject)) {
					rejectedElements.add(allProjects[i]);
				}
			}
			ViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
			
			FolderSelectionDialog dialog = new FolderSelectionDialog(
					getShell(),
					new WorkbenchLabelProvider(), 
					new WorkbenchContentProvider());
			
			dialog.setTitle(DBPlugin.getResourceString("wizard.generate.browse.title"));
			dialog.setMessage(DBPlugin.getResourceString("wizard.generate.browse.message"));
			
			dialog.setInput(wsroot);
			dialog.setValidator(validator);
			dialog.addFilter(filter);
			dialog.setInitialSelection(init);
			if (dialog.open() == Window.OK) {
				txtOutputFolder.setText(getFolderName(dialog.getFirstResult()));
			}
			
		} catch (Exception ex) {
			DBPlugin.logException(ex);
		}
	}
	
	private String getFolderName(Object result) throws CoreException {
		if (result instanceof IFolder) {
			IFolder folder = (IFolder) result;
			return folder.getProjectRelativePath().toString();
		}
		return "";
	}

}
