package net.java.amateras.db.visual.action;

import java.sql.SQLException;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.wizard.NewDiagramWizardPage2;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.MessageBox;

/**
 * 
 * @author Naoki Takezoe
 */
public class ImportFromJDBCAction extends AbstractDBAction {
	
	public ImportFromJDBCAction(GraphicalViewer viewer){
		super(DBPlugin.getResourceString("action.importFromDB"), viewer);
	}
	
	public void run() {
		ImportFromJDBCWizard wizard = new ImportFromJDBCWizard();
		WizardDialog dialog = new WizardDialog(
				getViewer().getControl().getShell(), wizard);
		dialog.open();
	}
	
	private class ImportFromJDBCWizard extends Wizard {
		
		private NewDiagramWizardPage2 page;
		
		public ImportFromJDBCWizard() {
			super();
			setNeedsProgressMonitor(true);
			setWindowTitle(DBPlugin.getResourceString("wizard.new.import.title"));
		}
		
		public void addPages() {
			page = new NewDiagramWizardPage2();
			addPage(page);
		}

		public boolean performFinish() {
			RootModel root = (RootModel) getViewer().getContents().getModel();
			try {
				page.importTables(root);
				return true;
			} catch(SQLException ex){
				DBPlugin.logException(ex);
				MessageBox msg = new MessageBox(getShell());
				msg.setMessage(ex.getMessage());
				msg.open();
				return false;
			}
		}
	}

}
