package net.java.amateras.db.view.dialect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.java.amateras.db.DBPlugin;

public class DialectProvider {
	
	private static Map dialects = DBPlugin.getDefault().getContributedDialects();
	
	public static IDialect[] getDialects(){
		Iterator ite = dialects.values().iterator();
		List dialects = new ArrayList();
		while(ite.hasNext()){
			dialects.add(ite.next());
		}
		return (IDialect[])dialects.toArray(new IDialect[dialects.size()]);
	}
	
	public static String[] getDialectNames(){
		Set set = dialects.keySet();
		return (String[])set.toArray(new String[set.size()]);
	}
	
	public static IDialect getDialect(String dbName){
		return (IDialect)dialects.get(dbName);
	}
	
}
