package net.java.amateras.db.view.dialect;

import java.sql.Types;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.ColumnModel;

public class DerbyDialect extends AbstractDialect {
	
	private static final IColumnType[] COLUMN_TYPES = {
		new ColumnType("BOOLEAN", DBPlugin.getResourceString("type.boolean"), true, Types.BOOLEAN),
		new ColumnType("BIGINT", DBPlugin.getResourceString("type.integer"), true, Types.BIGINT),
		new ColumnType("VARCHAR", DBPlugin.getResourceString("type.string"),true, Types.VARCHAR),
		new ColumnType("LONG VARCHAR", DBPlugin.getResourceString("type.string"),true, Types.VARCHAR),
		new ColumnType("CHAR", DBPlugin.getResourceString("type.char"), true, Types.CHAR),
		new ColumnType("CHARACTER", DBPlugin.getResourceString("type.char"), true, Types.CHAR),
		new ColumnType("DECIMAL", DBPlugin.getResourceString("type.real"), true, Types.DECIMAL),
		new ColumnType("DEC", DBPlugin.getResourceString("type.real"), true, Types.DECIMAL),
		new ColumnType("NUMERIC", DBPlugin.getResourceString("type.numeric"), true, Types.NUMERIC),
		new ColumnType("NUM", DBPlugin.getResourceString("type.numeric"), true, Types.NUMERIC),
		new ColumnType("INT", DBPlugin.getResourceString("type.integer"), true, Types.INTEGER),
		new ColumnType("INTEGER", DBPlugin.getResourceString("type.integer"), true, Types.INTEGER),
		new ColumnType("DOUBLE", DBPlugin.getResourceString("type.real"), true, Types.DOUBLE),
		new ColumnType("FLOAT", DBPlugin.getResourceString("type.real"), true, Types.FLOAT),
		new ColumnType("DATE", DBPlugin.getResourceString("type.date"), false, Types.DATE),
		new ColumnType("TIME", DBPlugin.getResourceString("type.time"), false, Types.TIME),
		new ColumnType("TIMESTAMP", DBPlugin.getResourceString("type.datetime"), false, Types.TIMESTAMP),
		new ColumnType("REAL", DBPlugin.getResourceString("type.real"), true, Types.REAL),
		new ColumnType("SMALLINT", DBPlugin.getResourceString("type.integer"), true, Types.SMALLINT),
		new ColumnType("TINYINT", DBPlugin.getResourceString("type.integer"), true, Types.TINYINT),
		new ColumnType("CHARACTER VARYING FOR BIT DATA", DBPlugin.getResourceString("type.binary"), true, Types.BINARY),
		new ColumnType("CHAR VARYING FOR BIT DATA", DBPlugin.getResourceString("type.binary"), true, Types.BINARY),
		new ColumnType("VARCHAR FOR BIT DATA", DBPlugin.getResourceString("type.binary"), true, Types.BINARY),
		// TODO: Support following TYPE
		//   BLOB
		//   CLOB
		//   CHARACTER LARGE OBJECT
		//   CHAR LARGE OBJECT
        //   DBCLOB
		//   XML
	};
	
	public DerbyDialect(){
		super(COLUMN_TYPES);
	}
	
	protected String createColumnDDL(ColumnModel model) {
		String ddl = super.createColumnDDL(model);
		if(model.isAutoIncrement()){
			ddl += " GENERATED ALWAYS AS IDENTITY";
		}
		return ddl;
	}
	
}
