package net.java.amateras.db;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import net.java.amateras.db.view.dialect.IDialect;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class DBPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static DBPlugin plugin;
	
	public static final String PLUGIN_ID = "net.java.amateras.db";
	private ResourceBundle resource = null;
	private Map contributedDialects = null;
	
	
	/**
	 * The constructor.
	 */
	public DBPlugin() {
		plugin = this;
		resource = ResourceBundle.getBundle(PLUGIN_ID + ".DBPlugin");
	}
	
	public static String getResourceString(String key){
		return getDefault().resource.getString(key);
	}
	
	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static DBPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("net.java.amateras.db", path);
	}
	
	public static void logException(Exception ex){
		IStatus status = new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, "Error", ex);
		getDefault().getLog().log(status);
		ex.printStackTrace(); // TODO Debug
	}
	
	public String createMessage(String key, String[] values){
		String message = getResourceString(key);
		for(int i=0;i<values.length;i++){
			message = message.replaceAll("\\{"+i+"\\}", values[i]);
		}
		return message;
	}
	
	/**
	 * Returns contributed <code>IDialect</code>s.
	 * 
	 * @return contributed dialects.
	 */
	public Map getContributedDialects(){
		if(this.contributedDialects==null){
			IExtensionRegistry registry = Platform.getExtensionRegistry();
			IExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID + ".dialects");
			IExtension[] extensions = point.getExtensions();
			this.contributedDialects = new HashMap();
			
			for(int i=0;i<extensions.length;i++){
				IConfigurationElement[] elements = extensions[i].getConfigurationElements();
				for (int j = 0; j < elements.length; j++) {
					try {
						if("dialect".equals(elements[j].getName())) {
							String name = elements[j].getAttribute("name");
							IDialect dialect = (IDialect) elements[j].createExecutableExtension("class");
							this.contributedDialects.put(name, dialect);
						}
					} catch(Exception ex){
						logException(ex);
					}
				}
			}
		}
		return this.contributedDialects;
	}
}
