/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.wizards;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.template.StrutsTemplateAccess;

public class JSPWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Combo templateCombo;
    private ISelection selection;
    private String fileName;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    private Template[] templates;
    static /* synthetic */ Class class$0;

    public JSPWizardPage(ISelection selection, String fileName) {
        super("wizardPage");
        this.setTitle(this.resource.getString("wizard.jsp.title"));
        this.setDescription(this.resource.getString("wizard.jsp.description"));
        this.selection = selection;
        this.fileName = fileName;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(this.resource.getString("wizard.label.container"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JSPWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(this.resource.getString("wizard.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSPWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(this.resource.getString("wizard.label.file"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JSPWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(StrutsPlugin.getResourceString("wizard.label.template"));
        this.templateCombo = new Combo(container, 8);
        this.templates = StrutsTemplateAccess.getDefault().getTemplateStore().getTemplates("tk.eclipse.plugin.struts.StrutsPlugin.templateContextType.jsp");
        int i = 0;
        while (i < this.templates.length) {
            this.templateCombo.add(this.templates[i].getName());
            ++i;
        }
        if (this.templateCombo.getItemCount() > 0) {
            this.templateCombo.select(0);
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            IResource resource = null;
            IContainer container = null;
            if (obj instanceof IResource) {
                resource = (IResource)obj;
            } else if (obj instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)obj;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource != null) {
                container = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
            }
            if (container != null) {
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText(this.fileName);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, this.resource.getString("wizard.message.selectContainer"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.required"), new String[]{this.resource.getString("message.container")}));
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource containerObj = root.findMember((IPath)new Path(container));
        if (containerObj == null || !containerObj.exists() || !(containerObj instanceof IContainer) || this.resource instanceof IWorkspaceRoot) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.invalidPath"), new String[]{container}));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.required"), new String[]{this.resource.getString("message.file")}));
            return;
        }
        IResource fileObj = root.findMember(new Path(container).append(fileName));
        if (fileObj != null && fileObj.exists() && fileObj instanceof IFile) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.alreadyExists"), new String[]{fileName}));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("jsp")) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.extention"), new String[]{"jsp"}));
            return;
        }
        if (this.templateCombo.getText().equals("")) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.noTemplate"), new String[0]));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setMessage(message, 3);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public Template getTemplate() {
        String name = this.templateCombo.getText();
        int i = 0;
        while (i < this.templates.length) {
            if (this.templates[i].getName().equals(name)) {
                return this.templates[i];
            }
            ++i;
        }
        return null;
    }
}

