/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.wizards;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.MultiPageStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class ConfigurationActionWizardPage
extends WizardPage {
    protected Text pathText;
    protected Text typeText;
    protected ActionModel model;
    protected Combo comboFormBean;
    protected Combo comboScope;
    protected Button createClass;
    private IJavaProject project;

    protected ConfigurationActionWizardPage(IJavaProject project, String pageName, ActionModel model) {
        super(pageName);
        this.model = model;
        this.project = project;
        this.setTitle(StrutsPlugin.getResourceString("wizard.action.title"));
        this.setDescription(StrutsPlugin.getResourceString("wizard.action.description"));
    }

    private static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private void doValidate() {
        if (this.pathText.getText().length() == 0) {
            this.setErrorMessage(Util.createMessage(StrutsPlugin.getResourceString("error.required"), new String[]{"path"}));
            this.setPageComplete(false);
            return;
        }
        if (this.typeText.getText().length() == 0) {
            this.setErrorMessage(Util.createMessage(StrutsPlugin.getResourceString("error.required"), new String[]{"type"}));
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    public void createControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        ConfigurationActionWizardPage.createLabel(container, "path:");
        this.pathText = new Text(container, 2052);
        this.pathText.setText(this.model.getPath());
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ConfigurationActionWizardPage.this.doValidate();
            }
        });
        ConfigurationActionWizardPage.createLabel(container, "");
        ConfigurationActionWizardPage.createLabel(container, "type:");
        this.typeText = new Text(container, 2052);
        this.typeText.setText(this.model.getType());
        this.typeText.setLayoutData((Object)new GridData(768));
        this.typeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ConfigurationActionWizardPage.this.doValidate();
            }
        });
        Button button = new Button(container, 8);
        button.setText(StrutsPlugin.getResourceString("wizard.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationActionWizardPage.this.handleBrowse("action class", "action class", (Control)container, ConfigurationActionWizardPage.this.typeText);
            }
        });
        ConfigurationActionWizardPage.createLabel(container, "");
        this.createClass = new Button(container, 32);
        this.createClass.setText(StrutsPlugin.getResourceString("wizard.label.createActionClass"));
        this.createClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationActionWizardPage.this.doValidate();
            }
        });
        ConfigurationActionWizardPage.createLabel(container, "");
        ConfigurationActionWizardPage.createLabel(container, "scope:");
        this.comboScope = new Combo(container, 8);
        this.comboScope.add("");
        this.comboScope.add("request");
        this.comboScope.add("session");
        if ("request".equals(this.model.getScope())) {
            this.comboScope.select(1);
        } else if ("session".equals(this.model.getScope())) {
            this.comboScope.select(2);
        } else {
            this.comboScope.select(0);
        }
        this.comboScope.setLayoutData((Object)new GridData());
        ConfigurationActionWizardPage.createLabel(container, "");
        ConfigurationActionWizardPage.createLabel(container, "form:");
        this.comboFormBean = new Combo(container, 8);
        this.comboFormBean.add("");
        MultiPageStrutsConfigEditor strutsconfigEditor = (MultiPageStrutsConfigEditor)HTMLUtil.getActiveEditor();
        RootModel root = strutsconfigEditor.getRoot();
        List list = root.getChildren();
        int i = 0;
        while (list.size() > i) {
            Object obj = list.get(i);
            if (obj instanceof FormBeanModel) {
                FormBeanModel tmp = (FormBeanModel)obj;
                this.comboFormBean.add(tmp.getName());
                if (tmp.getName() != null && this.model.getName().equals(tmp.getName())) {
                    this.comboFormBean.select(i + 1);
                }
            }
            ++i;
        }
        this.comboFormBean.setLayoutData((Object)new GridData());
        this.setControl((Control)container);
        this.doValidate();
    }

    public IWizardPage getNextPage() {
        if (!this.createClass.getSelection()) {
            return null;
        }
        NewClassWizardPage nextPage = (NewClassWizardPage)super.getNextPage();
        try {
            String className;
            int index;
            nextPage.setSuperClass("org.apache.struts.action.Action", true);
            IPackageFragmentRoot[] roots = this.project.getPackageFragmentRoots();
            if (roots.length > 0) {
                nextPage.setPackageFragmentRoot(roots[0], true);
            }
            if ((index = (className = this.typeText.getText()).lastIndexOf(46)) != -1) {
                String packageName = className.substring(0, index);
                className = className.substring(index + 1, className.length());
                if (roots.length > 0) {
                    IPackageFragment fragment = roots[0].getPackageFragment(packageName);
                    nextPage.setPackageFragment(fragment, true);
                }
            }
            nextPage.setTypeName(className, false);
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        return nextPage;
    }

    protected void handleBrowse(String id, String displayname, Control control, Text text) {
        IEditorPart editorPart = HTMLUtil.getActiveEditor();
        IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
        IJavaProject project = JavaCore.create((IProject)input.getFile().getProject());
        HTMLUtil.openClassSelectDialog((IJavaProject)project, (Control)control);
    }
}

