/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import java.util.Arrays;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.FormInfo;
import tk.eclipse.plugin.struts.PropertyInfo;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.validator.AbstractStrutsXMLValidator;

public class ValidatorValidator
extends AbstractStrutsXMLValidator {
    private FormInfo[] forms;
    private String[] ruleNames;
    private String moduleName;

    public ValidatorValidator(StrutsProject project, IFile file, String moduleName) {
        super(project, file);
        this.moduleName = moduleName;
        this.ruleNames = Util.getValidatorRules(project, moduleName);
        Arrays.sort(this.ruleNames);
    }

    protected void executeValidate() {
        try {
            this.forms = this.project.getActionForms(this.moduleName);
            this.validateElement(this.doc.getDocumentElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateElement(FuzzyXMLElement element) {
        try {
            String name;
            FuzzyXMLAttribute attr;
            if (element.getName().equals("form") && (attr = element.getAttributeNode("name")) != null && !this.existsForm(name = attr.getValue())) {
                this.createAttributeValueMarker(attr, Util.createMessage(StrutsPlugin.getResourceString("error.noActionForm"), new String[]{name}));
                return;
            }
            if (element.getName().equals("field")) {
                String property;
                FuzzyXMLElement parent;
                String form;
                attr = element.getAttributeNode("property");
                if (attr != null && !this.existsProperty(form = (parent = (FuzzyXMLElement)element.getParentNode()).getAttributeNode("name").getValue(), property = attr.getValue())) {
                    this.createAttributeValueMarker(attr, Util.createMessage(StrutsPlugin.getResourceString("error.noProperty"), new String[]{form, property}));
                    return;
                }
                FuzzyXMLAttribute depends = element.getAttributeNode("depends");
                if (depends != null) {
                    String[] rules = depends.getValue().split(",");
                    int i = 0;
                    while (i < rules.length) {
                        if (Arrays.binarySearch(this.ruleNames, rules[i].trim()) < 0) {
                            this.createAttributeValueMarker(depends, Util.createMessage(StrutsPlugin.getResourceString("error.noValidationRule"), new String[]{rules[i].trim()}));
                            return;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception attr) {
            // empty catch block
        }
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)children[i]);
            }
            ++i;
        }
    }

    private String getFormFromPath(String path) {
        IFile[] files = this.project.getStrutsConfigXML(this.moduleName);
        int i = 0;
        while (i < files.length) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
                FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)("//struts-config/action-mappings/action[@path=\"" + path + "\"]"));
                if (nodes.length > 0) {
                    FuzzyXMLElement element = (FuzzyXMLElement)nodes[0];
                    return element.getAttributeNode("name").getValue();
                }
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
            ++i;
        }
        return null;
    }

    private boolean existsForm(String name) {
        if (name.startsWith("/")) {
            name = this.getFormFromPath(name);
        }
        int i = 0;
        while (i < this.forms.length) {
            if (this.forms[i].getFormName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean existsProperty(String name, String property) {
        if (name.startsWith("/")) {
            name = this.getFormFromPath(name);
        }
        property = property.replaceAll("\\[[0-9]+\\]", "");
        int i = 0;
        while (i < this.forms.length) {
            if (this.forms[i].getFormName().equals(name)) {
                PropertyInfo[] props = this.forms[i].getProperties();
                int j = 0;
                while (j < props.length) {
                    if (props[j].getPropertyName().equals(property)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

