/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.validator.AbstractStrutsXMLValidator;

public class StrutsConfigValidator
extends AbstractStrutsXMLValidator {
    private String[] tilesDefinitions;
    private String extention;
    private String moduleName;

    public StrutsConfigValidator(StrutsProject project, IFile file, String moduleName) {
        super(project, file);
        this.extention = project.getExtension();
        if (this.extention == null) {
            this.extention = ".do";
        }
        this.moduleName = moduleName;
    }

    protected void executeValidate() {
        this.tilesDefinitions = new StrutsProject(this.file.getProject()).getTilesDefinition(this.moduleName);
        this.validateElement(this.doc.getDocumentElement());
    }

    private void validateElement(FuzzyXMLElement element) {
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            try {
                if (attrs[i].getName().equals("type") || attrs[i].getName().equals("className")) {
                    if (!attrs[i].getValue().equals("") && attrs[i].getValue().indexOf(123) < 0 && !this.project.existsClass(attrs[i].getValue())) {
                        this.createAttributeValueMarker(attrs[i], Util.createMessage(StrutsPlugin.getResourceString("error.notexists"), new String[]{attrs[i].getValue()}));
                    }
                } else if (!element.getName().equals("action") && attrs[i].getName().equals("path")) {
                    String attrValue = attrs[i].getValue();
                    if (attrValue.endsWith(".jsp")) {
                        attrValue = String.valueOf(this.moduleName) + "/" + attrValue;
                    }
                    if (!attrs[i].getValue().equals("") && attrValue.indexOf(123) < 0 && !this.existsPath(attrValue)) {
                        this.createAttributeValueMarker(attrs[i], Util.createMessage(StrutsPlugin.getResourceString("error.notexists"), new String[]{attrs[i].getValue()}));
                    }
                }
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
            ++i;
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)nodes[i2]);
            }
            ++i2;
        }
    }

    private boolean existsPath(String path) {
        if (path.endsWith(this.extention)) {
            path = path.substring(0, path.indexOf(this.extention));
            FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)this.doc.getDocumentElement(), (String)"/struts-config/action-mappings/action");
            int i = 0;
            while (i < nodes.length) {
                FuzzyXMLElement action = (FuzzyXMLElement)nodes[i];
                String actionPath = action.getAttributeNode("path").getValue();
                if (path.equals(actionPath)) {
                    return true;
                }
                ++i;
            }
        } else {
            if (path.indexOf("?") > 0) {
                path = path.substring(0, path.indexOf("?"));
            }
            int i = 0;
            while (i < this.tilesDefinitions.length) {
                if (this.tilesDefinitions[i].equals(path)) {
                    return true;
                }
                ++i;
            }
            IFile jsp = this.file.getProject().getFile(new Path(this.params.getRoot()).append(path));
            if (jsp.exists()) {
                return true;
            }
        }
        return false;
    }
}

