/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public abstract class AbstractStrutsXMLValidator {
    protected StrutsProject project;
    protected IFile file;
    protected HTMLProjectParams params;
    protected FuzzyXMLDocument doc;
    private String contents;

    public AbstractStrutsXMLValidator(StrutsProject project, IFile file) {
        this.project = project;
        this.file = file;
    }

    public void doValidate() {
        try {
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(true);
            SAXParser parser = spfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new StrutsConfigResolver());
            reader.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)this.file));
            reader.parse(new InputSource(this.file.getContents()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.params = new HTMLProjectParams(this.file.getProject());
            this.contents = new String(HTMLUtil.readStream((InputStream)this.file.getContents()));
            this.contents = this.contents.replaceAll("\r\n", " \n");
            this.contents = this.contents.replaceAll("\r", "\n");
            this.doc = new FuzzyXMLParser().parse(this.file.getContents());
            this.executeValidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void executeValidate();

    protected int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        return text.split("\n").length;
    }

    protected int getAttrValueOffset(int offset) {
        int valueStart = 0;
        valueStart = this.contents.indexOf("\"", offset);
        if (valueStart == -1) {
            valueStart = this.contents.indexOf("=") + 1;
        }
        return valueStart;
    }

    protected void createAttributeValueMarker(FuzzyXMLAttribute attr, String message) throws CoreException {
        this.createMarker(this.getAttrValueOffset(attr.getOffset() + 1), attr.getOffset() + attr.getLength(), this.getLineAtOffset(attr.getOffset() + 1), message);
    }

    protected void createMarker(int start, int end, int line, String message) throws CoreException {
        IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("severity", new Integer(2));
        map.put("message", message);
        map.put("lineNumber", new Integer(line));
        map.put("charStart", new Integer(start));
        map.put("charEnd", new Integer(end));
        marker.setAttributes(map);
    }
}

