/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.struts.FormInfo;
import tk.eclipse.plugin.struts.PropertyInfo;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class ValidatorXMLEditor
extends XMLEditor {
    private static final String[] CLASS_ATTRIBUTES = new String[]{"classname"};

    public ValidatorXMLEditor() {
        super((XMLConfiguration)new ValidatorConfiguration());
        this.addDTDResolver(new StrutsConfigResolver());
        this.setValidation(false);
    }

    public String[] getClassNameAttributes() {
        return CLASS_ATTRIBUTES;
    }

    private static class ValidatorConfiguration
    extends XMLConfiguration {
        public ValidatorConfiguration() {
            super(HTMLPlugin.getDefault().getColorProvider());
        }

        protected HTMLAssistProcessor createAssistProcessor() {
            return new ValidatorAssistProcessor();
        }
    }

    private static class ValidatorAssistProcessor
    extends XMLAssistProcessor {
        private String moduleName;
        private StrutsProject project = null;
        private ArrayList ruleNames = new ArrayList();

        private ValidatorAssistProcessor() {
        }

        protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
            int i;
            if (tagName.equals("form") && info.getAttributeName().equals("name")) {
                FormInfo[] forms = this.project.getActionForms(this.moduleName);
                AssistInfo[] assist = new AssistInfo[forms.length];
                int i2 = 0;
                while (i2 < assist.length) {
                    assist[i2] = new AssistInfo(forms[i2].getFormName(), String.valueOf(forms[i2].getFormName()) + " - " + forms[i2].getClassName(), StrutsPlugin.getDefault().getImage("__icon_bean"));
                    ++i2;
                }
                return assist;
            }
            if (tagName.equals("field") && info.getAttributeName().equals("property")) {
                FuzzyXMLElement element = this.getOffsetElement();
                while (!element.getName().equals("form")) {
                    if ((element = (FuzzyXMLElement)element.getParentNode()) == null) break;
                }
                if (element != null) {
                    String formName = element.getAttributeNode("name").getValue();
                    FormInfo[] forms = this.project.getActionForms(this.moduleName);
                    i = 0;
                    while (i < forms.length) {
                        if (forms[i].getFormName().equals(formName)) {
                            PropertyInfo[] properties = forms[i].getProperties();
                            AssistInfo[] assist = new AssistInfo[properties.length];
                            int j = 0;
                            while (j < properties.length) {
                                assist[j] = new AssistInfo(properties[j].getPropertyName(), String.valueOf(properties[j].getPropertyName()) + " - " + properties[j].getPropertyType(), StrutsPlugin.getDefault().getImage("__icon_property"));
                                ++j;
                            }
                            return assist;
                        }
                        ++i;
                    }
                }
            }
            if (tagName.equals("field") && info.getAttributeName().equals("depends")) {
                AssistInfo[] assist = new AssistInfo[this.ruleNames.size()];
                String pre = "";
                if (value.indexOf(",") >= 0) {
                    StringBuffer sb = new StringBuffer();
                    i = 0;
                    while (i < value.length()) {
                        char c = value.charAt(i);
                        if (Character.isJavaIdentifierPart(c) || c == '.') {
                            sb.append(c);
                        } else {
                            sb.setLength(0);
                        }
                        ++i;
                    }
                    String lastWord = sb.toString();
                    pre = value.substring(0, value.length() - lastWord.length());
                }
                int i3 = 0;
                while (i3 < assist.length) {
                    assist[i3] = new AssistInfo(String.valueOf(pre) + (String)this.ruleNames.get(i3), (String)this.ruleNames.get(i3));
                    ++i3;
                }
                return assist;
            }
            return super.getAttributeValues(tagName, value, info);
        }

        public void update(HTMLSourceEditor editor, String source) {
            super.update(editor, source);
            if (editor.getEditorInput() instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
                this.project = new StrutsProject(input.getFile().getProject());
                String[] modules = this.project.getModuleNames();
                this.moduleName = "";
                int i = 0;
                while (i < modules.length) {
                    IFile[] files = this.project.getValidatorXML(modules[i]);
                    int j = 0;
                    while (j < files.length) {
                        if (files[j].equals((Object)input.getFile())) {
                            this.moduleName = modules[i];
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.ruleNames.clear();
                String[] rules = Util.getValidatorRules(this.project, this.moduleName);
                int i2 = 0;
                while (i2 < rules.length) {
                    this.ruleNames.add(rules[i2]);
                    ++i2;
                }
            }
        }
    }
}

