/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import tk.eclipse.plugin.struts.StrutsPlugin;

public class SaveAsImageAction
extends Action {
    private GraphicalViewer viewer;

    public SaveAsImageAction(GraphicalViewer viewer) {
        super(StrutsPlugin.getResourceString("action.saveAsImage"), StrutsPlugin.getDefault().getImageRegistry().getDescriptor("__icon_save_image"));
        this.viewer = viewer;
    }

    public void update(IStructuredSelection sel) {
    }

    public void run() {
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.viewer.getRootEditPart();
        double zoom = rootEditPart.getZoomManager().getZoom();
        try {
            try {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFileName(String.valueOf(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle()) + ".jpg");
                String file = dialog.open();
                if (file != null) {
                    rootEditPart.getZoomManager().setZoomAsText(ZoomManager.FIT_ALL);
                    IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
                    Rectangle rectangle = figure.getBounds();
                    Image image = new Image((Device)Display.getDefault(), rectangle.width + 50, rectangle.height + 50);
                    GC gc = new GC((Drawable)image);
                    SWTGraphics graphics = new SWTGraphics(gc);
                    figure.paint((Graphics)graphics);
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{image.getImageData()};
                    if (file.endsWith(".bmp")) {
                        loader.save(file, 0);
                    } else if (file.endsWith(".jpg") || file.endsWith(".jpeg")) {
                        loader.save(file, 4);
                    } else {
                        file = String.valueOf(file) + ".bmp";
                        loader.save(file, 0);
                    }
                    image.dispose();
                    gc.dispose();
                }
            }
            catch (Exception exception) {}
        }
        finally {
            rootEditPart.getZoomManager().setZoom(zoom);
        }
    }
}

