/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsTagDefinition;
import tk.eclipse.plugin.struts.Util;

public class StrutsAttributeAssist
implements ICustomTagAttributeAssist {
    private Image actionImage = StrutsPlugin.getDefault().getImage("__icon_action");
    private Image forwardImage = StrutsPlugin.getDefault().getImage("__icon_forward");
    private IFileAssistProcessor[] hrefAssistProcessor = HTMLPlugin.getDefault().getFileAssistProcessors();

    public AssistInfo[] getAttributeValues(String tagName, String uri, String value, AttributeInfo attrInfo) {
        String type;
        block14: {
            block13: {
                if (this.getFile().getProject().hasNature("tk.eclipse.plugin.struts.StrutsProjectNature")) break block13;
                return null;
            }
            String attrName = attrInfo.getAttributeName();
            type = StrutsTagDefinition.getAttributeInfo(tagName, attrName);
            if (type != null) break block14;
            return null;
        }
        try {
            if (type == StrutsTagDefinition.ACTION) {
                Document doc = this.getStrutsConfigDocument();
                ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
                JXPathContext ctx = JXPathContext.newContext((Object)doc);
                List nodes = ctx.selectNodes("/struts-config/action-mappings/action");
                int i = 0;
                while (i < nodes.size()) {
                    Element element = (Element)nodes.get(i);
                    Attr attr = element.getAttributeNode("path");
                    if (attr != null) {
                        list.add(new AssistInfo(attr.getValue(), this.actionImage));
                    }
                    ++i;
                }
                return list.toArray(new AssistInfo[list.size()]);
            }
            if (type == StrutsTagDefinition.HREF) {
                IFile file = this.getFile();
                ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
                int i = 0;
                while (i < this.hrefAssistProcessor.length) {
                    this.hrefAssistProcessor[i].reload(file);
                    AssistInfo[] info = this.hrefAssistProcessor[i].getAssistInfo(value);
                    int j = 0;
                    while (j < info.length) {
                        list.add(info[j]);
                        ++j;
                    }
                    ++i;
                }
                return list.toArray(new AssistInfo[list.size()]);
            }
            if (type == StrutsTagDefinition.FORWARD) {
                Document doc = this.getStrutsConfigDocument();
                ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
                JXPathContext ctx = JXPathContext.newContext((Object)doc);
                List nodes = ctx.selectNodes("/struts-config/global-forwards/forward");
                int i = 0;
                while (i < nodes.size()) {
                    Element element = (Element)nodes.get(i);
                    Attr attr = element.getAttributeNode("name");
                    if (attr != null) {
                        list.add(new AssistInfo(attr.getValue(), this.forwardImage));
                    }
                    ++i;
                }
                return list.toArray(new AssistInfo[list.size()]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Document getStrutsConfigDocument() {
        try {
            IEditorPart editor = HTMLUtil.getActiveEditor();
            IProject project = ((IFileEditorInput)editor.getEditorInput()).getFile().getProject();
            HTMLProjectParams params = new HTMLProjectParams(project);
            IFile file = project.getFile(new Path(params.getRoot()).append("/WEB-INF/struts-config.xml"));
            if (file.exists()) {
                Document doc = Util.createXMLDocument(new String(HTMLUtil.readStream((InputStream)file.getContents())));
                return doc;
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        return null;
    }

    private IFile getFile() {
        IEditorPart editor = HTMLUtil.getActiveEditor();
        return ((IFileEditorInput)editor.getEditorInput()).getFile();
    }
}

