/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.struts.editors.models.PageModel;

public class PageEditPart
extends AbstractEntityEditPart {
    private PageDirectEditManager directManager;
    static /* synthetic */ Class class$0;

    public PageEditPart(IFile file) {
        super(file);
    }

    protected IFigure createFigure() {
        PageModel model = (PageModel)this.getModel();
        String path = model.getPath();
        if (path.equals("")) {
            path = "<page>";
        }
        Label label = new Label();
        label.setText(path);
        if (this.exists(model.getPath())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage_warn"));
        }
        label.setTextPlacement(4);
        return label;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new PageDirectEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = (Label)this.getFigure();
        PageModel model = (PageModel)this.getModel();
        if (this.exists(model.getPath())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage_warn"));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PageModel model;
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        Label label = (Label)this.getFigure();
        if (propName.equals("_path")) {
            String path = (String)evt.getNewValue();
            if (path.equals("")) {
                path = "<page>";
            }
            label.setText(path);
        }
        if (this.exists((model = (PageModel)this.getModel()).getPath())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage_warn"));
        }
    }

    public boolean exists(String path) {
        try {
            if (path == null || path.equals("")) {
                return false;
            }
            if (path.indexOf(123) >= 0) {
                return true;
            }
            if (path.indexOf("?") > 0) {
                path = path.substring(0, path.indexOf("?"));
            }
            IProject project = this.getFile().getProject();
            PageModel model = (PageModel)this.getModel();
            if (model.getRoot().getTilesRoot() != null && model.getRoot().getTilesRoot().existsDefinition(path)) {
                return true;
            }
            HTMLProjectParams params = new HTMLProjectParams(project);
            if (project.getFile(new Path(params.getRoot()).append(path)).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.directManager = new PageDirectEditManager(clazz, new PageCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    private class PageDirectEditManager
    extends DirectEditManager {
        public PageDirectEditManager(Class editorType, CellEditorLocator locator) {
            super((GraphicalEditPart)PageEditPart.this, editorType, locator);
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((PageModel)PageEditPart.this.getModel()).getPath());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class PageCellEditorLocator
    implements CellEditorLocator {
        private IFigure figure;

        public PageCellEditorLocator(IFigure f) {
            this.figure = f;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.figure.getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y + 32, rect.width, rect.height - 32);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldPath;
        private String newPath;

        DirectEditCommand() {
        }

        public void execute() {
            PageModel model = (PageModel)PageEditPart.this.getModel();
            this.oldPath = model.getPath();
            model.setPath(this.newPath);
        }

        public void setPath(String path) {
            this.newPath = path;
        }

        public void undo() {
            PageModel model = (PageModel)PageEditPart.this.getModel();
            model.setPath(this.oldPath);
        }
    }

    private class PageDirectEditPolicy
    extends DirectEditPolicy {
        PageDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setPath((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

