/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.xpath;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLCDATA;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLAttrIterator;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLNodeIterator;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class FuzzyXMLNodePointer
extends NodePointer {
    private Object node;

    public FuzzyXMLNodePointer(NodePointer nodePointer, Object object) {
        super(null);
        this.node = object;
    }

    public FuzzyXMLNodePointer(Object object, Locale locale) {
        super(null, locale);
        this.node = object;
    }

    public NodeIterator childIterator(NodeTest nodeTest, boolean bl, NodePointer nodePointer) {
        return new FuzzyXMLNodeIterator(this, nodeTest, bl, nodePointer);
    }

    public NodeIterator attributeIterator(QName qName) {
        return new FuzzyXMLAttrIterator(this, qName);
    }

    public boolean isLeaf() {
        if (this.node instanceof FuzzyXMLElement) {
            return ((FuzzyXMLElement)this.node).getChildren().length == 0;
        }
        if (this.node instanceof FuzzyXMLDocument) {
            return ((FuzzyXMLDocument)this.node).getDocumentElement() == null;
        }
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public QName getName() {
        Object var1_1 = null;
        String string = null;
        if (this.node instanceof FuzzyXMLElement) {
            string = ((FuzzyXMLElement)this.node).getName();
        }
        return new QName(null, string);
    }

    public Object getBaseValue() {
        return this.node;
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public Object getValue() {
        if (this.node instanceof FuzzyXMLElement) {
            return ((FuzzyXMLElement)this.node).getValue().trim();
        }
        if (this.node instanceof FuzzyXMLComment) {
            return ((FuzzyXMLComment)this.node).getValue();
        }
        if (this.node instanceof FuzzyXMLText) {
            return ((FuzzyXMLText)this.node).getValue();
        }
        if (this.node instanceof FuzzyXMLCDATA) {
            return ((FuzzyXMLCDATA)this.node).getValue();
        }
        if (this.node instanceof FuzzyXMLAttribute) {
            return ((FuzzyXMLAttribute)this.node).getValue();
        }
        return null;
    }

    public void setValue(Object object) {
    }

    public int compareChildNodePointers(NodePointer nodePointer, NodePointer nodePointer2) {
        Object object;
        Object object2 = nodePointer.getBaseValue();
        if (object2 == (object = nodePointer2.getBaseValue())) {
            return 0;
        }
        if (object2 instanceof FuzzyXMLAttribute && !(object instanceof FuzzyXMLAttribute)) {
            return -1;
        }
        if (!(object2 instanceof FuzzyXMLAttribute) && object instanceof FuzzyXMLAttribute) {
            return 1;
        }
        if (object2 instanceof FuzzyXMLAttribute && object instanceof FuzzyXMLAttribute) {
            List<FuzzyXMLAttribute> list = Arrays.asList(((FuzzyXMLElement)this.getNode()).getAttributes());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                FuzzyXMLAttribute fuzzyXMLAttribute = list.get(i);
                if (fuzzyXMLAttribute == object2) {
                    return -1;
                }
                if (fuzzyXMLAttribute != object) continue;
                return 1;
            }
            return 0;
        }
        if (!(this.node instanceof FuzzyXMLElement)) {
            throw new RuntimeException("JXPath internal error: compareChildNodes called for " + this.node);
        }
        List<FuzzyXMLNode> list = Arrays.asList(((FuzzyXMLElement)this.node).getChildren());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FuzzyXMLNode fuzzyXMLNode = list.get(i);
            if (fuzzyXMLNode == object2) {
                return -1;
            }
            if (fuzzyXMLNode != object) continue;
            return 1;
        }
        return 0;
    }

    public static boolean testNode(NodePointer nodePointer, Object object, NodeTest nodeTest) {
        if (nodeTest == null) {
            return true;
        }
        if (nodeTest instanceof NodeNameTest) {
            if (!(object instanceof FuzzyXMLElement)) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)nodeTest;
            QName qName = nodeNameTest.getNodeName();
            String string = nodeNameTest.getNamespaceURI();
            boolean bl = nodeNameTest.isWildcard();
            String string2 = qName.getPrefix();
            if (bl && string2 == null) {
                return true;
            }
            if (bl || qName.getName().equals(((FuzzyXMLElement)object).getName())) {
                return true;
            }
        } else if (nodeTest instanceof NodeTypeTest) {
            switch (((NodeTypeTest)nodeTest).getNodeType()) {
                case 1: {
                    return object instanceof FuzzyXMLElement;
                }
                case 2: {
                    return object instanceof FuzzyXMLText || object instanceof FuzzyXMLCDATA;
                }
                case 3: {
                    return object instanceof FuzzyXMLComment;
                }
            }
            return false;
        }
        return false;
    }
}

