/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class XMLValidationHandler
implements ErrorHandler {
    private IResource resource;

    public XMLValidationHandler(IResource resource) {
        this.resource = resource;
        try {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private void addMarker(int line, String message, int type) {
        if (message.startsWith("src-")) {
            return;
        }
        try {
            IMarker marker = this.resource.createMarker("org.eclipse.core.resources.problemmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(type));
            map.put("message", message);
            map.put("lineNumber", new Integer(line));
            marker.setAttributes(map);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        int line = exception.getLineNumber();
        String message = exception.getMessage();
        this.addMarker(line, message, 2);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        int line = exception.getLineNumber();
        String message = exception.getMessage();
        this.addMarker(line, message, 2);
    }

    public void warning(SAXParseException exception) throws SAXException {
        int line = exception.getLineNumber();
        String message = exception.getMessage();
        this.addMarker(line, message, 1);
    }
}

