/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IFileEditorInput;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public class XMLEditor
extends HTMLSourceEditor {
    private boolean validation = true;
    private ArrayList resolvers = new ArrayList();
    private Pattern patternDoctypePublic = Pattern.compile("<!DOCTYPE.+?PUBLIC(\\s|\r|\n)*?\"(.+?)\"(\\s|\r|\n)*?\"(.+?)\"", 32);
    private Pattern patternDoctypeSystem = Pattern.compile("<!DOCTYPE.+?SYSTEM(\\s|\r|\n)*?\"(.+?)\"", 32);
    private Pattern patternNsXSD = Pattern.compile("schemaLocation(\\s|\r|\n)*?=(\\s|\r|\n)*?\"(.+?)\"", 32);

    public XMLEditor() {
        super(new XMLConfiguration(HTMLPlugin.getDefault().getColorProvider()));
    }

    public XMLEditor(XMLConfiguration config) {
        super(config);
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new XMLOutlinePage(this);
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public boolean getValidation() {
        return this.validation;
    }

    public void addDTDResolver(IDTDResolver resolver) {
        this.resolvers.add(resolver);
    }

    public IDTDResolver[] getDTDResolvers() {
        return this.resolvers.toArray(new IDTDResolver[this.resolvers.size()]);
    }

    protected void doValidate() {
        if (!this.validation) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)XMLEditor.this.getEditorInput();
                        String xml = XMLEditor.this.getDocumentProvider().getDocument((Object)input).get();
                        IFile resource = input.getFile();
                        String charset = resource.getCharset();
                        charset = "Shift_JIS";
                        HTMLProjectParams params = new HTMLProjectParams(resource.getProject());
                        if (!params.getUseDTD()) {
                            Matcher matcher = XMLEditor.this.patternDoctypePublic.matcher(xml);
                            if (matcher.find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                            if ((matcher = XMLEditor.this.patternDoctypeSystem.matcher(xml)).find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                        }
                        SAXParser parser = new SAXParser();
                        String dtd = XMLEditor.this.getDTD(xml);
                        String[] xsd = XMLEditor.this.getXSD(xml);
                        if (dtd == null && xsd == null) {
                            parser.setFeature("http://xml.org/sax/features/validation", false);
                        } else {
                            parser.setFeature("http://xml.org/sax/features/validation", true);
                        }
                        if (xsd != null) {
                            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", (Object)"http://www.w3.org/2001/XMLSchema");
                            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", (Object)xsd);
                            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                            parser.setFeature("http://xml.org/sax/features/namespaces", true);
                        }
                        parser.setEntityResolver((EntityResolver)new DTDResolver(XMLEditor.this.getDTDResolvers()));
                        parser.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)resource));
                        parser.parse(new InputSource(new ByteArrayInputStream(xml.getBytes(charset))));
                    }
                    catch (Exception ex) {
                        HTMLPlugin.logException(ex);
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String removeMatched(String source, int start, int end) {
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(0, start));
        int i = start;
        while (i < end + 1) {
            char c = source.charAt(i);
            if (c == '\r' || c == '\n') {
                sb.append(c);
            } else {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(source.substring(end + 1, source.length()));
        return sb.toString();
    }

    public String getDTD(String xml) {
        Matcher matcher = this.patternDoctypePublic.matcher(xml);
        if (matcher.find()) {
            return matcher.group(4);
        }
        matcher = this.patternDoctypeSystem.matcher(xml);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public String[] getXSD(String xml) {
        Matcher matcher = this.patternNsXSD.matcher(xml);
        if (matcher.find()) {
            String matched = matcher.group(3).trim();
            matched.replaceAll("\r\n", "\n");
            matched.replaceAll("\r", "\n");
            String[] xsd = matched.split("\n");
            int i = 0;
            while (i < xsd.length) {
                xsd[i] = xsd[i].trim();
                ++i;
            }
            return xsd;
        }
        return null;
    }

    protected void updateAssist() {
        try {
            String[] xsd;
            DTDResolver resolver;
            InputStream in;
            super.updateAssist();
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
            if (!params.getUseDTD()) {
                return;
            }
            String xml = this.getDocumentProvider().getDocument((Object)input).get();
            String dtd = this.getDTD(xml);
            if (dtd != null && (in = (resolver = new DTDResolver(this.getDTDResolvers())).getInputStream(dtd)) != null) {
                InputStreamReader reader = new InputStreamReader(in);
                XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                assistProcessor.updateDTDInfo(reader);
                ((Reader)reader).close();
            }
            if ((xsd = this.getXSD(xml)) != null) {
                DTDResolver resolver2 = new DTDResolver(this.getDTDResolvers());
                int i = 0;
                while (i < xsd.length) {
                    InputStream in2 = resolver2.getInputStream(xsd[i]);
                    if (in2 != null) {
                        InputStreamReader reader = new InputStreamReader(in2);
                        XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                        assistProcessor.updateXSDInfo(xsd[i], reader);
                        ((Reader)reader).close();
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

