/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.wizards;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSNamedMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;

public class XMLDTDWizardPage
extends WizardPage {
    private Text textPublicID;
    private Combo comboSystemID;
    private Combo comboDocumentRoot;
    private Combo comboSchemaURI;
    private Button radioNone;
    private Button radioDTD;
    private Button radioXSD;
    private Button buttonLoadDTD;

    public XMLDTDWizardPage(String pageName) {
        super(pageName);
        this.setTitle(HTMLPlugin.getResourceString("XMLDTDWizardPage.Title"));
        this.setDescription(HTMLPlugin.getResourceString("XMLDTDWizardPage.Description"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Composite radios = new Composite(composite, 0);
        radios.setLayout((Layout)new FillLayout(512));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        radios.setLayoutData((Object)gd);
        radios.setLayoutData((Object)gd);
        this.radioNone = new Button(radios, 16);
        this.radioNone.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.NoSchema"));
        this.radioNone.setSelection(true);
        this.radioNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (XMLDTDWizardPage.this.radioNone.getSelection()) {
                    XMLDTDWizardPage.this.textPublicID.setEnabled(false);
                    XMLDTDWizardPage.this.comboSystemID.setEnabled(false);
                    XMLDTDWizardPage.this.comboSchemaURI.setEnabled(false);
                    XMLDTDWizardPage.this.buttonLoadDTD.setEnabled(false);
                    XMLDTDWizardPage.this.comboDocumentRoot.setEnabled(false);
                }
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        this.radioDTD = new Button(radios, 16);
        this.radioDTD.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.UseDID"));
        this.radioDTD.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (XMLDTDWizardPage.this.radioDTD.getSelection()) {
                    XMLDTDWizardPage.this.textPublicID.setEnabled(true);
                    XMLDTDWizardPage.this.comboSystemID.setEnabled(true);
                    XMLDTDWizardPage.this.comboSchemaURI.setEnabled(false);
                    XMLDTDWizardPage.this.buttonLoadDTD.setEnabled(true);
                    XMLDTDWizardPage.this.comboDocumentRoot.setEnabled(true);
                }
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        this.radioXSD = new Button(radios, 16);
        this.radioXSD.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.UseXSD"));
        this.radioXSD.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (XMLDTDWizardPage.this.radioXSD.getSelection()) {
                    XMLDTDWizardPage.this.textPublicID.setEnabled(false);
                    XMLDTDWizardPage.this.comboSystemID.setEnabled(false);
                    XMLDTDWizardPage.this.comboSchemaURI.setEnabled(true);
                    XMLDTDWizardPage.this.buttonLoadDTD.setEnabled(true);
                    XMLDTDWizardPage.this.comboDocumentRoot.setEnabled(true);
                }
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        Label label = new Label(composite, 0);
        label.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.PublicID"));
        this.textPublicID = new Text(composite, 2048);
        this.textPublicID.setLayoutData((Object)new GridData(768));
        this.textPublicID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        label = new Label(composite, 0);
        label.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.SystemID"));
        this.comboSystemID = new Combo(composite, 4);
        this.comboSystemID.setLayoutData((Object)new GridData(768));
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String[] uri = store.getString("_pref_dtd_uri").split("\n");
        int i = 0;
        while (i < uri.length) {
            if (uri[i].endsWith(".dtd")) {
                this.comboSystemID.add(uri[i]);
            }
            ++i;
        }
        this.comboSystemID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        label = new Label(composite, 0);
        label.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.XMLSchema"));
        this.comboSchemaURI = new Combo(composite, 4);
        this.comboSchemaURI.setLayoutData((Object)new GridData(768));
        i = 0;
        while (i < uri.length) {
            if (uri[i].endsWith(".xsd")) {
                this.comboSchemaURI.add(uri[i]);
            }
            ++i;
        }
        this.comboSchemaURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        this.buttonLoadDTD = new Button(composite, 8);
        this.buttonLoadDTD.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.LoadDTD"));
        this.buttonLoadDTD.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    if (XMLDTDWizardPage.this.getUseDTD()) {
                        String systemID = XMLDTDWizardPage.this.comboSystemID.getText();
                        XMLDTDWizardPage.this.comboDocumentRoot.removeAll();
                        DTDResolver resolver = new DTDResolver(new IDTDResolver[0]);
                        InputStream in = resolver.getInputStream(systemID);
                        if (in != null) {
                            InputStreamReader reader = new InputStreamReader(in);
                            DTDParser parser = new DTDParser((Reader)reader);
                            DTD dtd = parser.parse();
                            Object[] obj = dtd.getItems();
                            int i = 0;
                            while (i < obj.length) {
                                if (obj[i] instanceof DTDElement) {
                                    DTDElement element = (DTDElement)obj[i];
                                    String name = element.getName();
                                    XMLDTDWizardPage.this.comboDocumentRoot.add(name);
                                }
                                ++i;
                            }
                            XMLDTDWizardPage.this.comboDocumentRoot.select(0);
                        }
                    }
                    if (XMLDTDWizardPage.this.getUseXSD()) {
                        XMLDTDWizardPage.this.comboDocumentRoot.removeAll();
                        DTDResolver resolver = new DTDResolver(new IDTDResolver[0]);
                        InputStream in = resolver.getInputStream(XMLDTDWizardPage.this.getSchemaURI());
                        if (in != null) {
                            SchemaGrammar grammer = (SchemaGrammar)new XMLSchemaLoader().loadGrammar(new XMLInputSource(null, null, null, in, null));
                            XSNamedMap map = grammer.getComponents((short)2);
                            int i = 0;
                            while (i < map.getLength()) {
                                XSElementDeclaration element = (XSElementDeclaration)map.item(i);
                                XMLDTDWizardPage.this.comboDocumentRoot.add(element.getName());
                                ++i;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        });
        label = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(HTMLPlugin.getResourceString("XMLDTDWizardPage.DocumentRoot"));
        this.comboDocumentRoot = new Combo(composite, 8);
        this.comboDocumentRoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLDTDWizardPage.this.setPageComplete(XMLDTDWizardPage.this.validatePage());
            }
        });
        this.textPublicID.setEnabled(false);
        this.comboSystemID.setEnabled(false);
        this.comboSchemaURI.setEnabled(false);
        this.buttonLoadDTD.setEnabled(false);
        this.comboDocumentRoot.setEnabled(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public boolean getUseDTD() {
        return this.radioDTD.getSelection();
    }

    public boolean getUseXSD() {
        return this.radioXSD.getSelection();
    }

    public String getSystemID() {
        return this.comboSystemID.getText();
    }

    public String getPublicID() {
        return this.textPublicID.getText();
    }

    public String getSchemaURI() {
        return this.comboSchemaURI.getText();
    }

    public String getDocumentRoot() {
        return this.comboDocumentRoot.getText();
    }

    private boolean validatePage() {
        if (this.getUseDTD()) {
            if (this.getPublicID().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("XMLDTDWizardPage.Message.PublicID")}));
                return false;
            }
            if (this.getSystemID().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("XMLDTDWizardPage.Message.SystemID")}));
                return false;
            }
            if (this.getDocumentRoot().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("XMLDTDWizardPage.Message.DocumentRoot")}));
                return false;
            }
        }
        if (this.getUseXSD()) {
            if (this.getSchemaURI().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("XMLDTDWizardPage.Message.XMLSchema")}));
                return false;
            }
            if (this.getDocumentRoot().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("XMLDTDWizardPage.Message.DocumentRoot")}));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }
}

