/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.HashMap;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class HTMLValidator {
    private String original;
    private String contents;
    private IFile file;

    public HTMLValidator(IFile file) {
        this.file = file;
    }

    public void doValidate() {
        try {
            String contents;
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            this.original = new String(HTMLUtil.readStream(this.file.getContents()));
            this.contents = contents = HTMLUtil.scriptlet2space(this.original, false);
            this.contents = this.contents.replaceAll("\r\n", " \n");
            this.contents = this.contents.replaceAll("\r", "\n");
            FuzzyXMLParser parser = new FuzzyXMLParser();
            FuzzyXMLDocument doc = parser.parse(contents);
            this.validateDocument(doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateDocument(FuzzyXMLDocument doc) {
    }

    protected IFile getFile() {
        return this.file;
    }

    protected String getContent() {
        return this.original;
    }

    protected void addMarker(int offset, int length, String message) {
        try {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(2));
            map.put("message", message);
            map.put("charStart", new Integer(offset));
            map.put("charEnd", new Integer(offset + length));
            map.put("lineNumber", new Integer(this.getLineAtOffset(offset)));
            marker.setAttributes(map);
        }
        catch (CoreException ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        return text.split("\n").length;
    }
}

