/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class HTMLAnnotationHover
implements IAnnotationHover {
    private IEditorPart editor;

    public HTMLAnnotationHover(IEditorPart editor) {
        this.editor = editor;
    }

    private IMarker[] getMarker() {
        try {
            IFileEditorInput input = (IFileEditorInput)this.editor.getEditorInput();
            IFile file = input.getFile();
            return file.findMarkers("org.eclipse.core.resources.marker", true, 0);
        }
        catch (CoreException e) {
            return new IMarker[0];
        }
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        IMarker[] marker = this.getMarker();
        if (marker != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < marker.length) {
                try {
                    String message;
                    Integer integer = (Integer)marker[i].getAttribute("lineNumber");
                    if (integer != null && integer == lineNumber + 1 && (message = (String)marker[i].getAttribute("message")) != null && message.length() != 0) {
                        if (buffer.length() > 0) {
                            buffer.append("\r\n");
                        }
                        buffer.append(message);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }
}

