/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class HTMLEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor colorForeground;
    private SystemColorFieldEditor colorBackground;
    private ColorFieldEditor colorTag;
    private ColorFieldEditor colorComment;
    private ColorFieldEditor colorDoctype;
    private ColorFieldEditor colorString;
    private ColorFieldEditor colorScriptlet;
    private ColorFieldEditor colorCssProperty;
    private UseSoftTabFieldEditor useSoftTab;
    private SoftTabWidthFieldEditor softTabWidth;
    private RadioGroupFieldEditor editorType;

    public HTMLEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.setTitle(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Appearance"));
        Composite parent = this.getFieldEditorParent();
        this.colorForeground = new ColorFieldEditor("__pref_color_foreground", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.ForegroundColor"), parent);
        this.addField((FieldEditor)this.colorForeground);
        this.colorBackground = new SystemColorFieldEditor("AbstractTextEditor.Color.Background", "AbstractTextEditor.Color.Background.SystemDefault", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.BackgroundColor"), parent);
        this.addField((FieldEditor)this.colorBackground);
        this.colorTag = new ColorFieldEditor("_pref_color_tag", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TagColor"), parent);
        this.addField((FieldEditor)this.colorTag);
        this.colorComment = new ColorFieldEditor("_pref_color_comment", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CommentColor"), parent);
        this.addField((FieldEditor)this.colorComment);
        this.colorDoctype = new ColorFieldEditor("_pref_color_doctype", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.DocTypeColor"), parent);
        this.addField((FieldEditor)this.colorDoctype);
        this.colorString = new ColorFieldEditor("_pref_color_string", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.StringColor"), parent);
        this.addField((FieldEditor)this.colorString);
        this.colorScriptlet = new ColorFieldEditor("_pref_color_scriptlet", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.ScriptColor"), parent);
        this.addField((FieldEditor)this.colorScriptlet);
        this.colorCssProperty = new ColorFieldEditor("_pref_color_cssprop", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CSSPropColor"), parent);
        this.addField((FieldEditor)this.colorCssProperty);
        this.useSoftTab = new UseSoftTabFieldEditor("_pref_use_softtab", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.UseSoftTab"), parent);
        this.addField((FieldEditor)this.useSoftTab);
        this.softTabWidth = new SoftTabWidthFieldEditor("_pref_softtab_width", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.SoftTabWidth"), parent, 4);
        this.softTabWidth.setEnabled(this.getPreferenceStore().getBoolean("_pref_use_softtab"), parent);
        this.addField((FieldEditor)this.softTabWidth);
        this.editorType = new RadioGroupFieldEditor("_pref_editor_type", HTMLPlugin.getResourceString("HTMLEditorPreferencePage.EditorType"), 1, (String[][])new String[][]{{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.EditorTab"), "tab"}, {HTMLPlugin.getResourceString("HTMLEditorPreferencePage.EditorSplitHor"), "horizontal"}, {HTMLPlugin.getResourceString("HTMLEditorPreferencePage.EditorSplitVer"), "vertical"}}, parent, true);
        this.addField((FieldEditor)this.editorType);
    }

    private class SystemColorFieldEditor
    extends ColorFieldEditor {
        private String booleanName = null;
        private Button colorButton;
        private Button checkbox;

        public SystemColorFieldEditor(String colorName, String booleanName, String labelText, Composite parent) {
            super(colorName, labelText, parent);
            this.booleanName = booleanName;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns - 1;
            control.setLayoutData((Object)gd);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.colorButton = this.getChangeControl(composite);
            gd = new GridData();
            gd.heightHint = this.convertVerticalDLUsToPixels((Control)this.colorButton, 14);
            int widthHint = this.convertHorizontalDLUsToPixels((Control)this.colorButton, 61);
            gd.widthHint = Math.max(widthHint, this.colorButton.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.colorButton.setLayoutData((Object)gd);
            this.checkbox = new Button(composite, 32);
            this.checkbox.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.SystemDefault"));
            this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SystemColorFieldEditor this$1;
                {
                    this.this$1 = systemColorFieldEditor;
                }

                public void widgetSelected(SelectionEvent evt) {
                    SystemColorFieldEditor.access$0(this.this$1).setEnabled(!SystemColorFieldEditor.access$1(this.this$1).getSelection());
                }
            });
        }

        protected void doLoad() {
            super.doLoad();
            this.checkbox.setSelection(this.getPreferenceStore().getBoolean(this.booleanName));
            this.colorButton.setEnabled(!this.checkbox.getSelection());
        }

        protected void doLoadDefault() {
            super.doLoadDefault();
            this.checkbox.setSelection(this.getPreferenceStore().getDefaultBoolean(this.booleanName));
            this.colorButton.setEnabled(!this.checkbox.getSelection());
        }

        protected void doStore() {
            super.doStore();
            this.getPreferenceStore().setValue(this.booleanName, this.checkbox.getSelection());
        }

        static /* synthetic */ Button access$0(SystemColorFieldEditor systemColorFieldEditor) {
            return systemColorFieldEditor.colorButton;
        }

        static /* synthetic */ Button access$1(SystemColorFieldEditor systemColorFieldEditor) {
            return systemColorFieldEditor.checkbox;
        }
    }

    private class UseSoftTabFieldEditor
    extends BooleanFieldEditor {
        private Composite parent;

        public UseSoftTabFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
            this.parent = parent;
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            super.valueChanged(oldValue, newValue);
            HTMLEditorPreferencePage.this.softTabWidth.setEnabled(newValue, this.parent);
        }
    }

    private class SoftTabWidthFieldEditor
    extends IntegerFieldEditor {
        public SoftTabWidthFieldEditor(String name, String labelText, Composite parent, int textLimit) {
            super(name, labelText, parent, textLimit);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
            GridData gd = (GridData)this.getTextControl().getLayoutData();
            gd.horizontalAlignment = 0;
            gd.widthHint = 40;
        }
    }
}

