// NewFileFormatDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "NewFileFormatDlg.h"
#include "CodePageManager.h"
#include "..\Manah\ComboBox.h"
using Alpha::CNewFileFormatDlg;
using Alpha::CCodePageManager;


// CNewFileFormatDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnInitDialog
bool CNewFileFormatDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	CComboBox		oCombobox;
	list<UINT>		listCPs;
	const wchar_t*	pwszCPName = 0;
	int				iItem;

	// [R[hy[W]
	oCombobox.Attach(GetDlgItem(IDC_COMBO_CHARCODE));
	CCodePageManager::EnumAvailableCodePages(listCPs);
	for(list<UINT>::const_iterator it = listCPs.begin(); it != listCPs.end(); ++it) {
		pwszCPName = CCodePageManager::GetCodePageName(*it);
		if(wcslen(pwszCPName) != 0) {
			iItem = oCombobox.AddString(pwszCPName);
			oCombobox.SetItemData(iItem, *it);
			if(*it == m_nCodePage)
				oCombobox.SetCurSel(iItem);
		}
	}
	oCombobox.Detach();

	// [sR[h]
	oCombobox.Attach(GetDlgItem(IDC_COMBO_BREAKCODE));
	iItem = oCombobox.AddString(L"CR+LF (Windows)");
	oCombobox.SetItemData(iItem, Ascension::BT_CRLF);
	iItem = oCombobox.AddString(L"LF (Unix)");
	oCombobox.SetItemData(iItem, Ascension::BT_LF);
	iItem = oCombobox.AddString(L"CR (Macintosh)");
	oCombobox.SetItemData(iItem, Ascension::BT_CR);
	iItem = oCombobox.AddString(L"NEL (U+0085)");
	oCombobox.SetItemData(iItem, Ascension::BT_NEL);
	iItem = oCombobox.AddString(L"LS (U+2028)");
	oCombobox.SetItemData(iItem, Ascension::BT_LS);
	iItem = oCombobox.AddString(L"PS (U+2029)");
	oCombobox.SetItemData(iItem, Ascension::BT_PS);
	for(unsigned short i = 0; i < 6; ++i) {
		if(m_breakType == static_cast<Ascension::BreakType>(oCombobox.GetItemData(i))) {
			oCombobox.SetCurSel(i);
			break;
		}
	}
	oCombobox.Detach();

	// [^Cv]
	oCombobox.Attach(GetDlgItem(IDC_COMBO_DOCTYPENAMES));
	for(list<wstring>::const_iterator it =
			m_listDocumentTypes.begin(); it != m_listDocumentTypes.end(); ++it) {
		SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES,
			CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
	}
	oCombobox.SetCurSel(m_iDocumentType);
	oCombobox.Detach();

	return true;
}

///	@see	CDialog::OnOK
void CNewFileFormatDlg::OnOK() {
	m_nCodePage = SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETITEMDATA,
					SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETCURSEL, 0, 0L), 0L);
	m_breakType = static_cast<Ascension::BreakType>(SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_GETITEMDATA,
					SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_GETCURSEL, 0, 0L), 0L));
	m_iDocumentType = SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES, CB_GETCURSEL, 0, 0L);

	CDialog::OnOK();
}

/* [EOF] */