// TextSearcher.h
// (c) 2004 exeal

#ifndef _TEXT_SEARCHER_H_
#define _TEXT_SEARCHER_H_
#include "..\..\Manah\Object.h"


namespace Ascension {

///	tO
typedef unsigned short	SearchFlag;
///	ɂȂ
const SearchFlag	SF_NONE					= 0x0000;
///	啶ʂȂ (P)
const SearchFlag	SF_IGNORE_CASE_SIMPLE	= 0x0001;
///	啶ʂȂ (S)
const SearchFlag	SF_IGNORE_CASE_FULL		= 0x0002;
///	ЉʂȂ
const SearchFlag	SF_IGNORE_KANATYPE		= 0x0004;
///	SppʂȂ
const SearchFlag	SF_IGNORE_WIDTH			= 0x0008;
///	̎ނʂȂ (0-9 ̂)
const SearchFlag	SF_IGNORE_DIGITTYPE		= 0x0010;
///	L𖳎
const SearchFlag	SF_IGNORE_SYMBOLS		= 0x0020;
///	ꏊƂȂ𖳎
const SearchFlag	SF_IGNORE_NONSPACE		= 0x0040;
///	JV_𖳎
const SearchFlag	SF_IGNORE_KASHIDA		= 0x0080;
///	𕪉
const SearchFlag	SF_DECOMPOSE			= 0x0100;
///	
const SearchFlag	SF_BACKWARD				= 0x1000;


///	eLXgs
class CTextSearcher : public Manah::CObject {
	// \bh
public:
	bool	Search(size_t iBegin, size_t& iFound, size_t& cchFound);
	void	SetFlag(SearchFlag flags);
	void	SetString(const wstring& strText);
	void	SetTargetString(const wstring& strText);
private:
	void	_UpdateSearchFlags();
};

} // namespace Ascension

#endif /* _TEXT_SEARCHER_H_ */

/* [EOF] */