// AlphaApplicationObject.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "AlphaApplicationObject.h"
#include "AlphaApp_i.c"	// IID, LIBID
#include "AlphaView.h"
#include "Ascension\EditPoint.h"
#include <limits>

#pragma warning(disable : 4390)	// u䂪̕܂B...v

using Alpha::Ambient::CAdhocEventSink;
using Alpha::Ambient::CApplication;
using Alpha::Ambient::CBreakPoint;
using Alpha::Ambient::CBreakPoints;
using Alpha::Ambient::CDebugger;
using Alpha::Ambient::CDocuments;
using Alpha::Ambient::CTextDocument;
using Alpha::Ambient::CTextPoint;
using Alpha::Ambient::CTextRange;
using Alpha::Ambient::CTextProcessor;
using Alpha::Ambient::CTextSelection;
using Alpha::Ambient::CAutomationScriptHost;
using Alpha::Ambient::CArguments;
using Alpha::CAlphaApp;
using Alpha::CAlphaDoc;
using Alpha::CAlphaView;


// IDispatch::Invoke Ɏg}NA
/////////////////////////////////////////////////////////////////////////////

// ̐`FbNAȂ DISP_E_BADPARAMCOUNT ԂƂ
#define VERIFY_ARGUMENTS_COUNT(c)	\
	if(pDispParams->cArgs != (c))	\
		return DISP_E_BADPARAMCOUNT

// iArgs Ԗڂ̌^ type ɕϊBϊłȂ΃G[R[hԂƂ
// ([Jϐ pDispParams Ahr ApuArgErr Aargs[] 邱ƂO)
#define COERCE_ARGUMENT_AT(iArgs, type)								\
	do {															\
		hr = ::DispGetParam(pDispParams,							\
				pDispParams->cArgs - iArgs - 1, type,				\
				&args[iArgs], puArgErr);							\
		if(FAILED(hr))												\
			return hr;												\
	} while(false)

// _Xbhx̃G[ pExcepInfo ɃZbgA
// DISP_E_EXCEPTION ԂB
// (ʎq pException Ahr Lł邱ƂO)
#define RETURN_WITH_EXCEPTION()										\
	do {															\
		IErrorInfo*	pErrorInfo = 0;									\
		assert(SUCCEEDED(::GetErrorInfo(0, &pErrorInfo)));			\
		pExcepInfo->wCode = 0;										\
		pExcepInfo->scode = hr;										\
		pErrorInfo->GetSource(&pExcepInfo->bstrSource);				\
		pErrorInfo->GetDescription(&pExcepInfo->bstrDescription);	\
		pErrorInfo->GetHelpFile(&pExcepInfo->bstrHelpFile);			\
		pErrorInfo->GetHelpContext(&pExcepInfo->dwHelpContext);		\
		pExcepInfo->pvReserved = 0;									\
		pExcepInfo->pfnDeferredFillIn = 0;							\
		::SetErrorInfo(0, pErrorInfo);								\
		pErrorInfo->Release();										\
		return DISP_E_EXCEPTION;									\
	} while(false)


// CApplication class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CApplication::CApplication(Alpha::CAlphaApp* pApp,
		const vector<wstring>* pvecArguments /* = 0 */) : m_pApp(pApp) {
}

///	fXgN^
CApplication::~CApplication() {
}

///	@see	IApplication::ClearOutput
STDMETHODIMP CApplication::ClearOutput() {
//	m_pApp->m_wndOutput.Clear(OTT_GENERAL, false);
	return S_OK;
}

///	@see	IApplication::get_Active
STDMETHODIMP CApplication::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	*pbActive = m_pApp->GetMainWindow()->m_hWnd == CWindow::GetActiveWindow()->m_hWnd;
	return S_OK;
}

///	@see	IApplication::get_ActiveDocument
STDMETHODIMP CApplication::get_ActiveDocument(IDocument** ppActiveDocument) {
	VERIFY_POINTER(ppActiveDocument);
	*ppActiveDocument = new CTextDocument(m_pApp, m_pApp->GetActiveDocument());
	(*ppActiveDocument)->AddRef();
	return S_OK;
}

///	@see	IApplication::get_Application
STDMETHODIMP CApplication::get_Application(IApplication** ppApplication) {
	VERIFY_POINTER(ppApplication);
	m_pApp->GetAutomation(ppApplication);
	return S_OK;
}

///	@see	IApplication::get_CurrentDirectory
STDMETHODIMP CApplication::get_CurrentDirectory(BSTR* pbstrDirectory) {
	VERIFY_POINTER(pbstrDirectory);
	OLECHAR	wszPath[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, wszPath);
	*pbstrDirectory = ::SysAllocString(wszPath);
	return S_OK;
}

///	@see	IApplication::get_Debugger
STDMETHODIMP CApplication::get_Debugger(IDebugger** ppDebugger) {
	VERIFY_POINTER(ppDebugger);
	*ppDebugger = 0;
	return E_NOTIMPL;
}

///	@see	IApplication::get_Documents
STDMETHODIMP CApplication::get_Documents(IDocuments** ppDocuments) {
	VERIFY_POINTER(ppDocuments);
	m_pApp->GetAutomationDocuments(ppDocuments);
	return S_OK;
}

///	@see	IApplication::getFullName
STDMETHODIMP CApplication::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszFileName[MAX_PATH];

	::GetModuleFileName(0, wszFileName, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszFileName);
	return S_OK;
}

///	@see	IApplication::get_Height
STDMETHODIMP CApplication::get_Height(long* pnHeight) {
	VERIFY_POINTER(pnHeight);

	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	*pnHeight = rect.bottom - rect.top;
	return S_OK;
}

///	@see	IApplication::get_Left
STDMETHODIMP CApplication::get_Left(long* pnLeft) {
	VERIFY_POINTER(pnLeft);

	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	*pnLeft = rect.left;
	return S_OK;
}

///	@see	IApplication::get_Name
STDMETHODIMP CApplication::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(IDS_APPNAME OLESTR(" ") IDS_APPVERSION OLESTR(" ") IDS_APPVERSIONINFO);
	return S_OK;
}

///	@see	IApplication::get_Top
STDMETHODIMP CApplication::get_Top(long* pnTop) {
	VERIFY_POINTER(pnTop);

	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	*pnTop = rect.top;
	return S_OK;
}

///	@see	IApplication::get_Version
STDMETHODIMP CApplication::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = ::SysAllocString(ASH_VERSION);
	return S_OK;
}

///	@see	IApplication::get_Visible
STDMETHODIMP CApplication::get_Visible(VARIANT_BOOL* pbVisible) {
	VERIFY_POINTER(pbVisible);
	*pbVisible = m_pApp->GetMainWindow()->IsWindowVisible();
	return S_OK;
}

///	@see	IApplication::get_Width
STDMETHODIMP CApplication::get_Width(long* pnWidth) {
	VERIFY_POINTER(pnWidth);

	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	*pnWidth = rect.right - rect.left;
	return S_OK;
}

///	@see	IApplication::get_WindowState
STDMETHODIMP CApplication::get_WindowState(AlphaWindowState* palphaWindowState) {
	VERIFY_POINTER(palphaWindowState);

	if(m_pApp->GetMainWindow()->IsIconic())
		*palphaWindowState = AWS_MINIMIZED;
	else if(m_pApp->GetMainWindow()->IsZoomed())
		*palphaWindowState = AWS_MAXIMIZED;
	else
		*palphaWindowState = AWS_NORMAL;
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CApplication::Invoke(DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	bool			bCreatedResult = false;
	CComVariant		args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:
			pVarResult->vt = VT_BOOL;
			return get_Active(&pVarResult->boolVal);
		case DISPID_APPLICATION_ACTIVEDOCUMENT:
			pVarResult->vt = VT_DISPATCH;
			return get_ActiveDocument(reinterpret_cast<IDocument**>(&pVarResult->pdispVal));
		case DISPID_APPLICATION_CURRENTDIRECTORY:
			pVarResult->vt = VT_BSTR;
			return get_CurrentDirectory(&pVarResult->bstrVal);
		case DISPID_APPLICATION_DOCUMENTS:
			pVarResult->vt = VT_DISPATCH;
			return get_Documents(reinterpret_cast<IDocuments**>(&pVarResult->pdispVal));
		case DISPID_APPLICATION_FULLNAME:
			pVarResult->vt = VT_BSTR;
			return get_FullName(&pVarResult->bstrVal);
		case DISPID_APPLICATION_HEIGHT:
			pVarResult->vt = VT_I4;
			return get_Height(&pVarResult->lVal);
		case DISPID_APPLICATION_LEFT:
			pVarResult->vt = VT_I4;
			return get_Left(&pVarResult->lVal);
		case DISPID_APPLICATION_NAME:
		case 0:
			pVarResult->vt = VT_BSTR;
			return get_Name(&pVarResult->bstrVal);
		case DISPID_APPLICATION_TOP:
			pVarResult->vt = VT_I4;
			return get_Top(&pVarResult->lVal);
		case DISPID_APPLICATION_VERSION:
			pVarResult->vt = VT_BSTR;
			return get_Version(&pVarResult->bstrVal);
		case DISPID_APPLICATION_VISIBLE:
			pVarResult->vt = VT_BOOL;
			return get_Visible(&pVarResult->boolVal);
		case DISPID_APPLICATION_WIDTH:
			pVarResult->vt = VT_I4;
			return get_Width(&pVarResult->lVal);
		case DISPID_APPLICATION_WINDOWSTATE:
			pVarResult->vt = VT_I2;
			return get_WindowState(reinterpret_cast<AlphaWindowState*>(&pVarResult->iVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Active(args[0].boolVal);
		case DISPID_APPLICATION_CURRENTDIRECTORY:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return put_CurrentDirectory(args[0].bstrVal);
		case DISPID_APPLICATION_HEIGHT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Height(args[0].lVal);
		case DISPID_APPLICATION_LEFT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Left(args[0].lVal);
		case DISPID_APPLICATION_TOP:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Top(args[0].lVal);
		case DISPID_APPLICATION_VISIBLE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Visible(args[0].boolVal);
		case DISPID_APPLICATION_WIDTH:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Width(args[0].lVal);
		case DISPID_APPLICATION_WINDOWSTATE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_WindowState(static_cast<AlphaWindowState>(args[0].iVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
			;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_APPLICATION_CLEAROUTPUT:
			VERIFY_ARGUMENTS_COUNT(0);
			return ClearOutput();
		case DISPID_APPLICATION_QUIT:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Quit(args[0].iVal);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_APPLICATION_WRITETOOUTPUT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return WriteToOutput(args[1].bstrVal, args[0].boolVal);
		case DISPID_APPLICATION_WRITELINETOOUTPUT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return WriteLineToOutput(args[1].bstrVal, args[0].boolVal);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IApplication::put_Active
STDMETHODIMP CApplication::put_Active(VARIANT_BOOL bActive) {
	if(bActive)
		m_pApp->GetMainWindow()->SetActiveWindow();
	else
		::SetActiveWindow(::GetDesktopWindow());
	return S_OK;
}

///	@see	IApplication::put_CurrentDirectory
STDMETHODIMP CApplication::put_CurrentDirectory(BSTR bstrDirectory) {
	::SetCurrentDirectoryW((bstrDirectory != 0) ? bstrDirectory : L"");
	return S_OK;
}

///	@see	IApplication::put_Height
STDMETHODIMP CApplication::put_Height(long nHeight) {
	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	m_pApp->GetMainWindow()->SetWindowPos(0, 0, 0, rect.right - rect.left, nHeight, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_Left
STDMETHODIMP CApplication::put_Left(long nLeft) {
	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	m_pApp->GetMainWindow()->SetWindowPos(0, nLeft, rect.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_Top
STDMETHODIMP CApplication::put_Top(long nTop) {
	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	m_pApp->GetMainWindow()->SetWindowPos(0, rect.left, nTop, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_Visible
STDMETHODIMP CApplication::put_Visible(VARIANT_BOOL bVisible) {
	m_pApp->GetMainWindow()->ShowWindow(bVisible ? SW_SHOW : SW_HIDE);
	return S_OK;
}

///	@see	IApplication::put_Width
STDMETHODIMP CApplication::put_Width(long nWidth) {
	RECT	rect;
	m_pApp->GetMainWindow()->GetWindowRect(&rect);
	m_pApp->GetMainWindow()->SetWindowPos(0, 0, 0, nWidth, rect.bottom - rect.top, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_WindowState
STDMETHODIMP CApplication::put_WindowState(AlphaWindowState alphaWindowState) {
	switch(alphaWindowState) {
	case AWS_MINIMIZED:
		m_pApp->GetMainWindow()->ShowWindow(SW_MINIMIZE);
		break;
	case AWS_MAXIMIZED:
		m_pApp->GetMainWindow()->ShowWindow(SW_MAXIMIZE);
		break;
	case AWS_NORMAL:
		m_pApp->GetMainWindow()->ShowWindow(SW_RESTORE);
		break;
	default:
		return E_INVALIDARG;
		break;
	}
	return S_OK;
}

///	@see	IApplication::Quit
STDMETHODIMP CApplication::Quit(short nErrorCode) {
	m_pApp->GetMainWindow()->SendMessage(WM_CLOSE);
	return S_OK;
}

///	@see	IApplication::WriteToOutput
STDMETHODIMP CApplication::WriteToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_pApp->m_wndOutput.Write(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}

///	@see	IApplication::WriteLineToOutput
STDMETHODIMP CApplication::WriteLineToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_pApp->m_wndOutput.WriteLine(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}


// CDocuments class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDocuments::CDocuments(Alpha::CAlphaApp* pApp) : m_pApp(pApp) {
	assert(m_pApp != 0);
}

///	@see	IDocuments::AddNew
STDMETHODIMP CDocuments::AddNew() {
	m_pApp->GetMainWindow()->SendMessage(WM_COMMAND, IDCM_FILE_NEW);
	return S_OK;
}

///	@see	IDocuments::CloseAll
STDMETHODIMP CDocuments::CloseAll() {
	m_pApp->GetMainWindow()->SendMessage(WM_COMMAND, IDCM_FILE_CLOSEALL);
	return S_OK;
}

///	@see	IDocuments::get_Application
STDMETHODIMP CDocuments::get_Application(IApplication** ppApplication) {
	VERIFY_POINTER(ppApplication);
	*ppApplication = new CApplication(m_pApp);
	(*ppApplication)->AddRef();
	return S_OK;
}

///	@see	IDocuments::get_Count
STDMETHODIMP CDocuments::get_Count(long* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_pApp->GetTabCount();
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CDocuments::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	bool		bCreatedResult = false;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENTS_APPLICATION:
			pVarResult->vt = VT_DISPATCH;
			return get_Application(reinterpret_cast<IApplication**>(&pVarResult->pdispVal));
		case DISPID_DOCUMENTS_COUNT:
			pVarResult->vt = VT_I4;
			return get_Count(&pVarResult->lVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_DOCUMENTS_ADDNEW:
			VERIFY_ARGUMENTS_COUNT(0);
			return AddNew();
		case DISPID_DOCUMENTS_CLOSEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return CloseAll();
		case DISPID_DOCUMENTS_ITEM:
		case 0:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			if(pVarResult == 0) {
				pVarResult = new VARIANT;
				bCreatedResult = true;
			}
			pVarResult->vt = VT_DISPATCH;
			hr = Item(args[0].lVal, reinterpret_cast<IDocument**>(&pVarResult->pdispVal));
			if(bCreatedResult) {
				delete pVarResult;
				pVarResult = 0;
			}
			return hr;
		case DISPID_DOCUMENTS_OPEN:
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Open(args[1].bstrVal, static_cast<AlphaFileShareMode>(args[0].iVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I2);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return Open(args[2].bstrVal,
					static_cast<AlphaFileShareMode>(args[1].iVal), args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENTS_SAVEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return SaveAll();
		}
	}

	return hr;
}

///	@see	IDocuments::Item
STDMETHODIMP CDocuments::Item(long iDocument, IDocument** ppDocument) {
	VERIFY_POINTER(ppDocument);
	try {
		m_pApp->GetTextEditor(iDocument)->GetDocument()->GetAutomation(m_pApp, ppDocument);
	} catch(out_of_range& /* e */) {
		*ppDocument = 0;
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IDocuments::Open
STDMETHODIMP CDocuments::Open(
		BSTR bstrPathName, AlphaFileShareMode nShareMode, long nCodePage /* = 0 */) {
	if(bstrPathName == 0)
		return E_INVALIDARG;
	m_pApp->OpenFile(bstrPathName, (nCodePage != 0) ? nCodePage : ::GetACP());
	return S_OK;
}

///	@see	IDocuments::SaveAll
STDMETHODIMP CDocuments::SaveAll() {
	m_pApp->GetMainWindow()->SendMessage(WM_COMMAND, IDCM_FILE_SAVEALL);
	return S_OK;
}


// CTextDocument class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextDocument::CTextDocument(
		CAlphaApp* pApp, CAlphaDoc* pDocument) : m_pApp(pApp), m_pDocument(pDocument) {
	assert(m_pApp != 0 && m_pDocument != 0);
}

///	@see	IDocument::ClearUndoBuffer
STDMETHODIMP CTextDocument::ClearUndoBuffer() {
	m_pDocument->ClearUndoBuffer();
	return S_OK;
}

///	@see	IDocument::Close
STDMETHODIMP CTextDocument::Close(VARIANT_BOOL bConfirm /* = VARIANT_TRUE */) {
	m_pApp->SetActiveTab(FindDocument());
	m_pApp->GetMainWindow()->SendMessage(WM_COMMAND, MAKEWPARAM(IDCM_FILE_CLOSE, !bConfirm));
	return S_OK;
}

/**
 *	AvP[VIuWFNg (CAlphaApp) 玩̃^uԍT
 *	@return	^uԍ
 */
unsigned int CTextDocument::FindDocument() const {
	for(unsigned int iTab = 0; iTab < m_pApp->GetTabCount(); ++iTab) {
		if(m_pApp->GetTab(iTab)->IsTextEditor()
				&& m_pApp->GetTextEditor(iTab) == m_pDocument->GetController())
			return iTab;
	}
	assert(false);	//tȂ͖͂
	return -1;
}

///	@see	IDocument::get_Active
STDMETHODIMP CTextDocument::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	*pbActive = m_pApp->GetActiveDocument() == m_pDocument;
	return S_OK;
}

///	@see	IDocument::get_Application
STDMETHODIMP CTextDocument::get_Application(IApplication** ppApplication) {
	VERIFY_POINTER(ppApplication);
	m_pApp->GetAutomation(ppApplication);
	return S_OK;
}

///	@see	IDocument::get_BreakType
STDMETHODIMP CTextDocument::get_BreakType(AlphaBreakType* pBreakType) {
	VERIFY_POINTER(pBreakType);
	*pBreakType = static_cast<AlphaBreakType>(m_pDocument->GetBreakType());
	return S_OK;
}

///	@see	IDocument::get_CodePage
STDMETHODIMP CTextDocument::get_CodePage(long* pnCodePage) {
	VERIFY_POINTER(pnCodePage == 0);
	*pnCodePage = m_pDocument->GetCodePage();
	return S_OK;
}

///	@see	ITextDocument::get_EndPoint
STDMETHODIMP CTextDocument::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);
	*ppEndPoint = new CTextPoint(m_pApp,
		m_pDocument->GetController()->GetActiveView()->CreateEditPoint(CCharPos(-1, -1)));
	(*ppEndPoint)->AddRef();
	return S_OK;
}

///	@see	IDocument::get_FileName
STDMETHODIMP CTextDocument::get_FileName(BSTR* pbstrFileName) {
	VERIFY_POINTER(pbstrFileName);
	*pbstrFileName = ::SysAllocString(m_pDocument->GetTitle().c_str());
	return S_OK;
}

///	@see	IDocument::get_FilePath
STDMETHODIMP CTextDocument::get_FilePath(BSTR* pbstrFilePath) {
	VERIFY_POINTER(pbstrFilePath);
	*pbstrFilePath = ::SysAllocString(m_pDocument->GetPathName().c_str());
	return S_OK;
}

///	@see	IDocument::get_Modified
STDMETHODIMP CTextDocument::get_Modified(VARIANT_BOOL* pbModified) {
	VERIFY_POINTER(pbModified);
	*pbModified = m_pDocument->IsModified();
	return S_OK;
}

///	@see	IDocument::get_ReadOnly
STDMETHODIMP CTextDocument::get_ReadOnly(VARIANT_BOOL* pbReadOnly) {
	VERIFY_POINTER(pbReadOnly);
	*pbReadOnly = m_pDocument->IsReadOnly();
	return S_OK;
}

///	@see	ITextDocument::get_StartPoint
STDMETHODIMP CTextDocument::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
	*ppStartPoint = new CTextPoint(m_pApp,
		m_pDocument->GetController()->GetActiveView()->CreateEditPoint(CCharPos(0, 0)));
	(*ppStartPoint)->AddRef();
	return S_OK;
}

///	@see	ITextDocument::get_TextProcessor
STDMETHODIMP CTextDocument::get_TextProcessor(ITextProcessor** ppTextProcessor) {
	VERIFY_POINTER(ppTextProcessor);
	*ppTextProcessor = new CTextProcessor(m_pApp, m_pDocument->GetController()->GetActiveView());
	(*ppTextProcessor)->AddRef();
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTextDocument::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENT_ACTIVE:
			pVarResult->vt = VT_BOOL;
			return get_Active(&pVarResult->boolVal);
		case DISPID_DOCUMENT_APPLICATION:
			pVarResult->vt = VT_DISPATCH;
			return get_Application(reinterpret_cast<IApplication**>(&pVarResult->pdispVal));
		case DISPID_DOCUMENT_BREAKTYPE:
			pVarResult->vt = VT_I2;
			return get_BreakType(reinterpret_cast<AlphaBreakType*>(&pVarResult->iVal));
		case DISPID_DOCUMENT_CODEPAGE:
			pVarResult->vt = VT_I4;
			return get_CodePage(&pVarResult->lVal);
		case DISPID_TEXTDOCUMENT_ENDPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_EndPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_DOCUMENT_FILENAME:
			pVarResult->vt = VT_BSTR;
			return get_FileName(&pVarResult->bstrVal);
		case DISPID_DOCUMENT_FILEPATH:
		case 0:
			pVarResult->vt = VT_BSTR;
			return get_FilePath(&pVarResult->bstrVal);
		case DISPID_DOCUMENT_MODIFIED:
			pVarResult->vt = VT_BOOL;
			return get_Modified(&pVarResult->boolVal);
		case DISPID_DOCUMENT_READONLY:
			pVarResult->vt = VT_BOOL;
			return get_ReadOnly(&pVarResult->boolVal);
		case DISPID_TEXTDOCUMENT_STARTPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_StartPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTDOCUMENT_TEXTPROCESSOR:
			pVarResult->vt = VT_DISPATCH;
			return get_TextProcessor(reinterpret_cast<ITextProcessor**>(&pVarResult->pdispVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_DOCUMENT_ACTIVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Active(args[0].boolVal);
		case DISPID_DOCUMENT_BREAKTYPE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_BreakType(static_cast<AlphaBreakType>(args[0].iVal));
		case DISPID_DOCUMENT_CODEPAGE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_CodePage(args[0].lVal);
		case DISPID_DOCUMENT_MODIFIED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Modified(args[0].boolVal);
		case DISPID_DOCUMENT_READONLY:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ReadOnly(args[0].boolVal);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_DOCUMENT_CLEARUNDOBUFFER:
			VERIFY_ARGUMENTS_COUNT(0);
			return ClearUndoBuffer();
		case DISPID_DOCUMENT_CLOSE:
			if(pDispParams->cArgs == 0)
				return Close();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Close(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENT_REDO:
			VERIFY_ARGUMENTS_COUNT(0);
			return Redo();
		case DISPID_DOCUMENT_SAVE:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return Save(args[0].bstrVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Save(args[1].bstrVal, static_cast<AlphaBreakType>(args[0].iVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I2);
				COERCE_ARGUMENT_AT(0, VT_UI2);
				return Save(args[2].bstrVal,
					static_cast<AlphaBreakType>(args[1].iVal), args[0].uiVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENT_UNDO:
			VERIFY_ARGUMENTS_COUNT(0);
			return Undo();
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IDocument::put_Active
STDMETHODIMP CTextDocument::put_Active(VARIANT_BOOL bActive) {
	m_pApp->SetActiveTab(FindDocument());
	return S_OK;
}

///	@see	IDocument::put_BreakType
STDMETHODIMP CTextDocument::put_BreakType(AlphaBreakType breakType) {
	try {
		m_pDocument->SetBreakType(static_cast<BreakType>(breakType));
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IDocument::put_CodePage
STDMETHODIMP CTextDocument::put_CodePage(long nCodePage) {
	try {
		m_pDocument->SetCodePage(nCodePage);
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IDocument::put_Modified
STDMETHODIMP CTextDocument::put_Modified(VARIANT_BOOL bModified) {
	m_pDocument->SetModified(toBoolean(bModified));
	return S_OK;
}

///	@see	IDocument::put_ReadOnly
STDMETHODIMP CTextDocument::put_ReadOnly(VARIANT_BOOL bReadOnly) {
	m_pDocument->SetReadOnly(toBoolean(bReadOnly));
	return S_OK;
}

///	@see	IDocument::Redo
STDMETHODIMP CTextDocument::Redo() {
	m_pDocument->Redo();
	return S_OK;
}

///	@see	IDocument::Save
STDMETHODIMP CTextDocument::Save(
		BSTR bstrFileName, AlphaBreakType breakType /* = ABT_AUTO */, long nCodePage /* = 0 */) {
	if(bstrFileName == 0)
		return E_INVALIDARG;
	if(SS_OK == m_pDocument->SaveDocument(bstrFileName,
						SDO_IGNORE_NOFITCHARS,
						static_cast<BreakType>(breakType), nCodePage))
		return S_OK;
	return S_FALSE;
}

///	@see	IDocument::Undo
STDMETHODIMP CTextDocument::Undo() {
	m_pDocument->Undo();
	return S_OK;
}


// CTextProcessor class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextProcessor::CTextProcessor(CAlphaApp* pApp, CAlphaView* pView)
		: m_pApp(pApp), m_pView(pView) {
	assert(m_pApp != 0 && m_pView != 0);
}

///	@see	ITextProcessor::BackSpace
STDMETHODIMP CTextProcessor::BackSpace() {
	m_pView->ExecCommand(CMDID_EDIT_BACKSPACE, 0L);
	return S_OK;
}

///	@see	ITextProcessor::CreateEditPoint
STDMETHODIMP CTextProcessor::CreateEditPoint(ITextPoint* pTextPoint, IEditPoint** ppEditPoint) {
	VERIFY_POINTER(ppEditPoint);
	*ppEditPoint = 0;
	return E_NOTIMPL;
}

///	@see	ITextProcessor::Delete
STDMETHODIMP CTextProcessor::Delete() {
	m_pView->ExecCommand(CMDID_EDIT_DELETE, 0L);
	return S_OK;
}

///	@see	ITextProcessor::FindText
STDMETHODIMP CTextProcessor::FindText(
		BSTR bstrFindWhat, AlphaFindTextFlags ftf, VARIANT_BOOL* pbFound) {
	VERIFY_POINTER(pbFound);

	if(bstrFindWhat == 0)
		return E_INVALIDARG;
	*pbFound = toVariantBoolean(m_pView->FindNext(bstrFindWhat, static_cast<EditViewFindFlag>(ftf)));
	return S_OK;
}

///	@see	ITextProcessor::get_Application
STDMETHODIMP CTextProcessor::get_Application(IApplication** ppApplication) {
	VERIFY_POINTER(ppApplication);
	m_pApp->GetAutomation(ppApplication);
	return S_OK;
}

///	@see	ITextProcessor::get_OverwriteMode
STDMETHODIMP CTextProcessor::get_OverwriteMode(VARIANT_BOOL* pbOverwriteMode) {
	VERIFY_POINTER(pbOverwriteMode);
	*pbOverwriteMode = toVariantBoolean(m_pView->IsOverwriteMode());
	return S_OK;
}

///	@see	ITextProcessor::get_Selection
STDMETHODIMP CTextProcessor::get_Selection(ITextSelection** ppSelection) {
	VERIFY_POINTER(ppSelection);
	m_pView->GetAutomation(IID_ITextSelection, m_pApp, reinterpret_cast<IDispatch**>(ppSelection));
	return S_OK;
}

///	@see	ITextProcessor::get_TabWidth
STDMETHODIMP CTextProcessor::get_TabWidth(short* pnTabWidth) {
	VERIFY_POINTER(pnTabWidth);
	*pnTabWidth = m_pView->GetTabWidth();
	return S_OK;
}

///	@see	ITextProcessor::Indent
STDMETHODIMP CTextProcessor::Indent() {
	m_pView->ExecCommand(CMDID_EDIT_TABINDENT, false);
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTextProcessor::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_APPLICATION:
			pVarResult->vt = VT_DISPATCH;
			return get_Application(reinterpret_cast<IApplication**>(&pVarResult->pdispVal));
		case DISPID_TEXTPROCESSOR_OVERWRITEMODE:
			pVarResult->vt = VT_BOOL;
			return get_OverwriteMode(&pVarResult->boolVal);
		case DISPID_TEXTPROCESSOR_SELECTION:
			pVarResult->vt = VT_DISPATCH;
			return get_Selection(reinterpret_cast<ITextSelection**>(&pVarResult->pdispVal));
		case DISPID_TEXTPROCESSOR_TABWIDTH:
			pVarResult->vt = VT_I2;
			return get_TabWidth(&pVarResult->iVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_OVERWRITEMODE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_OverwriteMode(args[0].boolVal);
		case DISPID_TEXTPROCESSOR_TABWIDTH:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_TabWidth(args[0].iVal);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_BACKSPACE:
			VERIFY_ARGUMENTS_COUNT(0);
			return BackSpace();
		case DISPID_TEXTPROCESSOR_DELETE:
			VERIFY_ARGUMENTS_COUNT(0);
			return Delete();
		case DISPID_TEXTPROCESSOR_FINDTEXT:
			VERIFY_ARGUMENTS_COUNT(2);
			pVarResult->vt = VT_BOOL;
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return FindText(args[1].bstrVal,
				static_cast<AlphaFindTextFlags>(args[0].iVal), &pVarResult->boolVal);
		case DISPID_TEXTPROCESSOR_INDENT:
			VERIFY_ARGUMENTS_COUNT(0);
			return Indent();
		case DISPID_TEXTPROCESSOR_NEWLINE:
			VERIFY_ARGUMENTS_COUNT(0);
			return NewLine();
		case DISPID_TEXTPROCESSOR_PASTE:
			VERIFY_ARGUMENTS_COUNT(0);
			return Paste();
		case DISPID_TEXTPROCESSOR_UNINDENT:
			VERIFY_ARGUMENTS_COUNT(0);
			return Unindent();
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	ITextProcessor::NewLine
STDMETHODIMP CTextProcessor::NewLine() {
	m_pView->ExecCommand(CMDID_EDIT_BREAK, 0L);
	return S_OK;
}

///	@see	ITextProcessor::Paste
STDMETHODIMP CTextProcessor::Paste() {
	m_pView->ExecCommand(CMDID_EDIT_PASTE, 0L);
	return S_OK;
}

///	@see	ITextProcessor::put_OverwriteMode
STDMETHODIMP CTextProcessor::put_OverwriteMode(VARIANT_BOOL bOverwriteMode) {
	m_pView->SetOverwriteMode(toBoolean(bOverwriteMode));
	return S_OK;
}

///	@see	ITextProcessor::put_TabWidth
STDMETHODIMP CTextProcessor::put_TabWidth(short nTabWidth) {
	m_pView->SetTabWidth(nTabWidth);
	return S_OK;
}

///	@see	ITextProcessor::Unindent
STDMETHODIMP CTextProcessor::Unindent() {
	m_pView->ExecCommand(CMDID_EDIT_TABINDENT, true);
	return S_OK;
}


// CTextSelection class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSelection::CTextSelection(CAlphaApp* pApp, CAlphaView* pView)
		: m_pApp(pApp), m_pView(pView) {
	assert(m_pApp != 0 && m_pView != 0);
}

///	@see	ITextSelection::Cancel
STDMETHODIMP CTextSelection::Cancel() {
	m_pView->ExecCommand(CMDID_MOVE_CANCELSELECTION);
	return S_OK;
}

///	@see	ITextSelection::CharNext
STDMETHODIMP CTextSelection::CharNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return E_INVALIDARG;
	while(cOffset-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_CHARNEXTEXTEND : CMDID_MOVE_CHARNEXT);
	return S_OK;
}

///	@see	ITextSelection::CharPrev
STDMETHODIMP CTextSelection::CharPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return E_INVALIDARG;
	while(cOffset-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_CHARPREVEXTEND : CMDID_MOVE_CHARPREV);
	return S_OK;
}

///	@see	ITextSelection::Copy
STDMETHODIMP CTextSelection::Copy() {
	m_pView->ExecCommand(CMDID_EDIT_COPY);
	return S_OK;
}

///	@see	ITextSelection::Cut
STDMETHODIMP CTextSelection::Cut() {
	m_pView->ExecCommand(CMDID_EDIT_CUT);
	return S_OK;
}

///	@see	ITextSelection::get_ActiveEndGreater
STDMETHODIMP CTextSelection::get_ActiveEndGreater(VARIANT_BOOL* pbActiveEndGreater) {
	VERIFY_POINTER(pbActiveEndGreater);
	CCharPos	posBegin, posEnd;
	m_pView->GetSel(posBegin, posEnd);
	*pbActiveEndGreater = toVariantBoolean(posBegin < posEnd);
	return S_OK;
}

///	@see	ITextSelection::get_ActivePoint
STDMETHODIMP CTextSelection::get_ActivePoint(ITextPoint** ppActivePoint) {
	VERIFY_POINTER(ppActivePoint);
	CCharPos	posBegin, posEnd;
	m_pView->GetSel(posBegin, posEnd);
	*ppActivePoint = new CTextPoint(m_pApp, m_pView->CreateEditPoint(posEnd));
	(*ppActivePoint)->AddRef();
	return S_OK;
}

///	@see	ITextSelection::get_AnchorPoint
STDMETHODIMP CTextSelection::get_AnchorPoint(ITextPoint** ppAnchorPoint) {
	VERIFY_POINTER(ppAnchorPoint);
	CCharPos	posBegin, posEnd;
	m_pView->GetSel(posBegin, posEnd);
	*ppAnchorPoint = new CTextPoint(m_pApp, m_pView->CreateEditPoint(posBegin));
	(*ppAnchorPoint)->AddRef();
	return S_OK;
}

///	@see	ITextSelection::get_Application
STDMETHODIMP CTextSelection::get_Application(IApplication** ppApplication) {
	m_pApp->GetAutomation(ppApplication);
	return S_OK;
}

///	@see	ITextSelection::get_BottomPoint
STDMETHODIMP CTextSelection::get_BottomPoint(ITextPoint** ppBottomPoint) {
	VERIFY_POINTER(ppBottomPoint);
	CCharPos	posBegin, posEnd;
	m_pView->GetSel(posBegin, posEnd);
	*ppBottomPoint = new CTextPoint(
		m_pApp, m_pView->CreateEditPoint((posBegin < posEnd) ? posEnd : posBegin));
	(*ppBottomPoint)->AddRef(); 
	return S_OK;
}

///	@see	ITextSelection::get_Empty
STDMETHODIMP CTextSelection::get_Empty(VARIANT_BOOL* pbEmpty) {
	VERIFY_POINTER(pbEmpty);
	*pbEmpty = toVariantBoolean(!m_pView->HasSelection());
	return S_OK;
}

///	@see	ITextSelection::get_Text
STDMETHODIMP CTextSelection::get_Text(BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	*pbstrText = ::SysAllocString(m_pView->GetSelection().c_str());
	return S_OK;
}

///	@see	ITextSelection::get_TextRanges
STDMETHODIMP CTextSelection::get_TextRanges(ITextRanges** ppTextRanges) {
	VERIFY_POINTER(ppTextRanges);
	*ppTextRanges = 0;
	return E_NOTIMPL;
}

///	@see	ITextSelection::get_TopPoint
STDMETHODIMP CTextSelection::get_TopPoint(ITextPoint** ppTopPoint) {
	VERIFY_POINTER(ppTopPoint);
	CCharPos	posBegin, posEnd;
	m_pView->GetSel(posBegin, posEnd);
	*ppTopPoint = new CTextPoint(
		m_pApp, m_pView->CreateEditPoint((posBegin < posEnd) ? posBegin : posEnd));
	(*ppTopPoint)->AddRef(); 
	return S_OK;
}

///	@see	ITextSelection::GoToEndOfDocument
STDMETHODIMP CTextSelection::GoToEndOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_pView->ExecCommand(bExtend ? CMDID_MOVE_ENDEXTEND : CMDID_MOVE_END);
	return S_OK;
}

///	@see	ITextSelection::GoToEndOfLine
STDMETHODIMP CTextSelection::GoToEndOfLine(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_pView->ExecCommand(bExtend ? CMDID_MOVE_LINEENDEXTEND : CMDID_MOVE_LINEEND);
	return S_OK;
}

///	@see	ITextSelection::GoToNextBookmark
STDMETHODIMP CTextSelection::GoToNextBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_pView->ExecCommand(CMDID_MOVE_BOOKMARKNEXT);
	return S_OK;
}

///	@see	ITextSelection::GoToPreviousBookmark
STDMETHODIMP CTextSelection::GoToPreviousBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_pView->ExecCommand(CMDID_MOVE_BOOKMARKPREV);
	return S_OK;
}

///	@see	ITextSelection::GoToStartOfDocument
STDMETHODIMP CTextSelection::GoToStartOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_pView->ExecCommand(bExtend ? CMDID_MOVE_HOMEEXTEND : CMDID_MOVE_HOME);
	return S_OK;
}

///	@see	ITextSelection::GoToStartOfLine
STDMETHODIMP CTextSelection::GoToStartOfLine(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_pView->ExecCommand(bExtend ? CMDID_MOVE_LINEHOMEEXTEND : CMDID_MOVE_LINEHOME);
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTextSelection::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_ACTIVEENDGREATER:
			pVarResult->vt = VT_BOOL;
			return get_ActiveEndGreater(&pVarResult->boolVal);
		case DISPID_TEXTSELECTION_ACTIVEPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_ActivePoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_ANCHORPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_AnchorPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_APPLICATION:
			pVarResult->vt = VT_DISPATCH;
			return get_Application(reinterpret_cast<IApplication**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_BOTTOMPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_BottomPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_EMPTY:
			pVarResult->vt = VT_BOOL;
			return get_Empty(&pVarResult->boolVal);
		case DISPID_TEXTSELECTION_TEXT:
		case 0:
			pVarResult->vt = VT_BSTR;
			return get_Text(&pVarResult->bstrVal);
		case DISPID_TEXTSELECTION_TEXTRANGES:
			pVarResult->vt = VT_DISPATCH;
			return get_TextRanges(reinterpret_cast<ITextRanges**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_TOPPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_TopPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_CANCEL:
			VERIFY_ARGUMENTS_COUNT(0);
			return Cancel();
		case DISPID_TEXTSELECTION_CHARNEXT:
			if(pDispParams->cArgs == 0)
				return CharNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return CharNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return CharNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CHARPREV:
			if(pDispParams->cArgs == 0)
				return CharPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return CharPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return CharPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_COPY:
			VERIFY_ARGUMENTS_COUNT(0);
			return Copy();
		case DISPID_TEXTSELECTION_CUT:
			VERIFY_ARGUMENTS_COUNT(0);
			return Cut();
		case DISPID_TEXTSELECTION_GOTOENDOFDOCUMENT:
			if(pDispParams->cArgs == 0)
				return GoToEndOfDocument();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return GoToEndOfDocument(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_GOTOENDOFLINE:
			if(pDispParams->cArgs == 0)
				return GoToEndOfLine();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return GoToEndOfLine(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_GOTONEXTBOOKMARK:
			if(pDispParams->cArgs == 0)
				return GoToNextBookmark();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return GoToNextBookmark(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_GOTOPREVIOUSBOOKMARK:
			if(pDispParams->cArgs == 0)
				return GoToPreviousBookmark();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return GoToPreviousBookmark(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_GOTOSTARTOFDOCUMENT:
			if(pDispParams->cArgs == 0)
				return GoToStartOfDocument();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return GoToStartOfDocument(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_GOTOSTARTOFLINE:
			if(pDispParams->cArgs == 0)
				return GoToStartOfLine();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return GoToStartOfLine(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEDOWN:
			if(pDispParams->cArgs == 0)
				return LineDown();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return LineDown(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return LineDown(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEUP:
			if(pDispParams->cArgs == 0)
				return LineUp();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return LineUp(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return LineUp(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MAKECAPITAL:
			VERIFY_ARGUMENTS_COUNT(0);
			return MakeCapital();
		case DISPID_TEXTSELECTION_MAKELOWER:
			VERIFY_ARGUMENTS_COUNT(0);
			return MakeLower();
		case DISPID_TEXTSELECTION_MAKEUPPER:
			VERIFY_ARGUMENTS_COUNT(0);
			return MakeUpper();
		case DISPID_TEXTSELECTION_MOVETO:
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_UI4);
				COERCE_ARGUMENT_AT(0, VT_UI4);
				return MoveTo(args[1].ulVal, args[0].ulVal);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_UI4);
				COERCE_ARGUMENT_AT(1, VT_UI4);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveTo(args[2].ulVal, args[1].ulVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEDOWN:
			if(pDispParams->cArgs == 0)
				return PageDown();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return PageDown(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return PageDown(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEUP:
			if(pDispParams->cArgs == 0)
				return PageUp();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return PageUp(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return PageUp(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PASTE:
			VERIFY_ARGUMENTS_COUNT(0);
			return Paste();
		case DISPID_TEXTSELECTION_REPLACE:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return Replace(args[0].bstrVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Replace(args[1].bstrVal,
					static_cast<AlphaOperationConcatenationFlag>(args[0].iVal));
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_SELECTALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return SelectAll();
		case DISPID_TEXTSELECTION_SELECTLINE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_UI4);
			return SelectLine(args[0].ulVal);
		case DISPID_TEXTSELECTION_SWAPANCHOR:
			VERIFY_ARGUMENTS_COUNT(0);
			return SwapAnchor();
		case DISPID_TEXTSELECTION_WORDENDNEXT:
			if(pDispParams->cArgs == 0)
				return WordEndNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordEndNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordEndNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDENDPREV:
			if(pDispParams->cArgs == 0)
				return WordEndPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordEndPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordEndPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDNEXT:
			if(pDispParams->cArgs == 0)
				return WordNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDPREV:
			if(pDispParams->cArgs == 0)
				return WordPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	ITextSelection::LineDown
STDMETHODIMP CTextSelection::LineDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineUp(bExtend, -cLines);
	while(cLines-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_LINEDOWNEXTEND : CMDID_MOVE_LINEDOWN);
	return S_OK;
}

///	@see	ITextSelection::LineUp
STDMETHODIMP CTextSelection::LineUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineDown(bExtend, -cLines);
	while(cLines-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_LINEUPEXTEND : CMDID_MOVE_LINEUP);
	return S_OK;
}

///	@see	ITextSelection::MakeCaptital
STDMETHODIMP CTextSelection::MakeCapital() {
	m_pView->ExecCommand(CMDID_EDIT_MAKESELCAPITAL);
	return S_OK;
}

///	@see	ITextSelection::MakeLower
STDMETHODIMP CTextSelection::MakeLower() {
	m_pView->ExecCommand(CMDID_EDIT_MAKESELLOWER);
	return S_OK;
}

///	@see	ITextSelection::MakeUpper
STDMETHODIMP CTextSelection::MakeUpper() {
	m_pView->ExecCommand(CMDID_EDIT_MAKESELUPPER);
	return S_OK;
}

///	@see	ITextSelection::MoveTo
STDMETHODIMP CTextSelection::MoveTo(
		long iLine, long iChar, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	if(bExtend) {
		CCharPos	posBegin, posEnd;
		m_pView->GetSel(posBegin, posEnd);
		m_pView->SetSel(posBegin, CCharPos(iLine, iChar));
	} else
		m_pView->SetSelWithoutSelection(iLine, iChar);
	return S_OK;
}

///	@see	ITextSelection::PageDown
STDMETHODIMP CTextSelection::PageDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageUp(bExtend, cPages);
	while(cPages-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_PAGEDOWNEXTEND : CMDID_MOVE_PAGEDOWN);
	return S_OK;
}

///	@see	ITextSelection::PageUp
STDMETHODIMP CTextSelection::PageUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageDown(bExtend, cPages);
	while(cPages-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_PAGEUPEXTEND : CMDID_MOVE_PAGEUP);
	return S_OK;
}

///	@see	ITextSelection::Paste
STDMETHODIMP CTextSelection::Paste() {
	m_pView->ExecCommand(CMDID_EDIT_PASTE);
	return S_OK;
}

///	@see	ITextSelection::Replace
STDMETHODIMP CTextSelection::Replace(
		BSTR bstrText, AlphaOperationConcatenationFlag nFlags /* = AOCF_PREVENTALL */) {
	m_pView->ReplaceSel((bstrText != 0) ?
		bstrText : L"", static_cast<OperationConcatenationFlag>(nFlags));
	return S_OK;
}

///	@see	ITextSelection::SelectAll
STDMETHODIMP CTextSelection::SelectAll() {
	m_pView->ExecCommand(CMDID_MOVE_SELECTALL);
	return S_OK;
}

///	@see	ITextSelection::SelectLine
STDMETHODIMP CTextSelection::SelectLine(long iLine) {
	m_pView->SetSel(CCharPos(iLine, 0), CCharPos(iLine, -1));
	return S_OK;
}

///	@see	ITextSelection::SwapAnchor
STDMETHODIMP CTextSelection::SwapAnchor() {
	CCharPos	posBegin, posEnd;
	m_pView->GetSel(posBegin, posEnd);
	m_pView->SetSel(posEnd, posBegin);
	return S_OK;
}

///	@see	ITextSelection::Tabify
STDMETHODIMP CTextSelection::Tabify() {
	m_pView->ExecCommand(CMDID_EDIT_TABIFY);
	return S_OK;
}

///	@see	ITextSelection::Untabify
STDMETHODIMP CTextSelection::Untabify() {
	m_pView->ExecCommand(CMDID_EDIT_UNTABIFY);
	return S_OK;
}

///	@see	ITextSelection::WordEndNext
STDMETHODIMP CTextSelection::WordEndNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndPrev(bExtend, -cWords);
	while(cWords-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_WORDENDNEXTEXTEND : CMDID_MOVE_WORDENDNEXT);
	return S_OK;
}

///	@see	ITextSelection::WordEndPrev
STDMETHODIMP CTextSelection::WordEndPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndNext(bExtend, -cWords);
	while(cWords-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_WORDENDPREVEXTEND : CMDID_MOVE_WORDENDPREV);
	return S_OK;
}

///	@see	ITextSelection::WordNext
STDMETHODIMP CTextSelection::WordNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordPrev(bExtend, -cWords);
	while(cWords-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_WORDNEXTEXTEND : CMDID_MOVE_WORDNEXT);
	return S_OK;
}

///	@see	ITextSelection::WordPrev
STDMETHODIMP CTextSelection::WordPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordNext(bExtend, -cWords);
	while(cWords-- != 0)
		m_pView->ExecCommand(bExtend ? CMDID_MOVE_WORDPREVEXTEND : CMDID_MOVE_WORDPREV);
	return S_OK;
}


// CTextPoint class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextPoint::CTextPoint(
		CAlphaApp* pApp, CEditPoint* pos) : m_pApp(pApp), m_pos(pos) {
	assert(m_pApp != 0 && m_pos != 0);
}

///	@see	ITextPoint::CharNext
STDMETHODIMP CTextPoint::CharNext(long nOffset /* = 1 */) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->CharNext(nOffset);
	return S_OK;
}

///	@see	ITextPoint::CharRight
STDMETHODIMP CTextPoint::CharPrev(long nOffset /* = 1 */) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->CharPrev(nOffset);
	return S_OK;
}

///	@see	ITextPoint::CreateEditPoint
STDMETHODIMP CTextPoint::CreateEditPoint(IEditPoint** ppEditPoint) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(ppEditPoint);
	*ppEditPoint = 0;
	return E_NOTIMPL;
}

///	@see	ITextPoint::EnsureVisible
STDMETHODIMP CTextPoint::EnsureVisible() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->EnsureVisible();
	return S_OK;
}

///	@see	ITextPoint::EqualTo
STDMETHODIMP CTextPoint::EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pbEqual);

	long	iLine, iChar;

	pTextPoint->get_Line(&iLine);
	pTextPoint->get_Char(&iChar);

	*pbEqual = toVariantBoolean(
		m_pos->GetLineNumber() == iLine && m_pos->GetCharNumber() == iChar);
	return S_OK;
}

///	@see	ITextPoint::get_AbsoluteCharOffset
STDMETHODIMP CTextPoint::get_AbsoluteCharOffset(long* pnAbsoluteCharOffset) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnAbsoluteCharOffset);
	*pnAbsoluteCharOffset = m_pos->GetAbsoluteCharOffset();
	return S_OK;
}

///	@see	ITextPoint::get_Application
STDMETHODIMP CTextPoint::get_Application(IApplication** ppApplication) {
	VERIFY_POINTER(ppApplication);
	m_pApp->GetAutomation(ppApplication);
	return S_OK;
}

///	@see	ITextPoint::get_AtEndOfDocument
STDMETHODIMP CTextPoint::get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtEndOfDocument);
	*pbAtEndOfDocument = toVariantBoolean(m_pos->IsAtEndOfDocument());
	return S_OK;
}

///	@see	ITextPoint::get_AtEndOfLine
STDMETHODIMP CTextPoint::get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtEndOfLine);
	*pbAtEndOfLine = toVariantBoolean(m_pos->IsAtEndOfLine());
	return S_OK;
}

///	@see	ITextPoint::get_AtStartOfDocument
STDMETHODIMP CTextPoint::get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtStartOfDocument);
	*pbAtStartOfDocument = toVariantBoolean(m_pos->IsAtStartOfDocument());
	return S_OK;
}

///	@see	ITextPoint::get_AtStartOfLine
STDMETHODIMP CTextPoint::get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtStartOfLine);
	*pbAtStartOfLine = toVariantBoolean(m_pos->IsAtStartOfLine());
	return S_OK;
}

///	@see	ITextPoint::get_Char
STDMETHODIMP CTextPoint::get_Char(long* pnChar) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnChar);
	*pnChar = m_pos->GetCharNumber();
	return S_OK;
}

///	@see	ITextPoint::get_Column
STDMETHODIMP CTextPoint::get_Column(long* pnColumn) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnColumn);
	*pnColumn = m_pos->GetColumnNumber();
	return S_OK;
}

///	@see	ITextPoint::get_Line
STDMETHODIMP CTextPoint::get_Line(long* pnLine) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnLine);
	*pnLine = m_pos->GetLineNumber();
	return S_OK;
}

///	@see	ITextPoint::get_LineLength
STDMETHODIMP CTextPoint::get_LineLength(long* pnLineLength) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnLineLength);
	*pnLineLength = m_pos->GetLineLength();
	return S_OK;
}

///	@see	ITextPoint::GreaterThan
STDMETHODIMP CTextPoint::GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pbGreater);

	unsigned long	iLine, iChar;

	pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
	if(m_pos->GetLineNumber() > iLine)
		*pbGreater = VARIANT_TRUE;
	else if(m_pos->GetLineNumber() < iLine)
		*pbGreater = VARIANT_FALSE;
	else {
		pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
		*pbGreater = toVariantBoolean(m_pos->GetCharNumber() > iChar);
	}
	return S_OK;
}

///	@see	ITextPoint::Invoke
STDMETHODIMP CTextPoint::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	return S_OK;
}

///	@see	ITextPoint::LessThan
STDMETHODIMP CTextPoint::LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pbLess);

	unsigned long	iLine, iChar;

	pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
	if(m_pos->GetLineNumber() < iLine)
		*pbLess = VARIANT_TRUE;
	else if(m_pos->GetLineNumber() > iLine)
		*pbLess = VARIANT_FALSE;
	else {
		pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
		*pbLess = toVariantBoolean(m_pos->GetCharNumber() < iChar);
	}
	return S_OK;
}

///	@see	ITextPoint::LineDown
STDMETHODIMP CTextPoint::LineDown(long nLines) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->LineDown(nLines);
	return S_OK;
}

///	@see	ITextPoint::LineUp
STDMETHODIMP CTextPoint::LineUp(long nLines) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->LineUp(nLines);
	return S_OK;
}

///	@see	ITextPoint::MoveTo
STDMETHODIMP CTextPoint::MoveTo(long iLine, long iChar) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToPoint(CCharPos(iLine, iChar));
	return S_OK;
}

///	@see	ITextPoint::MoveToAbsoluteOffset
STDMETHODIMP CTextPoint::MoveToAbsoluteOffset(long nOffset) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToAbsoluteCharOffset(nOffset);
	return S_OK;
}

///	@see	ITextPoint::MoveToEndOfDocument
STDMETHODIMP CTextPoint::MoveToEndOfDocument() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToEndOfDocument();
	return S_OK;
}

///	@see	ITextPoint::MoveToEndOfLine
STDMETHODIMP CTextPoint::MoveToEndOfLine() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToEndOfLine();
	return S_OK;
}

///	@see	ITextPoint::MoveToNextBookmark
STDMETHODIMP CTextPoint::MoveToNextBookmark() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToNextBookmark();
	return S_OK;
}

///	@see	ITextPoint::MoveToPreviousBookmark
STDMETHODIMP CTextPoint::MoveToPreviousBookmark() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToPrevBookmark();
	return S_OK;
}

///	@see	ITextPoint::MoveToStartOfDocument
STDMETHODIMP CTextPoint::MoveToStartOfDocument() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToStartOfDocument();
	return S_OK;
}

///	@see	ITextPoint::MoveToStartOfLine
STDMETHODIMP CTextPoint::MoveToStartOfLine() {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->MoveToStartOfLine();
	return S_OK;
}

///	@see	ITextPoint::WordEndNext
STDMETHODIMP CTextPoint::WordEndNext(long nWords /* = 1 */) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->WordEndNext(nWords);
	return S_OK;
}

///	@see	ITextPoint::WordEndPrev
STDMETHODIMP CTextPoint::WordEndPrev(long nWords /* = 1 */) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->WordEndPrev(nWords);
	return S_OK;
}

///	@see	ITextPoint::WordNext
STDMETHODIMP CTextPoint::WordNext(long nWords /* = 1 */) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->WordNext(nWords);
	return S_OK;
}

///	@see	ITextPoint::WordPrev
STDMETHODIMP CTextPoint::WordPrev(long nWords /* = 1 */) {
	if(!m_pos->IsAvailable())
		return E_UNEXPECTED;
	m_pos->WordPrev(nWords);
	return S_OK;
}


// CTextRange class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextRange::CTextRange(CAlphaApp* pApp, CEditRange* pRange) : m_pApp(pApp), m_pRange(pRange) {
	assert(pApp != 0 && pRange != 0);
}

///	@see	ITextRange::get_Application
STDMETHODIMP CTextRange::get_Application(IApplication** ppApplication) {
	VERIFY_POINTER(ppApplication);
	m_pApp->GetAutomation(ppApplication);
	return S_OK;
}

///	@see	ITextRange::get_EndPoint
STDMETHODIMP CTextRange::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);
//	*ppEndPoint = new CTextPoint(m_pApp, m_pRange->GetEndPoint());
//	(*ppEndPoint)->AddRef();
	return S_OK;
}

///	@see	ITextRange::get_StartPoint
STDMETHODIMP CTextRange::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
//	*ppStartPoint = new CTextPoint(m_pApp, m_pRange->GetStartPoint());
//	(*ppStartPoint)->AddRef();
	return S_OK;
}

///	@see	ITextRange::Invoke
STDMETHODIMP CTextRange::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTRANGE_APPLICATION:
			pVarResult->vt = VT_DISPATCH;
			return get_Application(reinterpret_cast<IApplication**>(&pVarResult->pdispVal));
		case DISPID_TEXTRANGE_ENDPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_EndPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTRANGE_STARTPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_StartPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		}
	}
	return DISP_E_MEMBERNOTFOUND;
}


// CAutomationScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAutomationScriptHost::CAutomationScriptHost(HWND hwndOwner)
		: m_hwndOwner(hwndOwner), m_bInteractive(true), m_nTimeout(0) {
	assert(m_hwndOwner == 0 || ::IsWindow(m_hwndOwner));
	wcscpy(m_wszScriptPath, L"");
}

///	fXgN^
CAutomationScriptHost::~CAutomationScriptHost() {
	map<IDispatch*, CAdhocEventSink*>::const_iterator	it;

	for(it = m_mapEventSinks.begin(); it != m_mapEventSinks.end(); ++it) {
		if(FAILED(DisconnectObject(it->first))) {
			it->first->Release();
			it->second->Release();
		}
	}
}

///	@see	IScriptHost::ConnectObject
STDMETHODIMP CAutomationScriptHost::ConnectObject(IDispatch* pObject, BSTR bstrPrefix) {
	VERIFY_POINTER(pObject);
	if(bstrPrefix == 0)
		return E_INVALIDARG;

	return E_NOTIMPL;
/*	CComPtr<IConnectionPoint>			pConnectionPoint;
	CComPtr<IConnectionPointContainer>	pCPContainer;
	CComPtr<IEnumConnectionPoints>		pCPEnumerator;
	HRESULT								hr;
	unsigned long						cFetched;
	IID									iidEventSink;	// CxgVNC^[tFCX IID

	try {
		// ڑ|CgƗ񋓔\͂?
		if(FAILED(hr = pObject->QueryInterface(IID_IConnectionPointContainer, reinterpret_cast<void**>(&pCPContainer))))
			throw CComException(CONNECT_E_NOCONNECTION,
					IID_IScriptHost, OLESTR("Alpha.Ambient.CAutomationScriptHost.ConnectObject"));
		if(FAILED(hr = pCPContainer->EnumConnectionPoints(&pCPEnumerator)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CAutomationScriptHost.ConnectObject"));
		if(S_OK == pCPEnumerator->Next(1, &pConnectionPoint, &cFetched)) {
			if(SUCCEEDED(pConnectionPoint->GetConnectionInterface(&iidEventSink))) {
				CAdhocEventSink*	pEventSink = new CAdhocEventSink(
													pConnectionPoint, iidEventSink, bstrPrefix);
				pEventSink->AddRef();
				m_mapEventSinks[pObject] = pEventSink;
				pObject->AddRef();
				return S_OK;
			}
		}
		throw CComException(E_FAIL, IID_IScriptHost,
				OLESTR("Alpha.Ambient.CAutomationScriptHost.ConnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}*/
}

///	@see	IScriptHost::CreateObject
STDMETHODIMP CAutomationScriptHost::CreateObject(
		BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	VERIFY_POINTER(ppObject);
	if(bstrProgId == 0)
		return E_INVALIDARG;
	CLSID	clsidObject;
	HRESULT	hr;

	try {
		if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsidObject)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CAutomationScriptHost.CreateObject"));
		if(FAILED(hr = ::CoCreateInstance(clsidObject, 0,
				CLSCTX_ALL, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CAutomationScriptHost.CreateObject"));
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	return (bstrPrefix == 0) ? hr : ConnectObject(*ppObject, bstrPrefix);
}

///	@see	IScriptHost::DisconnectObject
STDMETHODIMP CAutomationScriptHost::DisconnectObject(IDispatch* pObject) {
	VERIFY_POINTER(pObject);

	return E_NOTIMPL;
/*	map<IDispatch*, CAdhocEventSink*>::iterator	it = m_mapEventSinks.find(pObject);

	if(it == m_mapEventSinks.end())
		return E_FAIL;

	CComPtr<IConnectionPoint>	pConnectionPoint;
	CAdhocEventSink*			pEventSink = it->second;

	pEventSink->GetConnectionPoint(&pConnectionPoint);
	pConnectionPoint->Unadvise(pEventSink->GetCookie());
	m_mapEventSinks.erase(it);
	pObject->Release();
	pEventSink->Release();

	return S_OK;*/
}

///	@see	IScriptHost::Echo
STDMETHODIMP CAutomationScriptHost::Echo(SAFEARRAY* parr) {
	if(parr == 0 || parr->cDims != 1)
		return E_INVALIDARG;
	if(!m_bInteractive)
		return S_OK;

	wstring	strText;
	long	nUBound;
	BSTR*	pbstrArgs = reinterpret_cast<BSTR*>(parr->pvData);

	::SafeArrayGetUBound(parr, 1, &nUBound);
	for(long i = 0; i <= nUBound; ++i) {
		strText += (pbstrArgs[i] != 0) ? pbstrArgs[i] : L"";
		if(i != nUBound)
			strText += L" ";
	}
	::MessageBox(m_hwndOwner, strText.c_str(), ASH_HOSTNAME, 0);
	return S_OK;
}

///	@see	IScriptHost::get_Arguments
STDMETHODIMP CAutomationScriptHost::get_Arguments(IArguments** ppArguments) {
	VERIFY_POINTER(ppArguments);
	vector<wstring>	vecArgs;
	*ppArguments = new CArguments(vecArgs);
	(*ppArguments)->AddRef();
	return S_OK;
}

///	@see	IScriptHost::get_BuildVersion
STDMETHODIMP CAutomationScriptHost::get_BuildVersion(short* pnBuildVersion) {
	VERIFY_POINTER(pnBuildVersion);
	*pnBuildVersion = ASH_BUILDVERSION;
	return S_OK;
}

///	@see	IScriptHost::get_FullName
STDMETHODIMP CAutomationScriptHost::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszPath);
	return S_OK;
}

///	@see	IScriptHost::get_Interactive
STDMETHODIMP CAutomationScriptHost::get_Interactive(VARIANT_BOOL* pbInteractive) {
	VERIFY_POINTER(pbInteractive);
	*pbInteractive = toVariantBoolean(m_bInteractive);
	return S_OK;
}

///	@see	IScriptHost::get_Name
STDMETHODIMP CAutomationScriptHost::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrName = ::SysAllocString(::PathFindFileNameW(wszPath));
	return S_OK;
}

///	@see	IScriptHost::get_Path
STDMETHODIMP CAutomationScriptHost::get_Path(BSTR* pbstrPath) {
	VERIFY_POINTER(pbstrPath);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrPath = ::SysAllocStringLen(wszPath, wszPath - ::PathFindFileNameW(wszPath) - 1);
	return S_OK;
}

///	@see	IScriptHost::get_ScriptFullName
STDMETHODIMP CAutomationScriptHost::get_ScriptFullName(BSTR* pbstrScriptFullName) {
	VERIFY_POINTER(pbstrScriptFullName);
	*pbstrScriptFullName = ::SysAllocString(m_wszScriptPath);
	return S_OK;
}

///	@see	IScriptHost::get_ScriptName
STDMETHODIMP CAutomationScriptHost::get_ScriptName(BSTR* pbstrScriptName) {
	VERIFY_POINTER(pbstrScriptName);
	*pbstrScriptName = ::SysAllocString(::PathFindFileNameW(m_wszScriptPath));
	return S_OK;
}

///	@see	IScriptHost::get_StdErr
STDMETHODIMP CAutomationScriptHost::get_StdErr(IDispatch** ppStdErr) {
//	VERIFY_POINTER(ppStdErr);
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdIn
STDMETHODIMP CAutomationScriptHost::get_StdIn(IDispatch** ppStdIn) {
//	VERIFY_POINTER(ppStdIn);
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdOut
STDMETHODIMP CAutomationScriptHost::get_StdOut(IDispatch** ppStdOut) {
//	VERIFY_POINTER(ppStdOut);
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_Timeout
STDMETHODIMP CAutomationScriptHost::get_Timeout(long* pnMilliseconds) {
	VERIFY_POINTER(pnMilliseconds);
	*pnMilliseconds = m_nTimeout;
	return S_OK;
}

///	@see	IScriptHost::get_Version
STDMETHODIMP CAutomationScriptHost::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = ::SysAllocString(ASH_VERSION);
	return S_OK;
}

///	@see	IScriptHost::GetObject
STDMETHODIMP CAutomationScriptHost::GetObject(
		BSTR bstrPathName, BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	VERIFY_POINTER(ppObject);

	HRESULT	hr;

	try {
		if(bstrProgId == 0) {
			if(FAILED(hr = ::CoGetObject(bstrPathName, 0, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
				throw CComException(hr, IID_IApplication, OLESTR("Alpha.Ambient.CAutomationScriptHost.GetObject"));
		} else {	// GetInstanceFromFile g
			CLSID		clsidObject;
			MULTI_QI	mq = {&IID_IDispatch, 0, 0};

			if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsidObject)))
				throw CComException(hr, IID_IApplication, OLESTR("Alpha.Ambient.CAutomationScriptHost.GetObject"));
			if(FAILED(hr = ::CoGetInstanceFromFile(0, &clsidObject, 0,
					CLSCTX_ALL, STGM_READWRITE, bstrPathName, 1, &mq)))
				throw CComException(hr, IID_IApplication, OLESTR("Alpha.Ambient.CAutomationScriptHost.GetObject"));
			hr = mq.pItf->QueryInterface(IID_IDispatch, reinterpret_cast<void**>(ppObject));
		}
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
	}

	return hr;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationScriptHost::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	unsigned int	iArgs;
	bool			bCreatedResult = false;
	CComVariant		args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_ARGUMENTS:
			pVarResult->vt = VT_DISPATCH;
			return get_Arguments(reinterpret_cast<IArguments**>(&pVarResult->pdispVal));
		case DISPID_SCRIPTHOST_BUILDVERSION:
			pVarResult->vt = VT_I2;
			return get_BuildVersion(&pVarResult->iVal);
		case DISPID_SCRIPTHOST_FULLNAME:
			pVarResult->vt = VT_BSTR;
			return get_FullName(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_INTERACTIVE:
			pVarResult->vt = VT_BOOL;
			return get_Interactive(&pVarResult->boolVal);
		case DISPID_SCRIPTHOST_NAME:
		case 0:
			pVarResult->vt = VT_BSTR;
			return get_Name(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_SCRIPTFULLNAME:
			pVarResult->vt = VT_BSTR;
			return get_ScriptFullName(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_SCRIPTNAME:
			pVarResult->vt = VT_BSTR;
			return get_ScriptName(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_STDERR:
			pVarResult->vt = VT_DISPATCH;
			return get_StdErr(&pVarResult->pdispVal);
		case DISPID_SCRIPTHOST_STDIN:
			pVarResult->vt = VT_DISPATCH;
			return get_StdIn(&pVarResult->pdispVal);
		case DISPID_SCRIPTHOST_STDOUT:
			pVarResult->vt = VT_DISPATCH;
			return get_StdOut(&pVarResult->pdispVal);
		case DISPID_SCRIPTHOST_TIMEOUT:
			pVarResult->vt = VT_I4;
			return get_Timeout(&pVarResult->lVal);
		case DISPID_SCRIPTHOST_VERSION:
			pVarResult->vt = VT_BSTR;
			return get_Version(&pVarResult->bstrVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_INTERACTIVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Interactive(args[0].boolVal);
		case DISPID_SCRIPTHOST_TIMEOUT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Timeout(args[0].lVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
			;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_CONNECTOBJECT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_DISPATCH);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return ConnectObject(args[1].pdispVal, args[0].bstrVal);
		case DISPID_SCRIPTHOST_CREATEOBJECT:
			if(pVarResult == 0) {
				pVarResult = new VARIANT;
				bCreatedResult = true;
			}
			pVarResult->vt = VT_DISPATCH;
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[0].bstrVal, 0, &pVarResult->pdispVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[1].bstrVal,
					args[0].bstrVal, &pVarResult->pdispVal);
			} else {
				if(bCreatedResult) {
					delete pVarResult;
					pVarResult = 0;
				}
				return DISP_E_BADPARAMCOUNT;
			}
			if(bCreatedResult) {
				delete pVarResult;
				pVarResult = 0;
			}
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return S_OK;
		case DISPID_SCRIPTHOST_DISCONNECTOBJECT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			return DisconnectObject(args[0].pdispVal);
		case DISPID_SCRIPTHOST_ECHO:
			if(pDispParams->cArgs == 1 && pDispParams->rgvarg[0].vt == VT_SAFEARRAY)
				return Echo(pDispParams->rgvarg[0].parray);
			else {
				pArray = ::SafeArrayCreateVector(VT_BSTR, 0, pDispParams->cArgs);
				::SafeArrayAccessData(pArray, reinterpret_cast<void**>(&arrBstrArgs));
				for(iArgs = 0; iArgs < pDispParams->cArgs; ++iArgs) {
					hr = ::DispGetParam(pDispParams, iArgs, VT_BSTR, &args[0], puArgErr);
					if(FAILED(hr)) {
						::SafeArrayUnaccessData(pArray);
						::SafeArrayDestroy(pArray);
						return hr;
					}
					arrBstrArgs[iArgs] = ::SysAllocString(args[0].bstrVal);
				}
				::SafeArrayUnaccessData(pArray);
				hr = Echo(pArray);
				::SafeArrayDestroy(pArray);
				return hr;
			}
		case DISPID_SCRIPTHOST_GETOBJECT:
			if(pVarResult == 0) {
				pVarResult = new VARIANT;
				bCreatedResult = true;
			}
			pVarResult->vt = VT_DISPATCH;
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[0].bstrVal, 0, 0, &pVarResult->pdispVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[1].bstrVal,
					args[0].bstrVal, 0, &pVarResult->pdispVal);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[2].bstrVal,
					args[1].bstrVal, args[0].bstrVal, &pVarResult->pdispVal);
			} else {
				if(bCreatedResult) {
					delete pVarResult;
					pVarResult = 0;
				}
				return DISP_E_BADPARAMCOUNT;
			}
			if(bCreatedResult) {
				delete pVarResult;
				pVarResult = 0;
			}
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_SCRIPTHOST_QUIT:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Quit(args[0].iVal);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_SCRIPTHOST_SLEEP:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return Sleep(args[0].lVal);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IScriptHost::put_Interactive
STDMETHODIMP CAutomationScriptHost::put_Interactive(VARIANT_BOOL bInteractive) {
	m_bInteractive = toBoolean(bInteractive);
	return S_OK;
}

///	@see	IScriptHost::put_Timeout
STDMETHODIMP CAutomationScriptHost::put_Timeout(long nTimeout) {
	if(nTimeout < 0)
		return E_INVALIDARG;
	m_nTimeout = nTimeout;
	return S_OK;
}

///	@see	IScriptHost::Quit
STDMETHODIMP CAutomationScriptHost::Quit(short nExitCode /* = 0 */) {
	if(::IsWindow(m_hwndOwner))
		::SendMessage(m_hwndOwner, WM_CLOSE, 0, 0L);
	else
		::PostQuitMessage(nExitCode);	// 댯
	return S_OK;
}

///	@see	CAlphaScriptHost::RunEventSinks
void CAutomationScriptHost::RunEventSinks(IDispatch* pScriptObject) {
	assert(pScriptObject != 0);

	map<IDispatch*, CAdhocEventSink*>::iterator	it;
	CAdhocEventSink*							pEventSink = 0;
	CComPtr<IConnectionPoint>					pConnectionPoint;
	DWORD										dwCookie;

	// SẴCxgVN̊Jn
	for(it = m_mapEventSinks.begin(); it != m_mapEventSinks.end(); ++it) {
		pEventSink = it->second;
		pEventSink->GetConnectionPoint(&pConnectionPoint);
		if(S_OK == pConnectionPoint->Advise(pEventSink, &dwCookie)) {
			pEventSink->SetCookie(dwCookie);
			pEventSink->SetScriptObject(pScriptObject);
		}
	}
}

///	@see	CAlphaScriptHost::SetScriptPath
void CAutomationScriptHost::SetScriptPath(const wchar_t* pwszScriptPath) {
	wcscpy(m_wszScriptPath, (pwszScriptPath != 0) ? pwszScriptPath : L"");
}

///	@see	IScriptHost::Sleep
STDMETHODIMP CAutomationScriptHost::Sleep(long nMilliseconds) {
	if(nMilliseconds < 0)
		return E_INVALIDARG;
	::Sleep(nMilliseconds);
	return S_OK;
}


// CArguments class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CArguments::CArguments(const vector<wstring>& vecArgs) : m_vecArgs(vecArgs) {
}

///	@see	IArguments::_NewEnum
STDMETHODIMP CArguments::_NewEnum(IUnknown** ppOut) {
	return E_NOTIMPL;
}

///	@see	IArguments::Count
STDMETHODIMP CArguments::Count(long* pcArgs) {
	VERIFY_POINTER(pcArgs);
	*pcArgs = m_vecArgs.size();
	return S_OK;
}

///	@see	IArguments::get_Item
STDMETHODIMP CArguments::get_Item(long nIndex, BSTR* pbstrArgs) {
	VERIFY_POINTER(pbstrArgs);

	if(nIndex < 0 || nIndex >= static_cast<long>(m_vecArgs.size()))
		return 0x800A0009;
	*pbstrArgs = ::SysAllocString(m_vecArgs[nIndex].c_str());
	return S_OK;
}

///	@see	IArguments::get_Length
STDMETHODIMP CArguments::get_Length(long* pcArgs) {
	VERIFY_POINTER(pcArgs);
	*pcArgs = m_vecArgs.size();
	return S_OK;
}

///	@see	IArguments::get_Named
STDMETHODIMP CArguments::get_Named(IDispatch** ppNamed) {
	return E_NOTIMPL;
}

///	@see	IArguments::get_Unamed
STDMETHODIMP CArguments::get_Unnamed(IDispatch** ppUnnamed) {
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CArguments::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pDispParams,
		VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_ARGUMENTS_ITEM:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			pVarResult->vt = VT_BSTR;
			return get_Item(args[0].lVal, &pVarResult->bstrVal);
		case DISPID_ARGUMENTS_LENGTH:
			pVarResult->vt = VT_I4;
			return get_Length(&pVarResult->lVal);
		case DISPID_ARGUMENTS_NAMED:
			pVarResult->vt = VT_DISPATCH;
			return get_Named(&pVarResult->pdispVal);
		case DISPID_ARGUMENTS_UNNAMED:
			pVarResult->vt = VT_DISPATCH;
			return get_Unnamed(&pVarResult->pdispVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	else if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_ARGUMENTS__NEWENUM:
			VERIFY_ARGUMENTS_COUNT(0);
			pVarResult->vt = VT_UNKNOWN;
			return _NewEnum(&pVarResult->punkVal);
		case DISPID_ARGUMENTS_COUNT:
			VERIFY_ARGUMENTS_COUNT(0);
			pVarResult->vt = VT_I4;
			return Count(&pVarResult->lVal);
		case DISPID_ARGUMENTS_SHOWUSAGE:
			VERIFY_ARGUMENTS_COUNT(0);
			return ShowUsage();
		default:
			DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IArguments::ShowUsage
STDMETHODIMP CArguments::ShowUsage() {
	return E_NOTIMPL;
}


#undef VERIFY_ARGUMENTS_COUNT
#undef COERCE_ARGUMENT_AT

#pragma warning(default : 4390)

/* [EOF] */