// SmallObject.h
// (c) 2004-2005 exeal

#ifndef _SMALL_OBJECT_H_
#define _SMALL_OBJECT_H_

#include "Object.h"
#include <cassert>
#include <vector>
#include <limits>
#include <algorithm>

#ifndef DEFAULT_CHUNK_SIZE
#define DEFAULT_CHUNK_SIZE	4096
#endif
#ifndef MAX_SMALL_OBJECT_SIZE
#define MAX_SMALL_OBJECT_SIZE	64
#endif

namespace Manah {
namespace Windows {

template<std::size_t nChunkSize_, std::size_t nMaxSmallObjectSize_>
class _CSmallObjectAllocator;

/**
 *	K̓IuWFNg
 *
 *	Loki (http://sourceforge.net/projects/loki-lib/) ƂقƂǓB
 *	bN Win32 v~eBuĝł̖OԂɒuĂ
 *
 *	@param bMultiThreaded		bN邩
 *	@param nChunkSize			`ÑTCY
 *	@param nMaxSmallObjectSize	K̓IuWFNgƂ݂Ȃő̃TCY
 */
template<
	bool bMultiThreaded = false,
	std::size_t nChunkSize = DEFAULT_CHUNK_SIZE,
	std::size_t nMaxSmallObjectSize = MAX_SMALL_OBJECT_SIZE>
class CSmallObject : public CSelfAssertable {
	// fXgN^
public:
	virtual	~CSmallObject();

	// Zq
public:
	static void*	operator new(std::size_t size);
	static void		operator delete(void* p, std::size_t size);

	// \bh
private:
	static _CSmallObjectAllocator<nChunkSize, nMaxSmallObjectSize>&	_GetAllocator();

	// NX
private:
	class _CLock {
	public:
		_CLock() {
			::InitializeCriticalSection(&cs);
			::EnterCriticalSection(&cs);
		}
		~_CLock() {
			::LeaveCriticalSection(&cs);
			::DeleteCriticalSection(&cs);
		}
	private:
		CRITICAL_SECTION	cs;
	};
};


class _CFixedAllocator {
public:
	typedef unsigned char	size_type;

	// RXgN^
public:
	explicit _CFixedAllocator(std::size_t nBlockSize = 0);
	_CFixedAllocator(const _CFixedAllocator& rhs);
	~_CFixedAllocator();

	// \bh
public:
	void*		Allocate();
	void		Deallocate(void* p);
	std::size_t	GetBlockSize() const;

	// Zq
public:
	_CFixedAllocator&	operator =(const _CFixedAllocator& rhs);
	bool				operator <(std::size_t rhs) const;
private:

	// NX
private:
	class _CChunk {
		// RXgN^
	public:
		_CChunk(std::size_t nBlockSize, size_type cBlocks);

		// \bh
	public:
		void*		Allocate(std::size_t size);
		void		Deallocate(void* p, std::size_t nBlockSize);
		size_type	GetAvailableBlockCount() const;
		bool		IsAvailable() const;
		bool		IsContaining(const void* p, std::size_t size) const;
		void		Release();

		// f[^o
	private:
		size_type*	m_pData;
		size_type	m_iFirstAvailableBlock;
		size_type	m_cAvailableBlocks;
	};

	// f[^o
private:
	typedef std::vector<_CChunk>	ChunkVector;
	std::size_t	m_nBlockSize;
	size_type	m_cBlocks;
	ChunkVector	m_chunks;
	_CChunk*	m_pLastAllocatedChunk;
	_CChunk*	m_pLastDeallocatedChunk;

	mutable const _CFixedAllocator*	m_pNext;
	mutable const _CFixedAllocator*	m_pPrev;
};


template<
	std::size_t nChunkSize_,
	std::size_t nMaxSmallObjectSize_
>
class _CSmallObjectAllocator {
	friend class CSmallObject<>;

	// RXgN^
private:
	_CSmallObjectAllocator();
	_CSmallObjectAllocator(const _CSmallObjectAllocator& rhs);
//	~_CSmallObjectAllocator();
	operator =(const _CSmallObjectAllocator& rhs);

	// \bh
public:
	void*	Allocate(std::size_t cBytes);
	void	Deallocate(void* p, std::size_t cBytes);

	// f[^o
private:
	std::vector<_CFixedAllocator>	m_pools;
	_CFixedAllocator*				m_pLastAllocated;
	_CFixedAllocator*				m_pLastDeallocated;
};



// CSmallObject class implementation
/////////////////////////////////////////////////////////////////////////////

template<bool bMultiThreaded, std::size_t nChunkSize, std::size_t nMaxSmallObjectSize>
inline CSmallObject<bMultiThreaded, nChunkSize, nMaxSmallObjectSize>::~CSmallObject() {
}

template<bool bMultiThreaded, std::size_t nChunkSize, std::size_t nMaxSmallObjectSize>
inline void* CSmallObject<bMultiThreaded,
		nChunkSize, nMaxSmallObjectSize>::operator new(std::size_t size) {
#if(DEFAULT_CHUNK_SIZE != 0) && (MAX_SMALL_OBJECT_SIZE != 0)
	if(!bMultiThreaded)
		return _GetAllocator().Allocate(size);
	_CLock	lock;
	return _GetAllocator().Allocate(size);
#else
	return ::operator new(size);
#endif
}

template<bool bMultiThreaded, std::size_t nChunkSize, std::size_t nMaxSmallObjectSize>
inline void CSmallObject<bMultiThreaded,
	nChunkSize, nMaxSmallObjectSize>::operator delete(void* p, std::size_t size) {
#if(DEFAULT_CHUNK_SIZE != 0) && (MAX_SMALL_OBJECT_SIZE != 0)
	if(!bMultiThreaded) {
		_GetAllocator().Deallocate(p, size);
		return;
	}
	_CLock	lock;
	_GetAllocator().Deallocate(p, size);
#else
	::operator delete(p, size);
#endif
}

template<bool bMultiThreaded, std::size_t nChunkSize, std::size_t nMaxSmallObjectSize>
inline _CSmallObjectAllocator<nChunkSize, nMaxSmallObjectSize>&
CSmallObject<bMultiThreaded, nChunkSize, nMaxSmallObjectSize>::_GetAllocator() {
	static _CSmallObjectAllocator<nChunkSize, nMaxSmallObjectSize>	allocator;
	return allocator;
}


// _CChunk class implementation
/////////////////////////////////////////////////////////////////////////////

inline _CFixedAllocator::_CChunk::_CChunk(std::size_t nBlockSize, size_type cBlocks)
		: m_iFirstAvailableBlock(0), m_cAvailableBlocks(cBlocks) {
	assert(nBlockSize > 0 && cBlocks > 0);
	assert((nBlockSize * cBlocks) / nBlockSize == cBlocks);

	m_pData = new size_type[nBlockSize * cBlocks];
	size_type*	p = m_pData;
	for(size_type i = 0; i < cBlocks; p += nBlockSize)
		*p = ++i;
}

inline void* _CFixedAllocator::_CChunk::Allocate(std::size_t nBlockSize) {
	if(m_cAvailableBlocks == 0)
		return 0;
	assert((m_iFirstAvailableBlock * nBlockSize) / nBlockSize == m_iFirstAvailableBlock);

	size_type* p = m_pData + m_iFirstAvailableBlock * nBlockSize;

	m_iFirstAvailableBlock = *p;
	--m_cAvailableBlocks;
	return p;
}

inline void _CFixedAllocator::_CChunk::Deallocate(void* p, std::size_t nBlockSize) {
	assert(p >= m_pData);
	size_type*	pRelease = static_cast<size_type*>(p);
	assert((pRelease - m_pData) % nBlockSize == 0);
	*pRelease = m_iFirstAvailableBlock;
	m_iFirstAvailableBlock = static_cast<size_type>((pRelease - m_pData) / nBlockSize);
	assert(m_iFirstAvailableBlock == (pRelease - m_pData) / nBlockSize);
	++m_cAvailableBlocks;
}

inline _CFixedAllocator::size_type _CFixedAllocator::_CChunk::GetAvailableBlockCount() const {
	return m_cAvailableBlocks;
}

inline bool _CFixedAllocator::_CChunk::IsAvailable() const {
	return m_cAvailableBlocks > 0;
}

inline bool _CFixedAllocator::_CChunk::IsContaining(const void* p, std::size_t size) const {
	return p >= m_pData && p < m_pData + size;
}

inline void _CFixedAllocator::_CChunk::Release() {
	delete[] m_pData;
}


// _CFixedAllocator class implementation
/////////////////////////////////////////////////////////////////////////////

inline _CFixedAllocator::_CFixedAllocator(std::size_t nBlockSize /* = 0 */)
		: m_nBlockSize(nBlockSize),
		m_pLastAllocatedChunk(0), m_pLastDeallocatedChunk(0) {
	assert(m_nBlockSize > 0);

	m_pNext = m_pPrev = this;
	std::size_t	cBlocks = DEFAULT_CHUNK_SIZE / nBlockSize;

	if(cBlocks > std::numeric_limits<size_type>::max())
		cBlocks = std::numeric_limits<size_type>::max();
	else if(cBlocks == 0)
		cBlocks = 8 * nBlockSize;

	m_cBlocks = static_cast<size_type>(cBlocks);
	assert(m_cBlocks == cBlocks);
}

inline _CFixedAllocator::_CFixedAllocator(const _CFixedAllocator& rhs)
		: m_nBlockSize(rhs.m_nBlockSize),
		m_cBlocks(rhs.m_cBlocks), m_chunks(rhs.m_chunks) {
	m_pPrev = &rhs;
	m_pNext = rhs.m_pNext;
	rhs.m_pNext->m_pPrev = this;
	rhs.m_pNext = this;
	m_pLastAllocatedChunk = (rhs.m_pLastAllocatedChunk != 0) ?
		&m_chunks.front() + (rhs.m_pLastAllocatedChunk - &rhs.m_chunks.front()) : 0;
	m_pLastDeallocatedChunk = (rhs.m_pLastDeallocatedChunk != 0) ?
		&m_chunks.front() + (rhs.m_pLastDeallocatedChunk - &rhs.m_chunks.front()) : 0;
}

inline _CFixedAllocator::~_CFixedAllocator() {
	if(m_pPrev != this) {
		m_pPrev->m_pNext = m_pNext;
		m_pNext->m_pPrev = m_pPrev;
		return;
	}
	assert(m_pPrev == m_pNext);
	for(ChunkVector::iterator it = m_chunks.begin(); it != m_chunks.end(); ++it) {
//		assert(it->GetAvailableBlockCount() == m_cBlocks);
		it->Release();
	}
}

inline _CFixedAllocator& _CFixedAllocator::operator =(const _CFixedAllocator& rhs) {
	_CFixedAllocator	copy(rhs);

	std::swap(m_nBlockSize, copy.m_nBlockSize);
	std::swap(m_cBlocks, copy.m_cBlocks);
	m_chunks.swap(copy.m_chunks);
	std::swap(m_pLastAllocatedChunk, copy.m_pLastAllocatedChunk);
	std::swap(m_pLastDeallocatedChunk, copy.m_pLastDeallocatedChunk);
	return *this;
}

inline bool _CFixedAllocator::operator <(std::size_t rhs) const {
	return m_nBlockSize < rhs;
}

inline void* _CFixedAllocator::Allocate() {
	if(m_pLastAllocatedChunk != 0
			&& m_pLastAllocatedChunk->IsAvailable())
		return m_pLastAllocatedChunk->Allocate(m_nBlockSize);
	for(ChunkVector::iterator it = m_chunks.begin(); ; ++it) {
		if(it == m_chunks.end()) {
			m_chunks.reserve(m_chunks.size() + 1);
			m_chunks.push_back(_CChunk(m_nBlockSize, m_cBlocks));
			m_pLastAllocatedChunk = &m_chunks.back();
			m_pLastDeallocatedChunk = &m_chunks.front();
			break;
		} else if(it->IsAvailable()) {
			m_pLastAllocatedChunk = &*it;
			break;
		}
	}
	assert(m_pLastAllocatedChunk != 0 && m_pLastAllocatedChunk->IsAvailable());
	return m_pLastAllocatedChunk->Allocate(m_nBlockSize);
}

inline void _CFixedAllocator::Deallocate(void* p) {
	assert(p != 0);
	assert(!m_chunks.empty());
	assert(&m_chunks.front() <= m_pLastDeallocatedChunk);
	assert(&m_chunks.back() >= m_pLastDeallocatedChunk);
	assert(m_pLastDeallocatedChunk != 0);

	const std::size_t	nChunkLength = m_nBlockSize * m_cBlocks;
	_CChunk*			pLower = m_pLastDeallocatedChunk;
	_CChunk*			pUpper = m_pLastDeallocatedChunk + 1;
	const _CChunk*		pLowerBound = &m_chunks.front();
	const _CChunk*		pUpperBound = &m_chunks.back() + 1;

	if(pUpper == pUpperBound)
		pUpper = 0;
	while(true) {
		if(pLower != 0) {
			if(pLower->IsContaining(p, nChunkLength)) {
				m_pLastDeallocatedChunk = pLower;
				break;
			} else if(pLower == pLowerBound)
				pLower = 0;
			else
				--pLower;
		}
		if(pUpper != 0) {
			if(pUpper->IsContaining(p, nChunkLength)) {
				m_pLastDeallocatedChunk = pUpper;
				break;
			} else if(++pUpper == pUpperBound)
				pUpper = 0;
		}
	}

	assert(m_pLastDeallocatedChunk != 0);
	assert(m_pLastDeallocatedChunk->IsContaining(p, nChunkLength));
	m_pLastDeallocatedChunk->Deallocate(p, m_nBlockSize);
	if(m_pLastDeallocatedChunk->GetAvailableBlockCount() == m_cBlocks) {
		_CChunk*	pLastChunk = &m_chunks.back();
		if(pLastChunk == m_pLastDeallocatedChunk) {
			if(m_chunks.size() > 1
					&& m_pLastDeallocatedChunk[-1].GetAvailableBlockCount() == m_cBlocks) {
				pLastChunk->Release();
				m_chunks.pop_back();
				m_pLastAllocatedChunk = m_pLastDeallocatedChunk = &m_chunks.front();
			}
			return;
		}
		if(pLastChunk->GetAvailableBlockCount() == m_cBlocks) {
			pLastChunk->Release();
			m_chunks.pop_back();
			m_pLastAllocatedChunk = m_pLastDeallocatedChunk;
		} else {
			std::swap(*m_pLastDeallocatedChunk, *pLastChunk);
			m_pLastAllocatedChunk = &m_chunks.back();
		}
	}
}

inline std::size_t _CFixedAllocator::GetBlockSize() const {
	return m_nBlockSize;
}


// _CSmallObjectAllocator class implementation
/////////////////////////////////////////////////////////////////////////////

template<std::size_t nChunkSize_, std::size_t nMaxSmallObjectSize_>
inline _CSmallObjectAllocator<nChunkSize_, nMaxSmallObjectSize_>::_CSmallObjectAllocator()
		: m_pLastAllocated(0), m_pLastDeallocated(0) {
}

// template<std::size_t nChunkSize_, std::size_t nMaxSmallObjectSize_>
// inline _CSmallObjectAllocator<nChunkSize_, nMaxSmallObjectSize_>::~_CSmallObjectAllocator() {
// }

template<std::size_t nChunkSize_, std::size_t nMaxSmallObjectSize_>
inline void* _CSmallObjectAllocator<nChunkSize_, nMaxSmallObjectSize_>::Allocate(std::size_t cBytes) {
	if(cBytes > nMaxSmallObjectSize_)
		return ::operator new(cBytes);
	else if(m_pLastAllocated != 0 && m_pLastAllocated->GetBlockSize() == cBytes)
		return m_pLastAllocated->Allocate();

	std::vector<_CFixedAllocator>::iterator	it =
		std::lower_bound(m_pools.begin(), m_pools.end(), cBytes);
	if(it == m_pools.end() || it->GetBlockSize() != cBytes) {
		it = m_pools.insert(it, _CFixedAllocator(cBytes));
		m_pLastDeallocated = &*m_pools.begin();
	}
	m_pLastAllocated = &*it;
	return m_pLastAllocated->Allocate();
}

template<std::size_t nChunkSize_, std::size_t nMaxSmallObjectSize_>
inline void _CSmallObjectAllocator<nChunkSize_, nMaxSmallObjectSize_>::Deallocate(void* p, std::size_t cBytes) {
	if(cBytes > nMaxSmallObjectSize_) {
		::operator delete(p);
		return;
	} else if(m_pLastDeallocated != 0 && m_pLastDeallocated->GetBlockSize() == cBytes) {
		m_pLastDeallocated->Deallocate(p);
		return;
	}
	
	std::vector<_CFixedAllocator>::iterator	it =
		std::lower_bound(m_pools.begin(), m_pools.end(), cBytes);
	assert(it != m_pools.end() && it->GetBlockSize() == cBytes);
	m_pLastDeallocated = &*it;
	m_pLastDeallocated->Deallocate(p);
}


} // namespace Windows
} // namespace Manah

#endif /* _SMALL_OBJCET_H_ */

/* [EOF] */