// Button.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _BUTTON_H_
#define _BUTTON_H_

#include "Window.h"


namespace Manah {
namespace Windows {
namespace Controls {

class CButton : public CWindow {
	// \bh
public:
	/* 쐬 */
	bool	Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);
	bool	CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);

	/*  */
	HBITMAP	GetBitmap() const;
	UINT	GetButtonStyle() const;
	int		GetCheck() const;
	HCURSOR	GetCursor() const;
	HICON	GetIcon() const;
	bool	GetIdealSize(SIZE& size) const;
	UINT	GetState() const;
	bool	GetTextMargin(RECT& margin) const;
	HBITMAP	SetBitmap(HBITMAP hBitmap);
	void	SetButtonStyle(UINT nStyle, bool bRedraw = true);
	void	SetCheck(int nCheck);
	HCURSOR	SetCursor(HCURSOR hCursor);
	HICON	SetIcon(HICON hIcon);
	void	SetState(bool bHighlight);
	bool	SetTextMargin(const RECT& margin);

	/*  */
	void	Click();

#ifdef BCM_FIRST
	bool	GetImageList(BUTTON_IMAGELIST& bi) const;
	bool	SetImageList(const BUTTON_IMAGELIST& bi) const;
#endif /* BCM_FIRST */
};


#define UNCONST_THIS	const_cast<CButton*>(this)

inline void CButton::Click() {
	SendMessage(BM_CLICK);
}

inline bool CButton::Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::Create(false, _T("BUTTON"), _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline bool CButton::CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::CreateEx(false, dwExStyle, _T("BUTTON"), _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline HBITMAP CButton::GetBitmap() const {
	return reinterpret_cast<HBITMAP>(UNCONST_THIS->SendMessage(BM_GETIMAGE, IMAGE_BITMAP));
}

inline UINT CButton::GetButtonStyle() const {
	return GetWindowLong(GWL_STYLE) & 0xFF;
}

inline int CButton::GetCheck() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(BM_GETCHECK));
}

inline HCURSOR CButton::GetCursor() const {
	return reinterpret_cast<HCURSOR>(UNCONST_THIS->SendMessage(BM_GETIMAGE, IMAGE_CURSOR));
}

inline HICON CButton::GetIcon() const {
	return reinterpret_cast<HICON>(UNCONST_THIS->SendMessage(BM_GETIMAGE, IMAGE_ICON));
}

inline bool CButton::GetIdealSize(SIZE& size) const {
#ifndef BCM_GETIDEALSIZE
	const UINT	BCM_GETIDEALSIZE = 0x1601;
#endif/* !BCM_GETIDEALSIZE */
	return toBoolean(UNCONST_THIS->SendMessage(BCM_GETIDEALSIZE, 0, reinterpret_cast<LPARAM>(&size)));
}

inline UINT CButton::GetState() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(BM_GETSTATE));
}

inline bool CButton::GetTextMargin(RECT& margin) const {
#ifndef BCM_GETTEXTMARGIN
	const UINT	BCM_GETTEXTMARGIN = 0x1605;
#endif /* !BCM_GETTEXTMARGIN */
	return toBoolean(UNCONST_THIS->SendMessage(BCM_GETTEXTMARGIN, 0, reinterpret_cast<LPARAM>(&margin)));
}

inline HBITMAP CButton::SetBitmap(HBITMAP hBitmap) {
	return reinterpret_cast<HBITMAP>(SendMessage(BM_SETIMAGE, IMAGE_BITMAP, reinterpret_cast<LPARAM>(hBitmap)));
}

inline void CButton::SetButtonStyle(UINT nStyle, bool bRedraw /* = true */) {
	SendMessage(BM_SETSTYLE, nStyle, bRedraw);
}

inline void CButton::SetCheck(int nCheck) {
	SendMessage(BM_SETCHECK, nCheck);
}

inline HCURSOR CButton::SetCursor(HCURSOR hCursor) {
	return reinterpret_cast<HCURSOR>(SendMessage(BM_SETIMAGE, IMAGE_CURSOR, reinterpret_cast<LPARAM>(hCursor)));
}

inline HICON CButton::SetIcon(HICON hIcon) {
	return reinterpret_cast<HICON>(SendMessage(BM_SETIMAGE, IMAGE_ICON, reinterpret_cast<LPARAM>(hIcon)));
}

inline void CButton::SetState(bool bHighlight) {
	SendMessage(BM_SETSTATE, bHighlight);
}

inline bool CButton::SetTextMargin(const RECT& margin) {
#ifndef BCM_SETTEXTMARGIN
	const UINT	BCM_SETTEXTMARGIN = 0x1604;
#endif /* !BCM_SETTEXTMARGIN */
	return toBoolean(SendMessage(BCM_SETTEXTMARGIN, 0, reinterpret_cast<LPARAM>(&margin)));
}

#ifdef BCM_FIRST
inline bool CButton::GetImageList(BUTTON_IMAGELIST& bi) const {
	return toBoolean(UNCONST_THIS->SendMessage(BCM_GETIMAGELIST, 0, reinterpret_cast<LPARAM>(&bi)));
}
inline bool CButton::SetImageList(const BUTTON_IMAGELIST& bi) const {
	return toBoolean(SendMessage(BCM_SETIMAGELIST, 0, reinterpret_cast<LPARAM>(&bi)));
}
#endif /* BCM_FIRST */


#undef UNCONST_THIS

} // namespace Controls
} // namespace Windows
} // namespace Controls

#endif /* _BUTTON_H_ */

/* [EOF] */