// UnknownImpl.h
// (c) 2002-2005 exeal

#ifndef _UNKNOWN_IMPL_H_
#define _UNKNOWN_IMPL_H_

#include "ComBasic.h"

/**
 *	@file	UnknownImpl.h
 *
 *	IUnknown 3̃\bh}N`
 */


namespace Armaiti {

template<bool bThreadedSafe>
class _CReferenceCounter {
public:
	_CReferenceCounter() : m_count(0) {}
	long	Get() const {return m_count;}
	long	Increment();
	long	Decrement();
private:
	long	m_count;
};

template<> inline long _CReferenceCounter<true>::Decrement() {return ::InterlockedDecrement(&m_count);}
template<> inline long _CReferenceCounter<true>::Increment() {return ::InterlockedIncrement(&m_count);}
template<> inline long _CReferenceCounter<false>::Decrement() {return --m_count;}
template<> inline long _CReferenceCounter<false>::Increment() {return ++m_count;}

/// QƃJEggȂ (q[vIuWFNg)
#define IMPLEMENT_UNKNOWN_NO_REF_COUNT()		\
	STDMETHODIMP_(ULONG) AddRef() {return 2;}	\
	STDMETHODIMP_(ULONG) Release() {return 1;}

/// QƃJEg̑XbhZ[tłȂ
#define IMPLEMENT_UNKNOWN_SINGLE_THREADED()		\
private:										\
	Armaiti::_CReferenceCounter<false>	m_rc;	\
public:											\
	STDMETHODIMP_(ULONG) AddRef() {				\
		return m_rc.Increment();				\
	}											\
	STDMETHODIMP_(ULONG) Release() {			\
		if(m_rc.Decrement() == 0) {				\
			delete this;						\
			return 0;							\
		}										\
		return m_rc.Get();						\
	}

/// QƃJEg̑XbhZ[tȎ
#define IMPLEMENT_UNKNOWN_MULTI_THREADED()		\
private:										\
	Armaiti::_CReferenceCounter<true>	m_rc;	\
public:											\
	STDMETHODIMP_(ULONG) AddRef() {				\
		return m_rc.Increment();				\
	}											\
	STDMETHODIMP_(ULONG) Release() {			\
		if(m_rc.Decrement() == 0) {				\
			delete this;						\
			return 0;							\
		}										\
		return m_rc.Get();						\
	}

#define BEGIN_INTERFACE_TABLE()								\
	STDMETHODIMP QueryInterface(REFIID riid, void** ppv) {	\
		VERIFY_POINTER(ppv);

#define IMPLEMENTS_LEFTMOST_INTERFACE(InterfaceName)			\
		if(riid == IID_##InterfaceName || riid == IID_IUnknown)	\
			*ppv = static_cast<InterfaceName*>(this);

#define IMPLEMENTS_INTERFACE(InterfaceName)		\
		else if(riid == IID_##InterfaceName)	\
			*ppv= static_cast<InterfaceName*>(this);

#define END_INTERFACE_TABLE()							\
		else											\
			return (*ppv = 0), E_NOINTERFACE;			\
		reinterpret_cast<IUnknown*>(*ppv)->AddRef();	\
		return S_OK;									\
	}

} // namespace Armaiti

#endif /* _UNKNOWN_IMPL_H_ */

/* [EOF] */