// EnumImpl.h
// (c) 2005 exeal

#ifndef _ENUM_IMPL_H_
#define _ENUM_IMPL_H_

#include "UnknownImpl.h"


namespace Armaiti {

// IEnumXXXX::Clone ̎|V[
/////////////////////////////////////////////////////////////////////////////

///	IEnumXXXX::Clone 
struct AllowCloning {enum {allow = true};};
///	IEnumXXXX::Clone Ȃ
struct DisallowCloning {enum {allow = false};};


/**
 *	IEnumXXXX ̎B񋓗vf\̂ւ̃|C^łP[X͖T|[g
 *	@param T				񋓗vf̌^
 *	@param IEnum			񋓃C^[tFCX
 *	@param CloningPolicy	IEnumXXXX::Clone 邩
 */
template<class T, class IEnum, class CloningPolicy = DisallowCloning>
class IEnumImpl : virtual public IEnum {
private:
	typedef char	_Small;
	class _Big {char dummy[2];};
	static _Small Test(IUnknown*);
	static _Big Test(...);
	static T MakeT();
	enum {_isInterfacePointer = sizeof(Test(MakeT())) == sizeof(_Small)};
	template<typename U0, typename U1> struct _isSameType {enum {res = false};};
	template<typename U0> struct _isSameType<U0, U0> {enum {res = true};};
	enum {
		isPrimitive = 0,
		isOLESTR = 1,
		isBSTR = 2,
		isVARIANT = 3,
		isInterfacePointer = 4,
		typeSpec = (_isSameType<T, OLECHAR*>::res ? isOLESTR : isPrimitive)
			| (_isSameType<T, BSTR>::res ? isBSTR : isPrimitive)
			| (_isSameType<T, VARIANT>::res ? isVARIANT : isPrimitive)
			| (_isInterfacePointer ? isInterfacePointer : isPrimitive)
	};
	template<int TypeSpec> struct _Copier;
	template<> struct _Copier<0/*isPrimitive*/> {
		static void Copy(T& lhs, const T& rhs) {lhs = rhs;}
		static void Release(T& v) {}
	};
	template<> struct _Copier<1/*isOLESTR*/> {
		static void Copy(T& lhs, const T& rhs) {
			lhs = ::CoTaskMemAlloc(sizeof(OLECHAR) * (wcslen(rhs) + 1));
			wcscpy(lhs, rhs);
		}
		static void Release(T& v) {::CoTaskMemFree(v);}
	};
	template<> struct _Copier<2/*isBSTR*/> {
		static void Copy(T& lhs, const T& rhs) {lhs = ::SysAllocString(rhs);}
		static void Release(T& v) {::SysFreeString(v);}
	};
	template<> struct _Copier<3/*isVARIANT*/> {
		static void Copy(T& lhs, const T& rhs) {
			::VariantInit(&lhs);
			::VariantCopy(&lhs, const_cast<VARIANT*>(&rhs));
		}
		static void Release(T& v) {::VariantClear(&v);}
	};
	template<> struct _Copier<4/*isInterfacePointer*/> {
		static void Copy(T& lhs, const T& rhs) {lhs = rhs; lhs->AddRef();}
		static void Release(T& v) {v->Release();}
	};
	typedef _Copier<typeSpec>	Copier;

private:
	IEnumImpl();
	IEnumImpl(const IEnumImpl&);
	operator =(const IEnumImpl&);
public:
	/**
	 *	RXgN^
	 *	@param arr	vf̔z
	 *	@param cArr	z
	 */
	IEnumImpl(const T* arr, std::size_t cArr) : cursor_(0) {
		elements_.reserve(cArr);
		for(std::size_t i = 0; i < cArr; ++i) {
			T	copy;
			Copier::Copy(copy, arr[i]);
			elements_.push_back(copy);
		}
	}
	/**
	 *	RXgN^
	 *	@param begin, end	vf̃Ce[^
	 */
	template<class Itr>
	IEnumImpl(Itr begin, Itr end) : cursor_(0) {
		std::size_t	c = 0;
		Itr			_begin = begin;

		while(_begin++ != end)
			++c;
		elements_.reserve(c);
		while(begin != end) {
			T	copy;
			Copier::Copy(copy, *begin);
			elements_.push_back(copy);
			++begin;
		}
	}
	///	fXgN^
	virtual ~IEnumImpl() {
//		std::for_each(elements_.begin(), elements_.end(), &Copier::Release);
		for(std::size_t i = 0; i < elements_.size(); ++i)
			Copier::Release(elements_[i]);
	}
public:
	IMPLEMENT_UNKNOWN_MULTI_THREADED()
	///	@see	IUnknown::QueryInterface
	STDMETHODIMP QueryInterface(REFIID riid, void** ppv) {
		VERIFY_POINTER(ppv);
		if(riid == __uuidof(IEnum) || riid == IID_IUnknown)
			*ppv = static_cast<IEnum*>(this);
		else
			return (*ppv = 0), E_NOINTERFACE;
		reinterpret_cast<IUnknown*>(*ppv)->AddRef();
		return S_OK;
	}
	///	@see	IEnumXXXX::Next
	STDMETHODIMP Next(unsigned long celt, T* rgelt, unsigned long* pcFetched) {
		if(celt == 0)
			return S_OK;
		else if(rgelt == 0 || (celt != 1 && pcFetched == 0))
			return E_INVALIDARG;
		while(celt-- != 0) {
			if(cursor_ == elements_.size())
				return S_FALSE;
			Copier::Copy(*rgelt, elements_[cursor_]);
			++cursor_;
			++rgelt;
		}
		return (celt + 1 == 0) ? S_OK : S_FALSE;
	}
	///	@see	IEnumXXXX::Skip
	STDMETHODIMP Skip(unsigned long celt) {
		while(celt-- != 0) {
			if(cursor_ == elements_.size())
				return S_FALSE;
			++cursor_;
		}
		return (celt + 1 == 0) ? S_OK : S_FALSE;
	}
	///	@see	IEnumXXXX::Reset
	STDMETHODIMP Reset() {
		cursor_ = 0;
		return S_OK;
	}
	///	@see	IEnumXXXX::Clone
	STDMETHODIMP Clone(IEnum** ppEnum) {
		VERIFY_POINTER(ppEnum);

		if(!CloningPolicy::allow)
			return E_NOTIMPL;

		IEnumImpl*	pNew = new IEnumImpl<T, IEnum, CloningPolicy>(elements_.begin(), elements_.end());
		if(pNew == 0)
			return E_OUTOFMEMORY;
		pNew->cursor_ = cursor_;
		(*ppEnum)->AddRef();
		return S_OK;
	}
private:
	std::vector<T>	elements_;
	std::size_t		cursor_;
};

///	IEnumString ̎
typedef IEnumImpl<OLECHAR*, IEnumString>	IEnumStringImpl;
///	IEnumVARIANT ̎
typedef IEnumImpl<VARIANT, IEnumVARIANT>	IEnumVARIANTImpl;

} // namespace Armaiti

#endif /* _ENUM_IMPL_H_ */

/* [EOF] */