// ScriptMacroManager.h
// (c) 2003-2004 exeal

#ifndef _SCRIPT_MACRO_MANAGER_H_
#define _SCRIPT_MACRO_MANAGER_H_

#include <vector>
#include <list>
#include "Ascension\Encodings\Encoder.h"
#include "../Armaiti/UnknownImpl.h"
#define _COM_NO_STANDARD_GUIDS_
#include "msxml3.tlh"

interface IActiveScript;


namespace Alpha {

class CAlphaApp;


// CScriptMacroManager class definition
/////////////////////////////////////////////////////////////////////////////


///	vOC̊Ǘ
class CScriptMacroManager {
	// oNX
public:
	///	XNvgt@CJȂƂO
	class EFailedToOpenScript : public std::runtime_error {
	public:
		EFailedToOpenScript(const std::wstring& strFileName) :
			std::runtime_error("Specified script file is not found."), m_strFileName(strFileName) {
		}
		const std::wstring	m_strFileName;
	};
	///	XNvǧꖼȂƂO
	class EInvalidLanguage : public std::runtime_error {
	public:
		EInvalidLanguage(const std::wstring& strLanguage) :
			std::runtime_error("Specified language is invalid or not supported"), m_strLanguage(strLanguage) {
		}
		const std::wstring	m_strLanguage;
	};
	///	XML ̉͂ɎsƂO
	class EFailedToParseXml : public std::runtime_error {
	public:
		EFailedToParseXml() : std::runtime_error("Failed to load SAX parser.") {
		}
	};

	// RXgN^
public:
	CScriptMacroManager(CAlphaApp& app);
	~CScriptMacroManager();

	// \bh
public:
	void			Execute(size_t i, const std::vector<std::wstring>& args = std::vector<std::wstring>())
						throw(std::out_of_range, EFailedToOpenScript, EInvalidLanguage);
	std::size_t		GetCount() const;
	std::wstring	GetDescription(std::size_t i) const throw(std::out_of_range);
	std::wstring	GetName(std::size_t i) const throw(std::out_of_range);
	bool			IsExecuting() const;
	bool			Load(const wchar_t* pwszFilePath) throw(EFailedToParseXml);
private:
	static void __cdecl	ScriptThreadProc(void* p);

	// f[^o
private:
	CAlphaApp&		m_app;
	std::wstring	m_strFilePath;
	bool			m_bExecuting;

	struct TMacroInfo {
		std::wstring					strName;
		std::wstring					strDescription;
		std::wstring					strScriptPath;
		std::wstring					strLanguage;
		Ascension::Encodings::CodePage	nCodePage;
	};
	TMacroInfo**	m_ppMacros;
	std::size_t		m_cMacros;

	// NX
private:
	class CSAXReadHandler : virtual public MSXML2::ISAXContentHandler, virtual public MSXML2::ISAXErrorHandler {
		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_NO_REF_COUNT()
		STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {
			VERIFY_POINTER(ppvObject);
			if(riid == IID_IUnknown || riid == __uuidof(ISAXContentHandler))
				*ppvObject = static_cast<ISAXContentHandler*>(this);
			else if(riid == __uuidof(ISAXErrorHandler))
				*ppvObject = static_cast<ISAXErrorHandler*>(this);
			else
				return (*ppvObject = 0), E_NOINTERFACE;
			reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
			return S_OK;
		}
//		BEGIN_INTERFACE_TABLE()
//			IMPLEMENTS_LEFTMOST_INTERFACE(ISAXContentHandler)
//			IMPLEMENTS_INTERFACE(ISAXErrorHandler)
//		END_INTERFACE_TABLE()

		// ISAXContentHandler C^[tFCX
		STDMETHODIMP	putDocumentLocator(MSXML2::ISAXLocator* pLocator);
		STDMETHODIMP	startDocument();
		STDMETHODIMP	endDocument();
		STDMETHODIMP	startPrefixMapping(unsigned short* pwchPrefix,
							int cchPrefix, unsigned short* pwchUri, int cchUri);
		STDMETHODIMP	endPrefixMapping(unsigned short* pwchPrefix, int cchPrefix);
		STDMETHODIMP	startElement(unsigned short* pwchNamespaceUri, int cchNamespaceUri,
							unsigned short* pwchLocalName, int cchLocalName,
							unsigned short* pwchQName, int cchQName, MSXML2::ISAXAttributes* pAttributes);
		STDMETHODIMP	endElement(unsigned short* pwchNamespaceUri, int cchNamespaceUri,
							unsigned short* pwchLocalName, int cchLocalName,
							unsigned short* pwchQName, int cchQName);
		STDMETHODIMP	characters(unsigned short* pwchChars, int cchChars);
		STDMETHODIMP	ignorableWhitespace(unsigned short* pwchChars, int cchChars);
		STDMETHODIMP	processingInstruction (unsigned short* pwchTarget, int cchTarget,
							unsigned short* pwchData, int cchData);
		STDMETHODIMP	skippedEntity(unsigned short* pwchName, int cchName);

		// ISAXErrorHandler C^[tFCX
		STDMETHODIMP	error(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode);
		STDMETHODIMP	fatalError(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode);
		STDMETHODIMP	ignorableWarning(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode);

		// f[^o
	public:
		int						m_nReadingPhase;	// 0-plugin, 1-description, 2-script
		std::list<TMacroInfo>	m_works;
		CScriptMacroManager*	m_pThis;
	} m_saxHandler;

	friend class CSAXReadHandler;
};

inline bool CScriptMacroManager::IsExecuting() const {
	return m_bExecuting;
}

} /* namespace Alpha */

#endif /* _SCRIPT_MACRO_MANAGER_H_ */

/* [EOF] */