// KeyboardMap.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "KeyboardMap.h"
#include "CommandManager.h"
#include "AlphaScriptHost.h"
#include "../Manah/File.h"
using namespace Alpha;
using namespace std;


///	RXgN^
CKeyboardMap::CKeyboardMap() {
	for(KeyModifier modifiers = 0; modifiers < 8; ++modifiers) {
		for(VirtualKey key = 0; key < 0x0100; ++key) {
			m_firstKeyMaps[modifiers][key].pCommand = 0;
			m_firstKeyMaps[modifiers][key].ppp2ndKeyMap = 0;
		}
	}
	Clear();
	m_bDirty = false;
}

///	fXgN^
CKeyboardMap::~CKeyboardMap() {
	Clear();
}

/**
 *	1̃R}ho^
 *	@param command	R}h
 *	@param keys		L[gݍ킹
 *	@return			̊蓖Ă㏑ꍇ false
 */
bool CKeyboardMap::Assign(const CKeyAssignableCommand& command, const TKeyCombination& keys) {
	T1stKeyMap&	firstKeyMap = m_firstKeyMaps[keys.modifiers][keys.key];
	bool		bOverridden = false;

	if(firstKeyMap.ppp2ndKeyMap != 0) {
		for(size_t i = 0; i < 8; ++i) {
			for(size_t j = 0; j < 0x100; ++j)
				delete firstKeyMap.ppp2ndKeyMap[i][j];
			delete[] firstKeyMap.ppp2ndKeyMap[i];
		}
		delete[] firstKeyMap.ppp2ndKeyMap;
		firstKeyMap.ppp2ndKeyMap = 0;
		bOverridden = true;
	}
	if(firstKeyMap.pCommand != 0) {
		delete firstKeyMap.pCommand;
		bOverridden = true;
	}
	firstKeyMap.pCommand = command.CopyAsKeyAssignableCommand();
	m_bDirty = true;

	return !bOverridden;
}

/**
 *	1̃R}ho^
 *	@param command		R}h
 *	@param firstKeys	1̃L[gݍ킹
 *	@param secondKeys	2̃L[gݍ킹
 */
bool CKeyboardMap::Assign(const CKeyAssignableCommand& command, const TKeyCombination& firstKeys, const TKeyCombination& secondKeys) {
	T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstKeys.modifiers][firstKeys.key];
	bool		bOverridden = false;

	if(firstKeyMap.pCommand != 0 &&
			(!firstKeyMap.pCommand->IsBuiltIn()
			|| firstKeyMap.pCommand->GetId() != CMD_SPECIAL_WAITFOR2NDKEYS))
		bOverridden = true;
	delete firstKeyMap.pCommand;
	firstKeyMap.pCommand = new CBuiltInCommand(CMD_SPECIAL_WAITFOR2NDKEYS);

	if(firstKeyMap.ppp2ndKeyMap == 0) {
		firstKeyMap.ppp2ndKeyMap = new CKeyAssignableCommand**[8];
		memset(firstKeyMap.ppp2ndKeyMap, 0, sizeof(CCommand**) * 8);
	}
	if(firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers] == 0) {
		firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers] = new CKeyAssignableCommand*[0x0100];
		memset(firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers], 0, sizeof(CKeyAssignableCommand*) * 0x0100);
	}
	firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers][secondKeys.key] = command.CopyAsKeyAssignableCommand();
	m_bDirty = true;

	return !bOverridden;
}

///	o^Sĉ
void CKeyboardMap::Clear() {
	m_bDirty = true;
	for(KeyModifier modifiers = 0; modifiers < 8; ++modifiers) {
		for(VirtualKey key = 0; key < 0x0100; ++key) {
			T1stKeyMap&	firstKeyMap = m_firstKeyMaps[modifiers][key];
			delete firstKeyMap.pCommand;
			firstKeyMap.pCommand = 0;
			if(firstKeyMap.ppp2ndKeyMap != 0) {
				for(size_t i = 0; i < 8; ++i) {
					if(firstKeyMap.ppp2ndKeyMap[i] != 0) {
						for(size_t j = 0; j < 0x100; ++j)
							delete firstKeyMap.ppp2ndKeyMap[i][j];
						delete[] firstKeyMap.ppp2ndKeyMap[i];
					}
				}
				delete[] firstKeyMap.ppp2ndKeyMap;
				firstKeyMap.ppp2ndKeyMap = 0;
			}
		}
	}
}

/**
 *	gݍ݃R}hɊ蓖ĂĂL[̕\擾
 *	@param id			R}hʒl
 *	@param bShortName	Z𓾂ꍇ true
 *	@return				"Ctrl+N" Ȃǂ̕\Bo^ĂȂ΋󕶎
 */
wstring CKeyboardMap::GetKeyString(CommandId id, bool bShortName) const {
	wstring	str;

	for(KeyModifier firstModifiers = 0; firstModifiers < 8; ++firstModifiers) {
		for(VirtualKey firstKey = 0; firstKey < 0x0100; ++firstKey) {
			const T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstModifiers][firstKey];
			if(firstKeyMap.pCommand != 0
					&& firstKeyMap.pCommand->IsBuiltIn()
					&& firstKeyMap.pCommand->GetId() == id) {	// 1Xg[N
				const wstring	str_ = GetStrokeString(TKeyCombination(firstKey, firstModifiers), bShortName);
				if(str.empty() || str_.length() < str.length())
					str = str_;
			} else if(firstKeyMap.ppp2ndKeyMap != 0) {
				for(KeyModifier secondModifiers = 0; secondModifiers < 8; ++secondModifiers) {
					if(firstKeyMap.ppp2ndKeyMap[secondModifiers] == 0)
						continue;
					for(VirtualKey secondKey = 0; secondKey < 0x0100; ++secondKey) {
						if(firstKeyMap.ppp2ndKeyMap[secondModifiers][secondKey] != 0
								&& firstKeyMap.ppp2ndKeyMap[secondModifiers][secondKey]->IsBuiltIn()
								&& firstKeyMap.ppp2ndKeyMap[secondModifiers][secondKey]->GetId() == id) {	// 2Xg[N
							const wstring	str_ = GetStrokeString(
								TKeyCombination(firstKey, firstModifiers),
								TKeyCombination(secondKey, secondModifiers), bShortName);
							if(str.empty() || str_.length() < str.length())
								str = str_;
						}
					}
				}
			}
		}
	}
	return str;
}

///	@see	ISerializable::Load
bool CKeyboardMap::Load(const wchar_t* pwszPathName) {
	assert(pwszPathName != 0);

	using namespace Manah::Windows::IO;

	Clear();

	try {
		CFile<false>	file(pwszPathName, modeRead);
		CommandId		id;
		VirtualKey		firstKey, secondKey;
		KeyModifier		firstModifiers, secondModifiers;
		DWORD			dwRead;

		while(true) {
			if(!file.Read(&id, sizeof(CommandId), &dwRead) || dwRead != sizeof(CommandId))
				break;
			if(!file.Read(&firstKey, sizeof(VirtualKey), &dwRead) || dwRead != sizeof(VirtualKey))
				break;
			if(!file.Read(&firstModifiers, sizeof(KeyModifier), &dwRead) || dwRead != sizeof(KeyModifier))
				break;
			if(id != CMD_SPECIAL_WAITFOR2NDKEYS)
				Assign(CBuiltInCommand(id), TKeyCombination(firstKey, firstModifiers));
			else {
				if(!file.Read(&id, sizeof(CommandId), &dwRead) || dwRead != sizeof(CommandId))
					break;
				if(!file.Read(&secondKey, sizeof(VirtualKey), &dwRead) || dwRead != sizeof(VirtualKey))
					break;
				if(!file.Read(&secondModifiers, sizeof(KeyModifier), &dwRead) || dwRead != sizeof(KeyModifier))
					break;
				Assign(CBuiltInCommand(id),
					TKeyCombination(firstKey, firstModifiers), TKeyCombination(secondKey, secondModifiers));
			}
		}
		file.Close();
	} catch(CFileException& /*e*/) {
		return false;
	} catch(out_of_range&) {
		return false;
	}

	m_bDirty = false;
	return true;
}

///	@see	ISerializable::Save
bool CKeyboardMap::Save(const wchar_t* pwszPathName) {
	assert(pwszPathName != 0);

	using namespace Manah::Windows::IO;

	try {
		CFile<false>	file(pwszPathName, modeWrite | modeCreate | shareExclusive);

		for(KeyModifier firstModifiers = 0; firstModifiers < 8; ++firstModifiers) {
			for(VirtualKey firstKey = 0; firstKey < 0x0100; ++firstKey) {
				const T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstModifiers][firstKey];
				if(firstKeyMap.pCommand == 0)	// 蓖ĂĂȂ
					continue;
				else if(firstKeyMap.ppp2ndKeyMap == 0 && firstKeyMap.pCommand->IsBuiltIn()) {	// 1Xg[N
					const CommandId	id = firstKeyMap.pCommand->GetId();
					file.Write(&id, sizeof(CommandId));
					file.Write(&firstKey, sizeof(VirtualKey));
					file.Write(&firstModifiers, sizeof(KeyModifier));
				} else {	// 2Xg[N
					assert(firstKeyMap.ppp2ndKeyMap != 0);
					for(KeyModifier secondModifiers = 0; secondModifiers < 8; ++secondModifiers) {
						for(VirtualKey secondKey = 0; secondKey < 0x0100; ++secondKey) {
							if(firstKeyMap.ppp2ndKeyMap[secondModifiers] == 0
									|| firstKeyMap.ppp2ndKeyMap[secondModifiers][secondKey] == 0
									|| !firstKeyMap.ppp2ndKeyMap[secondModifiers][secondKey]->IsBuiltIn())
								continue;
							CommandId	id = firstKeyMap.pCommand->GetId();
							file.Write(&id, sizeof(CommandId));
							file.Write(&firstKey, sizeof(VirtualKey));
							file.Write(&firstModifiers, sizeof(KeyModifier));
							id = firstKeyMap.ppp2ndKeyMap[secondModifiers][secondKey]->GetId();
							file.Write(&id, sizeof(CommandId));
							file.Write(&secondKey, sizeof(VirtualKey));
							file.Write(&secondModifiers, sizeof(KeyModifier));
						}
					}
				}
			}
		}
		file.Close();
	} catch(CFileException& /*e*/) {
		return false;
	}

	m_bDirty = false;
	return true;
}

/// L[蓖Ă1BL[gݍ킹2Xg[NL[̑1L[gݍ킹ł΂̑SĂ̊蓖Ă
void CKeyboardMap::Unassign(const TKeyCombination& keys) {
	T1stKeyMap&	firstKeyMap = m_firstKeyMaps[keys.modifiers][keys.key];

	if(firstKeyMap.pCommand == 0)
		return;
	m_bDirty = true;
	delete firstKeyMap.pCommand;
	firstKeyMap.pCommand = 0;
	if(firstKeyMap.ppp2ndKeyMap != 0) {
		for(size_t i = 0; i < 8; ++i) {
			if(firstKeyMap.ppp2ndKeyMap[i] != 0) {
				for(size_t j = 0; j < 0x100; ++j)
					delete firstKeyMap.ppp2ndKeyMap[i][j];
				delete[] firstKeyMap.ppp2ndKeyMap[i];
			}
		}
		delete[] firstKeyMap.ppp2ndKeyMap;
		firstKeyMap.ppp2ndKeyMap = 0;
	}
}

/// L[蓖Ă1
void CKeyboardMap::Unassign(const TKeyCombination& firstKeys, const TKeyCombination& secondKeys) {
	const T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstKeys.modifiers][firstKeys.key];
	if(firstKeyMap.ppp2ndKeyMap != 0) {
		if(firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers] != 0) {
			delete firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers][secondKeys.key];
			firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers][secondKeys.key] = 0;
			m_bDirty = true;
		}
	}
}

/* [EOF] */