// KeyboardMacro.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "KeyboardMacro.h"
#include "EditView.h"

using namespace Ascension;
using namespace std;
using namespace Manah::Windows::IO;


// CKeyboardMacro class implementation
/////////////////////////////////////////////////////////////////////////////

/// L^̃L[}Nɓ͑҂Ԃ}
/// @throw std::logic_error	L^łȂ΃X[
void CKeyboardMacro::QueryUser() throw(logic_error) {
	AssertValid();
	if(m_state == KMS_RECORDING)	;	//
	else							throw logic_error("Key macro is not in recording.");
}

/// }N̎s
/// @throw std::logic_error	sAL^ł΃X[
void CKeyboardMacro::Run() throw(logic_error) {
	AssertValid();

	if(m_state == KMS_NONE) {
		m_state = KMS_PLAYING;
		m_bCanceledDuringQuery = false;
		if(!m_view.GetDocument().IsReadOnly()) {
			for(KeyboardMacroCommandList::const_iterator it = m_commands.begin(); it != m_commands.end(); ++it) {
//				m_view.ExecuteCommand(it->id, it->nParam);
				if(m_bCanceledDuringQuery)	// ~?
					break;
			}
		}
		m_state = KMS_NONE;
	} else
		throw logic_error("Player is not ready to run macro.");
}

/// L^Ă}NsA̖ɒǉL^Jn
/// @throw std::logic_error	sAL^ł΃X[
void CKeyboardMacro::RunAndAppendLast() throw(logic_error) {
	AssertValid();
	Run();
	m_recordingCommands = m_commands;
	StartRecording();
}

/// }N̋L^Jn
/// @throw std::logic_error	sAL^ł΃X[
void CKeyboardMacro::StartRecording() throw(logic_error) {
	AssertValid();
	if(m_state == KMS_NONE)	m_state = KMS_RECORDING;
	else					throw logic_error("Recorder is not ready to start recording.");
}

/**
 *	@brief	}N̋L^I
 *
 *	R}h1ǉɏIƁAOL^Ă̂͂̂܂܎c
 *	@throw std::logic_error	L^łȂ΃X[
 */
void CKeyboardMacro::StopRecording() throw(logic_error) {
	AssertValid();
	if(m_state == KMS_RECORDING || m_state == KMS_PAUSING) {
		if(!m_recordingCommands.empty()) {
			m_commands = m_recordingCommands;
			m_recordingCommands.clear();
		}
		m_state = KMS_NONE;
	} else
		throw logic_error("Key macro is not in recording.");
}

/* [EOF] */