// CodePagesDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "CodePagesDlg.h"
#include "Alpha.h"
#include "../Manah/ListBox.h"
using Alpha::CCodePagesDlg;
using namespace Ascension::Encodings;
using namespace std;


// CCodePagesDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CCodePagesDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LIST_CODEPAGES && wNotifyCode == LBN_DBLCLK) {
		OnOK();
		return true;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CCodePagesDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	const CEncoderFactory&				encoders = CEncoderFactory::GetInstance();
	Manah::Windows::Controls::CListBox	cpListbox;
	set<CodePage>						codePages;
	wchar_t								wszCpName[128];

	cpListbox.Attach(GetDlgItem(IDC_LIST_CODEPAGES));
	encoders.EnumCodePages(codePages);
	for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
		if(!m_bForReading && (encoders.IsCodePageForAutoDetection(*it) || encoders.IsCodePageForReadOnly(*it)))
			continue;
		if(const wchar_t* const pwsz = CAlphaApp::GetCodePageName(*it)) {
			wcscpy(wszCpName, pwsz);
			if(m_codePage == *it)
				wcscat(wszCpName, L" *");
			cpListbox.SetItemData(cpListbox.AddString(wszCpName), *it);
		}
	}
	const int	cItems = cpListbox.GetCount();
	for(int i = 0; i < cItems; ++i) {
		if(m_codePage == cpListbox.GetItemData(i)) {
			cpListbox.SetCurSel(i);
			break;
		}
	}
	cpListbox.Detach();

	return true;
}

///	@see	CDialog::OnOK
void CCodePagesDlg::OnOK() {
	m_codePage = SendDlgItemMessage(IDC_LIST_CODEPAGES, LB_GETITEMDATA,
					SendDlgItemMessage(IDC_LIST_CODEPAGES, LB_GETCURSEL, 0, 0L), 0L);
	CDialog::OnOK();
}

/* [EOF] */