// BufferList.h
// (c) 2004-2005 exeal

#ifndef _BUFFER_LIST_H_
#define _BUFFER_LIST_H_

#include <string>
#include <vector>
#include <stdexcept>
#include <algorithm>	// std::find
#include "../Manah/Menu.h"


namespace Alpha {
	class CAlphaDoc;

	///	^Cvƃt@C̑Ή
	struct TDocumentType {
		std::wstring	strName;				///< ^Cv
		wchar_t			wszFileSpec[MAX_PATH];	///< ChJ[hB MAX_PATH ȉłȂ΂ȂȂ
		std::wstring	strCommand;				///< [s] ŎsR}hB"$F" ݂̃t@C\
		bool			bPrivate;				///< Kp\XgB
	};
	typedef std::vector<TDocumentType>	DocTypeList;

	/**
	 *	@brief	^Cv̊Ǘ
	 *
 	 *	ɊǗ镶^CvXgɂ̓CfbNXŃANZXB
	 *	0Ԗڂ̕^Cv͍ŏo^Ă镶^CvŁA
	 *	O͋󕶎Agq̃ftHg^CvłB
	 *	̕^Cv RemoveAll gĂ폜Ȃ
	 */
	class CDocumentTypeManager : public Manah::CNoncopyable {
		// RXgN^
	private:
		CDocumentTypeManager();

		// \bh
	public:
		void					Add(const TDocumentType& type) throw(std::invalid_argument);
		std::size_t				Find(const std::wstring& strName) const;
		const TDocumentType&	GetAt(std::size_t iType) const throw(std::out_of_range);
		const TDocumentType&	GetByFileName(const std::wstring& strFileName) const;
		std::size_t				GetCount() const;
		void					RemoveAll();

		// f[^o
	private:
		std::vector<TDocumentType>	m_documentTypes;
		friend class CBufferList;
	};

	/**
	 *	@brief	obt@Xg̊Ǘ
	 *
	 *	Xgɒǉꂽobt@͂̃IuWFNgj󂷂B
	 *	܂̃NX̓obt@o[ɎgACR񋟂
	 */
	class CBufferList : public Manah::CNoncopyable {
		// RXgN^
	public:
		CBufferList();
		~CBufferList();

		// \bh
	public:
		/* obt@ */
		void		Add(CAlphaDoc& buffer);
		std::size_t	Find(const CAlphaDoc& buffer) const;
		CAlphaDoc&	GetAt(std::size_t i) const throw(std::out_of_range);
		std::size_t	GetCount() const;
		void		Move(std::size_t i, std::size_t iInsertion) throw(std::out_of_range);
		void		Remove(std::size_t i) throw(std::out_of_range);
		void		UpdateList();
		/* \[XȂ */
		const Manah::Windows::Controls::CMenu&	GetBufferListMenu() const;
		CDocumentTypeManager&					GetDocumentTypeManager() const;
		HIMAGELIST								GetImageList() const;
	private:
		void	_ResetResources();

		// f[^o
	private:
		std::vector<CAlphaDoc*>			m_buffers;
		CDocumentTypeManager			m_documentTypes;
		HIMAGELIST						m_hImageList;
		Manah::Windows::Controls::CMenu	m_bufferListMenu;
	};


	/// obt@Xg̖ɒǉ
	inline void CBufferList::Add(CAlphaDoc& buffer) {
		if(std::find(m_buffers.begin(), m_buffers.end(), &buffer) != m_buffers.end())	// ̂ɂ
			return;
		m_buffers.push_back(&buffer);
		_ResetResources();
	}

	///	obt@Xg̃j[Ԃ
	inline const Manah::Windows::Controls::CMenu& CBufferList::GetBufferListMenu() const {
		return m_bufferListMenu;
	}

	///	wʒũobt@Ԃ (obt@1ꍇ null)
	inline CAlphaDoc& CBufferList::GetAt(std::size_t iBuffer) const throw(std::out_of_range) {
		return *m_buffers.at(iBuffer);
	}

	///	hLg̐Ԃ
	inline std::size_t CBufferList::GetCount() const {
		return m_buffers.size();
	}

	/// ^Cv}l[WԂ
	inline CDocumentTypeManager& CBufferList::GetDocumentTypeManager() const {
		return const_cast<CBufferList*>(this)->m_documentTypes;
	}

	///	C[WXgԂBԂꂽC[WXgjҏWĂ͂ȂȂ
	inline HIMAGELIST CBufferList::GetImageList() const {
		return m_hImageList;
	}

	///	Xg̓eωƂ𕶏}l[Wɒʒm
	inline void CBufferList::UpdateList() {
		_ResetResources();
	}

} // namespace Alpha

#endif /* _BUFFER_LIST_H_ */

/* [EOF] */