// LineLayout.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "LineLayout.h"
#include "EditView.h"

using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah;
using namespace Manah::Windows::GDI;
using namespace std;
//using CLineLayoutManager::BidiClass;


#define FIRE_LAYOUT_EVENT(event)																			\
	for(set<IEventListener*>::iterator it = m_eventListeners.begin(); it != m_eventListeners.end(); ++it)	\
		(*it)->On##event()
#define PREPARE_DC(dc)	\
	CClientDC	dc = m_eventListeners.empty() ? CScreenDC() : (*m_eventListeners.begin())->OnQueryDeviceContext()

#ifdef _DEBUG
#include "../../Manah/Timer.h"
using Manah::Windows::CTimer;
using Manah::Windows::dout;
#endif /* _DEBUG */


namespace {
	// zfobOo
	template<typename T> inline void dumpArray(const T* arr, size_t c) {
		for(size_t i = 0; i < c; ++i)
			Manah::Windows::dout << arr[i] << L",";
		Manah::Windows::dout << L"\n";
	}

	// ASCII 䕶𔻕ʂ֐IuWFNg (CLexer::IsAsciiControl )
	struct IsAsciiControl {
		operator ()(char_t ch) const {
			return ch < 0x20 || ch == 0x7F;
		}
	};
}


// CLineLayout class implementation
/////////////////////////////////////////////////////////////////////////////

const Tokens					CLineLayout::m_nullTokenList;
const Tokens					CLineLayout::m_simpleTokenList;
auto_ptr<CLineLayout::CRuns>	CLineLayout::m_pSimpleRuns;

/// ێĂg[NXg폜
void CLineLayout::_DeleteTokenList() {
	// Loł΍폜Ȃ
	if(m_pTokens != &m_nullTokenList && m_pTokens != &m_simpleTokenList)
		delete m_pTokens;
	m_pTokens = 0;
}

/**
 *	w肵͒iK܂Ŋ߂
 *	@param stage	͒iK
 */
void CLineLayout::BackParseStage(ParseStage stage) {
	if(stage <= PARSE_STAGE_FULL) {
		delete[] m_pRuns;
		m_pRuns = 0;
		delete[] m_caretPositions;
		m_caretPositions = 0;
		delete m_pWrapOffsets;
		m_pWrapOffsets = 0;
		m_parseStage = PARSE_STAGE_TOKENS;
	}
	if(stage <= PARSE_STAGE_TOKENS) {
		_DeleteTokenList();
		m_parseStage = PARSE_STAGE_MULTILINE_ANNOTATIONS;
	}
}

/// ̃XgԂ
const CLineLayout::CRuns& CLineLayout::GetRuns() const {
	if(m_pRuns != 0)
		return *m_pRuns;
	else if(m_pSimpleRuns.get() == 0) {
		CRun**	_pp = new CRun*[1];
		_pp[0] = new CRun(0, false);
		m_pSimpleRuns.reset(new CRuns(1, _pp));
	}
	return *m_pSimpleRuns.get();
}


// CLineLayoutManager class implementation
/////////////////////////////////////////////////////////////////////////////

CLineLayoutManager::_CBidirectionalLayoutCalculator	CLineLayoutManager::m_bidiCalculator;

/**
 *	RXgN^
 *	@param document	hLg
 */
CLineLayoutManager::CLineLayoutManager(CEditDoc& document)
		: m_document(document), m_bLexingEnabled(true), m_nFreezeCount(0),
		m_pHead(0), m_nMaxDisplayWidth(0), m_pMaxDisplayWidthLine(0),
		m_hRegularFont(0), m_hBoldFont(0), m_hItalicFont(0), m_hBoldItalicFont(0), m_pLineCache(0)
#ifdef SUBSTITUTE_BIDIFORMATTERS
		, m_pBidiFmtSubstFont(0)
#endif /* SUBSTITUTE_BIDIFORMATTERS */
{
	m_pLexer = new CLexer(this);
	for(size_t i = 0; i < ETT_COUNT; ++i) {
		if(i != TT_KEYWORD && i != TT_ANNOTATION)
			m_tokenFoundations[i].body.pFoundation = new TTextFoundation();
		else
			m_tokenFoundations[i].body.pCookedFoundations = new _CookedTokenMap();
		m_tokenFoundations[i].bEnabled = true;
	}

	// ̃tHg
	const LOGFONTW	defaultFont = {
		0, 0, 0, 0, FW_NORMAL, false, false, false,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		FIXED_PITCH | FF_DONTCARE, L"Terminal"
	};
	SetFont(defaultFont);
}

///	fXgN^
CLineLayoutManager::~CLineLayoutManager() {
	DeleteAllLines();
	delete m_pLexer;
	for(size_t i = 0; i < ETT_COUNT; ++i) {
		if(i != TT_KEYWORD && i != TT_ANNOTATION)
			delete m_tokenFoundations[i].body.pFoundation;
		else
			delete m_tokenFoundations[i].body.pCookedFoundations;
	}
	::DeleteObject(m_hRegularFont);
	::DeleteObject(m_hBoldFont);
	::DeleteObject(m_hItalicFont);
	::DeleteObject(m_hBoldItalicFont);
#ifdef SUBSTITUTE_BIDIFORMATTERS
	delete m_pBidiFmtSubstFont;
#endif /* SUBSTITUTE_BIDIFORMATTERS */
}

/// CxgXi̒ǉ
void CLineLayoutManager::AddEventListener(CLineLayoutManager::IEventListener& eventListener) {
	AssertValid();
	m_eventListeners.insert(&eventListener);
}

/// @see	CBookmarker::ClearAllBookmarks
void CLineLayoutManager::ClearAllBookmarks() {
	bool	bClearedOnce = false;

	for(CLineLayout* pLine = m_pHead; pLine != 0; pLine = pLine->m_pNext) {
		if(pLine->IsBookmarked()) {
			pLine->SetBookmark(false);
			bClearedOnce = true;
		}
	}
	if(bClearedOnce)
		FIRE_LAYOUT_EVENT(ClearedAllBookmarks);
}

///	CAEgׂĔj
void CLineLayoutManager::DeleteAllLines() {
	AssertValid();

	CLineLayout*	pCurrent = m_pHead;
	CLineLayout*	pNext;

	while(pCurrent != 0) {
		pNext = pCurrent->m_pNext;
		delete pCurrent;
		pCurrent = pNext;
	}
	m_pHead = 0;
	m_nMaxDisplayWidth = 0;
	m_pMaxDisplayWidthLine = 0;
	m_pLineCache = 0;
}

/**
 *	w肵s̃CAEg폜
 *	@param iLine			폜sԍ
 *	@exception out_of_range	<var>iLine</var> ݂Ȃsł΃X[
 */
void CLineLayoutManager::DeleteLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);

	if(pLine == 0)
		throw out_of_range("Specified line is not found.");
	m_pLineCache = 0;

	if(pLine->m_pNext == 0) {
		if(pLine->m_pPrev == 0)
			m_pHead = 0;
		else
			pLine->m_pPrev->m_pNext = 0;
		if(m_settings.wrapMode == WPM_NONE && pLine == m_pMaxDisplayWidthLine)
			UpdateMaxDisplayWidth();
//		if(pLine == m_view.m_layoutInfo.pAppDefinedSingleLine)
//			m_view.m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pLine;
	} else {
		CLineLayout*	pTemp = pLine->m_pNext;
		if(pLine->m_pPrev == 0) {
			pLine->m_pNext->m_pPrev = 0;
			m_pHead = pLine->m_pNext;
		} else {
			pLine->m_pPrev->m_pNext = pLine->m_pNext;
			pLine->m_pNext->m_pPrev = pLine->m_pPrev;
		}
		if(m_settings.wrapMode == WPM_NONE && pLine == m_pMaxDisplayWidthLine)
			UpdateMaxDisplayWidth();
//		if(pLine == m_view.m_layoutInfo.pAppDefinedSingleLine)
//			m_view.m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pLine;
		pLine = pTemp;
	}

	// 㑱̉e󂯂s`FbN (pLine  iLine ͊ɍ폜̍swĂ)
	if(pLine->m_pPrev == 0 && pLine->m_multilineAnnotationFromPrev == NullCookie)
		return;
	if(pLine->m_pPrev != 0 && pLine->m_pPrev->m_multilineAnnotationToNext == pLine->m_multilineAnnotationFromPrev)
		return;
	while(true) {
		ParseMultilineCommentContinue(iLine, *pLine);
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_parseStage < CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		++iLine;
	}
}

/**
 *	̍s̃CAEg폜
 *	@param iStart	폜Jns
 *	@param iEnd		폜Is (̍s폜)
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::DeleteLines(length_t iStart, length_t iEnd) throw(out_of_range) {
	AssertValid();
	assert(iStart <= iEnd);

	CLineLayout*	pLine = GetLineInternal(iStart);
	CLineLayout*	pLast = GetLineInternal(iEnd);

	if(pLine == 0 || pLast == 0)
		throw out_of_range("Specified lines are not found.");
	m_pLineCache = 0;

	CLineLayout*	pNext = 0;
	CLineLayout*	pBeginPrev = pLine->m_pPrev;
	CLineLayout*	pEndNext = pLast->m_pNext;
	bool			bMaxIsDeleted = false;

	if(pLine == m_pHead)
		m_pHead = pLast->m_pNext;

	while(true) {	// 폜
		pNext = pLine->m_pNext;
		if(pLine == m_pMaxDisplayWidthLine)
			bMaxIsDeleted = true;
//		if(pLine == m_view.m_layoutInfo.pAppDefinedSingleLine)
//			m_view.m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pLine;
		if(pNext == pEndNext)
			break;
		pLine = pNext;
	}

	if(pBeginPrev != 0)
		pBeginPrev->m_pNext = pEndNext;
	if(pEndNext != 0)
		pEndNext->m_pPrev = pBeginPrev;

	if(m_settings.wrapMode == WPM_NONE && bMaxIsDeleted)
		UpdateMaxDisplayWidth();

	if(pEndNext == 0)
		return;
	pLine = pEndNext;

	// 㑱̉e󂯂s`FbN (pInfo  iLine ͊ɍ폜̍swĂ)
	if(pLine->m_pPrev == 0 && pLine->m_multilineAnnotationFromPrev == NullCookie)
		return;
	if(pLine->m_pPrev != 0 && pLine->m_pPrev->m_multilineAnnotationToNext == pLine->m_multilineAnnotationFromPrev)
		return;
	ulong	iLine = iStart;
	while(true) {
		ParseMultilineCommentContinue(iLine, *pLine);
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_parseStage < CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		++iLine;
	}
}

/// @see	CLayoutSettings::EnableLexicalParsing
void CLineLayoutManager::EnableLexicalParsing(bool bEnable) {
	AssertValid();
	if(bEnable != m_bLexingEnabled) {
		m_bLexingEnabled = bEnable;
		Invalidate(CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS);
	}
}

/*
///	w肵R[h|Cg̑oeLXgԂ
BidiClass CLineLayoutManager::GetBidiClass(ulong cp) {
	// bidi_class.pl 쐬
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error This method is based on old version of Unicode.
#endif
#include "Script\LineLayout_BidiClassList_4_0"
#define CHECK_BIDI_CLASS(klass)																	\
	if(binary_search(arr##klass, arr##klass + sizeof(arr##klass) / sizeof(ulong), cp))	\
		return BC_##klass

	switch(cp) {
	case 0x202A:	return BC_LRE;
	case 0x202B:	return BC_RLE;
	case 0x202C:	return BC_PDF;
	case 0x202D:	return BC_LRO;
	case 0x202E:	return BC_RLO;
	}
	CHECK_BIDI_CLASS(R);
	CHECK_BIDI_CLASS(AL);
	CHECK_BIDI_CLASS(EN);
	CHECK_BIDI_CLASS(ES);
	CHECK_BIDI_CLASS(ET);
	CHECK_BIDI_CLASS(AN);
	CHECK_BIDI_CLASS(CS);
	CHECK_BIDI_CLASS(NSM);
	CHECK_BIDI_CLASS(BN);
	CHECK_BIDI_CLASS(B);
	CHECK_BIDI_CLASS(S);
	CHECK_BIDI_CLASS(WS);
	CHECK_BIDI_CLASS(ON);
	return BC_L;
}*/

///	GetLine ̓ (Ԃs͖͂̏ꍇ)
CLineLayout* CLineLayoutManager::GetLineInternal(length_t iLine) const {
	AssertValid();

	CLineLayout*	pLine;
	length_t		iRest;
	bool			bForward;	// m_pNext ŌƂ^

	if(m_pLineCache == 0 || iLine <= dif(iLine, m_iLineCache)) {	// LbVgȂ or n_̕߂
		pLine = m_pHead;
		iRest = iLine;
		bForward = true;
	} else {	// LbV_̕߂Ƃ
		pLine = m_pLineCache;
		iRest = dif(m_iLineCache, iLine);
		bForward = m_iLineCache < iLine;
	}

	if(bForward) {
		while(pLine != 0) {
			if(iRest == 0) {
				m_iLineCache = iLine;
				m_pLineCache = pLine;
				return pLine;
			}
			pLine = pLine->m_pNext;
			--iRest;
		}
	} else {
		while(pLine != 0) {
			if(iRest == 0) {
				m_iLineCache = iLine;
				m_pLineCache = pLine;
				return pLine;
			}
			pLine = pLine->m_pPrev;
			--iRest;
		}
	}
	return 0;
}

/// hLǧ݂̍ŏIsԍ10iŉɂȂ邩Ԃ
uint CLineLayoutManager::_GetLineNumberMaxDigit() const {
	AssertValid();

	uint		n = 1;
	length_t	cLines = m_document.GetLineCount() + m_settings.lineNumberLayout.iStartLine - 1;

	while(cLines >= 10) {
		cLines /= 10;
		++n;
	}
	return n;
}

/**
 *	ws̉͂ǂ̒xIĂ邩Ԃ
 *	@param iLine	_s
 *	@return			̓x
 */
CLineLayout::ParseStage CLineLayoutManager::GetLineParseStage(length_t iLine) const throw(out_of_range) {
	AssertValid();
	if(CLineLayout* pLine = GetLineInternal(iLine))
		return pLine->m_parseStage;
	else
		throw out_of_range("Specified line is not found.");
}

///	ő\s̕\Ԃ
int CLineLayoutManager::GetMaxDisplayWidth() const {
	AssertValid();
	return m_nMaxDisplayWidth;
}

/// @see	CBookmarker::GetNextBookmark
length_t CLineLayoutManager::GetNextBookmark(length_t iLine) const throw(invalid_argument, out_of_range) {
	const CLineLayout*	pLine = GetLineInternal((iLine != -1) ? iLine : 0);

	if(pLine == 0)
		throw out_of_range("Specified line number is out of range.");
	else if(iLine != -1 && !pLine->IsBookmarked())
		throw invalid_argument("Specified line is not bookmarked.");
	while(pLine = GetLineInternal(++iLine)) {
		if(pLine->IsBookmarked())
			return iLine;
	}
	return -1;
}


/// @see	CLayoutSettings::GetTokenFoundation
TTextFoundation CLineLayoutManager::GetTokenFoundation(int type, TokenCookie nCookie) const throw(invalid_argument) {
	AssertValid();
	if(type < TT_FIRST || type >= ETT_COUNT)
		throw invalid_argument("Invalid token type.");

	TTextFoundation	tf;
	if(type != TT_KEYWORD && type != TT_ANNOTATION)
		tf = *m_tokenFoundations[type].body.pFoundation;
	else {
		_CookedTokenMap::iterator	it = m_tokenFoundations[type].body.pCookedFoundations->find(nCookie);
		if(it == m_tokenFoundations[type].body.pCookedFoundations->end())
			throw invalid_argument("Invalid cookie value.");
		tf = it->second;
	}

	// OiF̎
	if(tf.fgColor == -1) {
		if(type == ETT_NORMAL)					tf.fgColor = ::GetSysColor(COLOR_WINDOWTEXT);
		else if(type == ETT_SELECTION)			tf.fgColor = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
		else if(type == ETT_INACTIVE_SELECTION)	tf.fgColor = ::GetSysColor(COLOR_INACTIVECAPTIONTEXT);
		else if(type == ETT_INDICATOR_MARGIN)	tf.fgColor = ::GetSysColor(COLOR_3DSHADOW);
		else if(type == ETT_RESTRICTION)		tf.fgColor = ::GetSysColor(COLOR_GRAYTEXT);
		else
			tf.fgColor = (m_tokenFoundations[ETT_NORMAL].body.pFoundation->fgColor != -1) ?
				m_tokenFoundations[ETT_NORMAL].body.pFoundation->fgColor : ::GetSysColor(COLOR_WINDOWTEXT);
	} else if(tf.fgColor > 0x7FFFFFFFUL)
		tf.fgColor = ::GetSysColor(tf.fgColor - 0x80000000UL);

	// wiF̎
	if(tf.bgColor == -1) {
		if(type == ETT_NORMAL)					tf.bgColor = ::GetSysColor(COLOR_WINDOW);
		else if(type == ETT_SELECTION)			tf.bgColor = ::GetSysColor(COLOR_HIGHLIGHT);
		else if(type == ETT_INACTIVE_SELECTION)	tf.bgColor = ::GetSysColor(COLOR_INACTIVECAPTION);
		else if(type == ETT_INDICATOR_MARGIN)	tf.bgColor = ::GetSysColor(COLOR_3DFACE);
		else
			tf.bgColor = (m_tokenFoundations[ETT_NORMAL].body.pFoundation->bgColor != -1) ?
				m_tokenFoundations[ETT_NORMAL].body.pFoundation->bgColor : ::GetSysColor(COLOR_WINDOW);
	} else if(tf.bgColor > 0x7FFFFFFFUL)
		tf.bgColor = ::GetSysColor(tf.bgColor - 0x80000000UL);

	// /gF̎
	if(tf.borderColor == -1)
		tf.borderColor = (type != ETT_LINK) ? tf.fgColor : m_tokenFoundations[ETT_NORMAL].body.pFoundation->fgColor;
	else if(tf.borderColor > 0x7FFFFFFFUL)
		tf.borderColor = ::GetSysColor(tf.borderColor - 0x80000000UL);

	return tf;
}

/**
 *	w肵s̃CAEg쐬AXgɒǉ
 *	@param iLine	sԍ
 *	@exception		iLine }s\ȍsԍł <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLine(length_t iLine) throw(out_of_range) {
	AssertValid();
	if(iLine > m_document.GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayout*	pLine = 0;
	CLineLayout*	pPrev = 0;

	m_pLineCache = 0;

	// s̑}
	if(iLine == 0) {
		pLine = new CLineLayout();
		pLine->m_pNext = m_pHead;
		m_pHead->m_pPrev = pLine;
		m_pHead = pLine;
	} else {
		pPrev = GetLineInternal(iLine - 1);
		assert(pPrev != 0);
		pLine = new CLineLayout();
		pLine->m_pPrev = pPrev;
		pLine->m_pNext = pPrev->m_pNext;
		if(pPrev->m_pNext != 0)
			pPrev->m_pNext->m_pPrev = pLine;
		pPrev->m_pNext = pLine;
		pLine->m_multilineAnnotationFromPrev = pLine->m_pPrev->m_multilineAnnotationToNext;
	}
	if(ASCENSION_MINIMUM_LINE_PARSE_STAGE <= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
		ParseMultilineCommentContinue(iLine, *pLine);
	else if(ASCENSION_MINIMUM_LINE_PARSE_STAGE == CLineLayout::PARSE_STAGE_TOKENS)
		ParseTokens(iLine, *pLine);
	else if(ASCENSION_MINIMUM_LINE_PARSE_STAGE == CLineLayout::PARSE_STAGE_FULL)
		ParseCharacterPositions(iLine, *pLine);
	else
		assert(false);

	if(pLine->m_pNext == 0)
		return;
	pLine = pLine->m_pNext;
	++iLine;

	// 㑱̉e󂯂s`FbN
	while(true) {
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_parseStage < CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		ParseMultilineCommentContinue(++iLine, *pLine);
	}
}

/**
 *	̍sCAEg쐬AXgɒǉ
 *	@param iStart	}Jns
 *	@param iEnd		}Is
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLines(length_t iStart, length_t iEnd) throw(out_of_range) {
	AssertValid();
	assert(iStart <= iEnd);

//	CTimer tm(L"InsertLines");
	if(iStart > m_document.GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayout*	pBeginPrev = (iStart != 0) ? GetLineInternal(iStart - 1) : 0;
	CLineLayout*	pEndNext = GetLineInternal(iStart);
	CLineLayout*	pNewLine = 0;
	CLineLayout*	pNewPrevLine = 0;

	// s̑}
	for(length_t iLine = iStart; /* iLine <= iEnd */; ++iLine) {
		pNewLine = new CLineLayout();
		if(iLine == iStart) {
			pNewLine->m_pPrev = pBeginPrev;
			if(pBeginPrev == 0)
				m_pHead = pNewLine;
			else
				pBeginPrev->m_pNext = pNewLine;
		} else {
			pNewLine->m_pPrev = pNewPrevLine;
			pNewPrevLine->m_pNext = pNewLine;
		}
		if(iLine == iEnd) {
			pNewLine->m_pNext = pEndNext;
			if(pEndNext != 0)
				pEndNext->m_pPrev = pNewLine;
			break;
		}
		pNewPrevLine = pNewLine;
	}
	m_pLineCache = 0;

	// }s̏XV
	CLineLayout*	pLine = GetLineInternal(iStart);
	for(length_t iLine = iStart; iLine <= iEnd; ++iLine, pLine = pLine->m_pNext) {
		if(ASCENSION_MINIMUM_LINE_PARSE_STAGE <= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
			ParseMultilineCommentContinue(iLine, *pLine);
		else if(ASCENSION_MINIMUM_LINE_PARSE_STAGE == CLineLayout::PARSE_STAGE_TOKENS)
			ParseTokens(iLine, *pLine);
		else if(ASCENSION_MINIMUM_LINE_PARSE_STAGE == CLineLayout::PARSE_STAGE_FULL)
			ParseCharacterPositions(iLine, *pLine);
		else
			assert(false);
	}

	// 㑱̉e󂯂s`FbN
	length_t	iLine_ = iEnd;
	pLine = pEndNext;
	if(pLine == 0)
		return;
	while(true) {
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_parseStage < CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		ParseMultilineCommentContinue(++iLine_, *pLine);
	}
}

/**
 *	SĂ̍sɑ΂Ďw肵x̉͂蒼Kv邱Ƃʒm
 *	@param invalidity	̓x
 */
void CLineLayoutManager::Invalidate(CLineLayout::ParseStage stage) {
	AssertValid();

	CLineLayout*	pLine = m_pHead;

	while(pLine != 0) {
		if(pLine->m_parseStage >= stage)
			pLine->m_parseStage = static_cast<CLineLayout::ParseStage>(stage - 1);
		pLine = pLine->m_pNext;
	}
}

/**
 *	w肵s̃CAEgXV
 *	@param iLine	(_) sԍ
 *	@return			es
 *	@exception		iLine ݂Ȃsł <code>out_of_range</code>
 */
length_t CLineLayoutManager::ModifyLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);

	if(pLine == 0)
		throw out_of_range("Specified line is not found.");
	m_pLineCache = 0;

	// ܂Ԃƍs̕\ɂ
	CEditDoc::LineIterator	it = m_document.GetLineIterator(iLine);
	const char_t*			pszLine = it->GetLine().c_str();
	const length_t			cchLine = it->GetLine().length();
	ulong					cxLine = 0;

	delete pLine->m_pWrapOffsets;
	pLine->m_pWrapOffsets = 0;
	pLine->m_parseStage = CLineLayout::PARSE_STAGE_UNPARSED;

//	hOldFont = m_pView->m_gdiObjects.oMemDC.SelectObject(m_pView->m_gdiObjects.hNormalFont);

//	if(m_pView->m_modeState.wpmWrapMode == WPM_NONE)
		ParseCharacterPositions(iLine, *pLine);
/*	else {	// ܂Ԃ̌vZ
		ulong	cxWrap;
		uint	cxChar;

		pInfo->m_pvecWrappedOffsets = new WrappedOffsets;
		if(m_pView->m_modeState.wpmWrapMode == WPM_SPECIFIED)
			cxWrap = m_pView->m_modeState.nWrapWidth;
		else if(m_pView->m_modeState.wpmWrapMode == WPM_WINDOW) {
			RECT	rect;
			m_pView->GetClientRect(&rect);
			cxWrap = rect.right - rect.left
						- m_pView->m_layoutInfo.nLeftTabWidth - m_pView->m_layoutInfo.nLeftMargin;
		}
		for(ulong i = 0; i < cchLine; ++i) {
			if(*(pszLine + i) == L'\t')
				cxChar = m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth()
							- cxLine % (m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth());
			else
				cxChar = m_pView->m_gdiObjects.oMemDC.GetTextExtent(pszLine + i, 1).cx;
			if(cxLine + cxChar > cxWrap) {	// ܂Ԃ
				pInfo->m_pvecWrappedOffsets->push_back(i);
				cxLine = 0;
			}
			cxLine += cxChar;
		}
	}

	m_pView->m_gdiObjects.oMemDC.SelectObject(hOldFont);*/

	// 㑱s̕sRgɂ
	length_t	cModifiedLines = 1;
	while(true) {
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_parseStage < CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		ParseMultilineCommentContinue(iLine + cModifiedLines, *pLine);
		++cModifiedLines;
	}
	return cModifiedLines;
}

/// @see	CBookmarker::IsBookmarked
bool CLineLayoutManager::IsBookmarked(length_t iLine) const throw(out_of_range) {
	if(const CLineLayout* const pLine = GetLineInternal(iLine))
		return pLine->IsBookmarked();
	else
		throw out_of_range("Specified line number is out of range.");
}

///	@see	ILexerEventListener::OnLexerAddedIdentifiedToken
void CLineLayoutManager::OnLexerAddedIdentifiedToken(Ascension::TokenType type, TokenCookie nCookie) {
	AssertValid();
	m_tokenFoundations[type].body.pCookedFoundations->insert(
		pair<TokenCookie, TTextFoundation>(nCookie, TTextFoundation()));
}

///	@see	ILexerEventListener::OnLexerChanged
void CLineLayoutManager::OnLexerChanged() {
	AssertValid();
	Invalidate(ASCENSION_MINIMUM_LINE_PARSE_STAGE);
	FIRE_LAYOUT_EVENT(ChangedLayout);
}

///	@see	ILexerEventListener::OnLexerCleared
void CLineLayoutManager::OnLexerCleared() {
	AssertValid();
	m_tokenFoundations[TT_KEYWORD].body.pCookedFoundations->clear();
	m_tokenFoundations[TT_ANNOTATION].body.pCookedFoundations->clear();
	Invalidate(ASCENSION_MINIMUM_LINE_PARSE_STAGE);
	FIRE_LAYOUT_EVENT(ChangedLayout);
}

///	@see	ILexerEventListener::OnLexerRemovedIdentifiedToken
void CLineLayoutManager::OnLexerRemovedIdentifiedToken(Ascension::TokenType type, TokenCookie nCookie) {
	AssertValid();
	_CookedTokenMap::iterator	itRemoved = m_tokenFoundations[type].body.pCookedFoundations->find(nCookie);
	m_tokenFoundations[type].body.pCookedFoundations->erase(itRemoved);
}


/**
 *	@brief	ws̉͂sB͍ς݂łΉȂ
 *
 *	CLineLayoutManager ̃NCAg GetLine
 *	gƂŉ͍ς݂̍s擾ł邪AGetLine
 *	ȊÕ\bh͍s͂sȂ̂ŁA
 *	̃\bhŗ\߉͂sƂŃI[owbhɘa邱Ƃł
 *
 *	@param iLine				_s
 *	@throw std::out_of_range	<var>iLine</var> ݂ȂŝƂX[
 */
void CLineLayoutManager::ParseLine(length_t iLine) throw(out_of_range) {
	AssertValid();
	if(CLineLayout* pLine = GetLineInternal(iLine)) {
		if(pLine->m_parseStage < CLineLayout::PARSE_STAGE_FULL)
			ParseCharacterPositions(iLine, *pLine);
	} else
		throw out_of_range("Specified line is not found.");
}

/**
 *	ʒǔvZs
 *	@param iLine	_sԍ
 *	@param layout	s̃CAEg
 */
void CLineLayoutManager::ParseCharacterPositions(length_t iLine, CLineLayout& layout) {
	AssertValid();

	// g[N؂oIĂȂ΂Ȃ
	if(layout.m_parseStage < CLineLayout::PARSE_STAGE_TOKENS)
		ParseTokens(iLine, layout);

	const length_t	cchLine = m_document.GetLineLength(iLine);
	int*			positions = new int[cchLine + 1];

	delete layout.m_pRuns;
	delete[] layout.m_caretPositions;
	layout.m_caretPositions = positions;
	positions[0] = 0;

	if(cchLine == 0) {
		layout.m_pRuns = 0;
		layout.m_nWidth = 0;
		layout.m_parseStage = CLineLayout::PARSE_STAGE_FULL;
		return;
	}

	PREPARE_DC(dc);
	const string_t&	strLine = m_document.GetLine(iLine);
	const char_t*	pwszLine = strLine.c_str();
	HFONT			hOldFont = dc.SelectObject(m_hRegularFont);

	dc.SetTextCharacterExtra(m_settings.nCharSpan);

	// 𓾂
	ulong*	pRunOrders;
	layout.m_pRuns = m_bidiCalculator.Calculate(dc, pwszLine, cchLine, m_settings.bRightToLeftReading, pRunOrders);
	assert(layout.m_pRuns != 0);

	// oꏇ̑ʒuvZĂ
	CLineLayout::CRuns&	runs = *const_cast<CLineLayout::CRuns*>(layout.m_pRuns);
	const Tokens&		tokens = layout.GetTokens();
	HFONT				hCurrentFont = 0;	//  dc őI𒆂̃tHg
	size_t		iNextFontChangingToken = 0;	// ɕ`tHg؂ւȂ΂ȂȂg[N
	length_t	nOffset = 0;				// s̈ʒu

	for(size_t iRun = 0; iRun < runs.GetCount(); ++iRun) {
		CLineLayout::CRun&	run = *runs.m_array[pRunOrders[iRun]];
		const bool		bLastRun = pRunOrders[iRun] == runs.GetCount() - 1;
		length_t		iStart = run.GetIndex();
		const length_t	iNextRun = !bLastRun ? runs.GetAt(pRunOrders[iRun] + 1).GetIndex() : cchLine;
		length_t		iNextCtrl = find_if(pwszLine, pwszLine + iNextRun, IsAsciiControl()) - pwszLine;	// ̐䕶
		SIZE			size;

		// ^uA֐䕶ȂẽLbgʒu𓾂
		run.m_nWidth = 0;
		positions[run.GetIndex()] = nOffset;
		while(true) {
			//  ASCII 䕶T
			if(iNextCtrl < iStart) {
				const char_t* const	pCtrl = find_if(pwszLine + iStart, pwszLine + iNextRun, IsAsciiControl());
				iNextCtrl = pCtrl - pwszLine;
			}

			// ɃtHgςʒuT
			if(iNextFontChangingToken < tokens.count
					&& iStart == tokens.array[iNextFontChangingToken].GetIndex()) {
				const CToken&	token = tokens.array[iNextFontChangingToken];
				dc.SelectObject(hCurrentFont = GetFontForRenderingToken(token.GetType(), token.GetCookie()));
				while(++iNextFontChangingToken < tokens.count) {
					const CToken&	nextToken = tokens.array[iNextFontChangingToken];
					if(GetFontForRenderingToken(nextToken.GetType(), nextToken.GetCookie()) != hCurrentFont)
						break;
				}
			}

			const length_t	iNextFontChanging =
				(iNextFontChangingToken < tokens.count) ? tokens.array[iNextFontChangingToken].GetIndex() : cchLine;

			//  ASCII 䕶tHg̕ςڂ܂
			if(min(iNextCtrl, iNextFontChanging) - iStart > 0) {
				const length_t	cch = min(iNextCtrl,
					(iNextFontChangingToken < tokens.count && iStart < iNextFontChanging) ? iNextFontChanging : cchLine) - iStart;
				const bool		bDropLast = !bLastRun && iStart + cch == iNextRun;
				if(bDropLast) {
					const int	nOriginalLastPos = positions[iStart + cch];
					dc.GetTextExtentExPoint(pwszLine + iStart, cch, 0, 0, positions + iStart + 1, &size);
					positions[iNextCtrl] = nOriginalLastPos;
				} else
					dc.GetTextExtentExPoint(pwszLine + iStart, cch, 0, 0, positions + iStart + 1, &size);
				if(nOffset != 0) {
					const length_t	iEnd = bDropLast ? iStart + cch - 1 : iStart + cch;
					for(length_t i = iStart; i < iEnd; ++i)
						positions[i + 1] += nOffset;
				}
				iStart += cch;
				run.m_nWidth += size.cx;
				nOffset += size.cx;
			}

			// ASCII 䕶
			if(iNextCtrl < iNextRun
					&& (iNextFontChangingToken == tokens.count || iNextCtrl <= iNextFontChanging)) {
				if(iNextCtrl == iNextFontChanging) {	// tHgɕς
					const CToken&	token = tokens.array[iNextFontChangingToken];
					dc.SelectObject(GetFontForRenderingToken(token.GetType(), token.GetCookie()));
				}
				if(pwszLine[iNextCtrl] == L'\t')	// ^u
					positions[iNextCtrl + 1] = GetNextTabStop(nOffset, true/*!run.IsRightToLeft()*/);
				else {	// ̑̐䕶
					char_t	wszGlyph[2];
					CLexer::GetAsciiControlSubstitutionGlyph(static_cast<uchar>(pwszLine[iNextCtrl]), wszGlyph);
					positions[iNextCtrl + 1] = positions[iNextCtrl] + dc.GetTextExtent(wszGlyph, 2).cx;
				}
				run.m_nWidth += positions[iNextCtrl + 1] - positions[iNextCtrl];
				nOffset += positions[iNextCtrl + 1] - positions[iNextCtrl];
				iStart = iNextCtrl + 1;
			}

			// ܂tHgςĎ̃g[N`悷KvӏcĂ
			else if(iNextFontChangingToken < tokens.count && iStart <= iNextFontChanging)
				/* break Ȃ */;

			// ̃͏I
			else
				break;
		}

		// RTL ł΃Lbgʒut]
		if(run.IsRightToLeft()) {
			for(length_t i = !bLastRun ? iNextRun - 1 : iNextRun; i > run.GetIndex(); --i)
				positions[i] = (positions[run.GetIndex()] + run.m_nWidth) - (positions[i] - positions[run.GetIndex()]);
			positions[run.GetIndex()] += run.m_nWidth;
		}
	}

	delete[] pRunOrders;
	if(layout.m_pRuns->m_count == 1 && !layout.m_pRuns->m_array[0]->m_bRtl) {
		delete layout.m_pRuns;
		layout.m_pRuns = 0;
	}
	layout.m_nWidth = nOffset;
	dc.SelectObject(hOldFont);
	layout.m_parseStage = CLineLayout::PARSE_STAGE_FULL;

	// ő\̌vZ (ł͂Ȃ...)
	if(layout.m_nWidth > m_nMaxDisplayWidth) {
		m_nMaxDisplayWidth = layout.m_nWidth;
		m_pMaxDisplayWidthLine = &layout;
		FIRE_LAYOUT_EVENT(ChangedMaximumWidthLine);
	} else if(&layout == m_pMaxDisplayWidthLine) {
		UpdateMaxDisplayWidth();
		FIRE_LAYOUT_EVENT(ChangedMaximumWidthLine);
	}

}

/**
 *	s̐擪A̕sRg
 *	@param iLine	_sԍ
 *	@param layout	sCAEg
 */
void CLineLayoutManager::ParseMultilineCommentContinue(length_t iLine, CLineLayout& layout) {
	AssertValid();

	if(!m_bLexingEnabled) {
		layout.m_multilineAnnotationFromPrev = layout.m_multilineAnnotationToNext = 0;
		layout.m_parseStage = CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS;
		return;
	}

	// O̍s̕sRgI󋵂g
	if(layout.m_pPrev == 0) {	// 擪s
		layout.m_multilineAnnotationFromPrev = NullCookie;
		layout.m_parseStage = CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS;
	} else {
		// O̍s͂Ȃ΍ċAIɉ͂
		CLineLayout*	pLine = &layout;
		
		// ܂͂łŏ̍s܂Ŗ߂
		while(true) {
			if(pLine->m_pPrev == 0) {	// 擪s
				pLine->m_multilineAnnotationFromPrev = NullCookie;
				break;
			} else if(pLine->m_pPrev->m_parseStage >= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS) {	// ͍ς݂̍sɓ
				pLine->m_multilineAnnotationFromPrev = pLine->m_pPrev->m_multilineAnnotationToNext;
				break;
			}
			pLine = pLine->m_pPrev;
			--iLine;
		}

		// ͂Ȑ擪s pLine ܂ł
		while(true) {
			pLine->m_multilineAnnotationToNext =
				m_pLexer->ParseMultilineAnnotation(m_document.GetLine(iLine), pLine->m_multilineAnnotationFromPrev);
			pLine->m_parseStage= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS;
			if(pLine == &layout)	// ŏɉ͂悤ƂĂs
				break;
			pLine = pLine->m_pNext;
			++iLine;
			pLine->m_multilineAnnotationFromPrev = pLine->m_pPrev->m_multilineAnnotationToNext;
		}
	}
}

/**
 *	g[N؂os
 *	@param iLine	_sԍ
 *	@param layout	sCAEg
 */
void CLineLayoutManager::ParseTokens(length_t iLine, CLineLayout& layout) {
	AssertValid();

	if(!m_bLexingEnabled) {
		layout._DeleteTokenList();
		if(CLineLayout::m_simpleTokenList.count == 0) {
			const_cast<Tokens&>(CLineLayout::m_simpleTokenList).count = 1;
			const_cast<Tokens&>(CLineLayout::m_simpleTokenList).array = new CToken(0, TT_UNSPECIFIED, NullCookie);
		}
		layout.m_pTokens = &CLineLayout::m_simpleTokenList;
		layout.m_parseStage = CLineLayout::PARSE_STAGE_TOKENS;
		return;
	}

	// O̍s畡sRgĂ邩ǂĂȂ΂Ȃ
	if(layout.m_pPrev != 0 && (layout.m_pPrev->m_parseStage < CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS))
		ParseMultilineCommentContinue(iLine - 1, *layout.m_pPrev);
	layout.m_multilineAnnotationFromPrev =
		(layout.m_pPrev != 0) ? layout.m_pPrev->m_multilineAnnotationToNext : NullCookie;

	const string_t&	strLine = m_document.GetLine(iLine);

	layout._DeleteTokenList();
	if(strLine.empty()) {
		layout.m_pTokens = &CLineLayout::m_nullTokenList;
		layout.m_multilineAnnotationToNext = layout.m_multilineAnnotationFromPrev;
		layout.m_parseStage = CLineLayout::PARSE_STAGE_TOKENS;
		return;
	}

	Tokens*			pTokens = new Tokens;
	list<CToken>	tokens;
	TokenCookie		nCookie = layout.m_multilineAnnotationFromPrev;
	m_pLexer->Parse(strLine, nCookie, tokens);
	pTokens->count = tokens.size();
	pTokens->array = new CToken[tokens.size()];
	copy(tokens.begin(), tokens.end(), pTokens->array);
	layout.m_pTokens = pTokens;
	layout.m_multilineAnnotationToNext = nCookie;
	layout.m_parseStage = CLineLayout::PARSE_STAGE_TOKENS;
}

/// [̕`ɕKvȕvZ
void CLineLayoutManager::_RecalculateVerticalRulerWidth() {
	int		nNewWidth = 0;	// V
	uint	cMaxDigits;

	if(m_settings.lineNumberLayout.bShowLineNumbers) {
		PREPARE_DC(dc);
		HFONT	hOldFont = dc.SelectObject(m_hRegularFont);
		dc.GetCharWidth(L'8', L'8', &nNewWidth);
		dc.SelectObject(hOldFont);
		cMaxDigits = _GetLineNumberMaxDigit();
		nNewWidth *= (max<uint>(cMaxDigits, m_settings.lineNumberLayout.cMinimumDigits) + 2);	// Œጅmۂ
		if(m_settings.lineNumberLayout.borderStyle != TLineNumberLayout::LNBS_NONE)
			nNewWidth += m_settings.lineNumberLayout.nBorderWidth;
	}
	if(m_settings.lineNumberLayout.bShowIndicatorMargin)
		nNewWidth += m_settings.lineNumberLayout.nIMWidth;
	if(nNewWidth != m_nVerticalRulerWidth) {
		m_nVerticalRulerWidth = nNewWidth;
		FIRE_LAYOUT_EVENT(ChangedVerticalRulerWidth);
	}
}

/// 
void CLineLayoutManager::ReconstructAll() {
	AssertValid();
	DeleteAllLines();
	InsertLines(0, m_document.GetLineCount() - 1);
	_RecalculateVerticalRulerWidth();
}

/// CxgXi̍폜
void CLineLayoutManager::RemoveEventListener(IEventListener& eventListener) {
	AssertValid();
	m_eventListeners.erase(&eventListener);
}

/// ݒԂɖ߂
void CLineLayoutManager::ResetConfigurations() {
	AssertValid();

	m_bLexingEnabled = true;
	for(int type = 0; type < ETT_COUNT; ++type) {
		m_tokenFoundations[type].bEnabled = true;
		if(type != TT_KEYWORD && type != TT_ANNOTATION)
			m_tokenFoundations[type].body.pFoundation->set();
		else {
			for(_CookedTokenMap::iterator it = m_tokenFoundations[type].body.pCookedFoundations->begin();
					it != m_tokenFoundations[type].body.pCookedFoundations->end(); ++it)
				it->second.set();
		}
	}
	SetSettings(TLayoutSettings());
}

/// @see	CBookmarker::SetBookmark
void CLineLayoutManager::SetBookmark(length_t iLine, bool bMark /* = true */) throw(out_of_range) {
	if(CLineLayout* const pLine = GetLineInternal(iLine)) {
		if(pLine->IsBookmarked() != bMark) {
			pLine->SetBookmark(bMark);
			for(set<IEventListener*>::iterator it = m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
				(*it)->OnChangedBookmark(iLine);
		}
	} else
		throw out_of_range("Specified line number is out of range.");
}

/// @see	CLayoutSettings::SetFont
void CLineLayoutManager::SetFont(const LOGFONTW& font) {
	LOGFONTW	lf = font;
	TEXTMETRICW	metric;

	::DeleteObject(m_hRegularFont);
	::DeleteObject(m_hBoldFont);
	::DeleteObject(m_hItalicFont);
	::DeleteObject(m_hBoldItalicFont);

	lf.lfItalic = lf.lfStrikeOut = lf.lfUnderline = false;
	lf.lfWeight = FW_NORMAL;
	m_hRegularFont = ::CreateFontIndirectW(&lf);
	lf.lfWeight = FW_BOLD;
	m_hBoldFont = ::CreateFontIndirectW(&lf);
	lf.lfItalic = true;
	m_hBoldItalicFont = ::CreateFontIndirectW(&lf);
	lf.lfWeight = FW_NORMAL;
	m_hItalicFont = ::CreateFontIndirectW(&lf);

	// tHg̕ۑ
	PREPARE_DC(dc);
	dc.SelectObject(m_hRegularFont);
	dc.GetTextMetrics(metric);
	m_nLineHeight = static_cast<ushort>(metric.tmHeight + 1) + m_settings.nLineSpan;
	m_nCharWidth = static_cast<ushort>(metric.tmAveCharWidth);

	// R[h֕\tHg̍XV
	const TTextFoundation&	foundation = *m_tokenFoundations[TT_UNICODE_CONTROL].body.pFoundation;
	m_bidiFmtSubst._Update(metric.tmHeight, foundation.bold, foundation.italic);

	_RecalculateVerticalRulerWidth();
	Invalidate(CLineLayout::PARSE_STAGE_FULL);
	if(m_nFreezeCount == 0)
		FIRE_LAYOUT_EVENT(ChangedLayout);
}

/// CAEg̐ݒ
void CLineLayoutManager::SetSettings(const TLayoutSettings& settings) {
	const bool	bAlignmentChanged = settings.bRightAlign != m_settings.bRightAlign;
	const bool	bDirectionChanged = settings.bRightToLeftReading != m_settings.bRightToLeftReading;
	if(settings.cchTabWidth != m_settings.cchTabWidth
			|| settings.nCharSpan != m_settings.nCharSpan
			|| settings.bCloseBoldCharacters != m_settings.bCloseBoldCharacters
			|| settings.bPerformBidirection != m_settings.bPerformBidirection
			|| settings.bRightAlign != m_settings.bRightAlign
			|| bDirectionChanged) {
		m_settings = settings;
		Invalidate(CLineLayout::PARSE_STAGE_FULL);
	} else
		m_settings = settings;
	_RecalculateVerticalRulerWidth();
	if(bAlignmentChanged)	FIRE_LAYOUT_EVENT(ChangedTextAlignment);
	if(bDirectionChanged)	FIRE_LAYOUT_EVENT(ChangedTextDirection);
	if(m_nFreezeCount == 0)	FIRE_LAYOUT_EVENT(ChangedLayout);
}

/**
 *	\̐ݒ
 *	@param type				g[N̎
 *	@param nCookie			NbL[l
 *	@param foundation		ݒe
 *	@throw invalid_argument	<var>type</var> A<var>nCookie</var> ̂ꂩȂ΃X[
 */
void CLineLayoutManager::SetTokenFoundation(int type,
		TokenCookie nCookie, const TTextFoundation& foundation) throw(invalid_argument) {
	bool	bNeedRecalc = false;
	if(type < TT_FIRST || type >= ETT_COUNT)
		throw invalid_argument("Invalid token type.");
	else if(type != TT_KEYWORD && type != TT_ANNOTATION) {
		bNeedRecalc =
			m_tokenFoundations[type].body.pFoundation->bold != foundation.bold
			|| m_tokenFoundations[type].body.pFoundation->italic != foundation.italic;
		*m_tokenFoundations[type].body.pFoundation = foundation;
	} else {
		_CookedTokenMap::iterator	it = m_tokenFoundations[type].body.pCookedFoundations->find(nCookie);
		if(it == m_tokenFoundations[type].body.pCookedFoundations->end())
			throw invalid_argument("Invalid cookie value.");
		bNeedRecalc = it->second.bold != foundation.bold || it->second.italic != foundation.italic;
		it->second = foundation;
		if(type == TT_UNICODE_CONTROL) {
			// R[h֕\tHg̍XV
			const TTextFoundation&	foundation = *m_tokenFoundations[TT_UNICODE_CONTROL].body.pFoundation;
			LOGFONTW				font;

			::GetObject(m_bidiFmtSubst.GetFont(), sizeof(LOGFONTW), &font);
			m_bidiFmtSubst._Update(font.lfHeight, foundation.bold, foundation.italic);
		}
	}

	if(m_nFreezeCount == 0) {
		if(bNeedRecalc)
			Invalidate(CLineLayout::PARSE_STAGE_FULL);
		FIRE_LAYOUT_EVENT(ChangedLayout);
	}
}

/// @see	CBookmarker::ToggleBookmark
void CLineLayoutManager::ToggleBookmark(length_t iLine) throw(out_of_range) {
	if(CLineLayout* const pLine = GetLineInternal(iLine)) {
		pLine->SetBookmark(!pLine->IsBookmarked());
		for(set<IEventListener*>::iterator it = m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
			(*it)->OnChangedBookmark(iLine);
	} else
		throw out_of_range("Specified line number is out of range.");
}

/// JEg1炷
void CLineLayoutManager::Unfreeze() {
	AssertValid();
	if(m_nFreezeCount == 0)
		throw logic_error("Layout is not freezed.");
	if(--m_nFreezeCount == 0) {
		Invalidate(CLineLayout::PARSE_STAGE_FULL);
		FIRE_LAYOUT_EVENT(ChangedLayout);
	}
}

///	ő\sT
void CLineLayoutManager::UpdateMaxDisplayWidth() {
	AssertValid();

	m_nMaxDisplayWidth = 0;
	for(CLineLayout* pLine = m_pHead; pLine != 0; pLine = pLine->m_pNext) {
		if(pLine->m_nWidth > m_nMaxDisplayWidth) {
			m_nMaxDisplayWidth = pLine->m_nWidth;
			m_pMaxDisplayWidthLine = pLine;
		}
	}
}


// CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver::CBidirectionalFormatterSubstitutionDriver() : m_hFont(0), m_pfnGetGlyphIndicesW(0) {
	if(m_hGdi32Dll = ::LoadLibraryA("GDI32.DLL")) {
		m_pfnGetGlyphIndicesW = reinterpret_cast<DWORD(WINAPI*)(
			HDC, const WCHAR*, int, LPWORD, DWORD)>(::GetProcAddress(m_hGdi32Dll, "GetGlyphIndicesW"));
		if(m_pfnGetGlyphIndicesW == 0) {
			::FreeLibrary(m_hGdi32Dll);
			m_hGdi32Dll = 0;
		}
	}
}

/// fXgN^
CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver::~CBidirectionalFormatterSubstitutionDriver() {
	::DeleteObject(m_hFont);
	::FreeLibrary(m_hGdi32Dll);
}

/// VɊÂătHg쐬
void CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver::_Update(int nNewHeight, bool bBold, bool bItalic) {
	::DeleteObject(m_hFont);
	m_hFont = ::CreateFontW(nNewHeight, 0, 0, 0,
		bBold ? FW_BOLD : FW_REGULAR, bItalic, false, false,
		DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_CHARACTER_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, L"Arial");
	fill(m_glyphCache, _endof(m_glyphCache), 0xFFFF);
}


// CLineLayoutManager::_CBidrectionalLayoutCalculator class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	ɕ
 *	@param dc					`foCXReLXg
 *	@param pwsz					
 *	@param cch					
 *	@param bRightToLeftReading	E獶ɓǂޏꍇ true
 *	@param runOrders			[out] ̓oꏇ
 *	@return						̔z
 */
CLineLayout::CRuns* CLineLayoutManager::_CBidirectionalLayoutCalculator::Calculate(
		CDC& dc, const char_t* pwsz, length_t cch, bool bRightToLeftReading, ulong*& runOrders) {
	assert(pwsz != 0);

#define _IS_GCPCLASS_RTL(c)	toBoolean(c == GCPCLASS_ARABIC || c == GCPCLASS_HEBREW)	// ۂ͓lȂ񂾂
#define _SET_RTL(n)			(n) |= 0x80000000
#define _IS_RTL(n)			toBoolean((n) & 0x80000000)
#define _GET_INDEX(n)		(n & 0x7FFFFFFF)

	list<length_t>			delimiters;	// e̐擪̈ʒu (ŏʃrbg͕: true  RTL)

	// NT 4.0 ȑO (Ƃ͌Ȃ) ͂ŏI
	if(!IsRtlSupported()) {
		CLineLayout::CRun**	ppRuns = new CLineLayout::CRun*[1];
		ppRuns[0] = new CLineLayout::CRun(0, false);
		runOrders = new ulong[1];
		runOrders[0] = 0;
		return new CLineLayout::CRuns(1, ppRuns);
	}

	GCP_RESULTSW	gcpr;

	memset(&gcpr, 0, sizeof(GCP_RESULTSW));
	gcpr.lStructSize = sizeof(GCP_RESULTSW);
	gcpr.lpClass = new char[cch + 1];
	gcpr.lpOrder = new uint[cch + 1];
	gcpr.nGlyphs = cch;

	// ̏oƕ () 𓾂
	if(bRightToLeftReading)	(*m_pfnSetLayout)(dc.GetSafeHdc(), true);
	dc.GetCharacterPlacement(pwsz, cch, 0, gcpr, GCP_DIACRITIC | GCP_DISPLAYZWG | GCP_GLYPHSHAPE | GCP_REORDER);
	if(bRightToLeftReading)	(*m_pfnSetLayout)(dc.GetSafeHdc(), false);

	// \AĂȂʒuŕ = ̐
	delimiters.push_back(0);
	for(length_t i = 1; i < cch; ++i) {
		if(gcpr.lpOrder[i] - gcpr.lpOrder[i - 1] != 1
				&& gcpr.lpOrder[i - 1] - gcpr.lpOrder[i] != 1
				&& gcpr.lpOrder[i] != gcpr.lpOrder[i - 1])
			delimiters.push_back(i);
	}

	// e̕߂
	for(list<length_t>::iterator it = delimiters.begin(); it != delimiters.end(); ++it) {
		const length_t	iNextRun = (++it != delimiters.end()) ? *it : cch;

		--it;
		if(gcpr.lpOrder[*it] == gcpr.lpOrder[iNextRun - 1]) {	// x[X1̏ꍇ GCP_RESULTSW::lpClass g
			if(_IS_GCPCLASS_RTL(gcpr.lpClass[*it]))
				_SET_RTL(*it);
		} else if(gcpr.lpOrder[iNextRun - 1] - gcpr.lpOrder[*it] == 1) {	// x[X2̏ꍇ
			// "LEE..REE.." ̏ꍇ "REE..LEE.." ̏ꍇ 00..11.. ƂȂĂ̂
			// ̃͂2ɕȂ΂ȂȂȂ

			if(_IS_GCPCLASS_RTL(gcpr.lpClass[*it]))
				_SET_RTL(*it);

			length_t	i = _GET_INDEX(*it) + 1;
			for(; i < iNextRun; ++i) {
				if(gcpr.lpOrder[i] != gcpr.lpOrder[i - 1])
					break;
			}
			assert(i != iNextRun);
			if(_IS_GCPCLASS_RTL(gcpr.lpClass[_GET_INDEX(*it)]) != _IS_GCPCLASS_RTL(gcpr.lpClass[i])) {
				// "LEE..REE.."  "REE..LEE" Ȃ̂2
				it = delimiters.insert(++it, i);
				if(_IS_GCPCLASS_RTL(gcpr.lpClass[i]))
					_SET_RTL(*it);
			}
		} else if(gcpr.lpOrder[_GET_INDEX(*it)] > gcpr.lpOrder[iNextRun - 1])	// P RTL
			_SET_RTL(*it);
	}

	// ʂ𐶐
	CLineLayout::CRun**	ppRuns = new CLineLayout::CRun*[delimiters.size()];
	size_t				iRun = 0;
	for(list<length_t>::const_iterator it = delimiters.begin(); it != delimiters.end(); ++it, ++iRun)
		ppRuns[iRun] = new CLineLayout::CRun(_GET_INDEX(*it), _IS_RTL(*it));
	CLineLayout::CRuns*	pResult = new CLineLayout::CRuns(delimiters.size(), ppRuns);

	// e̓oꏇ𐶐
	if(pResult->GetCount() != 1) {
		pair<uint, ulong>*	array = new pair<uint, ulong>[pResult->GetCount()];
		for(size_t i = 0; i < pResult->GetCount(); ++i) {
			array[i].first = gcpr.lpOrder[pResult->GetAt(i).GetIndex()];
			array[i].second = i;
		}
		sort(array, array + pResult->GetCount(), _OrderComparer());
		runOrders = new ulong[pResult->GetCount()];
		for(size_t i = 0; i < pResult->GetCount(); ++i)
			runOrders[i] = array[i].second;
		delete[] array;
	} else {
		runOrders = new ulong[1];
		runOrders[0] = 0;
	}

	delete[] gcpr.lpClass;
	delete[] gcpr.lpOrder;
	return pResult;

#undef _IS_GCPCLASS_RTL
#undef _SET_RTL
#undef _IS_RTL
#undef _GET_INDEX
}

#undef GET_DC

/* [EOF] */