// Layout.h
// (c) 2005 exeal

#ifndef _LAYOUT_H_
#define _LAYOUT_H_

#include "AscensionCommon.h"
#include <map>

namespace Ascension {

	class CFont {
	};

	class CFontset {
		// \bh
	public:
		void	Add(UnicodeBlock block, CFont& font) {
			const std::map<UnicodeBlock, CFont*>::iterator	it = m_fonts.find(block);
			if(it != m_fonts.end())
				delete it->second;
		}
		CFont*	Get(UnicodeBlock block) const {
			const std::map<UnicodeBlock, CFont*>::iterator	it = m_fonts.find(block);
			return (it != m_fonts.end()) ? it->second : m_fonts[UB_BASIC_LATIN];
		}
		void	Reset() {
			for(std::map<UnicodeBlock, CFont*>::iterator it = m_fonts.begin(); it != m_fonts.end(); ++it)
				delete it->second;
			m_fonts.clear();
		}

		// f[^o
	private:
		std::map<UnicodeBlock, CFont*>	m_fonts;
	};

	class CLayoutManager {
		// \bh
	public:
		int		GetCaretPosition(length_t iLine, length_t iChar) const;
		void	SetFontset(const CFontset& fontset);

		// f[^o
	private:
		CFontset*	m_pFontset;
	};

} // namespace Ascension

#endif /* !_LAYOUT_H_ */

/* [EOF] */