// Uncategorized.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


BEGIN_ENCODER_DEFINITION()
	DEFINE_ENCODER_CLASS(CPEX_UNCATEGORIZED_BINARY, Uncategorized_Binary, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_UNCATEGORIZED_NEXTSTEP, Uncategorized_Nextstep, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_UNCATEGORIZED_ATARIST, Uncategorized_Atarist, 1, 1)
END_ENCODER_DEFINITION()

// ȉ̕ϊe[u Atari ST/TT Character Encoding (http://www.kostis.net/charsets/atarist.htm)
// y Unicode.org ̃t@C (http://www.unicode.org/Public/MAPPINGS/VENDORS/MISC/ATARIST.TXT) ɂ
namespace {
	const wchar_t	ATARISTtoUCS_80[] = {
		/* 0x80 */	0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x00E0, 0x00E5, 0x00E7,
					0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x00EC, 0x00C4, 0x00C5,
		/* 0x90 */	0x00C9, 0x00E6, 0x00C6, 0x00F4, 0x00F6, 0x00F2, 0x00FB, 0x00F9,
					0x00FF, 0x00D6, 0x00DC, 0x00A2, 0x00A3, 0x00A5, 0x00DF, 0x0192,
		/* 0xA0 */	0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA,
					0x00BF, 0x2310, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00BB,
		/* 0xB0 */	0x00E3, 0x00F5, 0x00D8, 0x00F8, 0x0153, 0x0152, 0x00C0, 0x00C3,
					0x00D5, 0x00A8, 0x00B4, 0x2020, 0x00B6, 0x00A9, 0x00AE, 0x2122,
		/* 0xC0 */	0x0133, 0x0132, 0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5,
					0x05D6, 0x05D7, 0x05D8, 0x05D9, 0x05DB, 0x05DC, 0x05DE, 0x05E0,
		/* 0xD0 */	0x05E1, 0x05E2, 0x05E4, 0x05E6, 0x05E7, 0x05E8, 0x05E9, 0x05EA,
					0x05DF, 0x05DA, 0x05DD, 0x05E3, 0x05E5, 0x00A7, 0x2227, 0x221E,
		/* 0xE0 */	0x03B1, 0x03B2, 0x0393, 0x03C0, 0x03A3, 0x03C3, 0x00B5, 0x03C4,
					0x03A6, 0x0398, 0x03A9, 0x03B4, 0x222E, 0x03C6, 0x2208, 0x2229,
		/* 0xF0 */	0x2261, 0x00B1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00F7, 0x2248,
					0x00B0, 0x2219, 0x00B7, 0x221A, 0x207F, 0x00B2, 0x00B3, 0x00AF
	};
	const uchar	UCStoATARIST_00A0[] = {
		/* U+00A0 */	__NA, 0xAD, 0x9B, 0x9C, __NA, 0x9D, __NA, 0xDD,
						0xB9, 0xBD, 0xA6, 0xAE, 0xAA, __NA, 0xBE, 0xFF,
		/* U+00B0 */	0xF8, 0xF1, 0xFD, 0xFE, 0xBA, 0xE6, 0xBC, 0xFA,
						__NA, __NA, 0xA7, 0xAF, 0xAC, 0xAB, __NA, 0xA8,
		/* U+00C0 */	0xB6, __NA, __NA, 0xB7, 0x8E, 0x8F, 0x92, 0x80,
						__NA, 0x90, __NA, __NA, __NA, __NA, __NA, __NA,
		/* U+00D0 */	__NA, 0xA5, __NA, __NA, __NA, 0xB8, 0x99, __NA,
						0xB2, __NA, __NA, __NA, 0x9A, __NA, __NA, 0x9E,
		/* U+00E0 */	0x85, 0xA0, 0x83, 0xB0, 0x84, 0x86, 0x91, 0x87,
						0x8A, 0x82, 0x88, 0x89, 0x8D, 0xA1, 0x8C, 0x8B,
		/* U+00F0 */	__NA, 0xA4, 0x95, 0xA2, 0x93, 0xB1, 0x94, 0xF6,
						0xB3, 0x97, 0xA3, 0x96, 0x81, __NA, __NA, 0x98
	};
	const uchar	UCStoATARIST_0132[] = {
		/* U+0130 */				0xC1, 0xC0
	};
	const uchar	UCStoATARIST_0152[] = {
		/* U+0150 */				0xB5, 0xB4
	};
	const uchar	UCStoATARIST_0192[] = {
		/* U+0190 */				0x9F
	};
	const uchar	UCStoATARIST_0393[] = {
		/* U+0390 */					  0xE2, __NA, __NA, __NA, __NA,
						0xE9, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		/* U+03A0 */	__NA, __NA, __NA, 0xE4, __NA, __NA, 0xE8, __NA,
						__NA, 0xEA, __NA, __NA, __NA, __NA, __NA, __NA,
		/* U+03B0 */	__NA, 0xE0, 0xE1, __NA, 0xEB, __NA, __NA, __NA,
						__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		/* U+03C0 */	0xE3, __NA, __NA, 0xE5, 0xE7, __NA, 0xED
	};
	const uchar	UCStoATARIST_05D0[] = {
		/* U+05D0 */	0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9,
						0xCA, 0xCB, 0xD9, 0xCC, 0xCD, 0xDA, 0xCE, 0xD8,
		/* U+05E0 */	0xCF, 0xD0, 0xD1, 0xDB, 0xD2, 0xDC, 0xD3, 0xD4,
						0xD5, 0xD6, 0xD7
	};
	const uchar	UCStoATARIST_2020[] = {
		/* U+2020 */	0xBB
	};
	const uchar	UCStoATARIST_207F[] = {
		/* U+2078 */											  0xFC
	};
	const uchar	UCStoATARIST_2122[] = {
		/* U+2120 */				0xBF
	};
	const uchar	UCStoATARIST_2208[] = {
						0xEE, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		/* U+2210 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
						__NA, __NA, 0xF9, 0xFB, __NA, __NA, 0xDF, __NA,
		/* U+2220 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xDE,
						__NA, 0xEF, __NA, __NA, __NA, __NA, 0xEC
	};
	const uchar	UCStoATARIST_2248[] = {
						0xF7
	};
	const uchar	UCStoATARIST_2261[] = {
		/* U+2260 */		  0xF0, __NA, __NA, 0xF3, 0xF2
	};
	const uchar	UCStoATARIST_2310[] = {
		/* U+2310 */	0xA9, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
						__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		/* U+2120 */	0xF4, 0xF5
	};
}


// oCi /////////////////////////////////////////////////////////////////

size_t CEncoder_Uncategorized_Binary::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pwszSrc[i] > 0x00FF)
			CONFIRM_ILLEGAL_CHAR(pszDest[i]);
		pszDest[i] = static_cast<uchar>(pwszSrc[i]);
	}

	return cch;
}

size_t CEncoder_Uncategorized_Binary::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i)
		pwszDest[i] = pszSrc[i];
	return cch;
}


// NEXTSTEP /////////////////////////////////////////////////////////////////

size_t CEncoder_Uncategorized_Nextstep::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	return 0;
}

size_t CEncoder_Uncategorized_Nextstep::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	return 0;
}


// Atari ST/TT //////////////////////////////////////////////////////////////

size_t CEncoder_Uncategorized_Atarist::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t	cchMin = min(cchSrc, cchDest);
	for(size_t i = 0; i < cchMin; ++i) {
		if(pwszSrc[i] < 0x80)
			pszDest[i] = static_cast<uchar>(pwszSrc[i]);
		else {
			if(pwszSrc[i] >= 0x00A0 && pwszSrc[i] <= 0x00A0 + _countof(UCStoATARIST_00A0))
				pszDest[i] = UCStoATARIST_00A0[pwszSrc[i] - 0x00A0];
			else if(pwszSrc[i] >= 0x0132 && pwszSrc[i] <= 0x0132 + _countof(UCStoATARIST_0132))
				pszDest[i] = UCStoATARIST_0132[pwszSrc[i] - 0x0132];
			else if(pwszSrc[i] >= 0x0152 && pwszSrc[i] <= 0x0152 + _countof(UCStoATARIST_0152))
				pszDest[i] = UCStoATARIST_0152[pwszSrc[i] - 0x0152];
			else if(pwszSrc[i] >= 0x0192 && pwszSrc[i] <= 0x0192 + _countof(UCStoATARIST_0192))
				pszDest[i] = UCStoATARIST_0192[pwszSrc[i] - 0x0192];
			else if(pwszSrc[i] >= 0x0393 && pwszSrc[i] <= 0x0393 + _countof(UCStoATARIST_0393))
				pszDest[i] = UCStoATARIST_0393[pwszSrc[i] - 0x0393];
			else if(pwszSrc[i] >= 0x05D0 && pwszSrc[i] <= 0x05D0 + _countof(UCStoATARIST_05D0))
				pszDest[i] = UCStoATARIST_05D0[pwszSrc[i] - 0x05D0];
			else if(pwszSrc[i] >= 0x2020 && pwszSrc[i] <= 0x2020 + _countof(UCStoATARIST_2020))
				pszDest[i] = UCStoATARIST_2020[pwszSrc[i] - 0x2020];
			else if(pwszSrc[i] >= 0x207F && pwszSrc[i] <= 0x207F + _countof(UCStoATARIST_207F))
				pszDest[i] = UCStoATARIST_207F[pwszSrc[i] - 0x207F];
			else if(pwszSrc[i] >= 0x2122 && pwszSrc[i] <= 0x2122 + _countof(UCStoATARIST_2122))
				pszDest[i] = UCStoATARIST_2122[pwszSrc[i] - 0x2122];
			else if(pwszSrc[i] >= 0x2208 && pwszSrc[i] <= 0x2208 + _countof(UCStoATARIST_2208))
				pszDest[i] = UCStoATARIST_2208[pwszSrc[i] - 0x2208];
			else if(pwszSrc[i] >= 0x2248 && pwszSrc[i] <= 0x2248 + _countof(UCStoATARIST_2248))
				pszDest[i] = UCStoATARIST_2248[pwszSrc[i] - 0x2248];
			else if(pwszSrc[i] >= 0x2261 && pwszSrc[i] <= 0x2261 + _countof(UCStoATARIST_2261))
				pszDest[i] = UCStoATARIST_2261[pwszSrc[i] - 0x2261];
			else if(pwszSrc[i] >= 0x2310 && pwszSrc[i] <= 0x2310 + _countof(UCStoATARIST_2310))
				pszDest[i] = UCStoATARIST_2310[pwszSrc[i] - 0x2310];
			else
				pszDest[i] = __NA;
			if(pszDest[i] == __NA)
				CONFIRM_ILLEGAL_CHAR(pszDest[i]);
		}
	}
	return cchMin;
}

size_t CEncoder_Uncategorized_Atarist::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t	cchMin = min(cchSrc, cchDest);
	for(size_t i = 0; i < cchMin; ++i)
		pwszDest[i] = (pszSrc[i] < 0x80) ? pszSrc[i] : ATARISTtoUCS_80[pszSrc[i]];
	return cchMin;
}

/* [EOF] */