// Irish.cpp
// (c) 2005 exeal

#include "StdAfx.h"
#include "Encoder.h"

/**
 *	@file	Irish.cpp
 *
 *	ACh̃GR[fBOł I.S. 434:1999 ̎B
 *	ڍׂ http://www.evertype.com/standards/iso10646/pdf/is434.pdf Q
 *
 *	̎ł̓lCeBu 0xFD-FF  UCS  U+169D-169F Ƀ}bvB
 *	܂㕶 Annex 6 ɎĂI[K}bv
 */

using namespace Ascension::Encodings;
using namespace std;


BEGIN_ENCODER_DEFINITION()
	DEFINE_ENCODER_CLASS(CPEX_IRISH_IS434, Irish_Is434, 1, 1)
END_ENCODER_DEFINITION()


// ACh (I.S. 434:1999) ///////////////////////////////////////////

size_t CEncoder_Irish_Is434::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pwszSrc[i] >= 0x1680 && pwszSrc[i] < 0x16A0)
			pszDest[i] = static_cast<uchar>(pwszSrc[i] - 0x15A0);
		else if(pwszSrc[i] < 0xA0)
			pszDest[i] = static_cast<uchar>(pwszSrc[i]);
		else {
			switch(pwszSrc[i]) {
			case 0x00A0:	case 0x00A3:	case 0x00A7:	case 0x00A9:	case 0x00AE:
			case 0x00B0:	case 0x00B1:	case 0x00B6:	case 0x00B7:
				pszDest[i] = static_cast<uchar>(pwszSrc[i]);
				break;
			default:
				CONFIRM_ILLEGAL_CHAR(pszDest[i]);
			}
		}
	}
	return cch;
}

size_t CEncoder_Irish_Is434::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pszSrc[i] >= 0xE0)
			pwszDest[i] = pszSrc[i] + 0x15A0;
		else if(pszSrc[i] < 0xA0)
			pwszDest[i] = pszSrc[i];
		else {
			switch(pszSrc[i]) {
			case 0xA0:	case 0xA3:	case 0xA7:	case 0xA9:	case 0xAE:
			case 0xB0:	case 0xB1:	case 0xB6:	case 0xB7:
				pwszDest[i] = pszSrc[i];
				break;
			default:
				CONFIRM_ILLEGAL_CHAR(pwszDest[i]);
			}
		}
	}
	return cch;
}

/* [EOF] */