// Encoder.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"
#include <algorithm>

using namespace Ascension::Encodings;
using namespace std;


DEFINE_DETECTOR(CPEX_AUTODETECT_SYSTEMLANG, SystemLang);
DEFINE_DETECTOR(CPEX_AUTODETECT_USERLANG, UserLang);


namespace {
	set<CodePage>*	_pWorking;

	BOOL CALLBACK _EnumCodePages(LPWSTR lpstrCp) {
		const CodePage	cp = wcstoul(lpstrCp, 0, 10);
		if(toBoolean(::IsValidCodePage(cp)))
			_pWorking->insert(cp);
		return TRUE;
	}

	void DetectCodePage_SystemLang(const uchar*, size_t, CodePage&, size_t&) {
		assert(false);
	}
	void DetectCodePage_UserLang(const uchar*, size_t, CodePage&, size_t&) {
		assert(false);
	}
} // namespace `anonymous'


/**
 *	GR[_쐬BR[hy[WȂƂ null Ԃ
 *	@param cp	R[hy[W
 *	@return		GR[_
 */
CEncoder* CEncoderFactory::CreateEncoder(CodePage cp) {
	EncoderMap::iterator	it = m_registeredEncoders.find(cp);
	if(it != m_registeredEncoders.end())
		return it->second();
	else {
		try {
			return new CWindowsEncoder(cp);
		} catch(invalid_argument&) {
			return 0;
		}
	}
}

/**
 *	
 *	@param psz	
 *	@param cch	ׂoCg
 *	@param cp	ʂɎgp錾
 */
CodePage CEncoderFactory::DetectCodePage(const uchar* psz, size_t cch, CodePage cp) {
	assert(psz != 0);

	if(!IsCodePageForAutoDetection(cp))
		return cp;

	CodePage	cpDetected;
	size_t		nScore;

	if(cp == CPEX_AUTODETECT_SYSTEMLANG || cp == CPEX_AUTODETECT_USERLANG) {
		const LANGID	langId = (cp == CPEX_AUTODETECT_SYSTEMLANG) ? ::GetSystemDefaultLangID() : ::GetUserDefaultLangID();
		switch(PRIMARYLANGID(langId)) {
		case LANG_ARMENIAN:	cp = CPEX_ARMENIAN_AUTODETECT;	break;
		case LANG_JAPANESE:	cp = CPEX_JAPANESE_AUTODETECT;	break;
//		case LANG_KOREAN:	cp = CPEX_KOREAN_AUTODETECT;	break;
		default:			cp = 20127;	// US-ASCII
		}
	}

	DetectorMap::iterator	it = m_registeredDetectors.find(cp);

	assert(it != m_registeredDetectors.end());
	it->second(psz, cch, cpDetected, nScore);
	return (nScore != 0) ? cpDetected : ::GetACP();
}

/// p\ȃR[hy[W
void CEncoderFactory::EnumCodePages(set<CodePage>& codePages) const {
	codePages.clear();
	for(EncoderMap::const_iterator it = m_registeredEncoders.begin(); it != m_registeredEncoders.end(); ++it)
		codePages.insert(it->first);
	for(DetectorMap::const_iterator it = m_registeredDetectors.begin(); it != m_registeredDetectors.end(); ++it)
		codePages.insert(it->first);
	_pWorking = &codePages;
	::EnumSystemCodePagesW(_EnumCodePages, CP_INSTALLED);
}

/* [EOF] */