// EditView.h
// (c) 2003-2005 exeal

#ifndef _EDIT_VIEW_H_
#define _EDIT_VIEW_H_

#include "EditDoc.h"
#include "../../Manah/DC.h"	// Manah::Windows::GDI::CDC
#include "../../Armaiti/TextDataObject.h"
#include "EditPoint.h"
#include "LineLayout.h"
#include "TextSearcher.h"
#include "CompletionWindow.h"
#include <set>
#include <algorithm>
#include <bitset>

#ifndef ASCENSION_NO_TSF
#include <Textstor.h>
#endif /* !ASCENSION_NO_TSF*/


#define SB_SETPOS	20	// XN[ʒuύX邽߂ OnHScroll AOnVScroll ĂяoƂɎgR[h

// Ɏg}N (ĂԂ)
#define _BEGIN_OPERATION_SEQUENCE()			\
	GetDocument().BeginEditCollection();	\
	Freeze()
#define _END_OPERATION_SEQUENCE()			\
	GetDocument().EndEditCollection();		\
	Unfreeze()
#define _FOR_EACH_LISTENERS()						\
	for(set<IEditViewEventListener*>::iterator it =	\
		m_pSharedData->eventListeners.begin(); it != m_pSharedData->eventListeners.end(); ++it)
#define _FOR_EACH_CONST_LISTENERS()							\
	for(set<IEditViewEventListener*>::const_iterator it =	\
		m_pSharedData->eventListeners.begin(); it != m_pSharedData->eventListeners.end(); ++it)
#define _FOR_EACH_CLONES()	\
	for(_CCloneIterator it(*this); !it.IsEnd(); it.Next())


namespace Ascension {

class CEditView;
class CEditController;
class CLineLayoutInfo;
class CLineLayoutManager;
class CEditPoint;
class CVisibleEditPoint;
class CKeywordManager;


// Miscellaneous
/////////////////////////////////////////////////////////////////////////////

/// 2lIvV
namespace BooleanOptions {
	/// \̃IvV
	/// @see	CEditView::TOptions::appearance
	enum {
		BEEP_ON_SOME_FAILURE,			///< ̑ɎsƂɉ炷
		HIDE_CURSOR_FOR_CHAR_INPUT,		///< ͂n߂J[\\ɂ
		HIGHLIGHT_MATCH_TEXT,			///< Ƀ}b`eLXg\
		LOCALE_SPECIFIC_CARET_SHAPE,	///< ̓P[ɏ]Lbǧ`ς
		SHOW_BREAK_ARROWS,				///< s̖\
		SHOW_CURRENT_UNDERLINE,			///< ݍsɉ\
		SHOW_END_OF_FILE,				///< [EOF] }[N\
		SHOW_HAND_ON_LINK,				///< NeLXgŃnhJ[\\
		SHOW_HINT_ON_LINK,				///< NeLXgŃ|bvAbv\
		SHOW_SELECTION_ON_BREAK,		///< IɑĂs̔wih邩ǂ
		SHOW_UNICODE_CONTROLS,			///< Unicode 䕶\
		SHOW_WHITESPACE_ALTERNATIVE,	///< 󔒗ޕ̑֕\
		THIN_CARET,						///< 1sNZ̃Lbgg (ʏ2sNZ)
		USE_EDITOR_FONT_FOR_COMPLETION,	///< ⊮EBhẼtHgGfB^Ɠɂ
										///< (NAĂ΃VXe UI tHg)
		DISPLAY_BOOLEAN_OPTIONS_COUNT
	};

	/// ̃IvV
	/// @see	CEditView::TOptions::behavior
	enum {
		ACCEPT_CARET_ON_EXTENDER_BY_MOUSE,	///< Lbg󂯎Ȃ̑OɃ}EXňړł
		ACCEPT_CONTROL_CHAR_INPUT,			///< 䕶̓͂F߂
		MOVE_CARET_BY_RIGHT_CLICK,			///< ENbNŃLbgړ
		OLE_DRAG_AND_DROP,					///< OLE hbOAhhbvg
		BEHAVIOR_BOOLEAN_OPTIONS_COUNT
	};
}

/// ̓V[PX`FbN
typedef ushort	InputSequenceCheckLanguage;
const InputSequenceCheckLanguage
	ISCL_AINU		= 1,				///< ACk
	ISCL_HINDI		= ISCL_AINU << 1,	///< qfB[
	ISCL_KHMER		= ISCL_HINDI << 1,	///< N[
	ISCL_LAO		= ISCL_KHMER << 1,	///< I
	ISCL_TAMIL		= ISCL_LAO << 1,	///< ^~
	ISCL_THAI		= ISCL_TAMIL << 1,	///< ^C
	ISCL_VIETNAMESE	= ISCL_THAI << 1,	///< xgi
	ISCL_ALL		= 0xFFFF;			///< SĂ̌

/// Cfg̎
enum AutoIndentType {
	AIT_NONE,	///< Ȃ
	AIT_BLOCK,	///< O̍sɈv
	AIT_SMART	///< `̃X}[gCfg
};

/// GfB^EBhẼqbgeXg
enum HitTestResult {
	HTR_INDICATORMARGIN,	///< CWP[^}[W
	HTR_LINENUMBERS,		///< sԍ
	HTR_LEADMARGIN,			///< s]
	HTR_TOPMARGIN,			///< ]
	HTR_TEXT,				///< eLXg\`
	HTR_OUTOFVIEW			///< NCAg̈O
};

/// ɓ͂镶̕ϊ
enum NextCharVariation {
	NCV_NONE,			///< ϊ
	NCV_GRAVE,			///< ANZg
	NCV_ACUTE,			///< sANZg
	NCV_CIRCUMFLEX,		///< Ȑ܃ANZg
	NCV_TILDE,			///< @
	NCV_MACRON,			///< 
	NCV_BREVE,			///< Z
	NCV_DIAERESIS,		///< EEg
	NCV_CARON,			///< L
	NCV_CEDILLA,		///< ZfB[
	NCV_SUPERSCRIPT,	///< t
	NCV_SUBSCRIPT		///< t
};

/// CmdEditConvertSel ̕ϊ[h
enum SelConvertType {
	SCT_UPPERCASE,	///< 啶
	SCT_LOWERCASE,	///< 啶珬
	SCT_CAPITALIZE,	///< Ls^CY (P̐擪啶)
};

/// ҏWP
struct TEditOperation {
	/// ҏW̎
	enum Type {
		NONE,		///< 
		TYPING,		///< ^CsO
		DELETION,	///< 폜
		REPLACE,	///< ㏑
		PASTE		///< \t
	} type;	// ̎
	CCharPos	pos;	// sʃLbgړʒu

	void set(Type type_, const CCharPos& pos_) {
		type = type_;
		pos = pos_;
	}
};



/// CEditView::GetAllLineParams Ŏgp
struct TAppDefinedLine {
	length_t	iLine;		///< _s
	DWORD		dwParam;	///< AvP[V`l
};


/// CEditView CX^X̃Cxgnh
interface IEditViewEventListener {
	/// sCxg
	/// @see	IEditViewEventListener::OnLineOperationEvent
	enum LineOperationEvent {
		LOE_CREATED,	///< s쐬ꂽ
		LOE_DELETED,	///< s폜ꂽ
		LOE_MODIFIED	///< sύXꂽ
	};
	///	fXgN^
	virtual ~IEditViewEventListener() {}
	/**
	 *	LbgO̒PꂪZkƂēWJ\ȏԂɂȂ
	 *	@param bReady		WJ\ȏԂɂȂƂ trueBWJ\ȏԂ甲Ƃ false
	 *	@param strAbbrev	ZkB<var>bReady</var>  false ̂Ƃ͋󕶎
	 *	@see				CEditView::GetPrecedingWord ACEditView::ExpandAbbreviation
	 */
	virtual void OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) = 0;
	/// }/㏑[hύXꂽ
	virtual void OnChangedOvertypeMode() = 0;
	/// ҏWs\[ĥ CEditorCommand::Execute ۂꂽ
	virtual void OnDeniedGuiCommand() = 0;
	/**
	 *	URI NƂɌĂяo
	 *	@param strUri	URI
	 */
	virtual void OnInvokeUriLink(const char_t* pwszUri) = 0;
	/**
	 *	s쐬A폜AύXꂽ
	 *	@param event	Cxg̎
	 *	@param iLine	擪s (_s)
	 *	@param cLines	Ώۍs
	 */
	virtual void OnLineOperationEvent(LineOperationEvent event, length_t iLine, length_t cLines) = 0;
	/**
	 *	t@CǂݍŁÃx̍s͂sOɌĂяoB
	 *	IuWFNg͂̃\bhĂяoAǂݍ񂾃t@C݂Ƃďi߂̂ŁA
	 *	̃nhŊJꂽt@CÃt@CJ肵Ă͂ȂB
	 *	͑OɎ͊ɋKACAEg}l[Wɋ\^̂Ɏgp
	 */
	virtual void OnLoadFile() = 0;
	/**
	 *	Ίʂr[̊OŌ
	 *	@param pos	Ίʂ̈ʒuBȂꍇLbgʂ痣ꂽꍇ CCharPos(-1, -1)
	 */
	virtual void OnMatchBracketFoundOutOfView(const CCharPos& pos) = 0;
	/**
	 *	Lbgړ (`擀͌ĂяoȂBɌĂяo)
	 *	@param pos	ړ̃Lbgʒu
	 */
	virtual void OnMoveCaret(const CCharPos& pos) = 0;
	/**
	 *	}EXJ[\ړ
	 *	@param pt	NCAgW
	 */
	virtual void OnMoveCursor(const POINT& pt) = 0;
};


/// IEditViewEventListener ̋
class CEditViewEventAdapter : virtual public IEditViewEventListener {
public:
	virtual ~CEditViewEventAdapter() {}
	virtual void OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) {}
	virtual void OnChangedOvertypeMode() {}
	virtual void OnDeniedGuiCommand() {}
	virtual void OnInvokeUriLink(const char_t* pwszUri) {}
	virtual void OnLineOperationEvent(IEditViewEventListener::LineOperationEvent event, length_t iLine, length_t cLines) {}
	virtual void OnLoadFile() {}
	virtual void OnMatchBracketFoundOutOfView(length_t iLine, const char_t* pwsz) {}
	virtual void OnMoveCaret(const CCharPos& pos) {}
	virtual void OnMoveCursor(const POINT& pt) {}
};


/// Nbv{[hO
class CClipboardRing : public Manah::CSelfAssertable {
	// ^`
public:
	typedef uchar	SizeType;
	/// Nbv{[hÕCxgXi
	interface IEventListener {
		///	fXgN^
		virtual ~IEventListener() {}
		///	Oω
		virtual void OnClipboardRingChanged() = 0;
		///	Oɒǉ悤ƂeLXg傫ߋۂꂽ
		virtual void OnClipboardRingDeniedAdding() = 0;
	};

	// RXgN^
public:
	CClipboardRing();

	// \bh
public:
	void		Add(const string_t& strText, bool bBox);
	void		AddEventListener(IEventListener& eventListener);
	void		Delete(SizeType iText) throw(std::out_of_range);
	void		DeleteAll();
	SizeType	GetActiveItem() const;
	SizeType	GetCount() const;
	void		GetText(SizeType iText, string_t& strText, bool& bBox) const throw(std::out_of_range);
	void		LimitCount(SizeType nLimit);
	void		RemoveEventListener(IEventListener& eventListener) throw(std::invalid_argument);
	void		SetActiveItem(SizeType iText) throw(std::out_of_range);

	// f[^o
private:
	struct TClipText {
		string_t	strText;	// eLXg
		bool		bBox;		// `f[^
	};
	std::list<TClipText>		m_datas;
	SizeType					m_nLimit;
	ulong						m_nMaxByte;
	SizeType					m_iActive;
	std::set<IEventListener*>	m_eventListeners;
};


/// XN[̊Jn_ɕ\ۂEBhE
class CAutoScrollOriginMark :
		public Manah::Windows::Controls::CLayered<Manah::Windows::Controls::CCustomControl<CAutoScrollOriginMark> > {
	DEFINE_WINDOW_CLASS() {
		lpszName = L"AutoScrollOriginMark";
		nStyle = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW;
		bgColor = COLOR_WINDOW;
		cursor = IDC_IBEAM;
	}

	// \bh
public:
	bool	Create(const CEditView& view);

	// bZ[Wnh
protected:
	void	OnPaint(Manah::Windows::GDI::CPaintDC& dc);

	// f[^o
private:
	static const long	m_nWidth;
};

/// Zk̊Ǘ
class CAbbreviations {
	// RXgN^
private:
	CAbbreviations();

	// \bh
public:
	string_t	Expand(const string_t& strAbbreviation) const;
	void		GetList(std::set<string_t>& abbreviations) const;
	void		Register(const string_t& strAbbreviation, const string_t& strExpanded) throw(std::invalid_argument);
	void		Revoke(const string_t& strAbbreviation);
	void		RevokeAll();

	// f[^o
private:
	std::map<string_t, string_t>	m_abbreviations;
	length_t						m_cchMaxAbbreviation;	// ԒZk̕
	friend class CEditView;
};


/**
 *	GfB^R}h̊蒊ۃNX
 *	@see	Ascension::StandardCommands
 */
class CEditorCommand {
public:
	/// RXgN^
	CEditorCommand(CEditView& view) : m_pView(&view) {}
	/// fXgN^
	virtual ~CEditorCommand() {}
	/// R}hsAR}hˑ̒lԂ
	virtual ulong Execute() = 0;
	/// R}h^[QbgύX
	void Retarget(CEditView& view) {m_pView = &view;}
protected:
	/// ⊮EBhEԂ
	CCompletionWindow& GetCompletionWindow() const;
	/// R}h^[QbgԂ
	CEditView& GetTarget() const {return *m_pView;}
private:
	CEditView*	m_pView;
};


namespace Private {
	template<typename T>
	class CEditorCommandBase : public CEditorCommand {
	public:
		CEditorCommandBase(CEditView& view, T param) : CEditorCommand(view), m_param(param) {}
		virtual ~CEditorCommandBase() {}
	protected:
		T	m_param;
	};
} // namespace `anonymous'


/// GfB^̕WR}h̎
namespace StandardCommands {
	/// ubN}[N
	class CBookmarkCommand : public CEditorCommand {
	public:
		enum Type {
			CLEAR_ALL,			///< Sč폜
			TOGGLE_CURRENT_LINE	///< ݍs̃ubN}[ÑgO
		};
		CBookmarkCommand(CEditView& view, Type type) : CEditorCommand(view), m_type(type) {}
		ulong Execute();
	private:
		Type	m_type;
	};
	/// ỈACN^̒~
	class CCancelCommand : public CEditorCommand {
	public:
		CCancelCommand(CEditView& view) : CEditorCommand(view) {}
		ulong Execute();
	};
	/// Lbg̈ړ
	class CCaretMovementCommand : public CEditorCommand {
	public:
		enum Type {
			NEXT_CHARACTER,		///< ̕
			PREVIOUS_CHARACTER,	///< O̕
			LEFT_CHARACTER,		///< ̕
			RIGHT_CHARACTER,	///< E̕
			NEXT_WORD,		///< ̒P̐擪
			PREVIOUS_WORD,	///< O̒P̐擪
			LEFT_WORD,		///< ̒P̐擪
			RIGHT_WORD,		///< E̒P̐擪
			NEXT_WORDEND,		///< ̒P̏I[
			PREVIOUS_WORDEND,	///< O̒P̏I[
			LEFT_WORDEND,		///< ̒P̏I[
			RIGHT_WORDEND,		///< E̒P̏I[
			NEXT_LINE,		///< ̍s
			PREVIOUS_LINE,	///< O̍s
			NEXT_PAGE,		///< ̃y[W
			PREVIOUS_PAGE,	///< Õy[W
			START_OF_LINE,			///< s
			END_OF_LINE,			///< s
			FIRST_CHAR_OF_LINE,		///< s̍ŏ̕
			LAST_CHAR_OF_LINE,		///< s̍Ō̕
			START_OR_FIRST_OF_LINE,	///< ݈ʒuɂAss̍ŏ̕
			END_OR_LAST_OF_LINE,	///< ݈ʒuɂAss̍Ō̕
			START_OF_DOCUMENT,	///< hLg̐擪
			END_OF_DOCUMENT,	///< hLg̏I[
			NEXT_BOOKMARK,		///< ̃ubN}[N (ړʂ͏1)
			PREVIOUS_BOOKMARK,	///< ÕubN}[N (ړʂ͏1)
			MATCH_BRACKET,		///< Ί
		};
		CCaretMovementCommand(CEditView& view, Type type, bool bExtend = false, length_t c = 1)
				: CEditorCommand(view), m_type(type), m_bExtend(bExtend), m_c(c) {}
		ulong Execute();
	private:
		Type		m_type;
		bool		m_bExtend;
		length_t	m_c;
	};
	/// ƃR[h|Cg̕ϊ
	class CCharacterCodePointConversionCommand : public Private::CEditorCommandBase<bool> {
	public:
		CCharacterCodePointConversionCommand(CEditView& view, bool bCharToCp) : Private::CEditorCommandBase<bool>(view, bCharToCp) {}
		ulong Execute();
	};
	/// 1̓
	class CCharacterInputCommand : public Private::CEditorCommandBase<CodePoint> {
	public:
		CCharacterInputCommand(CEditView& view, CodePoint cp) : Private::CEditorCommandBase<CodePoint>(view, cp) {}
		ulong Execute();
	};
	/// אڍs̓ʒu̕
	class CCharacterInputFromNextLineCommand : Private::CEditorCommandBase<bool> {
	public:
		CCharacterInputFromNextLineCommand(CEditView& view, bool bFromNextLine) : Private::CEditorCommandBase<bool>(view, bFromNextLine) {}
		ulong Execute();
	};
	/// Nbv{[h֘ÃR}h
	class CClipboardCommand : public CEditorCommand {
	public:
		enum Type {
			COPY,	///< Rs[
			CUT,	///< ؂
			PASTE	///< \t
		};
		CClipboardCommand(CEditView& view, Type type, bool bPerformClipboardRing)
				: CEditorCommand(view),m_type(type), m_bPerformClipboardRing(bPerformClipboardRing) {}
		ulong Execute();
	private:
		Type	m_type;
		bool	m_bPerformClipboardRing;
	};
	/// eLXg̍폜
	class CDeletionCommand : public CEditorCommand {
	public:
		enum Type {
			NEXT_CHARACTER,		/// 1BCN^̏ꍇAJn̏ԂɃZbg
			PREVIOUS_CHARACTER,	/// O1BCN^̏ꍇAŌ̕ύXɖ߂
			NEXT_WORD,			/// ̒P̐擪܂
			PREVIOUS_WORD,		/// O̒P̐擪܂
			WHOLE_LINE			/// sS
		};
		CDeletionCommand(CEditView& view, Type type) : CEditorCommand(view), m_type(type) {}
		ulong Execute();
	private:
		Type	m_type;
	};
	/// S
	class CFindAllCommand : public CEditorCommand {
	public:
		enum Type {
			BOOKMARK,	///< ubN}[Nݒ
			REPLACE		///< u
		};
		CFindAllCommand(CEditView& view, Type type, bool bOnlySelection)
			: CEditorCommand(view), m_type(type), m_bOnlySelection(bOnlySelection) {}
		ulong Execute();
		const SearchResult& GetLastResult() const {return m_lastResult;}
	private:
		Type			m_type;
		bool			m_bOnlySelection;
		SearchResult	m_lastResult;
	};
	/// 
	class CFindNextCommand : public CEditorCommand {
	public:
		CFindNextCommand(CEditView& view, bool bReplace, bool bForward)
			: CEditorCommand(view), m_bReplace(bReplace), m_bForward(bForward) {}
		ulong Execute();
		const SearchResult& GetLastResult() const {return m_lastResult;}
	private:
		bool			m_bReplace, m_bForward;
		SearchResult	m_lastResult;
	};
	/// CN^
	class CIncrementalSearchCommand : public CEditorCommand {
	public:
		CIncrementalSearchCommand(CEditView& view,
			CIncrementalSearcher::State type, CIncrementalSearcher::IEventListener* pEventListener = 0)
			: CEditorCommand(view), m_type(type), m_pEventListener(pEventListener) {}
		ulong Execute();
		const SearchResult& GetLastResult() const {return m_lastResult;}
	private:
		CIncrementalSearcher::State				m_type;
		CIncrementalSearcher::IEventListener*	m_pEventListener;		
		SearchResult							m_lastResult;
	};
	/// Cfg
	class CIndentationCommand : public CEditorCommand {
	public:
		CIndentationCommand(CEditView& view, bool bIndent, bool bTabIndent, ushort nLevel)
				: CEditorCommand(view), m_bIndent(bIndent), m_bTabIndent(bTabIndent), m_nLevel(nLevel) {}
		ulong Execute();
	private:
		bool	m_bIndent;
		bool	m_bTabIndent;
		ushort	m_nLevel;
	};
	/// ͏Ԃ̃gO
	class CInputStatusToggleCommand : public CEditorCommand {
	public:
		enum Type {
			IME_STATUS,		///< IME
			OVERTYPE_MODE,	///< }/㏑[h
			SOFT_KEYBOARD	///< \tgL[{[h
		};
		CInputStatusToggleCommand(CEditView& view, Type type) : CEditorCommand(view), m_type(type) {}
		ulong Execute();
	private:
		Type	m_type;
	};
	/// s
	class CLineBreakCommand : public Private::CEditorCommandBase<bool> {
	public:
		CLineBreakCommand(CEditView& view, bool bPreviousLine) : Private::CEditorCommandBase<bool>(view, bPreviousLine) {}
		ulong Execute();
	};
	/// ͕̓ω郂[h̐ݒ
	class CNextInputVariationCommand : public Private::CEditorCommandBase<NextCharVariation> {
	public:
		CNextInputVariationCommand(CEditView& view, NextCharVariation variation)
				: Private::CEditorCommandBase<NextCharVariation>(view, variation) {}
		ulong Execute();
	};
	/// ⊮EBhEJ
	class COpenCompletionWindowCommand : public CEditorCommand {
	public:
		COpenCompletionWindowCommand(CEditView& view) : CEditorCommand(view) {}
		ulong Execute();
	};
	/// ĕϊ
	class CReconversionCommand : public CEditorCommand {
	public:
		CReconversionCommand(CEditView& view) : CEditorCommand(view) {}
		ulong Execute();
	};
	/// IgA`IJn
	class CRowSelectionExtensionCommand : public CEditorCommand {
	public:
		enum Type {
			NEXT_CHARACTER,		///< ̕
			PREVIOUS_CHARACTER,	///< O̕
			LEFT_CHARACTER,		///< ̕
			RIGHT_CHARACTER,	///< E̕
			NEXT_WORD,		///< ̒P̐擪
			PREVIOUS_WORD,	///< O̒P̐擪
			LEFT_WORD,		///< ̒P̐擪
			RIGHT_WORD,		///< E̒P̐擪
			NEXT_WORDEND,		///< ̒P̏I[
			PREVIOUS_WORDEND,	///< O̒P̏I[
			LEFT_WORDEND,		///< ̒P̏I[
			RIGHT_WORDEND,		///< E̒P̏I[
			NEXT_LINE,		///< ̍s
			PREVIOUS_LINE,	///< O̍s
			START_OF_LINE,			///< s
			END_OF_LINE,			///< s
			FIRST_CHAR_OF_LINE,		///< s̍ŏ̕
			LAST_CHAR_OF_LINE,		///< s̍Ō̕
			START_OR_FIRST_OF_LINE,	///< ݈ʒuɂAss̍ŏ̕
			END_OR_LAST_OF_LINE,	///< ݈ʒuɂAss̍Ō̕
		};
		CRowSelectionExtensionCommand(CEditView& view, Type type) : CEditorCommand(view), m_type(type) {}
		ulong Execute();
	private:
		Type	m_type;
	};
	/// I̍쐬 (CMDID_MOVE_SELECTALL ACMDID_MOVE_SELECURRENTWORD)
	class CSelectionCreationCommand : public CEditorCommand {
	public:
		enum Type {
			ALL,			///< SeLXg
			CURRENT_WORD	///< ݂̒P
		};
		CSelectionCreationCommand(CEditView& view, Type type) : CEditorCommand(view), m_type(type) {}
		ulong Execute();
	private:
		Type	m_type;
	};
	/// ^uƋ󔒂̕ϊ (CMDID_EDIT_TABIFY ACMDID_EDIT_UNTABIFY)
	class CTabifyCommand : public Private::CEditorCommandBase<bool> {
	public:
		CTabifyCommand(CEditView& view, bool bTabify) : Private::CEditorCommandBase<bool>(view, bTabify) {}
		ulong Execute();
	};
	/// eLXg̓ (CMDID_EDIT_TEXT)
	class CTextInputCommand : public Private::CEditorCommandBase<string_t> {
	public:
		CTextInputCommand(CEditView& view, const string_t& str) : Private::CEditorCommandBase<string_t>(view, str) {}
		ulong Execute();
	};
	/// eLXg̓ւ (CMDID_EDIT_TRANSPOSE*)
	class CTranspositionCommand : public CEditorCommand {
	public:
		enum Type {
			CHARACTERS,	///< 
			LINES,		///< s
			WORDS,		///< P
			SENTENCES	///< 
		};
		CTranspositionCommand(CEditView& view, Type type) : CEditorCommand(view), m_type(type) {}
		ulong Execute();
	private:
		Type	m_type;
	};
	/// ɖ߂/蒼 (CMDID_EDIT_UNDO ACMDID_EDIT_REDO)
	class CUndoCommand : public Private::CEditorCommandBase<bool> {
	public:
		CUndoCommand(CEditView& view, bool bUndo) : Private::CEditorCommandBase<bool>(view, bUndo) {}
		ulong Execute();
	};
} // namespace StandardCommands


/// I
class CSelection {
public:
	/// fXgN^
	virtual ~CSelection() {}
	/**
	 *	I͈͂̃eLXgNbv{[hɃRs[
	 *	@param bAlsoSendToClipboardRing	Nbv{[hOɂRs[ꍇ true
	 */
	virtual void Copy(bool bAlsoSendToClipboardRing) = 0;
	/**
	 *	I͈͂̃eLXg폜Nbv{[hɃRs[
	 *	@param bAlsoSendToClipboardRing	Nbv{[hOɂRs[ꍇ true
	 */
	virtual void Cut(bool bAlsoSendToClipboardRing) = 0;
	/// I͈͂̃eLXg폜
	virtual void Delete() = 0;
	/// ANeBu|Cg (Lbg) Ԃ
	virtual CVisualPoint& GetActivePoint() const = 0;
	/// AJ[|Cg (}[N) Ԃ
	virtual CVisualPoint& GetAnchorPoint() const = 0;
	/// 2_̂hLg̏I[ɋ߂Ԃ
	virtual const CVisualPoint& GetEndPoint() const {return std::max(GetActivePoint(), GetAnchorPoint());}
	/// ͈͂Ԃ
	virtual CTextRange GetRange() const {return CTextRange(GetAnchorPoint(), GetActivePoint());}
	/**
	 *	݂̑Iwŝǂ͈̔͂܂ł邩Ԃ
	 *	@param iLine			ׂs
	 *	@param piStart, piEnd	[out] JnʒuƏIʒuB
	 *							JnʒuwsOɂꍇ 0BIʒuwsɂꍇ -1
	 */
	virtual void GetRangeOnLine(length_t iLine, length_t* piStart, length_t* piEnd) const = 0;
	/// 2_̂hLg̐擪ɋ߂Ԃ
	virtual const CVisualPoint& GetStartPoint() const {return std::min(GetActivePoint(), GetAnchorPoint());}
	/// IeLXgԂ
	virtual string_t GetText() const = 0;
	/// I󂩂Ԃ
	virtual bool IsEmpty() const = 0;
	/// NCAgWI͈͏ォǂ
	virtual bool IsPointOver(const POINT& pt) const = 0;
	/// I`Ԃ
	virtual bool IsRectangle() const = 0;
	/**
	 *	2_𓯂ʒuɈړ
	 *	@param pos		ʒu
	 *	@param bReveal	IɂȂ悤Ƀr[XN[
	 */
	void MoveTo(const CCharPos& pos, bool bReveal) {Select(pos, pos, false, bReveal);}
	/**
	 *	Nbv{[heLXg\t
	 *	@param bFromClipboardRing	Nbv{[hOgꍇ true
	 */
	virtual void Paste(bool bFromClipboardRing) = 0;
	/**
	 *	weLXgŒu
	 *	@param first, last			ueLXg
	 *	@param bRectangleInsertion	`}
	 */
	virtual void Replace(const char_t* first, const char_t* last, bool bRectangleInsertion = false) = 0;
	/**
	 *	weLXgŒu
	 *	@param strText				ueLXg
	 *	@param bRectangleInsertion	`}
	 */
	void Replace(const string_t& strText, bool bRectangleInsertion = false) {
		Replace(strText.data(), strText.data() + strText.length(), bRectangleInsertion);
	}
	/**
	 *	͈͂I
	 *	@param range		͈
	 *	@param bRectangle	`I
	 *	@param bReveal		IɂȂ悤Ƀr[XN[
	 */
	void Select(const CTextRange& range, bool bRectangle, bool bReveal) {Select(range.m_pos1, range.m_pos2, bRectangle, bReveal);}
	/**
	 *	͈͂I
	 *	@param anchorPosition	AJ[|Cg (}[N)
	 *	@param activePosition	ANeBu|Cg (Lbg)
	 *	@param bRectangle		`I
	 *	@param bReveal			IɂȂ悤Ƀr[XN[
	 */
	virtual void Select(const CCharPos& anchorPosition, const CCharPos& activePosition, bool bRectangle, bool bReveal) = 0;
	/// ̃ANeBu|Cg̈ړ1񂾂AJ[|CgǏ]
	virtual void SynchronizeAnchorWithActive() = 0;
};

/**
 *	@brief	Ascension eLXgGfB^̃r[
 *
 *	<h3>KvpA</h3>
 *
 *	<ul>
 *		<li>OLE hbOAhhbvgpꍇ́A
 *	gݍ݃AvP[VXbh OleInitialize API ĂяoĂKvB</li>
 *		<li>c[`bvgꍇ InitCommonControlsEx ĂяoĂKvB</li>
 *		<li>̓\yуC^[tFCX͑S Unicode gp邽߁A
 *	 Windows NT n݂̂ƂȂB</li>
 *		<li>̃NX͌_ł̓XbhZ[tł<strong>Ȃ</strong>B</li>
 *		<li> Unicode ̒`ɂ͏]ĂȂB</li>
 *	</ul>
 *
 *	<h3>oeLXg֘ÃEBhEX^C</h3>
 *
 *	eLXgE񂹂ŕ\邽߂ WS_EX_RIGHT AE獶ɕ\邽߂ WS_EX_RTLREADING
 *	͂B̐ݒɂ͑ TLayoutSettings ̊YogpȂ΂ȂȂ
 *
 *	܂ WS_EX_LAYOUTRTL gpłȂB̃X^Cݒ肵ꍇ͖̓`ł
 *
 *	XN[o[ɕ\ɂ̓NCAg WS_EX_LEFTSCROLLBAR ݒ肵Ȃ΂ȂȂ
 *
 *	̐ݒꊇĕύXꍇ CEditView::SetTextDirection gƂł
 *
 *	[ (CWP[^}[Wƍsԍ) ̈ʒu̓eLXg񂹂ł΍[A
 *	E񂹂łΉE[ɂȂ
 *
 *	<h3>Rs[RXgN^ɂ镡ɂ (To deriver)</h3>
 *
 *	CEditView ̑cNX͑SăRs[RXgN^ĂA
 *	̃NXłRs[RXgN^găr[𕡐邱Ƃo (
 *	cNXƓlAEBhE͍쐬Ȃ)Bf[^oɑ
 *	̃NX͈ꕔ̃o𕡐ƕŋL
 *
 *	Lf[^oɂ̓CAEg֘A̐ݒ肪ʂɊ܂܂ĂB
 *	̓Rs[ԂňقȂ郌CAEgݒłȂƂƂӖĂ
 *
 *	͋Lf[^o<strong>L</strong>B
 *	LȂr[폜ĂLf[^͔jȂA
 *	Lr[폜ƁAL͂̃r[畡ꂽ̃r[ɈڂB
 *	čŌɎcr[폜ꂽƂALf[^͔j󂳂B
 *	̂߃Rs[RXgN^ł͕̃r[A
 *	̃r[IWĩr[LB܂A
 *	r[͎j󂳂ꂽƂɃIWiɒʒmāAN[Xg玩菜
 *
 *	܂ALێr[͎ɑ΂ݒ̍XV𑼂̃r[ɒʒmƂڂB
 *	NCAgtHgsԊuAAvP[V`sƂݒ̕ύXr[ɑ΂čsƁA
 *	Lr[ɏ`dALr[ƑSĂ̕ɐݒ肪f̂ŁA
 *	NCAg͂֘ASẴr[ݒ肷Kv͖
 *
 *	<strong>Rs[RXgN^ɂĕꂽr[́A
 *	ɂŏqׂ悤ȕÅ֌W</strong>ƂƂɒӂȂ΂ȂȂB
 *	̊֌W CEditView::IsCloneOf \bhŒׂ邱Ƃł
 *
 *	<h3>`̓Ɖ</h3>
 *
 *	܂Ƃ܂sۂɑSĂ̒iKŕ`sĂƓ삪xȂ̂ŁA
 *	CEditView ͕`̓s߂ CEditView::Freeze \bhA
 *	邽߂ CEditView::Unfreeze \bh2pӂĂB
 *	ACEditView::InvalidateLine ACEditView::InvalidateLines
 *	͑ɂ͍ĕ`s킸A`̕KvȍsL^ĂA
 *	ƂɈxɕ`sB̂ CEditView ̂قƂǂ̑
 *	CWindow::InvalidateRect 𒼐ڌĂяôł͂ȂAL2̃\bhōĕ`s
 *
 *	֐̂߂ɓƂ̉s\bh͎̕A
 *	/s (J CEditView::_Unfreeze g)
 *
 *	@see	CEditDoc
 */
class CEditView :
		public Manah::Windows::CView<CEditDoc, TDocumentUpdate, Manah::Windows::Controls::CCustomControl<CEditView> >,
		virtual public Ascension::CLineLayoutManager::IEventListener,
#ifndef ASCENSION_NO_TSF
		virtual public ITextStoreACP,
#endif /* !ASCENSION_NO_TSF */
		virtual public IDropSource, virtual public IDropTarget {
	typedef Manah::Windows::CView<CEditDoc, TDocumentUpdate, Manah::Windows::Controls::CCustomControl<CEditView> > _BaseView;
	DEFINE_WINDOW_CLASS() {
		lpszName = L"AscensionView";
		nStyle = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW | CS_DBLCLKS;
		bgColor = COLOR_WINDOW;
		cursor = IDC_IBEAM;
	}

public:
	/**
	 *	@brief	IvV
	 *
	 *	ݒ/擾̂߂̃\bhƃ\bĥŁA
	 *	ׂȂ̂͂ɏW߂
	 *
	 *	@see	CEditView::GetOptions ACEditView::SetOptions
	 */
	struct TOptions {
		AutoIndentType	autoIndentType;					///< Cfg̎
		length_t		cRecognizingLines;				///< X}[gCfgΊʌōls
		InputSequenceCheckLanguage	sequenceCheckingLanguages;	///< ̓V[PX`FbNLɂ錾
		std::bitset<BooleanOptions::DISPLAY_BOOLEAN_OPTIONS_COUNT>	appearance;	///< O̐ݒ
		std::bitset<BooleanOptions::BEHAVIOR_BOOLEAN_OPTIONS_COUNT>	behavior;	///< ̐ݒ

		/// RXgN^
		TOptions() : autoIndentType(AIT_BLOCK), cRecognizingLines(100), sequenceCheckingLanguages(ISCL_ALL) {
			using namespace BooleanOptions;
			appearance.set(BEEP_ON_SOME_FAILURE);
			appearance.set(HIDE_CURSOR_FOR_CHAR_INPUT);
			appearance.set(LOCALE_SPECIFIC_CARET_SHAPE);
			appearance.set(SHOW_HINT_ON_LINK);
			appearance.set(USE_EDITOR_FONT_FOR_COMPLETION);
			behavior.set(OLE_DRAG_AND_DROP);
		}
	};

	// RXgN^
public:
	CEditView(CEditDoc& document);
	CEditView(const CEditView& rhs);
protected:
	virtual ~CEditView();

	// Zq
private:
	/// gpȂ
	CEditView& operator =(const CEditView& rhs);

	// \bh
public:
	// 쐬
	virtual bool	Create(HWND hwndParent,
		const RECT& rect, DWORD dwStyle, DWORD dwExStyle) throw(std::runtime_error);

	// CxgXi
	void	AddEventListener(IEditViewEventListener& eventListener);
	void	RemoveEventListener(IEditViewEventListener& eventListener);

	// ̎擾
	static UINT			CanPaste();
	void				GetAllLineParams(std::list<TAppDefinedLine>& lines) const;
	Encodings::CodePage	GetClipboardNativeCodePage() const;
	CLayoutSettings&	GetLayoutSettings() const;
	CLexer&				GetLexer() const;
	DWORD				GetLineParam(length_t iLine) const;
	NextCharVariation	GetNextCharacterVariation() const;
	const TOptions&		GetOptions() const;
	ulong				GetScrollRatio(bool bHorizontal) const;
	bool				IsCloneOf(const CEditView& rhs) const;
	bool				IsGuiEditable() const;
	bool				IsOvertypeMode() const;
	bool				IsTextDirectionRightToLeft() const;

	// ̐ݒ
	void	SetClipboardNativeCodePage(Encodings::CodePage cp) throw(std::invalid_argument);
	void	SetGuiEditability(bool bEditable);
	void	SetLineParam(length_t iLine, DWORD dwParam, DWORD dwMask = 0xFFFFFFFF);
	void	SetNextCharacterVariation(NextCharVariation variation);
	void	SetOptions(TOptions& options);
	void	SetOvertypeMode(bool bOvertype = true);
	void	SetTextDirection(bool bRightToLeft);

	// {
	virtual bool	InputCharacter(CodePoint cp);
	virtual bool	InsertText(const char_t* first, const char_t* last, bool bAsRectangle);
	bool			InsertText(const string_t& text, bool bAsRectangle);

	// 
	const CBoundarySearcher&		GetBoundarySearcher() const;
	static CIncrementalSearcher&	GetIncrementalSearcher();
	static CTextSearcher&			GetTextSearcher();
	void							HighlightMatchTexts(bool bHighlight = true);

	// XN[
	void	BeginAutoScroll();
	bool	EndAutoScroll();

	// ⊮EBhE
	void	CloseCompletionWindow();
	void	OpenCompletionWindow();

#ifndef ASCENSION_NO_MIGEMO
	// Migemo
	static const WCHAR*	GetMigemoPath(bool bRuntime);
	static void			SetMigemoPath(const WCHAR* pwsz, bool bRuntime);
#endif /* !ASCENSION_NO_MIGEMO */

	// I
	CSelection&	GetSelection() const;

	// Nbv{[hO
	static CClipboardRing&	GetClipboardRing();

	// ݈ʒuӂ̃eLXg
	bool		GetNearestWordFromCaret(CCharPos* pStartPos, CCharPos* pEndPos, string_t* pstrWord) const;
	bool		GetNearestWordFromCursor(CCharPos* pStartPos, CCharPos* pEndPos, string_t* pstrWord) const;
	string_t	GetPrecedingWord(length_t cchLimit) const;

	// Zk
	bool					ExpandPrecedingWordAsAbbreviation();
	static CAbbreviations&	GetAbbreviations();

	// ubN}[N
	CBookmarker&	GetBookmarker() const;

	// [UC^[tFCX
	void	Beep();
	bool	CheckGuiEditability();
	void	HideToolTip();
	void	ShowToolTip(const string_t& strText, ulong nTimeToWait = -1, ulong nTimeRemainsVisible = -1);

	// `̓A
	void	Freeze();
	bool	IsFreezed() const;
	void	Unfreeze();

	// }EX̋/s
	void	EnableMouseOperation(bool bEnable);

	// [eBeB
	CCharPos		CharFromPos(const POINT& pt, bool bIgnoreExtenders, bool* bTruncated = 0) const;
	length_t		ColumnFromChar(const CCharPos& pos) const;
	CCharPos		DisplayCharFromLogicalChar(const CCharPos& posLogical) const;
	length_t		DisplayLineFromLogicalLine(length_t iLine) const;
	bool			FindMatchBracket(const CCharPos& pos, CCharPos& posFound, bool bRequireBody) const;
	length_t		GetDisplayLineCount() const;
	void			GetDisplayLineOffsetIndex(length_t iDisplayLine, length_t& iLogicalLine, length_t& iOffset) const;
	length_t		GetVisibleLineCount() const;
	length_t		GetVisibleCharCount() const;
	HitTestResult	HitTest(const POINT& pt) const;
	bool			IsOverInvokableLink(const POINT& pt, char_t*& pwsz) const;
	CCharPos		LogicalCharFromDisplayChar(const CCharPos& posDisplay) const;
	POINT			PosFromChar(const CCharPos& col) const;

	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN_NO_REF_COUNT()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDropSource)
		IMPLEMENTS_INTERFACE(IDropTarget)
#ifndef ASCENSION_NO_TSF
		IMPLEMENTS_INTERFACE(ITextStoreACP)
#endif /* !ASCENSION_NO_TSF */
//		IMPLEMENTS_INTERFACE(IDispatch)
//		IMPLEMENTS_INTERFACE(IViewObjectEx)
//		IMPLEMENTS_INTERFACE(IViewObject2)
//		IMPLEMENTS_INTERFACE(IViewObject)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObject)
//		IMPLEMENTS_INTERFACE(IOleWindow, IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceActiveObject)
//		IMPLEMENTS_INTERFACE(IOleControl)
//		IMPLEMENTS_INTERFACE(IOleObject)
//		IMPLEMENTS_INTERFACE(IPersistStreamInit)
//		IMPLEMENTS_INTERFACE(ISupportErrorInfo)
	END_INTERFACE_TABLE()

	// CViewBase<TDocumentUpdate> C^[tFCX
	void	OnDocumentSetup();
	void	OnInitialUpdate();
	void	OnUpdate(const TDocumentUpdate& update);

	// CLineLayoutManager::IEventListener C^[tFCX
	void	OnChangedBookmark(length_t iLine);
	void	OnChangedLayout();
	void	OnChangedMaximumWidthLine();
	void	OnChangedTextAlignment();
	void	OnChangedTextDirection();
	void	OnChangedVerticalRulerWidth();
	void	OnClearedAllBookmarks();
	Manah::Windows::GDI::CClientDC	OnQueryDeviceContext();

	// IDropSource C^[tFCX
	STDMETHODIMP	QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState);
	STDMETHODIMP	GiveFeedback(DWORD dwEffect);

	// IDropTarget C^[tFCX
	STDMETHODIMP	DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragLeave();
	STDMETHODIMP	Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);

#ifndef ASCENSION_NO_TSF
	// ITextStoreACP C^[tFCX
	STDMETHODIMP	AdviseSink(REFIID riid, IUnknown* punk, DWORD dwMask);
	STDMETHODIMP	UnadviseSink(IUnknown* punk);
	STDMETHODIMP	RequestLock(DWORD dwLockFlags, HRESULT* phrSession);
	STDMETHODIMP	GetStatus(TS_STATUS* pdcs);
	STDMETHODIMP	QueryInsert(LONG acpTestStart, LONG acpTestEnd, ULONG cch, LONG* pacpResultStart, LONG* pacpResultEnd);
	STDMETHODIMP	GetSelection(ULONG ulIndex, ULONG ulCount, TS_SELECTION_ACP* pSelection, ULONG* pcFetched);
	STDMETHODIMP	SetSelection(ULONG ulCount, const TS_SELECTION_ACP* pSelection);
	STDMETHODIMP	GetText(LONG acpStart, LONG acpEnd,
						WCHAR* pchPlain, ULONG cchPlainReq, ULONG* pcchPlainRet,
						TS_RUNINFO* prgRunInfo, ULONG cRunInfoReq, ULONG* pcRunInfoRet, LONG* pacpNext);
	STDMETHODIMP	SetText(DWORD dwFlags, LONG acpStart, LONG acpEnd, const WCHAR* pchText, ULONG cch, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	GetFormattedText(LONG acpStart, LONG acpEnd, IDataObject** ppDataObject);
	STDMETHODIMP	GetEmbedded(LONG acpPos, REFGUID rguidService, REFIID riid, IUnknown** ppunk);
	STDMETHODIMP	QueryInsertEmbedded(const GUID* pguidService, const FORMATETC* pFormatEtc, BOOL* pfInsertable);
	STDMETHODIMP	InsertEmbedded(DWORD dwFlags, LONG acpStart, LONG acpEnd, IDataObject* pDataObject, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	InsertTextAtSelection(DWORD dwFlags,
						const WCHAR* pchText, ULONG cch, LONG* pacpStart, LONG* pacpEnd, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	InsertEmbeddedAtSelection(DWORD dwFlags,
						IDataObject* pDataObject, LONG* pacpStart, LONG* pacpEnd, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	RequestSupportedAttrs(DWORD dwFlags, ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs);
	STDMETHODIMP	RequestAttrsAtPosition(LONG acpPos, ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs, DWORD dwFlags);
	STDMETHODIMP	RequestAttrsTransitioningAtPosition(LONG acpPos, ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs, DWORD dwFlags);
	STDMETHODIMP	FindNextAttrTransition(LONG acpStart, LONG acpHalt,
						ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs, DWORD dwFlags,
						LONG* pacpNext, BOOL* pfFound, LONG* plFoundOffset);
	STDMETHODIMP	RetrieveRequestedAttrs(ULONG ulCount, TS_ATTRVAL* paAttrVals, ULONG* pcFetched);
	STDMETHODIMP	GetEndACP(LONG* pacp);
	STDMETHODIMP	GetActiveView(TsViewCookie* pvcView);
	STDMETHODIMP	GetACPFromPoint(TsViewCookie vcView, const POINT* ptScreen, DWORD dwFlags, LONG* pacp);
	STDMETHODIMP	GetTextExt(TsViewCookie vcView, LONG acpStart, LONG acpEnd, RECT* prc, BOOL* pfClipped);
	STDMETHODIMP	GetScreenExt(TsViewCookie vcView, RECT* prc);
	STDMETHODIMP	GetWnd(TsViewCookie vcView, HWND* phwnd);
#endif /* !ASCENSION_NO_TSF */
				
	// J[eBeB (`)
protected:
	virtual void		DrawBorder(Manah::Windows::GDI::CPaintDC& dc,
							int left, int top, int right, int bottom, BorderType type, COLORREF color);
	virtual int			DrawEofMarker(Manah::Windows::GDI::CPaintDC& dc, int x, int y);
	virtual length_t	DrawLine(Manah::Windows::GDI::CPaintDC& dc,
							length_t iLine, int y, const string_t& strLine, LineBreak lineBreak, bool bCaretLine);
	virtual int			DrawLineTerminator(Manah::Windows::GDI::CPaintDC& dc,
							int x, int y, LineBreak lineBreak, COLORREF fgColor, COLORREF bgColor, bool bMirrored);
	virtual void		DrawVerticalRuler(Manah::Windows::GDI::CPaintDC& dc, length_t iStart, length_t iEnd);
	void				InvalidateLine(length_t iLine);
	void				InvalidateLines(length_t iStart, length_t iEnd);
private:
	void				_Unfreeze();
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	void				_UpdateMemoryDeviceContext();
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	// J[eBeB (ʒuvZ)
protected:
	string_t	CalculateSpacesReachingVirtualPoint(length_t iLine, ulong xVirtual) const;
	static int	MakeCaretPosValid(const char_t* pwsz, length_t cch, length_t nCaretPos, bool bBackward);
private:
	length_t	_MapAbsoluteXToCharacter(length_t iLine, int x, bool bIgnoreExtenders, bool* pbTruncated = 0) const;
	int			_MapAbsoluteXToClientX(int x, int nLineWidth) const;
	int			_MapClientXToAbsoluteX(int x, int nLineWidth) const;

	// J[eBeB (XN[ʒuvZ)
private:
	long	_MapInternalXToScrollBoxX(long x) const;
	long	_MapScrollBoxXToInternalX(long x) const;

	// J[eBeB (I͈͂ƃLbg)
protected:
	void			CheckMatchBrackets();
	virtual void	RecreateCaret();
private:
	void	OnSelectionChanged(const CTextRange& oldRange, bool bWasRectangle, bool bReveal);

	// J[eBeB (̑)
protected:
	bool			CharIsInCommentOrQuotation(const CCharPos& pos) const;
	static char_t	ConvertCharacter(char_t wch, NextCharVariation ncv);
	bool			GetNearestWord(const CCharPos& pos, length_t* piStart, length_t* piEnd, string_t* pstrWord) const;
	void			InitializeWindow(bool bCopyConstructing);
	virtual void	UpdateCaretPosition();
	virtual void	UpdateGdiObjects();
	void			UpdateImeCompositionWindowPosition();
	void			UpdateScrollInfo(bool bHorizontal, bool bVertical);

	// I[o[Ch\ȕ`惁\bhB̎͋
protected:
	virtual void		DrawIndicatorMargin(length_t iLine, Manah::Windows::GDI::CDC& dc, const RECT& rect);
	virtual string_t	QueryInvokableLinkMessage(const string_t& strUri);
	virtual void		QueryLineColors(length_t iLine, COLORREF& fgColor, COLORREF& bgColor);

	// I[o[Ch\ȃhLg̒ʐM
protected:
	virtual void	OnDocumentClosed();
	virtual void	OnDocumentSaved();

protected:
	virtual OVERRIDE_DISPATCH_EVENT(CEditView);

	// bZ[Wnh
protected:
	virtual void	OnCaptureChanged(HWND hwndNew);							// WM_CAPTURECHANGED
	void			OnChar(UINT nChar, UINT nFlags);						// WM_CHAR
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	virtual bool	OnContextMenu(HWND hWnd, POINT pt);						// WM_CONTEXTMENU
	virtual void	OnDestroy();											// WM_DESTROY
	virtual void	OnHScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);	// WM_HSCROLL
	virtual bool	OnImeComposition(WPARAM wParam, LPARAM lParam);			// WM_IME_COMPOSITION
	virtual void	OnImeEndComposition();									// WM_IME_ENDCOMPOSITION
	virtual LRESULT	OnImeRequest(WPARAM command, LPARAM lParam);			// WM_IME_REQUEST
	virtual void	OnImeStartComposition();								// WM_IME_STARTCOMPOSITION
	virtual bool	OnKeyDown(UINT nChar, UINT nFlags);						// WM_KEYDOWN
	virtual void	OnKillFocus(HWND hwndNew);								// WM_KILLFOCUS
	virtual void	OnLButtonDblClk(UINT nFlags, POINT pt);					// WM_LBUTTONDBLCLK
	virtual void	OnLButtonDown(UINT nFlags, POINT pt);					// WM_LBUTTONDOWN
	virtual void	OnLButtonUp(UINT nFlags, POINT pt);						// WM_LBUTTONUP
	virtual void	OnMouseMove(UINT nFlags, POINT pt);						// WM_MOUSEMOVE
	virtual bool	OnMouseWheel(UINT nFlags, short zDelta, POINT pt);		// WM_MOUSEWHEEL
	virtual bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);					// WM_NOTIFY
	virtual void	OnPaint(Manah::Windows::GDI::CPaintDC& dc);				// WM_PAINT
	virtual void	OnRButtonDown(UINT nFlags, POINT pt);					// WM_RBUTTONDOWN
	virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);	// WM_SETCURSOR
	virtual void	OnSetFocus(HWND hwndOld);								// WM_SETFOCUS
	virtual void	OnSize(UINT nType, int cx, int cy);						// WM_SIZE
	virtual bool	OnSysChar(UINT nChar, UINT nFlags);						// WM_SYSCHAR
	virtual void	OnSysColorChange();										// WM_SYSCOLORCHANGE
	virtual	bool	OnSysKeyDown(UINT nChar, UINT nFlags);					// WM_SYSKEYDOWN
	virtual	bool	OnSysKeyUp(UINT nChar, UINT nFlags);					// WM_SYSKEYUP
	virtual void	OnTimer(UINT nIDEvent);									// WM_TIMER
	virtual void	OnUniChar(UINT nChar, UINT nFlags);						// WM_UNICHAR
	virtual void	OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);	// WM_VSCROLL

	// NX
private:
	class _CCloneIterator {
	public:
		_CCloneIterator(CEditView& view) : m_pOriginal(view.m_pOriginalView),
				m_it(view.m_pOriginalView->m_pClones->begin()), m_bIsHead(true) {}
		CEditView& Get() const {assert(!IsEnd()); return m_bIsHead ? *m_pOriginal : **m_it;}
		bool IsEnd() const {return !m_bIsHead && m_it == m_pOriginal->m_pClones->end();}
		void Next() {
			if(m_bIsHead)									m_bIsHead = false;
			else if(m_it != m_pOriginal->m_pClones->end())	++m_it;
		}
		CEditView& operator *() const {return Get();}
		CEditView* operator ->() {return &Get();}
	private:
		CEditView*						m_pOriginal;
		std::set<CEditView*>::iterator	m_it;
		bool							m_bIsHead;
	};
	class _CSelection :
			public CSelection, public Manah::CNoncopyable, virtual public CEditPoint::IEventListener {
	public:
		_CSelection(CEditView& view) : m_view(view), m_bIgnoreActiveMovement(false), m_bSynchronizeAnchorWithActive(false) {
			m_pActivePoint = view.GetDocument().CreateEditPoint(this);
			m_pActivePoint->SynchronizeWithDocumentUpdate(true);
			m_pActivePoint->ExcludeFromRestriction(true);
			m_pAnchorPoint = view.GetDocument().CreateEditPoint();
			m_pAnchorPoint->SynchronizeWithDocumentUpdate(true);
			m_pAnchorPoint->ExcludeFromRestriction(true);
		}
		~_CSelection() {delete m_pAnchorPoint; delete m_pActivePoint;}
	public:
		void BeginLineSelection();
		void BeginWordSelection();
		void Copy(bool bAlsoSendToClipboardRing);
		void Cut(bool bAlsoSendToClipboardRing);
		void Delete();
		CVisualPoint& GetActivePoint() const {return *const_cast<_CSelection*>(this)->m_pActivePoint;}
		CVisualPoint& GetAnchorPoint() const {return *const_cast<_CSelection*>(this)->m_pAnchorPoint;}
		const CVisualPoint& GetEndPoint() const {return std::max(*m_pAnchorPoint, *m_pActivePoint);}
		length_t GetLineSelectionOriginalLine() const;
		void GetWordSelectionOriginalWord(CTextRange& word) const;
		void GetRangeOnLine(length_t iLine, length_t* piStart, length_t* piEnd) const;
		const CVisualPoint& GetStartPoint() const {return std::min(*m_pAnchorPoint, *m_pActivePoint);}
		string_t GetText() const;
		bool IsEmpty() const {return static_cast<CCharPos>(*m_pAnchorPoint) == *m_pActivePoint;}
		bool IsPastingFromClipboardRing() const {return toBoolean(m_type & PASTING_FROM_CLIPBOARD_RING);}
		bool IsPointOver(const POINT& pt) const;
		bool IsRectangle() const {return toBoolean(m_type & RECTANGLE);}
		void OnEditPointDestroyed() {}
		void OnEditPointMoved(const CEditPoint& self, const CCharPos& oldPosition);
		void Paste(bool bFromClipboardRing);
		void Replace(const char_t* first, const char_t* last, bool bRectangleInsertion /* = false */);
		void Select(const CCharPos& anchorPosition, const CCharPos& activePosition, bool bRectangle, bool bReveal);
		void SynchronizeAnchorWithActive() {m_bSynchronizeAnchorWithActive = true;}
		void UpdateRectangleRegion();
	private:
		CEditView&		m_view;
		CVisualPoint*	m_pAnchorPoint;
		CVisualPoint*	m_pActivePoint;
		bool			m_bIgnoreActiveMovement;	// m_pActivePoint 瑗Ă OnEditPointMoved 1񂾂
		bool			m_bSynchronizeAnchorWithActive;	// ANeBu|CgړƂ1񂾂AJ[ړ
		enum _Type {LINEAR = 0, RECTANGLE = 1, PASTING_FROM_CLIPBOARD_RING = 2}	m_type;

		length_t	m_iTemporaryAnchorLine;		// sIAPIA`IJñAJ[|Cg̍sԍB
												// `I͕\sAȊȌꍇ͘_s
		length_t	m_iBoxSelectionActiveLine;	// `ĨANeBu|Cg̕\s
		int			m_xBoxSelectionAnchor;		// `ĨAJ[|Cg x W (Lbgʒu)
		int			m_xBoxSelectionActive;		// `ĨANeBu|Cg x W (Lbgʒu)
		length_t	m_iWordSelectionChars[2];	// PI[hōŏɑIĂP̑O̕ʒu
	};

	// 
private:
	/// {^ǂ̂悤ȖړIŉĂ邩\
	enum _LeftDownMode {
		LDM_NONE,				// ĂȂ
		LDM_SELECTION_CHARACTER,// I
		LDM_SELECTION_LINE,		// sI
		LDM_SELECTION_WORD,		// PI
		LDM_DRAGANDDROP,		// vZX̃hbOAhhbv
		LDM_DRAGANDDROPSELF,	// vZX̃hbOAhhbv
		LDM_DRAGANDDROPBOXSELF	// vZX̃hbOAhhbv (`)
	};

	/// ^C} ID
	enum {
		TIMERID_EXPANDSELECTION		= 0,	///< }EXhbOőI͈͂ύX
		TIMERID_EXPANDLINESELECTION	= 1,	///< }EXhbOőIsύX
		TIMERID_DRAGSCROLL			= 2,	///< OLE hbO
		TIMERID_CALLTIP				= 3,	///< c[`bv̑҂
		TIMERID_AUTOSCROLL			= 4,	///< XN[
		TIMERID_LINEPARSE			= 5,	///< ss
	};

	/// ReLXgj[Ȃǂ ID
	enum {
		WM_REDO	= WM_APP + 1,			// ɖ߂
		WM_SELECTALL,					// SđI
		ID_SHOWDIRECTIONALFORMATTERS,	// Unicode 䕶̕\
		ID_RTLREADING,					// E獶ɓǂ
		ID_TOGGLEIMESTATUS,				// IME J/
		ID_TOGGLESOFTKEYBOARD,			// \tgL[{[hJ/
		ID_RECONVERT,					// ĕϊ

		ID_INSERT_LRM,		// LRM (Left-to-right mark)
		ID_INSERT_RLM,		// RLM (Right-to-left mark)
		ID_INSERT_ZWJ,		// ZWJ (Zero width joiner)
		ID_INSERT_ZWNJ,		// ZWNJ (Zero width non-joiner)
		ID_INSERT_LRE,		// LRE (Left-to-right embedding)
		ID_INSERT_RLE,		// RLE (Right-to-left embedding)
		ID_INSERT_LRO,		// LRO (Left-to-right override)
		ID_INSERT_RLO,		// RLO (Right-to-left override)
		ID_INSERT_PDF,		// PDF (Pop directional formatting)
		ID_INSERT_WJ,		// WJ (Word Joiner)
		ID_INSERT_NADS,		// NADS (National digit shapes)	<- ȉ6͔񐄏R[h|Cg (Unicode 4.0)
		ID_INSERT_NODS,		// NODS (Nominal digit shapes)
		ID_INSERT_ASS,		// ASS (Activate symmetric swapping)
		ID_INSERT_ISS,		// ISS (Inhibit symmetric swapping)
		ID_INSERT_AAFS,		// AAFS (Activate Arabic form shaping)
		ID_INSERT_IAFS,		// IAFS (Inhibit Arabic form shaping)
		ID_INSERT_RS,		// RS (Record Separator)
		ID_INSERT_US,		// US (Unit Separator)
		ID_INSERT_IAA,		// Interlinear Annotation Anchor
		ID_INSERT_IAS,		// Interlinear Annotation Separator
		ID_INSERT_IAT,		// Interlinear Annotation Terminator

		ID_INSERT_U0020,	// U+0020 (Space)
		ID_INSERT_NBSP,		// NBSP (No-Break Space)
		ID_INSERT_U1680,	// U+1680 (Ogham Space Mark)
		ID_INSERT_MVS,		// MVS (Mongolian Vowel Separator)
		ID_INSERT_U2000,	// U+2000 (En Quad)
		ID_INSERT_U2001,	// U+2001 (Em Quad)
		ID_INSERT_U2002,	// U+2002 (En Space)
		ID_INSERT_U2003,	// U+2003 (Em Space)
		ID_INSERT_U2004,	// U+2004 (Three-Per-Em Space)
		ID_INSERT_U2005,	// U+2005 (Four-Per-Em Space)
		ID_INSERT_U2006,	// U+2006 (Six-Per-Em Space)
		ID_INSERT_U2007,	// U+2007 (Figure Space)
		ID_INSERT_U2008,	// U+2008 (Punctuation Space)
		ID_INSERT_U2009,	// U+2009 (Thin Space)
		ID_INSERT_U200A,	// U+200A (Hair Space)
		ID_INSERT_ZWSP,		// ZWSP (Zero Width Space)
		ID_INSERT_NNBSP,	// NNSBP (Narrwow No-Break Space)
		ID_INSERT_MMSP,		// MMSP (Medium Mathematical Space)
		ID_INSERT_U3000,	// U+3000 (Ideographic Space)
		ID_INSERT_NEL,		// NEL (Next Line)
		ID_INSERT_LS,		// LS (Line Separator)
		ID_INSERT_PS,		// PS (Paragraph Separator)
	};


	// f[^o
private:
	/* 啨 */
	static CClipboardRing			m_clipboardRing;		// Nbv{[hO
	static CAbbreviations			m_abbreviations;		// Zk
	static CTextSearcher			m_textSearcher;			// eLXg
	static CIncrementalSearcher		m_incrementalSearcher;	// CN^
	_CSelection*					m_pSelection;			// I
	HWND							m_hwndToolTip;			// c[`bv
	char_t*							m_pwszTipText;			// c[`bṽeLXg
	CBoundarySearcher*				m_pBoundarySearcher;	// eLXgĚ
	Armaiti::OLE::CTextDataObject*	m_pDragging;			// OLE hbOIuWFNg
	CCompletionWindow*				m_pCompletionWindow;	// ͕⊮EBhE
	CAutoScrollOriginMark*			m_pAutoScrollOriginMark;// NX`Q

#ifndef ASCENSION_NO_MIGEMO
	/* C/Migemo */
	static WCHAR	m_wszMigemoRuntimePath[MAX_PATH];		// Migemo DLL fBNg
	static WCHAR	m_wszMigemoDictionaryPath[MAX_PATH];	// Migemo fBNg
#endif /* !ASCENSION_NO_MIGEMO */

	/* LÂ̊Ǘ (NX̐Q) */
	CEditView*		m_pOriginalView;	//  (this łΎ)
	std::set<CEditView*>*	m_pClones;	// ̕ (łȂ null)

	/* ̋Lo */
	struct _TSharedData {
		HMENU								hContextMenu;		// ReLXgj[
		std::set<IEditViewEventListener*>	eventListeners;		// CxgXi
		CLineLayoutManager					layoutManager;		// sCAEg
		TOptions							options;					// GȃIvV
		Encodings::CodePage					clipboardNativeCodePage;	// Nbv{[h̃R[hy[W
		int									nCaretWidth;				// ŌɌvZLbg
		bool								bHighlightMatches;			// ɈveLXg

		struct TGdiObjects {
			HPEN	hCaretLinePen;		// ݍs̉
			HPEN	hIACaretLinePen;	// ݍs̉ (ANeBu)
			HPEN	hLeftIndicatorPen;	// LTT_INDICATOR [hɍт`̂Ɏgp
			HPEN	hLineNumberPen;		// LTT_LINENUMBER [hɍт`̂Ɏgp
			HBITMAP	hCaretBitmap;		// LbgɎgprbg}bv

			TGdiObjects() : hCaretLinePen(0), hIACaretLinePen(0),
				hLeftIndicatorPen(0), hLineNumberPen(0), hCaretBitmap(0) {}
			~TGdiObjects() {
				::DeleteObject(hCaretLinePen);
				::DeleteObject(hIACaretLinePen);
				::DeleteObject(hLeftIndicatorPen);
				::DeleteObject(hLineNumberPen);
				::DeleteObject(hCaretBitmap);
			}
		} gdiObjects;

		_TSharedData(CEditView& view) : hContextMenu(0), layoutManager(view.GetDocument()), bHighlightMatches(false) {
		}
		~_TSharedData() {
			::DestroyMenu(::GetSubMenu(hContextMenu, 12));
			::DestroyMenu(::GetSubMenu(hContextMenu, 13));
			::DestroyMenu(hContextMenu);
		}
	} * m_pSharedData;

	/* [h */
	struct _TModeState {
		POINT	ptLastMouseDown;			// ŌɃ}EX{^ʒuBOLE hbOJnɎgp
		bool	bOvertype;					// ㏑[h
		bool	bGuiEditable;				// GUI NCAgҏW\
		bool	bReadyToExpandAbbrev;		// ZkWJł
		bool	bCursorHiddenForCharInput;	// [U̓͂Jn̂ŃJ[\\

		_TModeState() : bOvertype(false), bGuiEditable(true),
				bReadyToExpandAbbrev(false), bCursorHiddenForCharInput(false) {
			ptLastMouseDown.x = ptLastMouseDown.y = -1;
		}
	} m_modeState;

	/* XN[ */
	struct _TScrollInfo {
		POINT	position;			// XN[o[̈ʒu (x:Ay:)B
									// ̒l m_nHScrollRatio  m_nVScrollRatio 悸
									// \Jnʒu (:ϕPʁA:\sP) B
									// eLXg̕\E񂹂̏ꍇ͐ʒu͉E[0ɂȂ
		ulong	nHorizontalRatio;	// XN[1r[̉ɑ邩 (ʂ1)
		ulong	nVerticalRatio;		// XN[1sr[̉sɑ邩 (ʂ1)
		_TScrollInfo() : nHorizontalRatio(1), nVerticalRatio(1) {position.x = position.y = 0;}
		ulong GetX() const {return position.x * nHorizontalRatio;}
		ulong GetY() const {return position.y * nVerticalRatio;}
	} m_scrollInfo;

	/*  */
	struct _FreezeInfo {
		ulong				nCount;			// JE^B0ȊOłΕ`擀
		POINT				scrollPosition;	// ɗv̂XN[ʒuB𓀎
											// ̈ʒuɃXN[Bv (-1, -1)
		std::set<length_t>	invalidLines;	// ɍĕ`vꂽsB
											// InvalidateLine(s)  OnUpdate Ǘ
	} m_freezeInfo;
	
	/* s`LoX */
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	Manah::Windows::GDI::CAutoDC	m_memDC;		// foCXReLXg
	HBITMAP							m_hLineBitmap;	// memDC ɌѕtĂ1s`prbg}bv
	HBITMAP							m_hOldLineBitmap;
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	/*  */
	bool				m_bActiveImeComposition;	// IME œ͒
	_LeftDownMode		m_leftDownMode;				// LeftDownMode `Q
	NextCharVariation	m_nextCharVariation;		// NextCharVariation `Q
	TEditOperation		m_lastOperation;			// OɍsҏW
	ulong				m_nMouseOperationDisabledCount;
	CCharPos	m_posHilightedBrackets[2];	// \Ίʂ̈ʒu (ꍇ CCharPos(-1, -1))
	length_t	m_iFirstVisibleLine;// ݂̐擪s (_sB\s m_ptScroll.y)B
									// _s<->\sϊ̂߂̃LbV
									// cXN[ (OnVScroll)A܂Ԃ񂪕ωƂ (OnSize,
									// ModifyFontInfo)A\Jn_sO̍sҏWꂽƂ
									// (OnUpdate) XV <- !݂͎gĂȂ!

	/* XN[ */
	struct _TAutoScroll {
		POINT	indicatorPosition;	// CWP[^̈ʒu (NCAgW)
		bool	bScrolling;			// XN[

		_TAutoScroll() : bScrolling(false) {
		}
	} m_autoScroll;

	friend class CLineLayoutManager;
	friend class CVisualPoint;
	friend class CEditorCommand;
	friend class _CSelection;
};


// CC֐̎
/////////////////////////////////////////////////////////////////////////////

/**
 *	xgXi̓o^
 *	@param eventListener	Vo^CxgXi
 */
inline void CEditView::AddEventListener(IEditViewEventListener& eventListener) {
	AssertValid();
	m_pSharedData->eventListeners.insert(&eventListener);
}

/**
 *	u\tv삪\擾
 *	@return	\t\ȃNbv{[h`Bs̏ꍇ0
 */
inline UINT CEditView::CanPaste() {
	const UINT	nBoxClipFormat = ::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT);

	if(nBoxClipFormat != 0 && toBoolean(::IsClipboardFormatAvailable(nBoxClipFormat)))
		return nBoxClipFormat;
	if(toBoolean(::IsClipboardFormatAvailable(CF_UNICODETEXT)))
		return CF_UNICODETEXT;
	if(toBoolean(::IsClipboardFormatAvailable(CF_TEXT)))
		return CF_TEXT;

	return 0;
}

/**
 *	@brief	}EX̋/s̐ݒ
 *
 *	r[́u}EX얳JEgvێĂA̒l0łȂ΂}EX삪eB
 *	̃\bhł̃JEg𑝌邱ƂɂA}EX̋/sݒ肷邱Ƃł
 *
 *	JEg̒l𒼐ڒׂ@<strong></strong>
 *
 *	}EXɂXN[o[̑͗}~łȂ
 *
 *	vZXAEBhE OLE hbOAhhbv}~
 *	@param bEnable	JEgꍇ trueAꍇ false
 */
inline void CEditView::EnableMouseOperation(bool bEnable) {
	AssertValid();
	if(m_nMouseOperationDisabledCount != 0 || !bEnable)
		m_nMouseOperationDisabledCount += !bEnable ? 1 : -1;
}

/// ZkIuWFNgԂ
inline CAbbreviations& CEditView::GetAbbreviations() {
	return m_abbreviations;
}

/// ubN}[NIuWFNgԂ
inline CBookmarker& CEditView::GetBookmarker() const {
	AssertValid();
	return const_cast<CEditView*>(this)->m_pSharedData->layoutManager;
}

/// EIuWFNgԂ
inline const CBoundarySearcher& CEditView::GetBoundarySearcher() const {
	AssertValid();
	return *m_pBoundarySearcher;
}

/// Nbv{[h̃R[hy[WԂ
/// @see	CEditView::SetClipboardNativeCodePage
inline Encodings::CodePage CEditView::GetClipboardNativeCodePage() const {
	return m_pSharedData->clipboardNativeCodePage;
}

/// Nbv{[hOԂ
inline CClipboardRing& CEditView::GetClipboardRing() {
	return m_clipboardRing;
}

/// CN^IuWFNgԂ
inline CIncrementalSearcher& CEditView::GetIncrementalSearcher() {
	return m_incrementalSearcher;
}

/// CAEgݒ擾
inline CLayoutSettings& CEditView::GetLayoutSettings() const {
	AssertValid();
	return const_cast<CEditView*>(this)->m_pSharedData->layoutManager;
}

/// ͊Ԃ
inline CLexer& CEditView::GetLexer() const {
	AssertValid();
	return m_pSharedData->layoutManager.GetLexer();
}

#ifndef ASCENSION_NO_MIGEMO
/**
 *	C/Migemo DLL At@C̃fBNgԂ
 *	@param bRuntime	DLL ̏ꍇ trueB̏ꍇ false
 *	@return			fBNgpX
 */
inline const WCHAR* CEditView::GetMigemoPath(bool bRuntime) {
	return bRuntime ? m_wszMigemoRuntimePath : m_wszMigemoDictionaryPath;
}
#endif /* !ASCENSION_NO_MIGEMO */

/// GȐݒԂ
inline const CEditView::TOptions& CEditView::GetOptions() const {
	AssertValid();
	return m_pSharedData->options;
}

/**
 *	XN[ʂ̑΂sA̔䗦Ԃ
 *	@param bHorizontal	XN[o[ɂĒׂꍇ trueBXN[o[̏ꍇ false
 *	@return				䗦
 */
inline ulong CEditView::GetScrollRatio(bool bHorizontal) const {
	AssertValidAsWindow();
	return bHorizontal ? m_scrollInfo.nHorizontalRatio : m_scrollInfo.nVerticalRatio;
}

/// IԂ
inline CSelection& CEditView::GetSelection() const {
	AssertValid();
	return *const_cast<_CSelection*>(m_pSelection);
}

/// eLXgIuWFNgԂ
inline CTextSearcher& CEditView::GetTextSearcher() {
	return m_textSearcher;
}

/**
 *	NCAg̈ɕ\ł񐔂擾
 *	@return	\\ȗ
 */
inline length_t CEditView::GetVisibleCharCount() const {
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();
	RECT						rc;
	GetClientRect(rc);
	if(rc.right - rc.left == 0)
		return 0;
	else
		return (rc.right - rc.left - layout.nLeadMargin
			- layoutManager.GetVerticalRulerWidth()) / layoutManager.GetAverageCharacterWidth();
}

/**
 *	NCAg̈ɕ\łs擾
 *	@return	\\ȍs
 */
inline length_t CEditView::GetVisibleLineCount() const {
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();
	RECT						rc;
	GetClientRect(rc);
	return (rc.bottom - rc.left == 0) ? 0 : (rc.bottom - rc.top - layout.nTopMargin) / layoutManager.GetLineHeight();
}

/// @see	N[
inline bool CEditView::IsCloneOf(const CEditView& rhs) const {
	AssertValid();
	return m_pOriginalView == rhs.m_pOriginalView;
}

/// `擀
inline bool CEditView::IsFreezed() const {
	AssertValid();
	return m_freezeInfo.nCount != 0;
}

/// GUI NCAgҏW\Ԃ
/// @see	CEditView::CheckGuiEditability, CEditView::SetGuiEditability, CEditDoc::IsReadOnly
inline bool CEditView::IsGuiEditable() const {
	AssertValid();
	return m_modeState.bGuiEditable;
}

/// ㏑[hԂ
/// @see	CEditView::SetOvertypeMode
inline bool CEditView::IsOvertypeMode() const {
	AssertValid();
	return m_modeState.bOvertype;
}

/// eLXg̕E獶ł true Ԃ
/// @see	CEditView::SetTextDirection
inline bool CEditView::IsTextDirectionRightToLeft() const {
	AssertValid();
	return m_pSharedData->layoutManager.GetSettings().bRightToLeftReading;
}

/// m_scrollInfo.position.x ŕ\XN[ʒuXN[{bNX̍[̈ʒuɕϊ
inline long CEditView::_MapInternalXToScrollBoxX(long x) const {
	if(!GetLayoutSettings().GetSettings().bRightAlign)	// 
		return x;
	else {
//		AutoZeroCB<SCROLLINFO>	si;
//		si.fMask = SIF_PAGE | SIF_RANGE;
//		GetScrollInfo(SB_HORZ, si);
//		return si.nMax - si.nMin - si.nPage - x + 1;
		const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
		const ulong	nMaxLineWidth = (GetLayoutSettings().GetSettings().wrapMode == WPM_NONE) ?
			layoutManager.GetMaxDisplayWidth() / layoutManager.GetAverageCharacterWidth() : 0;
		return nMaxLineWidth / m_scrollInfo.nHorizontalRatio - 0 - GetVisibleCharCount() - x + 1;
	}
}

/// XN[{bNX̍[̈ʒu m_scrollInfo.position.x ŕ\XN[ʒuɕϊ
inline long CEditView::_MapScrollBoxXToInternalX(long x) const {
	// 2̕ϊ֐͎͓Ƃ̂AĂяöӐ}Ղ悤ɕʁX̊֐ɂĂ
	return _MapInternalXToScrollBoxX(x);
}

/**
 *	CxgXi̍폜
 *	@param eventListener	폜CxgXi
 */
inline void CEditView::RemoveEventListener(IEditViewEventListener& eventListener) {
	AssertValid();
	m_pSharedData->eventListeners.erase(&eventListener);
}

/**
 *	@brief	GUI NCAg̕ҏWF߂邩ݒ肷
 *
 *	GUI NCAg̕ҏWF߂ĂȂƂ
 *	CEditView::ExecuteCommand Ŋ̕ҏWR}heԂł
 *	@see	CEditView::SetGuiEditability, CEditDoc::SetReadOnly
 */
inline void CEditView::SetGuiEditability(bool bGuiEditable) {
	AssertValid();
	m_modeState.bGuiEditable = bGuiEditable;
}

#ifndef ASCENSION_NO_MIGEMO
/**
 *	C/Migemo DLL AfBNg̐ݒ
 *	@param pwsz		fBNgpXBnull ł悢
 *	@param bRuntime	DLL ̏ꍇ trueB̏ꍇ false
 */
inline void CEditView::SetMigemoPath(const WCHAR* pwsz, bool bRuntime) {
	if(pwsz == 0)
		std::wcscpy(bRuntime ? m_wszMigemoRuntimePath : m_wszMigemoDictionaryPath, L"");
	else if(wcslen(pwsz) > MAX_PATH - 1)
		return;
	else
		std::wcscpy(bRuntime ? m_wszMigemoRuntimePath : m_wszMigemoDictionaryPath, pwsz);
}
#endif /* !ASCENSION_NO_MIGEMO */

} // namespace Ascension

#endif /* _EDIT_VIEW_H_ */

/* [EOF] */