// EditView.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include <limits>	// numeric_limit
#include <algorithm>
#include <queue>
#include <zmouse.h>
#include <msctf.h>
#include "../../Manah/win_utils.h"
#include "../../Manah/WaitCursor.h"

using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Windows::GDI;
using namespace Armaiti;
using namespace std;
using Armaiti::OLE::CTextDataObject;


#if 0
namespace {
	// TIS 1566-2541 ɊÂ^C (ƃI) ̓̓V[PX`FbNB
	// Windows ł͕sR (Ql: http://www.nectec.or.th/it-standards/keyboard_layout/thai-key.htm)
	template<bool bThai>
	class CTISSequenceChecker {
	public:
		static bool Check(const char_t* pwsz, length_t i, CodePoint cp) {
			const CharacterClass	followingClass = _GetCharacterClass(cp);

			switch(followingClass) {
			case NON:	case LV:	case CONS:
			case FV1:	case FV2:	case FV3:
			case CTRL:	case INV:
				return true;
			default:
				if(i == 0)
					return false;
				else {
					const CharacterClass	leadingClass = _GetCharacterClass(pwsz[i - 1]);

					switch(followingClass) {
					case BV1:	case BV2:
					case AV1:	case AV2:	case AV3:
					case AD3:	case BD:
						return leadingClass == CONS;
					case AD1:
						return leadingClass == CONS
							|| leadingClass == BV1
							|| leadingClass == AV1;
					case AD2:
						return leadingClass == CONS
							|| leadingClass == AV3;
					case TONE:
						return leadingClass == CONS
							|| leadingClass == BV1
							|| leadingClass == AV1
							|| leadingClass == AV3;
					}
				}
			}
		}
	private:
		enum CharacterClass {	// WTT 2.0 ɂ镶̕
				CTRL,			// 䕶
				NON,			// 񌋍
				CONS,			// q
				LV,				// sꉹ
				FV1, FV2, FV3,	// 㑱ꉹ
				BV1, BV2,		// tꉹ
				BD,				// t敪L
				TONE,			// L
				AD1, AD2, AD3,	// t敪L
				AV1, AV2, AV3,	// tꉹ
				INV				// ȕ
		};
		static CharacterClass _GetCharacterClass(CodePoint cp) {
			if(cp < 0x0020 || cp == 0x007F)					return CTRL;
			else if(cp < 0x80)								return NON;
			else if(bThai && cp >= 0x0E00 && cp < 0x0E60)	return m_classes[cp - 0x0E00];
			else if(!bThai && cp >= 0x0E80 && cp < 0x0EE0)	return m_classes[cp - 0x0E80];
			else											return NON;
		}
		static const CharacterClass m_classes[];
	};

	typedef CTISSequenceChecker<true>	CThaiSequenceChecker;
	typedef CTISSequenceChecker<false>	CLaoSequenceChecker;

	const CThaiSequenceChecker::CharacterClass CThaiSequenceChecker::m_classes[] = {
	/* U+0E00 */	INV,  CONS, CONS, CONS, CONS, CONS, CONS, CONS,
					CONS, CONS, CONS, CONS, CONS, CONS, CONS, CONS,
	/* U+0E10 */	CONS, CONS, CONS, CONS, CONS, CONS, CONS, CONS,
					CONS, CONS, CONS, CONS, CONS, CONS, CONS, CONS,
	/* U+0E20 */	CONS, CONS, CONS, CONS, FV3,  CONS, FV3,  CONS,
					CONS, CONS, CONS, CONS, CONS, CONS, CONS, NON,
	/* U+0E30 */	FV1,  AV2,  FV1,  FV1,  AV1,  AV3,  AV2,  AV3,
					BV1,  BV2,  BD,   INV,  INV,  INV,  INV,  NON,
	/* U+0E40 */	LV,   LV,   LV,   LV,   LV,   FV2,  NON,  AD2,
					TONE, TONE, TONE, TONE, AD1,  AD1,  AD3,  NON,
	/* U+0E50 */	NON,  NON,  NON,  NON,  NON,  NON,  NON,  NON,
					NON,  NON,  NON,  NON,  INV,  INV,  INV,  INV,
	};
	const CLaoSequenceChecker::CharacterClass	CLaoSequenceChecker::m_classes[] = {
	/* U+0E80 */	INV,  CONS, CONS, INV,  CONS, INV,  INV,  CONS,
					CONS, INV,  CONS, INV,  INV,  CONS, INV,  INV,
	/* U+0E90 */	INV,  INV,  INV,  INV,  CONS, CONS, CONS, CONS,
					INV,  CONS, CONS, CONS, CONS, CONS, CONS, CONS,
	/* U+0EA0 */	INV,  CONS, CONS, CONS, INV,  CONS, INV,  CONS,
					INV,  INV,  CONS, CONS, INV,  CONS, CONS, NON,
	/* U+0EB0 */	FV1,  AV2,  FV1,  FV1,  AV1,  AV3,  AV2,  AV3,
					BV1,  BV2,  INV,  ????, ????, ????, INV,  INV,
	/* U+0EC0 */	LV,   LV,   LV,   LV,   LV,   INV,  NON,  INV,
					TONE, TONE, TONE, TONE, AD1,  AD1,  INV,  INV,
	/* U+0ED0 */	NON,  NON,  NON,  NON,  NON,  NON,  NON,  NON,
					NON,  NON,  INV,  INV,  CONS, CONS, INV,  INV,
	};
} // namespace `anonymous'
#endif

namespace {
	/**
	 *	@brief	茾̓̓V[PX̐`FbN
	 *
	 *	ΉĂ錾 InputSequenceCheckLanguage Q
	 *
	 *	xgiɂĂ͓̓P[xgȉꍇ̂݃`FbN
	 *
	 *	@param Language	
	 *	@param pwsz		s
	 *	@param i		͂悤ƂĂʒu
	 *	@param cp		͂悤ƂĂ镶
	 *	@return			V[PX true
	 */
	template<InputSequenceCheckLanguage Language>
	bool CheckCharSequence(const char_t* pwsz, length_t i, CodePoint cp);

	template<> inline bool CheckCharSequence<ISCL_AINU>(const char_t* pwsz, length_t i, CodePoint cp) {
		// \Ȕ_̃yA
		assert(pwsz != 0);
		return cp != 0x309A ||
			(i != 0 && (pwsz[i - 1] == L'Z' || pwsz[i - 1] == L'c' || pwsz[i - 1] == L'g' || pwsz[i - 1] == L'\x31F7'));
	}
	template<> inline bool CheckCharSequence<ISCL_TAMIL>(const char_t* pwsz, length_t i, CodePoint cp);
	template<> inline bool CheckCharSequence<ISCL_THAI>(const char_t* pwsz, length_t i, CodePoint cp) {
		// Uniscribe ۂĂ݂ǁAɂ悭
		assert(pwsz != 0);
		if(cp == 0x0E33) {	// Sara Am
			if(i == 0)
				return false;
			else if(pwsz[i - 1] >= 0x0E01 && pwsz[i - 1] <= 0x0E2F) 
				return true;
			else if(i > 1 && pwsz[i - 1] >= 0x0E48 && pwsz[i - 1] <= 0x0E4E
					&& pwsz[i - 2] >= 0x0E01 && pwsz[i - 2] <= 0x0E2F)
				return true;
			else
				return false;
		} else if((cp >= 0x0E34 && cp <= 0x0E3A) || cp == 0x0E47)	// ꉹ
			return i != 0 && pwsz[i - 1] >= 0x0E01 && pwsz[i - 1] <= 0x0E2F;
		else if(cp >= 0x0E48 && cp <= 0x0E4E) {	// LȂ̌L
			if(i == 0)
				return false;
			else if(pwsz[i - 1] >= 0x0E01 && pwsz[i - 1] <= 0x0E2F)
				return true;
			else if((pwsz[i - 1] >= 0x0E34 && pwsz[i - 1] <= 0x0E3A) || pwsz[i - 1] == 0x0E47)
				return true;
			else
				return false;
		}
		return true;
	}
	template<> inline bool CheckCharSequence<ISCL_VIETNAMESE>(const char_t* pwsz, length_t i, CodePoint cp) {
		assert(pwsz != 0);

		// Ǝ̃XNvgȂ߁A̓P[xgiłȂƂ̓`FbNȂ
		if(PRIMARYLANGID(LOWORD(::GetKeyboardLayout(::GetCurrentThreadId()))) != LANG_VIETNAMESE)
			return true;

		// xgi̕uNIbNEO[vł12̕ꉹA5̐LȂ̎qgB
		// ł͐L̓͂ <1̕ꉹ>+<1ȉ̐L>
		// Ƃp^[ɖĂȂ𒲂ׂB
		// ڍׂ http://www.asahi-net.or.jp/~ez3k-msym/charsets/cjk-v.htm Q
		// (Uniscribe Ɠꉹ̏ꍇ͖)
		static const CodePoint	vowels[] = {
			L'A', L'E', L'I', L'O', L'U', L'Y',
			L'a', L'e', L'i', L'o', L'u', L'y',
			0x00C2, 0x00CA, 0x00D4, 0x00E2, 0x00EA, 0x00F4,
			0x0102, 0x0103, 0x01A0, 0x01A1, 0x01AF, 0x01B0,
		};
		static const CodePoint	toneMarks[] = {0x0300, 0x0301, 0x0303, 0x309, 0x0323};

		if(i != 0 && binary_search(toneMarks, _endof(toneMarks), cp))
			return binary_search(vowels, _endof(vowels), pwsz[i - 1]);
		return true;
	}
} // namespace `anonymous'

// Lbgprbg}bv̍쐬
namespace {
	inline BITMAPINFO* _PrepareCaretBitmap(HDC hDC, ushort nWidth, ushort nHeight) {
		BITMAPINFO*			pbi = get_temporary_buffer<BITMAPINFO>(
			sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * nWidth * nHeight).first;
		BITMAPINFOHEADER&	header = pbi->bmiHeader;

		memset(&header, 0, sizeof(BITMAPINFOHEADER));
		header.biSize = sizeof(BITMAPINFOHEADER);
		header.biWidth = nWidth;
		header.biHeight = -nHeight;
		header.biBitCount = sizeof(RGBQUAD) * 8;//::GetDeviceCaps(hDC, BITSPIXEL);
		header.biPlanes = ::GetDeviceCaps(hDC, PLANES);

		return pbi;
	}
	inline HBITMAP _CreateSolidCaretBitmap(ushort nWidth, ushort nHeight, const RGBQUAD& color) {
		HDC			hDC = ::GetDC(0);
		BITMAPINFO*	pbi = _PrepareCaretBitmap(hDC, nWidth, nHeight);

		uninitialized_fill(pbi->bmiColors, pbi->bmiColors + nWidth * nHeight, color);
		HBITMAP	hBitmap = ::CreateDIBitmap(hDC, &pbi->bmiHeader, CBM_INIT, &pbi->bmiColors, pbi, DIB_RGB_COLORS);
		return_temporary_buffer<BITMAPINFO>(pbi);
		::ReleaseDC(0, hDC);

		return hBitmap;
	}
	inline HBITMAP _CreateRtlCaretBitmap(ushort nHeight, bool bThin, const RGBQUAD& color) {
		HDC				hDC = ::GetDC(0);
		const RGBQUAD	white = {0x00, 0x00, 0x00, 0x00};
		BITMAPINFO*		pbi = _PrepareCaretBitmap(hDC, 5, nHeight);

		assert(nHeight > 3);
		uninitialized_fill(pbi->bmiColors, pbi->bmiColors + 5 * nHeight, white);
		pbi->bmiColors[0] = color;
		pbi->bmiColors[1] = color;
		pbi->bmiColors[2] = color;
		pbi->bmiColors[6] = color;
		pbi->bmiColors[7] = color;
		pbi->bmiColors[12] = color;
		for(ushort i = 0; i < nHeight; ++i) {
			pbi->bmiColors[i * 5 + 3] = color;
			if(!bThin)	pbi->bmiColors[i * 5 + 4] = color;
		}
		HBITMAP	hBitmap = ::CreateDIBitmap(hDC, &pbi->bmiHeader, CBM_INIT, &pbi->bmiColors, pbi, DIB_RGB_COLORS);
		return_temporary_buffer<BITMAPINFO>(pbi);
		::ReleaseDC(0, hDC);

		return hBitmap;
	}
	inline HBITMAP _CreateThaiLaoCaretBitmap(ushort nHeight, bool bThin, const RGBQUAD& color) {
		HDC				hDC = ::GetDC(0);
		const RGBQUAD	white = {0x00, 0x00, 0x00, 0x00};
		const ushort	nWidth = max(nHeight / 8, 3);
		BITMAPINFO*		pbi = _PrepareCaretBitmap(hDC, nWidth, nHeight);

		assert(nHeight > 3);
		uninitialized_fill(pbi->bmiColors, pbi->bmiColors + nWidth * nHeight, white);
		for(ushort y = 0; y < nHeight - 1; ++y) {
			pbi->bmiColors[y * nWidth] = color;
			if(!bThin)	pbi->bmiColors[y * nWidth + 1] = color;
		}
		if(!bThin)
			for(ushort x = 2; x < nWidth; ++x)	pbi->bmiColors[nWidth * (nHeight - 2) + x] = color;
		for(ushort x = 0; x < nWidth; ++x)	pbi->bmiColors[nWidth * (nHeight - 1) + x] = color;
		HBITMAP	hBitmap = ::CreateDIBitmap(hDC, &pbi->bmiHeader, CBM_INIT, &pbi->bmiColors, pbi, DIB_RGB_COLORS);
		return_temporary_buffer<BITMAPINFO>(pbi);
		::ReleaseDC(0, hDC);

		return hBitmap;
	}
} // namespace `anonymous'


// CClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CClipboardRing::CClipboardRing() : m_nLimit(16), m_nMaxByte(100 * 1024), m_iActive(static_cast<SizeType>(-1)) {
}

/**
 *	VeLXgǉB𒴂ꍇ͌Â̂폜
 *	@param strText	VeLXgB1ȏ
 *	@param bBox		`f[^
 */
void CClipboardRing::Add(const string_t& strText, bool bBox) {
	AssertValid();
	assert(!strText.empty());

	if(strText.length() * sizeof(char_t) > m_nMaxByte) {
		for_each(m_eventListeners.begin(), m_eventListeners.end(),
			mem_fun(&CClipboardRing::IEventListener::OnClipboardRingDeniedAdding));
//		for(set<CClipboardRing::IEventListener*>::iterator it
//				= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//			(*it)->OnClipboardRingDeniedAdding();
		return;
	}

	TClipText	ct;
	ct.strText = strText;
	ct.bBox = bBox;
	m_datas.push_front(ct);
	if(m_datas.size() > m_nLimit)
		m_datas.pop_back();
	m_iActive = 0;
	for_each(m_eventListeners.begin(), m_eventListeners.end(),
		mem_fun(&CClipboardRing::IEventListener::OnClipboardRingChanged));
//	for(set<CClipboardRing::IEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnClipboardRingChanged();
}

/**
 *	CxgXi̒ǉ
 *	@param eventListener	ǉCxgXi
 */
void CClipboardRing::AddEventListener(CClipboardRing::IEventListener& eventListener) {
	AssertValid();
	m_eventListeners.insert(&eventListener);
}

/**
 *	w肵eLXg폜
 *	@param iText				폜eLXg̈ʒu
 *	@throw std::out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::Delete(SizeType iText) throw(out_of_range) {
	AssertValid();
	if(iText >= m_datas.size())
		throw out_of_range("Specified index is out of range.");

	list<TClipText>::iterator	it = m_datas.begin();
	for(SizeType i = 0; i < iText; ++i, ++it);
	m_datas.erase(it);
	if(iText == m_datas.size() && iText == m_iActive)
		--m_iActive;

	for_each(m_eventListeners.begin(), m_eventListeners.end(),
		mem_fun(&CClipboardRing::IEventListener::OnClipboardRingChanged));
//	for(set<CClipboardRing::IEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnClipboardRingChanged();
}

/// SẴeLXg폜
void CClipboardRing::DeleteAll() {
	AssertValid();
	m_datas.clear();
	for_each(m_eventListeners.begin(), m_eventListeners.end(),
		mem_fun(&CClipboardRing::IEventListener::OnClipboardRingChanged));
//	for(set<CClipboardRing::IEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnClipboardRingChanged();
}

///	ANeBuȃeLXg̈ʒuԂ
/// (eLXg1ꍇÃ\bh͈Ӗ̂lԂȂ)
CClipboardRing::SizeType CClipboardRing::GetActiveItem() const {
	AssertValid();
	return m_iActive;
}

/// eLXg̑Ԃ
CClipboardRing::SizeType CClipboardRing::GetCount() const {
	AssertValid();
	return m_datas.size();
}

/**
 *	w肵ʒũeLXgԂ
 *	@param iText				擾eLXg̈ʒu
 *	@param strText				eLXg
 *	@param bBox					`f[^
 *	@throw std::out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::GetText(SizeType iText, string_t& strText, bool& bBox) const throw(out_of_range) {
	AssertValid();
	if(iText >= m_datas.size())
		throw out_of_range("Specified index is out of range.");

	list<TClipText>::const_iterator	it = m_datas.begin();
	for(SizeType i = 0; i < iText; ++i, ++it);

	strText = it->strText;
	bBox = it->bBox;
}

/**
 *	eLXg̏ݒ肷Bꂽ͍폜
 *	@param nLimit	VlB0ȊO
 */
void CClipboardRing::LimitCount(SizeType nLimit) {
	AssertValid();
	assert(nLimit > 0);

	m_nLimit = nLimit;
	if(m_datas.size() > m_nLimit) {
		m_datas.resize(m_nLimit);
		for_each(m_eventListeners.begin(), m_eventListeners.end(),
			mem_fun(&CClipboardRing::IEventListener::OnClipboardRingChanged));
//		for(set<CClipboardRing::IEventListener*>::iterator it
//				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//			(*it)->OnClipboardRingChanged();
	}
}

/**
 *	CxgXi̍폜
 *	@param eventListener			폜CxgXi
 *	@throw std::invalid_argument	<var>eventListener</var> CxgXiƂēo^ĂȂ΃X[
 */
void CClipboardRing::RemoveEventListener(CClipboardRing::IEventListener& eventListener) throw(invalid_argument) {
	AssertValid();

	set<CClipboardRing::IEventListener*>::iterator	it = m_eventListeners.find(&eventListener);
	if(it == m_eventListeners.end())
		throw invalid_argument("Specified listener is not registered.");
	m_eventListeners.erase(it);
}

/**
 *	ANeBuȃeLXg̐ݒ
 *	@param iText				ANeBuɂeLXg̈ʒu
 *	@throw std::out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::SetActiveItem(SizeType iText) throw(out_of_range) {
	AssertValid();
	if(iText >= m_datas.size())
		throw out_of_range("Specified index is out of range.");
	m_iActive = iText;
}


// CAutoScrollOriginMark class implementation
/////////////////////////////////////////////////////////////////////////////

const long	CAutoScrollOriginMark::m_nWidth = 28;

/**
 *	EBhE̍쐬
 *	@param view	Ώۃr[
 *	@see		CWindow::Create
 */
bool CAutoScrollOriginMark::Create(const CEditView& view) {
	HINSTANCE	hInstance = reinterpret_cast<HINSTANCE>(view.GetWindowLong(GWL_HINSTANCE));
	RECT		rc = {0, 0, m_nWidth + 1, m_nWidth + 1};

	if(!Controls::CCustomControl<CAutoScrollOriginMark>::Create(view,
			rc, 0, WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_POPUP, WS_EX_TOOLWINDOW))
		return false;
	ModifyStyleEx(0, WS_EX_LAYERED);	// Ȃ CreateWindowEx(WS_EX_LAYERED) Ƃ NT 4.0 Ŏs

	HRGN	hRgn = ::CreateEllipticRgn(0, 0, m_nWidth + 1, m_nWidth + 1);
	SetWindowRgn(hRgn, false);
	::DeleteObject(hRgn);
	SetLayeredWindowAttributes(::GetSysColor(COLOR_WINDOW), 0, LWA_COLORKEY);

	return true;
}

/// @see	CWindow::OnPaint
void CAutoScrollOriginMark::OnPaint(CPaintDC& dc) {
	const COLORREF	color = ::GetSysColor(COLOR_APPWORKSPACE);
	HPEN	hPen = ::CreatePen(PS_SOLID, 1, color), hOldPen = dc.SelectObject(hPen);
	HBRUSH	hBrush = ::CreateSolidBrush(color), hOldBrush = dc.SelectObject(hBrush);
	POINT	points[4];

	points[0].x = 13; points[0].y = 3;
	points[1].x = 7; points[1].y = 9;
	points[2].x = 20; points[2].y = 9;
	points[3].x = 14; points[3].y = 3;
	dc.Polygon(points, 4);

	points[0].x = 13; points[0].y = 24;
	points[1].x = 7; points[1].y = 18;
	points[2].x = 20; points[2].y = 18;
	points[3].x = 14; points[3].y = 24;
	dc.Polygon(points, 4);

	dc.MoveTo(13, 12); dc.LineTo(15, 12);
	dc.MoveTo(12, 13); dc.LineTo(16, 13);
	dc.MoveTo(12, 14); dc.LineTo(16, 14);
	dc.MoveTo(13, 15); dc.LineTo(15, 15);

	dc.SelectObject(hOldPen);
	dc.SelectObject(hOldBrush);
	::DeleteObject(hPen);
	::DeleteObject(hBrush);
}


// CAbbreviations class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CAbbreviations::CAbbreviations() : m_cchMaxAbbreviation(0) {
}

/// w肵ZkWJԂBo^ĂȂ΋󕶎Ԃ
string_t CAbbreviations::Expand(const string_t& strAbbreviation) const {
	map<string_t, string_t>::const_iterator	it = m_abbreviations.find(strAbbreviation);
	return (it != m_abbreviations.end()) ? it->second : L"";
}

/// o^ĂZk̃XgԂ
void CAbbreviations::GetList(set<string_t>& abbreviations) const {
	for(map<string_t, string_t>::const_iterator it = m_abbreviations.begin(); it != m_abbreviations.end(); ++it)
		abbreviations.insert(it->first);
}

/**
 *	Zko^B̂̂͏㏑
 *	@param strAbbreviation			Zk
 *	@param strExpanded				WJ̕
 *	@throw std::invalid_argument	ꂩ̈󕶎̂ƂX[
 */
void CAbbreviations::Register(const string_t& strAbbreviation, const string_t& strExpanded) throw(invalid_argument) {
	map<string_t, string_t>::iterator	it = m_abbreviations.find(strAbbreviation);
	if(it != m_abbreviations.end())
		m_abbreviations.erase(it);
	m_abbreviations.insert(make_pair(strAbbreviation, strExpanded));
	m_cchMaxAbbreviation = max(strAbbreviation.length(), m_cchMaxAbbreviation);
}

/// w肵Zk폜
void CAbbreviations::Revoke(const string_t& strAbbreviation) {
	if(m_abbreviations.erase(strAbbreviation) != 0) {
		if(m_abbreviations.empty())
			m_cchMaxAbbreviation = 0;
		else if(strAbbreviation.length() == m_cchMaxAbbreviation) {
			for(map<string_t, string_t>::const_iterator it = m_abbreviations.begin(); it != m_abbreviations.end(); ++it)
				m_cchMaxAbbreviation = max(strAbbreviation.length(), m_cchMaxAbbreviation);
		}
	}
}

/// o^ĂSĂ̒Zk폜
void CAbbreviations::RevokeAll() {
	m_abbreviations.clear();
}


// CEditView class implementation
/////////////////////////////////////////////////////////////////////////////

// ÓIo
CClipboardRing			CEditView::m_clipboardRing;
CTextSearcher			CEditView::m_textSearcher;
CIncrementalSearcher	CEditView::m_incrementalSearcher;
CAbbreviations			CEditView::m_abbreviations;
#ifndef ASCENSION_NO_MIGEMO
WCHAR					CEditView::m_wszMigemoRuntimePath[MAX_PATH] = L"";
WCHAR					CEditView::m_wszMigemoDictionaryPath[MAX_PATH] = L"";
#endif /* !ASCENSION_NO_MIGEMO */

/// RXgN^
CEditView::CEditView(CEditDoc& document) : _BaseView(document), m_pwszTipText(0),
		m_pAutoScrollOriginMark(0), m_pClones(new set<CEditView*>), m_bActiveImeComposition(false),
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
		m_hLineBitmap(0), m_hOldLineBitmap(0),
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */
		m_leftDownMode(LDM_NONE), m_nextCharVariation(NCV_NONE),
		m_nMouseOperationDisabledCount(0), m_iFirstVisibleLine(0) {
	GetDocument().AddView(*this);
	m_pSelection = new _CSelection(*this);
	m_pOriginalView = this;	// C4345 (VC7)
	m_pDragging = new CTextDataObject(this);
	m_pDragging->AddRef();
	m_pCompletionWindow = new CCompletionWindow(*this);
	m_pSharedData = new _TSharedData(*this);
	m_pBoundarySearcher = new CBoundarySearcher(GetDocument(), GetLexer());

	m_pSharedData->layoutManager.AddEventListener(*this);
	m_freezeInfo.nCount = 0;
	m_posHilightedBrackets[0] = m_posHilightedBrackets[1] = CCharPos(-1, -1);
	m_lastOperation.type = TEditOperation::NONE;
}

/// Rs[RXgN^
CEditView::CEditView(const CEditView& rhs) : _BaseView(rhs), m_pwszTipText(0)
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
		, m_hLineBitmap(0), m_hOldLineBitmap(0)
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */
{
	GetDocument().AddView(*this);

	// 񋤗Lo͎ō쐬BLo̓Rs[
	m_pSelection = new _CSelection(*this);
	m_pDragging = new CTextDataObject(this);
	m_pDragging->AddRef();
	m_pCompletionWindow = new CCompletionWindow(*this);

	m_pOriginalView = rhs.m_pOriginalView;
	m_pOriginalView->m_pClones->insert(this);
	m_pSharedData = rhs.m_pSharedData;
	m_pBoundarySearcher = new CBoundarySearcher(GetDocument(), GetLexer());

	m_modeState = rhs.m_modeState;

	m_bActiveImeComposition = false;
	m_leftDownMode = LDM_NONE;
	m_nextCharVariation = NCV_NONE;
	m_nMouseOperationDisabledCount = 0;
	m_pSharedData->layoutManager.AddEventListener(*this);
	m_freezeInfo.nCount = 0;
	m_posHilightedBrackets[0] = m_posHilightedBrackets[1] = CCharPos(-1, -1);
	m_iFirstVisibleLine = rhs.m_iFirstVisibleLine;
}

/// fXgN^
CEditView::~CEditView() {
	m_pSharedData->layoutManager.RemoveEventListener(*this);

	// 񋤗Lf[^
	delete m_pSelection;
	delete[] m_pwszTipText;
	delete m_pBoundarySearcher;
	m_pDragging->Release();
	delete m_pCompletionWindow;
	delete m_pAutoScrollOriginMark;

	// L
	if(m_pOriginalView == this) {	// 
		if(m_pClones->empty()) {	// Ō
			delete m_pSharedData;	// ŋLf[^j
			delete m_pClones;		// N[̃Xgj
		} else {	// ̕܂cĂ
			CEditView*	pNewOriginal = *m_pClones->begin();	// V
			m_pClones->erase(m_pClones->begin());
			pNewOriginal->m_pOriginalView = pNewOriginal;
			pNewOriginal->m_pClones = m_pClones;
			for(set<CEditView*>::iterator it =
					pNewOriginal->m_pClones->begin(); it != pNewOriginal->m_pClones->end(); ++it) {
				if(*it != pNewOriginal)
					(*it)->m_pOriginalView = pNewOriginal;
			}
		}
	} else {	// IWiɎSʒm
		set<CEditView*>::iterator	it = m_pOriginalView->m_pClones->find(this);
		assert(it != m_pOriginalView->m_pClones->end());
		m_pOriginalView->m_pClones->erase(it);
	}
}

/// r[v炷ȂǂďsƂʒm
/// @see	CEditView::CheckGuiEditability
void CEditView::Beep() {
	if(m_pSharedData->options.appearance[BEEP_ON_SOME_FAILURE])
		::MessageBeep(MB_OK);
}

/// XN[̊Jn
void CEditView::BeginAutoScroll() {
	AssertValidAsWindow();

	if(GetFocus() != m_hWnd || GetDocument().GetLineCount() <= GetVisibleLineCount())
		return;

	RECT	rect;
	POINT	pt;

	m_pAutoScrollOriginMark->GetWindowRect(rect);
	::GetCursorPos(&pt);
	m_autoScroll.indicatorPosition = pt;
	ScreenToClient(m_autoScroll.indicatorPosition);
	m_pAutoScrollOriginMark->SetWindowPos(HWND_TOP,
		pt.x - (rect.right - rect.left) / 2, pt.y - (rect.bottom - rect.top) / 2,
		0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_SHOWWINDOW);
	m_autoScroll.bScrolling = true;
	SetCapture();
	SetTimer(TIMERID_AUTOSCROLL, 0, 0);
}

/**
 *	@brief	w肵z|CgɒB̂ɍs̖ɒǉKv̂󔒕Ԃ
 *
 *	s̏I[łɉz|Cg𒴂Ăꍇ͋󕶎ԂB
 *	`\tt[J[\̎Ɏgp
 *	@param iLine	sԍ (\s)
 *	@param xVirtual	s̍[̈ʒu
 *	@return			Kvȋ󔒕B^u (U+0009) Ɣp (U+0020) ݂̂ō\
 */
string_t CEditView::CalculateSpacesReachingVirtualPoint(length_t iLine, ulong xVirtual) const {
	AssertValidAsWindow();

	const CLineLayoutManager&	layout = m_pSharedData->layoutManager;
	ulong	x = layout.GetLine(iLine).GetWidth();

	if(x >= xVirtual)	// łɒĂ -> I
		return L"";

	stringstream_t	spaces;
	CClientDC		dc = const_cast<CEditView*>(this)->GetDC();
	HFONT			hOldFont = dc.SelectObject(layout.GetRegularFont());
	const long		nSpaceWidth = dc.GetTextExtent(L" ", 1).cx;

	dc.SelectObject(hOldFont);

	while(true) {	// xVirtual 𒴂܂Ő^utĂ
		const ulong	xNextTab = layout.GetNextTabStop(x, true);	// TODO: 肠

		if(xNextTab >= xVirtual)
			break;
		spaces << L'\t';
		x = xNextTab;
	}
	while(x + nSpaceWidth <= xVirtual) {	// xVirtual 𒴂܂ŔpXy[XtĂ
		spaces << L' ';
		x += nSpaceWidth;
	}

	return spaces.str();
}

/**
 *	NCAgWł߂sƕʒu (_l) 擾
 *	@param pt				NCAgW
 *	@param bIgnoreExtenders	Lbg󂯎Ȃ𖳎B
 *							TQ[g͏ɍl
 *	@param pbTruncated		[out] <var>pt</var> LȈʒuɐ؂l߂ꂽꍇ
 *							true (null w肷Ɩ)
 *	@return					ł߂ʒuB̌ʂ̓i[CỎe󂯂
 */
CCharPos CEditView::CharFromPos(const POINT& pt, bool bIgnoreExtenders, bool* pbTruncated /* = 0 */) const {
	AssertValidAsWindow();

	CCharPos		pos;
	const char_t*	pszLine = 0;
//	const length_t	cLines = GetDocument().GetLineCount();
	const CEditDoc&				document = GetDocument();
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = GetLayoutSettings().GetSettings();

	if(pbTruncated != 0)
		*pbTruncated = false;

	// s̊m
	if(pt.y <= static_cast<long>(layout.nTopMargin)
			&& static_cast<ulong>(layout.nTopMargin - pt.y) / layoutManager.GetLineHeight() > m_scrollInfo.GetY()) {
		pos.m_iLine = 0;
		if(pbTruncated != 0)
			*pbTruncated = true;
	} else {
		pos.m_iLine = m_scrollInfo.GetY() +
			static_cast<long>(pt.y - layout.nTopMargin) / static_cast<long>(layoutManager.GetLineHeight());
		if(pt.y < static_cast<long>(layout.nTopMargin) && pos.m_iLine > 0)
			pos.m_iLine -= 1;
	}
/*	if(pos.m_iLine < m_scrollInfo.GetY()) {
		pos.m_iLine = m_scrollInfo.GetY();
		if(pbTruncated != 0)
			*pbTruncated = true;
	} else if(pos.m_iLine >= m_scrollInfo.GetY() + GetVisibleLineCount()) {
		pos.m_iLine = m_scrollInfo.GetY() + GetVisibleLineCount() - 1;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}
*/	if(pos.m_iLine < document.GetStartPoint().m_iLine) {
		pos.m_iLine = document.GetStartPoint().m_iLine;
		if(pbTruncated != 0)
			*pbTruncated = true;
	} else if(pos.m_iLine > document.GetEndPoint().m_iLine) {
		pos.m_iLine = document.GetEndPoint().m_iLine;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}

	// ̊m
	const long	nMarginWidth = layout.nLeadMargin + layoutManager.GetVerticalRulerWidth();
	RECT		rcClient;
	if(layoutManager.GetSettings().bRightAlign)
		GetClientRect(rcClient);
	if((!layoutManager.GetSettings().bRightAlign && pt.x > nMarginWidth)
			|| (layoutManager.GetSettings().bRightAlign && pt.x < rcClient.right - rcClient.left - nMarginWidth))
		pos.m_iChar = _MapAbsoluteXToCharacter(pos.m_iLine,
			_MapClientXToAbsoluteX(pt.x, layoutManager.GetLine(pos.m_iLine).GetWidth()),
			bIgnoreExtenders, (pbTruncated != 0 && *pbTruncated) ? 0 : pbTruncated);
	else {
		pos.m_iChar = _MapAbsoluteXToCharacter(pos.m_iLine,
			_MapClientXToAbsoluteX(!layoutManager.GetSettings().bRightAlign ?
				nMarginWidth : rcClient.right - rcClient.left - nMarginWidth,
				layoutManager.GetLine(pos.m_iLine).GetWidth()),
			bIgnoreExtenders, (pbTruncated != 0 && *pbTruncated) ? 0 : pbTruncated);
		if(pbTruncated != 0)
			*pbTruncated = true;
	}
	if(document.IsNarrowed()) {
		if(pos.m_iLine == document.GetStartPoint().m_iLine)
			pos.m_iChar = max(document.GetStartPoint().m_iChar, pos.m_iChar);
		if(pos.m_iLine == document.GetEndPoint().m_iLine)
			pos.m_iChar = min(document.GetEndPoint().m_iChar, pos.m_iChar);
	}

	return LogicalCharFromDisplayChar(pos);
}

/// wʒuRgptłΐ^Ԃ
/// TODO: TT_OTHERQUOTATION Ή
bool CEditView::CharIsInCommentOrQuotation(const CCharPos& pos) const {
	AssertValid();

	// g[N1݂Ȃsł͒߂̂ݒׂďI
	if(GetDocument().GetLineLength(pos.m_iLine) == 0)
		return m_pSharedData->layoutManager.GetLine(pos.m_iLine).GetMultilineAnnotationStatus(false) != NullCookie;

	const length_t	cchLine = GetDocument().GetLineLength(pos.m_iLine);
	const Tokens&	tokens = m_pSharedData->layoutManager.GetLine(pos.m_iLine).GetTokens();
	int				type;

	// pos s̏ꍇ
	type = tokens.array[tokens.count - 1].GetType();
	if(type == TT_ANNOTATION) {
		if(pos.m_iChar == GetDocument().GetLineLength(pos.m_iLine))
			return true;	// 肠
//			return pLine->GetMultilineCommentStatus(true) != NullCookie;
	} else if(type == TT_DOUBLEQUOTATION || type == TT_SINGLEQUOTATION) {
		const string_t&	strLine = GetDocument().GetLine(pos.m_iLine);
		if(pos.m_iChar == strLine.length()) {
			if(cchLine - tokens.array[tokens.count - 1].GetIndex() == 1)
				return true;
			return (type == TT_DOUBLEQUOTATION
					&& strLine[pos.m_iChar - 1] == L'\"'
					&& strLine[pos.m_iChar - 2] == L'\\')
				|| (type == TT_SINGLEQUOTATION
					&& strLine[pos.m_iChar - 1] == L'\''
					&& strLine[pos.m_iChar - 2] == L'\\');
		}
	}

	for(size_t iToken = 0; iToken < tokens.count; ++iToken) {
		const CToken&	token = tokens.array[iToken];

		if(pos.m_iChar >= token.GetIndex()) {	// '=' ܂߂邩ǂ͔
			const length_t	iNext = (iToken < tokens.count - 1) ?
										tokens.array[iToken + 1].GetIndex() : cchLine;
			if(pos.m_iChar < iNext) {
				type = token.GetType();
				return type == TT_ANNOTATION
					|| type == TT_DOUBLEQUOTATION
					|| type == TT_SINGLEQUOTATION;
			}
		}
	}
	return false;
}

/// GUI [U̕ҏW\ԂA\łȂꍇ
/// CEditView::Beep ̌ĂяoƃCxgXi IEditViewEventListener::OnDeniedGuiCommand Ăяo
/// @see	CEditView::IsGuiEditable
bool CEditView::CheckGuiEditability() {
	if(IsGuiEditable())
		return true;
	Beep();
	_FOR_EACH_LISTENERS()
		(*it)->OnDeniedGuiCommand();
	return false;
}

/**
 *	@brief	ANeBu|Cg̕ʂł΋\
 *
 *	̃\bh͑Ίʂ̌Aĕ`AO܂ŋ\ĂΊʂ̖ȂǑSčsB
 *	i[COŃANZXs\ɂȂeLXg̊ʂ͑SĖ
 */
void CEditView::CheckMatchBrackets() {
	set<IEditViewEventListener*>::iterator	it;

#define FIRE_FOUND(pos)											\
	for(it = m_pSharedData->eventListeners.begin();				\
			it != m_pSharedData->eventListeners.end(); ++it)	\
		(*it)->OnMatchBracketFoundOutOfView(pos)
#define FIRE_NOT_FOUND()										\
	for(it = m_pSharedData->eventListeners.begin();				\
			it != m_pSharedData->eventListeners.end(); ++it)	\
		(*it)->OnMatchBracketFoundOutOfView(CCharPos(-1, -1))

	AssertValidAsWindow();

	if(m_pSharedData->layoutManager.IsTokenEnabled(ETT_MATCH_BRACKETS)
			&& m_pSelection->IsEmpty()
			&& !CharIsInCommentOrQuotation(m_pSelection->GetActivePoint())) {
		const CCharPos	posLast0 = m_posHilightedBrackets[0];
		const CCharPos	posLast1 = m_posHilightedBrackets[1];
		const CCharPos	posActive = m_pSelection->GetActivePoint();
		const CCharPos	posAnchor = m_pSelection->GetAnchorPoint();

		// () ΊʂT
		CCharPos	posBracket;
		bool		bFound;
		if(bFound = FindMatchBracket(posActive, posBracket, true)) {
			m_posHilightedBrackets[0] = posActive;
			m_posHilightedBrackets[1] = posBracket;
		} else if(posActive.m_iChar != 0	// 1Oׂ
				&& (bFound = FindMatchBracket(CCharPos(posActive.m_iLine, posActive.m_iChar - 1), posBracket, true))) {
			m_posHilightedBrackets[0] = CCharPos(posActive.m_iLine, posActive.m_iChar - 1);
			m_posHilightedBrackets[1] = posBracket;
		}
		if(bFound) {	// ꍇ
			InvalidateLine(m_posHilightedBrackets[0].m_iLine);
			if(!IsFreezed())
				UpdateWindow();
			if(m_posHilightedBrackets[0].m_iLine != m_posHilightedBrackets[1].m_iLine) {
				InvalidateLine(m_posHilightedBrackets[1].m_iLine);
				if(!IsFreezed())
					UpdateWindow();
			}
			if(posLast0 != CCharPos(-1, -1)
					&& posLast0.m_iLine != m_posHilightedBrackets[0].m_iLine
					&& posLast0.m_iLine != m_posHilightedBrackets[1].m_iLine) {
				InvalidateLine(posLast0.m_iLine);
				if(!IsFreezed())
					UpdateWindow();
			}
			if(posLast1 != CCharPos(-1, -1)
					&& posLast1.m_iLine != m_posHilightedBrackets[0].m_iLine
					&& posLast1.m_iLine != m_posHilightedBrackets[1].m_iLine
					&& posLast1.m_iLine != posLast0.m_iLine)
				InvalidateLine(posLast1.m_iLine);
			FIRE_NOT_FOUND();

			const CCharPos	posDisplay = DisplayCharFromLogicalChar(m_posHilightedBrackets[1]);
			const length_t	cVisibleLines = GetVisibleLineCount();
			if((posDisplay.m_iLine < m_scrollInfo.GetY())	// ʂ
					|| (posDisplay.m_iLine - m_scrollInfo.GetY() > cVisibleLines - 1))	// ʂ艺
				FIRE_FOUND(m_posHilightedBrackets[1]);
		} else if(posLast0 != CCharPos(-1, -1)) {	// Ȃꍇ -> O񕪂
			m_posHilightedBrackets[0] = m_posHilightedBrackets[1] = CCharPos(-1, -1);
			InvalidateLine(posLast0.m_iLine);
			if(!IsFreezed())
				UpdateWindow();
			if(posLast0.m_iLine != posLast1.m_iLine)
				InvalidateLine(posLast1.m_iLine);
			FIRE_NOT_FOUND();
		}
	} else if(m_posHilightedBrackets[0] != CCharPos(-1, -1)) {	// O񕪂邾
		const length_t	iLastLine0 = m_posHilightedBrackets[0].m_iLine;
		const length_t	iLastLine1 = m_posHilightedBrackets[1].m_iLine;

		m_posHilightedBrackets[0] = m_posHilightedBrackets[1] = CCharPos(-1, -1);
		InvalidateLine(iLastLine0);
		if(!IsFreezed())
			UpdateWindow();
		if(iLastLine0 != iLastLine1)
			InvalidateLine(iLastLine1);
		FIRE_NOT_FOUND();
	}
#undef FIRE_FOUND
#undef FIRE_NOT_FOUND
}

/// ⊮EBhE
void CEditView::CloseCompletionWindow() {
	if(m_pCompletionWindow->IsRunning())
		m_pCompletionWindow->Abort();
}

/**
 *	ʒu瑊ԍ擾
 *	@param pos	ʒu
 *	@return		ԍ
 */
length_t CEditView::ColumnFromChar(const CCharPos& pos) const {
	AssertValid();

	const length_t		iLine = min(pos.m_iLine, GetDocument().GetLineCount() - 1);
	const length_t		iChar = min<length_t>(pos.m_iChar, GetDocument().GetLineLength(iLine));
	const CLineLayout&	layout = m_pSharedData->layoutManager.GetLine(iLine);

	return layout.GetCaretPosition(iChar) / m_pSharedData->layoutManager.GetAverageCharacterWidth();
}

/**
 *	ϊBANZgt͂ƂȂǂɎg
 *	@param wch	ϊ镶
 *	@param ncv	ϊ̎
 */
char_t CEditView::ConvertCharacter(char_t wch, NextCharVariation ncv) {
#define MAP_CH(x, y)	case (x): return (y)

#if ASCENSION_UNICODE_VERSION != 0x0410
#error This implementation is based on old version of Unicode.
#endif

	// .::.
	// ̕ϊK͒PɃR[h|Cg̖O琶ĂB
	// Ⴆ "A With Acute" ł A ɉsANZg{ēR[h|CgƂB
	// extender ݂ꍇ͖ȌdvŁA"A With X And Y" ł
	// "A With X"  Y {ēR[h|Cg邪A
	// "A With Y"  X {ꍇ "A With Y And X" ̂ƂB
	// (ȑO͏𖳎Ă߁AʂɏdB)
	if(ncv == NCV_NONE)
		return wch;
	else if(ncv == NCV_GRAVE) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C0);	MAP_CH(0x0061, 0x00E0);	// A
		MAP_CH(0x0045, 0x00C8);	MAP_CH(0x0065, 0x00E8);	// E
		MAP_CH(0x0049, 0x00CC);	MAP_CH(0x0069, 0x00EC);	// I
		MAP_CH(0x004F, 0x00D2);	MAP_CH(0x006F, 0x00F2);	// O
		MAP_CH(0x0055, 0x00D9);	MAP_CH(0x0075, 0x00F9);	// U
		MAP_CH(0x00DC, 0x01DB);	MAP_CH(0x00FC, 0x01DC);	// U With Diaeresis
		MAP_CH(0x004E, 0x01F8);	MAP_CH(0x006E, 0x01F9);	// N
		MAP_CH(0x0415, 0x0400);	MAP_CH(0x0435, 0x0450);	// Cyrillic Ie
		MAP_CH(0x0418, 0x040D);	MAP_CH(0x0438, 0x045D);	// Cyrillic I
		MAP_CH(0x0112, 0x1E14);	MAP_CH(0x0113, 0x1E15);	// E With Macron
		MAP_CH(0x014C, 0x1E50);	MAP_CH(0x014D, 0x1E51);	// O With Macron
		MAP_CH(0x0057, 0x1E80);	MAP_CH(0x0077, 0x1E81);	// W
		MAP_CH(0x00C2, 0x1EA6);	MAP_CH(0x00E2, 0x1EA7);	// A With Circumflex
		MAP_CH(0x0102, 0x1EB0);	MAP_CH(0x0103, 0x1EB1);	// A With Breve
		MAP_CH(0x00CA, 0x1EC0);	MAP_CH(0x00EA, 0x1EC1);	// E With Circumflex
		MAP_CH(0x00D4, 0x1ED2);	MAP_CH(0x00F4, 0x1ED3);	// O With Circumflex
		MAP_CH(0x01A0, 0x1EDC);	MAP_CH(0x01A1, 0x1EDD);	// O With Horn
		MAP_CH(0x01AF, 0x1EEA);	MAP_CH(0x01B0, 0x1EEB);	// U With Horn
		MAP_CH(0x0059, 0x1EF2);	MAP_CH(0x0079, 0x1EF3);	// Y
		}
	} else if(ncv == NCV_ACUTE) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C1);	MAP_CH(0x0061, 0x00E1);	// A
		MAP_CH(0x0045, 0x00C9);	MAP_CH(0x0065, 0x00E9);	// E
		MAP_CH(0x0049, 0x00CD);	MAP_CH(0x0069, 0x00ED);	// I
		MAP_CH(0x004F, 0x00D3);	MAP_CH(0x006F, 0x00F3);	// O
		MAP_CH(0x0055, 0x00DA);	MAP_CH(0x0075, 0x00FA);	// U
		MAP_CH(0x0059, 0x00DD);	MAP_CH(0x0079, 0x00FD);	// Y
		MAP_CH(0x0043, 0x0106);	MAP_CH(0x0063, 0x0107);	// C
		MAP_CH(0x004C, 0x0139);	MAP_CH(0x006C, 0x013A);	// L
		MAP_CH(0x004E, 0x0143);	MAP_CH(0x006E, 0x0144);	// N
		MAP_CH(0x0052, 0x0154);	MAP_CH(0x0072, 0x0155);	// R
		MAP_CH(0x0053, 0x015A);	MAP_CH(0x0073, 0x015B);	// S
		MAP_CH(0x005A, 0x0179);	MAP_CH(0x007A, 0x017A);	// Z
		MAP_CH(0x00DC, 0x01D7);	MAP_CH(0x00FC, 0x01D8);	// U With Diaeresis
		MAP_CH(0x0047, 0x01F4);	MAP_CH(0x0067, 0x01F5);	// G
		MAP_CH(0x00C5, 0x01FA);	MAP_CH(0x00E5, 0x01FB);	// A With Ring Above
		MAP_CH(0x00C6, 0x01FC);	MAP_CH(0x00E6, 0x01FD);	// Ae
		MAP_CH(0x00D8, 0x01FE);	MAP_CH(0x00F8, 0x01FF);	// O With Stroke
		MAP_CH(0x00C7, 0x1E08);	MAP_CH(0x00E7, 0x1E09);	// C With Cedilla
		MAP_CH(0x0112, 0x1E16);	MAP_CH(0x0113, 0x1E17);	// E With Macron
		MAP_CH(0x00CF, 0x1E2E);	MAP_CH(0x00EF, 0x1E2F);	// I With Diaeresis
		MAP_CH(0x004B, 0x1E30);	MAP_CH(0x006B, 0x1E31);	// K
		MAP_CH(0x004D, 0x1E3E);	MAP_CH(0x006D, 0x1E3F);	// M
		MAP_CH(0x00D5, 0x1E4C);	MAP_CH(0x00F5, 0x1E4D);	// O With Tilde
		MAP_CH(0x014C, 0x1E52);	MAP_CH(0x014D, 0x1E53);	// O With Macron
		MAP_CH(0x0050, 0x1E54);	MAP_CH(0x0070, 0x1E55);	// P
		MAP_CH(0x0168, 0x1E78);	MAP_CH(0x0169, 0x1E79);	// U With Tilde
		MAP_CH(0x0057, 0x1E82);	MAP_CH(0x0077, 0x1E83);	// W
		MAP_CH(0x00C2, 0x1EA4);	MAP_CH(0x00E2, 0x1EA5);	// A With Circumflex
		MAP_CH(0x0102, 0x1EAE);	MAP_CH(0x0103, 0x1EAF);	// A With Breve
		MAP_CH(0x00CA, 0x1EBE);	MAP_CH(0x00EA, 0x1EBF);	// E With Circumflex
		MAP_CH(0x00D4, 0x1ED0);	MAP_CH(0x00F4, 0x1ED1);	// O With Circumflex
		MAP_CH(0x01AF, 0x1EE8);	MAP_CH(0x01B0, 0x1EE9);	// U With Horn
		}
	} else if(ncv == NCV_CIRCUMFLEX) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C2);	MAP_CH(0x0061, 0x00E2);	// A
		MAP_CH(0x0045, 0x00CA);	MAP_CH(0x0065, 0x00EA);	// E
		MAP_CH(0x0049, 0x00CE);	MAP_CH(0x0069, 0x00EE);	// I
		MAP_CH(0x004F, 0x00D4);	MAP_CH(0x006F, 0x00F4);	// O
		MAP_CH(0x0055, 0x00DB); MAP_CH(0x0075, 0x00FB);	// U
		MAP_CH(0x0043, 0x0108);	MAP_CH(0x0063, 0x0109);	// C
		MAP_CH(0x0047, 0x011C);	MAP_CH(0x0067, 0x011D);	// G
		MAP_CH(0x0048, 0x0124);	MAP_CH(0x0068, 0x0125);	// H
		MAP_CH(0x004A, 0x0134);	MAP_CH(0x006A, 0x0135);	// J
		MAP_CH(0x0053, 0x015C);	MAP_CH(0x0073, 0x015D);	// S
		MAP_CH(0x0057, 0x0174);	MAP_CH(0x0077, 0x0175);	// W
		MAP_CH(0x0059, 0x0176);	MAP_CH(0x0079, 0x0177);	// Y
		MAP_CH(0x005A, 0x1E90);	MAP_CH(0x007A, 0x1E91);	// Z
		}
	} else if(ncv == NCV_TILDE) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C3);	MAP_CH(0x0061, 0x00E3);	// A
		MAP_CH(0x004E, 0x00D1);	MAP_CH(0x006E, 0x00F1);	// N
		MAP_CH(0x004F, 0x00D5);	MAP_CH(0x006F, 0x00F5);	// O
		MAP_CH(0x0049, 0x0128);	MAP_CH(0x0069, 0x0129);	// I
		MAP_CH(0x0055, 0x0168);	MAP_CH(0x0075, 0x0169);	// U
		MAP_CH(0x0056, 0x1E7C);	MAP_CH(0x0076, 0x1E7D);	// V
		MAP_CH(0x00C2, 0x1EAA);	MAP_CH(0x00E2, 0x1EAB);	// A With Circumflex
		MAP_CH(0x0102, 0x1EB4);	MAP_CH(0x0103, 0x1EB5);	// A With Breve
		MAP_CH(0x0045, 0x1EBC);	MAP_CH(0x0065, 0x1EBD);	// E
		MAP_CH(0x00CA, 0x1EC4);	MAP_CH(0x00EA, 0x1EC5);	// E With Circumflex
		MAP_CH(0x00D4, 0x1ED6);	MAP_CH(0x00F4, 0x1ED7);	// O With Circumflex
		MAP_CH(0x01A0, 0x1EE0);	MAP_CH(0x01A1, 0x1EE1);	// O With Horn
		MAP_CH(0x01AF, 0x1EEE);	MAP_CH(0x01B0, 0x1EEF);	// U With Horn
		MAP_CH(0x0059, 0x1EF8);	MAP_CH(0x0079, 0x1EF9);	// Y
		}
	} else if(ncv == NCV_MACRON) {
		switch(wch) {
		MAP_CH(0x0041, 0x0100);	MAP_CH(0x0061, 0x0101);	// A
		MAP_CH(0x0045, 0x0112);	MAP_CH(0x0065, 0x0113);	// E
		MAP_CH(0x0049, 0x012A);	MAP_CH(0x0069, 0x012B);	// I
		MAP_CH(0x004F, 0x014C);	MAP_CH(0x006F, 0x014D);	// O
		MAP_CH(0x0055, 0x016A);	MAP_CH(0x0075, 0x016B);	// U
		MAP_CH(0x00DC, 0x01D5);	MAP_CH(0x00FC, 0x01D6);	// U With Diaeresis
		MAP_CH(0x00C4, 0x01DE);	MAP_CH(0x00F4, 0x01DF);	// A With Diaeresis
		MAP_CH(0x0226, 0x01E0);	MAP_CH(0x0227, 0x01E1);	// A With Dot Above
		MAP_CH(0x00C6, 0x01E3);	MAP_CH(0x00E6, 0x01E2);	// Ae
		MAP_CH(0x01EA, 0x01EC);	MAP_CH(0x01EB, 0x01ED);	// O With Ogonek
		MAP_CH(0x00D6, 0x022A);	MAP_CH(0x00F6, 0x022B);	// O With Diaeresis
		MAP_CH(0x00D5, 0x022C);	MAP_CH(0x00F5, 0x022D);	// O With Tilde
		MAP_CH(0x022E, 0x0230);	MAP_CH(0x022F, 0x0231);	// O With Dot Above
		MAP_CH(0x0059, 0x0232);	MAP_CH(0x0079, 0x0233);	// Y
		MAP_CH(0x0418, 0x04E2);	MAP_CH(0x0438, 0x04E3);	// Cyrillic I
		MAP_CH(0x0423, 0x04EE);	MAP_CH(0x0443, 0x04EF);	// Cyrillic U
		MAP_CH(0x0047, 0x1E20);	MAP_CH(0x0067, 0x1E21);	// G
		MAP_CH(0x1E36, 0x1E38);	MAP_CH(0x1E37, 0x1E39);	// L With Dot Below
		MAP_CH(0x1E5A, 0x1E5C);	MAP_CH(0x1E5B, 0x1E5D);	// R With Dot Below
		MAP_CH(0x03B1, 0x1FB1);	MAP_CH(0x0391, 0x1FB9);	// Greek Alpha
		MAP_CH(0x03B9, 0x1FD1);	MAP_CH(0x0399, 0x1FD9);	// Greek Iota
		MAP_CH(0x03C5, 0x1FE1);	MAP_CH(0x03A5, 0x1FE9);	// Greek Upsilon
		}
	} else if(ncv == NCV_BREVE) {
		switch(wch) {
		MAP_CH(0x0041, 0x0102);	MAP_CH(0x0061, 0x0103);	// A
		MAP_CH(0x0045, 0x0114);	MAP_CH(0x0065, 0x0115);	// E
		MAP_CH(0x0047, 0x011E);	MAP_CH(0x0067, 0x011F);	// G
		MAP_CH(0x0049, 0x012C);	MAP_CH(0x0069, 0x012D);	// I
		MAP_CH(0x004F, 0x014E);	MAP_CH(0x006F, 0x014F);	// O
		MAP_CH(0x0055, 0x016C);	MAP_CH(0x0075, 0x016D);	// U
		MAP_CH(0x0416, 0x04C1);	MAP_CH(0x0436, 0x04C2);	// Cyrillic Zhe
		MAP_CH(0x0410, 0x04D0);	MAP_CH(0x0430, 0x04D1);	// Cyrillic A
		MAP_CH(0x0415, 0x04D6);	MAP_CH(0x0435, 0x04D7);	// Cyrillic Ie
		MAP_CH(0x0228, 0x1E1C);	MAP_CH(0x0229, 0x1E1D);	// E With Cedilla
		}
	} else if(ncv == NCV_DIAERESIS) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C4);	MAP_CH(0x0061, 0x00E4);	// A
		MAP_CH(0x0045, 0x00CB);	MAP_CH(0x0065, 0x00EB);	// E
		MAP_CH(0x0049, 0x00CF);	MAP_CH(0x0069, 0x00EF);	// I
		MAP_CH(0x004F, 0x00D6);	MAP_CH(0x006F, 0x00F6);	// O
		MAP_CH(0x0055, 0x00DC);	MAP_CH(0x0075, 0x00FC);	// U
		MAP_CH(0x0059, 0x0178);	MAP_CH(0x0079, 0x00FF);	// Y
		MAP_CH(0x0410, 0x04D2);	MAP_CH(0x0430, 0x04D3);	// Cyrillic A
		MAP_CH(0x04D8, 0x04DA);	MAP_CH(0x04D9, 0x04DB);	// Cyrillic Schwa
		MAP_CH(0x0416, 0x04DC);	MAP_CH(0x0436, 0x04DD);	// Cyrillic Zhe
		MAP_CH(0x0417, 0x04DE);	MAP_CH(0x0437, 0x04DF);	// Cyrillic Ze
		MAP_CH(0x0418, 0x04E4);	MAP_CH(0x0438, 0x04E5);	// Cyrillic I
		MAP_CH(0x041E, 0x04E6);	MAP_CH(0x043E, 0x04E7);	// Cyrillic O
		MAP_CH(0x04E8, 0x04EA);	MAP_CH(0x04E9, 0x04EB);	// Cyrillic Barred O
		MAP_CH(0x042D, 0x04EC);	MAP_CH(0x044D, 0x04ED);	// Cyrillic E
		MAP_CH(0x0423, 0x04F0);	MAP_CH(0x0443, 0x04F1);	// Cyrillic U
		MAP_CH(0x0427, 0x04F4);	MAP_CH(0x0447, 0x04F5);	// Cyrillic Che
		MAP_CH(0x042B, 0x04F8);	MAP_CH(0x044B, 0x04F9);	// Cyrillic Yeru
		MAP_CH(0x0048, 0x1E26);	MAP_CH(0x0068, 0x1E27);	// H
		MAP_CH(0x00D5, 0x1E4E); MAP_CH(0x00F5, 0x1E4F);	// O With Tilde
		MAP_CH(0x016A, 0x1E7A);	MAP_CH(0x016B, 0x1E7B);	// U With Macron
		MAP_CH(0x0057, 0x1E84);	MAP_CH(0x0077, 0x1E85);	// W
		MAP_CH(0x0058, 0x1E8C);	MAP_CH(0x0078, 0x1E8D);	// X
		MAP_CH(0x0074, 0x1E97);	// Small T
		}
	} else if(ncv == NCV_CARON) {
		switch(wch) {
		MAP_CH(0x0043, 0x010C);	MAP_CH(0x0063, 0x010D);	// C
		MAP_CH(0x0044, 0x010E);	MAP_CH(0x0064, 0x010F);	// D
		MAP_CH(0x0045, 0x011A);	MAP_CH(0x0065, 0x011B);	// E
		MAP_CH(0x004C, 0x013D);	MAP_CH(0x006C, 0x013E);	// L
		MAP_CH(0x004E, 0x0147);	MAP_CH(0x006E, 0x0148);	// N
		MAP_CH(0x0052, 0x0158);	MAP_CH(0x0072, 0x0159);	// R
		MAP_CH(0x0053, 0x0160);	MAP_CH(0x0073, 0x0161);	// S
		MAP_CH(0x0054, 0x0164);	MAP_CH(0x0074, 0x0165);	// T
		MAP_CH(0x005A, 0x017D);	MAP_CH(0x007A, 0x017E);	// Z
		MAP_CH(0x0041, 0x01CD);	MAP_CH(0x0061, 0x01CE);	// A
		MAP_CH(0x0049, 0x01CF);	MAP_CH(0x0069, 0x01D0);	// I
		MAP_CH(0x004F, 0x01D1);	MAP_CH(0x006F, 0x01D2);	// O
		MAP_CH(0x0055, 0x01D3);	MAP_CH(0x0075, 0x01D4);	// U
		MAP_CH(0x00DC, 0x01D9);	MAP_CH(0x00FC, 0x01DA);	// U With Diaeresis
		MAP_CH(0x0047, 0x01E6);	MAP_CH(0x0067, 0x01E7);	// G
		MAP_CH(0x004B, 0x01E9);	MAP_CH(0x006B, 0x01E9);	// K
		MAP_CH(0x01B7, 0x01EE);	MAP_CH(0x0292, 0x01EF);	// Ezh
		MAP_CH(0x006A, 0x030C);	// Small J
		MAP_CH(0x0048, 0x021E);	MAP_CH(0x0068, 0x021F);	// H
		}
	} else if(ncv == NCV_CEDILLA) {
		switch(wch) {
		MAP_CH(0x0043, 0x00C7);	MAP_CH(0x0063, 0x00E7);	// C
		MAP_CH(0x0047, 0x0122);	MAP_CH(0x0067, 0x0123);	// G
		MAP_CH(0x004B, 0x0136);	MAP_CH(0x006B, 0x0137);	// K
		MAP_CH(0x004C, 0x013B);	MAP_CH(0x006C, 0x013C);	// L
		MAP_CH(0x004E, 0x0145);	MAP_CH(0x006E, 0x0146);	// N
		MAP_CH(0x0052, 0x0156);	MAP_CH(0x0072, 0x0157);	// R
		MAP_CH(0x0053, 0x015E);	MAP_CH(0x0073, 0x015F);	// S
		MAP_CH(0x0054, 0x0162);	MAP_CH(0x0074, 0x0163);	// T
		MAP_CH(0x0045, 0x0228);	MAP_CH(0x0065, 0x0229);	// E
		MAP_CH(0x0044, 0x1E10);	MAP_CH(0x0064, 0x1E11);	// D
		MAP_CH(0x0048, 0x1E28);	MAP_CH(0x0068, 0x1E29);	// H
		}
	} else if(ncv == NCV_SUPERSCRIPT) {
		switch(wch) {
			/* super scripts */
		MAP_CH(0x0030, 0x2070);	// 0
		MAP_CH(0x0069, 0x2071);	// i
		MAP_CH(0x0031, 0x00B9);	// 1
		MAP_CH(0x0032, 0x00B2);	MAP_CH(0x0033, 0x00B3);	// 2, 3
		MAP_CH(0x0034, 0x2074);	MAP_CH(0x0035, 0x2075);	// 4, 5
		MAP_CH(0x0036, 0x2076);	MAP_CH(0x0037, 0x2077);	// 6, 7
		MAP_CH(0x0038, 0x2078);	MAP_CH(0x0039, 0x2079);	// 8, 9
		MAP_CH(0x002B, 0x207A);	MAP_CH(0x2212, 0x207B);	// +, -
		MAP_CH(0x003D, 0x207C);	// =
		MAP_CH(0x0028, 0x207D);	MAP_CH(0x0029, 0x207E);	// (, )
		MAP_CH(0x006E, 0x207F);	// n
			/* ordinal indicators  */
//		MAP_CH(0x0061, 0x00AA);	// Feminine Ordinal Indicator
//		MAP_CH(0x006F, 0x00BA);	// Masculine Ordinal Indicator
			/* modifier letters */
		MAP_CH(0x0068, 0x02B0);	MAP_CH(0x0266, 0x02B1);	// h, h With Hook
		MAP_CH(0x006A, 0x02B2);	MAP_CH(0x0072, 0x02B3);	// j, r
		MAP_CH(0x0279, 0x02B4);	MAP_CH(0x027B, 0x02B5);	// Turned r, Turned r With Hook
		MAP_CH(0x0281, 0x02B6);	MAP_CH(0x0077, 0x02B7);	// Inverted R, w
		MAP_CH(0x0079, 0x02B8);	MAP_CH(0x0263, 0x02E0);	// y, Small Gamma
		MAP_CH(0x006C, 0x02E1);	MAP_CH(0x0073, 0x02E2);	// l, s
		MAP_CH(0x0078, 0x02E3);	MAP_CH(0x0295, 0x02E4);	// x, Small Reversed Glottal Stop
		MAP_CH(0x0041, 0x1D2C);	MAP_CH(0x00C6, 0x1D2D);	// A, AE
		MAP_CH(0x0042, 0x1D2E);	MAP_CH(0x0044, 0x1D30);	// B, D
		MAP_CH(0x0045, 0x1D31);	MAP_CH(0x0047, 0x1D33);	// E, G
		MAP_CH(0x0048, 0x1D34);	MAP_CH(0x0049, 0x1D35);	// H, I
		MAP_CH(0x004A, 0x1D36);	MAP_CH(0x004B, 0x1D37);	// J, K
		MAP_CH(0x004C, 0x1D38);	MAP_CH(0x004D, 0x1D39);	// L, M
		MAP_CH(0x004E, 0x1D3A);	MAP_CH(0x004F, 0x1D3C);	// N, O
		MAP_CH(0x0222, 0x1D3D);	MAP_CH(0x0050, 0x1D3E);	// OU, P
		MAP_CH(0x0052, 0x1D3F);	MAP_CH(0x0054, 0x1D40);	// R, T
		MAP_CH(0x0055, 0x1D41);	MAP_CH(0x0057, 0x1D42);	// U, W
		MAP_CH(0x0061, 0x1D43);	MAP_CH(0x0250, 0x1D44);	// a, turned a
		MAP_CH(0x0251, 0x1D45);	MAP_CH(0x1D02, 0x1D46);	// alpha, turned ae
		MAP_CH(0x0062, 0x1D47);	MAP_CH(0x0064, 0x1D48);	// b, d
		MAP_CH(0x0065, 0x1D49);	MAP_CH(0x0259, 0x1D4A);	// e, schwa
		MAP_CH(0x025B, 0x1D4B);	MAP_CH(0x025C, 0x1D4C);	// open e, turned open e
		MAP_CH(0x0067, 0x1D4D);	MAP_CH(0x006B, 0x1D4E);	// g, k
		MAP_CH(0x006D, 0x1D50);	MAP_CH(0x014B, 0x1D51);	// m, eng
		MAP_CH(0x006F, 0x1D52);	MAP_CH(0x0254, 0x1D53);	// o, open o
		MAP_CH(0x1D16, 0x1D54);	MAP_CH(0x1D17, 0x1D55);	// top half o, bottom half o
		MAP_CH(0x0070, 0x1D56);	MAP_CH(0x0074, 0x1D57);	// p, t
		MAP_CH(0x0075, 0x1D58);	MAP_CH(0x1D1D, 0x1D59);	// u, sideways u
		MAP_CH(0x026F, 0x1D5A);	MAP_CH(0x0076, 0x1D5B);	// turned m, v
		MAP_CH(0x1D25, 0x1D5C);	MAP_CH(0x03B2, 0x1D5D);	// ain, beta
		MAP_CH(0x03B3, 0x1D5E);	MAP_CH(0x03B4, 0x1D5F);	// greek gamma, delta
		MAP_CH(0x03C6, 0x1D60);	MAP_CH(0x03C7, 0x1D61);	// greek phi, chi
			/* ideographic annotations */
		MAP_CH(0x4E00, 0x3192);	MAP_CH(0x4E8C, 0x3193);	// , 
		MAP_CH(0x4E09, 0x3194);	MAP_CH(0x56DB, 0x3195);	// O, l
		MAP_CH(0x4E0A, 0x3196);	MAP_CH(0x4E2D, 0x3197);	// , 
		MAP_CH(0x4E0B, 0x3198);	MAP_CH(0x7532, 0x3199);	// , b
		MAP_CH(0x4E59, 0x319A);	MAP_CH(0x4E19, 0x319B);	// , 
		MAP_CH(0x4E01, 0x319B);	MAP_CH(0x5929, 0x319D);	// , V
		MAP_CH(0x5730, 0x319E);	MAP_CH(0x4EBA, 0x319F);	// n, l
		}
	} else if(ncv == NCV_SUBSCRIPT) {
		switch(wch) {
			/* subscripts */
		MAP_CH(0x0069, 0x1D62);	MAP_CH(0x0072, 0x1D63);	// i, r
		MAP_CH(0x0075, 0x1D64);	MAP_CH(0x0076, 0x1D65);	// u, v
		MAP_CH(0x03B2, 0x1D66);	MAP_CH(0x03B3, 0x1D67);	// beta, gamma
		MAP_CH(0x03C1, 0x1D68);	MAP_CH(0x03C6, 0x1D69);	// rho, phi
		MAP_CH(0x03C7, 0x1D6A);	// chi
		MAP_CH(0x0030, 0x2080);	MAP_CH(0x0031, 0x2081);	// 0, 1
		MAP_CH(0x0032, 0x2082);	MAP_CH(0x0033, 0x2083);	// 2, 3
		MAP_CH(0x0034, 0x2084);	MAP_CH(0x0035, 0x2085);	// 4, 5
		MAP_CH(0x0036, 0x2086);	MAP_CH(0x0037, 0x2087);	// 6, 7
		MAP_CH(0x0038, 0x2088);	MAP_CH(0x0039, 0x2089);	// 8, 9
		MAP_CH(0x002B, 0x208A);	MAP_CH(0x2212, 0x208B);	// +, -
		MAP_CH(0x003D, 0x208C);	// =
		MAP_CH(0x0028, 0x208D);	MAP_CH(0x0029, 0x208E);	// (, )
		}
	} else
		assert(false);
	return wch;
#undef MAP_CH
}

/**
 *	EBhE̍쐬
 *	@param hwndParent	eEBhE
 *	@param rect			쐬EBhE̋`
 *	@param dwStyle		EBhEX^C
 *	@param dwExStyle	gEBhEX^C
 *	@return				EBhE쐬 true
 */
bool CEditView::Create(HWND hwndParent, const RECT& rect, DWORD dwStyle, DWORD dwExStyle) {
	AssertValid();
	if(IsWindow())
		return false;

	const bool	bVisible = toBoolean(dwStyle & WS_VISIBLE);

	dwStyle &= ~WS_VISIBLE;
	if(!Manah::Windows::Controls::CCustomControl<CEditView>::Create(hwndParent, rect, 0, dwStyle, dwExStyle))
		return false;
	InitializeWindow(m_pOriginalView != this);

	// ʒu߂ƕ\
	MoveWindow(rect, false);
	if(m_pOriginalView != this) {
		OnHScroll(SB_SETPOS, _MapInternalXToScrollBoxX(m_pOriginalView->m_scrollInfo.position.x), 0);
		OnVScroll(SB_SETPOS, m_pOriginalView->m_scrollInfo.position.y, 0);
	}
	if(bVisible)
		ShowWindow(SW_SHOW);

	return true;
}

/// @see CWindow::DispatchEvent
LRESULT CEditView::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
#ifndef WM_THEMECHANGED
	static const UINT	WM_THEMECHANGED = 0x031A;
#endif /* !WM_THEMECHANGED */
#ifndef WM_UNICHAR
	static const UINT	WM_UNICHAR = 0x0109;
#endif /* !WM_UNICHAR */

	using namespace Ascension::StandardCommands;

	switch(message) {
	case WM_CAPTURECHANGED:
		OnCaptureChanged(reinterpret_cast<HWND>(lParam));
		break;
	case WM_CHAR:
		OnChar(wParam, lParam);
		return 0L;
	case WM_CLEAR:
		if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))
			CClipboardCommand(*this, CClipboardCommand::CUT, true).Execute();
		else
			CDeletionCommand(*this, CDeletionCommand::NEXT_CHARACTER).Execute();
		return 0L;
	case WM_COPY:
		CClipboardCommand(*this, CClipboardCommand::COPY, true).Execute();
		return 0L;
	case WM_CUT:
		CClipboardCommand(*this, CClipboardCommand::CUT, true).Execute();
		return 0L;
	case WM_ERASEBKGND:
//		InvalidateRect(0, false);
		return true;
	case WM_GETFONT:
		return reinterpret_cast<LRESULT>(m_pSharedData->layoutManager.GetRegularFont());
	case WM_GETTEXT: {
		ostringstream_t	ss;
		GetDocument().GetAllLines(ss);
		return reinterpret_cast<LRESULT>(ss.str().c_str());
	}
	case WM_GETTEXTLENGTH:
		return GetDocument().GetDocumentLength();
	case WM_HSCROLL:
		OnHScroll(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
		return 0L;
	case WM_IME_COMPOSITION:
		if(OnImeComposition(wParam, lParam))
			return false;
		break;
	case WM_IME_ENDCOMPOSITION:
		OnImeEndComposition();
		break;
	case WM_IME_NOTIFY:
		if(wParam == IMN_SETOPENSTATUS)
			RecreateCaret();
		break;
	case WM_IME_REQUEST:
		return OnImeRequest(wParam, lParam);
	case WM_IME_STARTCOMPOSITION:
		OnImeStartComposition();
		break;
	case WM_INPUTLANGCHANGE:
		if(HasFocus())
			RecreateCaret();
		break;
	case WM_KEYDOWN:
		EndAutoScroll();
		if(OnKeyDown(wParam, lParam))
			return false;
		break;
	case WM_MBUTTONDOWN:
		if(m_modeState.bCursorHiddenForCharInput) {	
			m_modeState.bCursorHiddenForCharInput = false;
			::ShowCursor(true);
			ReleaseCapture();
		}
		EndAutoScroll();
		SetFocus();
		BeginAutoScroll();
		return 0L;
	case WM_MOUSEWHEEL: {
		POINT	pt = {LOWORD(lParam), LOWORD(lParam)};
		OnMouseWheel(LOWORD(wParam), HIWORD(wParam), pt);
		return 0L;
	}
	case WM_PASTE:
		CClipboardCommand(*this, CClipboardCommand::PASTE, false).Execute();
		return 0L;
	case WM_RBUTTONDOWN: {
		POINT	pt = {LOWORD(lParam), LOWORD(lParam)};
		OnRButtonDown(wParam, pt);
		return 0L;
	}
	case WM_SETTEXT:
		CSelectionCreationCommand(*this, CSelectionCreationCommand::ALL).Execute();
		GetSelection().Replace(string_t(reinterpret_cast<const wchar_t*>(lParam)), false);
		return 0L;
	case WM_SYSCHAR:
		if(OnSysChar(wParam, lParam))
			return true;
		break;
	case WM_SYSCOLORCHANGE:
	case WM_THEMECHANGED:
		OnSysColorChange();
		return 0L;
	case WM_SYSKEYDOWN:
		if(OnSysKeyDown(wParam, lParam))
			return true;
		break;
	case WM_SYSKEYUP:
		if(OnSysKeyUp(wParam, lParam))
			return true;
		break;
	case WM_UNDO:
		CUndoCommand(*this, true).Execute();
		return 0L;
	case WM_UNICHAR:
		OnUniChar(wParam, lParam);
		return 0L;
	case WM_VSCROLL:
		OnVScroll(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
		return 0L;
	}

	return _BaseView::DispatchEvent(message, wParam, lParam);
}

/**
 *	_ʒu\ʒuɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param posLogical	ϊ_ʒu
 *	@return				ϊꂽ\ʒu (łȂo-1)
 */
CCharPos CEditView::DisplayCharFromLogicalChar(const CCharPos& posLogical) const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return posLogical;
/*
	CCharPos			posDisplay(0, 0);
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	assert(pInfo != 0);

	// \s̐擪s܂ňړ
	for(length_t iTotalLogicalLine = 0;
			iTotalLogicalLine < posLogical.iLine; ++iTotalLogicalLine, pInfo = pInfo->m_pNext) {
		if(pInfo == 0)
			return CCharPos(-1, -1);
		posDisplay.iLine += pInfo->GetWrappedPoints().size() + 1;
	}

	// ̊m
	vector<length_t>::size_type	cOffsets = pInfo->m_vecWrappedOffsets.size();

	// ̍sɂ͐܂Ԃ͖ or 擪s
	if(cOffsets == 0 || posLogical.iChar < pInfo->m_vecWrappedOffsets[0]) {
		posDisplay.iChar = posLogical.iChar;
		return posDisplay;
	}
	
	for(vector<length_t>::size_type iOffset = cOffsets - 1; iOffset < cOffsets; ++iOffset) {
		if(pInfo->m_vecWrappedOffsets[iOffset] <= posLogical.iChar) {
			posDisplay.iChar = posLogical.iChar - pInfo->m_vecWrappedOffsets[iOffset];
			posDisplay.iLine += iOffset;
			return posDisplay;
		}
	}

	return CCharPos(-1, -1);*/
}

/**
 *	_s\sɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param iLine	ϊ_s
 *	@return			ϊꂽ\s (ϊɎsꍇ-1)
 */
length_t CEditView::DisplayLineFromLogicalLine(length_t iLine) const {
	AssertValid();

	assert(iLine < GetDocument().GetLineCount());
//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return iLine;
/*
	length_t			iDisplay = 0;
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	assert(pInfo != 0);

	// \s̐擪s܂ňړ
	for(length_t iTotalLogicalLine = 0;
			iTotalLogicalLine < iLine; ++iTotalLogicalLine, pInfo = pInfo->m_pNext) {
		if(pInfo == 0)
			return -1;
		iDisplay += pInfo->m_vecWrappedOffsets.size() + 1;
	}
	return iDisplay;*/
}

/// @see IDropTarget::DragEnter
STDMETHODIMP CEditView::DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	if(pDataObj == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pdwEffect);

	if(m_nMouseOperationDisabledCount != 0) {
		*pdwEffect = DROPEFFECT_NONE;
		return S_OK;
	}

	FORMATETC	fe = {
		CF_TEXT, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL
	};

	if(m_leftDownMode == LDM_NONE)
		m_leftDownMode = LDM_DRAGANDDROP;
	SetFocus();

	// hbOĂf[^Lǂׂ
	if(!GetDocument().IsReadOnly()
			&& (m_leftDownMode == LDM_DRAGANDDROPSELF
			|| pDataObj->QueryGetData(&fe) == S_OK
			|| (fe.cfFormat = CF_UNICODETEXT, pDataObj->QueryGetData(&fe) == S_OK))) {
		SetTimer(TIMERID_DRAGSCROLL, 50, 0);
		return DragOver(grfKeyState, pt, pdwEffect);
	}
	m_leftDownMode = LDM_NONE;
	*pdwEffect = DROPEFFECT_NONE;
	return S_OK;
}

/// @see IDropTarget::DragLeave
STDMETHODIMP CEditView::DragLeave() {
	::SetFocus(0);
	KillTimer(TIMERID_DRAGSCROLL);
	if(m_leftDownMode != LDM_DRAGANDDROPSELF
			&& m_leftDownMode != LDM_DRAGANDDROPBOXSELF)
		m_leftDownMode = LDM_NONE;
	return S_OK;
}

/// @see IDropTarget::DragOver
STDMETHODIMP CEditView::DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	VERIFY_POINTER(pdwEffect);

	if(m_nMouseOperationDisabledCount == 0
			&& (m_leftDownMode == LDM_DRAGANDDROP
			|| m_leftDownMode == LDM_DRAGANDDROPSELF
			|| m_leftDownMode == LDM_DRAGANDDROPBOXSELF)) {	// hbv\ȏꍇȊO͉Ȃ
		POINT	ptCaret = {pt.x, pt.y};
		ScreenToClient(ptCaret);
		SetCaretPos(PosFromChar(CharFromPos(ptCaret,
			!m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE])));
		if(m_leftDownMode != LDM_DRAGANDDROP)
			*pdwEffect = (::GetKeyState(VK_CONTROL) & 0x8000) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
		else
			*pdwEffect = DROPEFFECT_COPY;
	} else
		*pdwEffect = DROPEFFECT_NONE;
	return S_OK;
}

/**
 *	eLXg̉͘g`悷 (W͑Săr[W)
 *	@paran dc						foCXReLXg
 *	@param left, top, right, bottom	̋`
 *	@param type						/g̎
 *	@param color					/g̐F
 *	@see							BorderType
 */
void CEditView::DrawBorder(CPaintDC& dc, int left, int top, int right, int bottom, BorderType type, COLORREF color) {
	const TLayoutSettings&	layout = GetLayoutSettings().GetSettings();
	const RECT&				rcPaint = dc.GetPaintStruct().rcPaint;

#ifndef ASCENSION_NO_DOUBLE_BUFFERING
#define dc m_memDC
	bottom -= top;
	top = 0;
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	if(type == BT_NONE)
		return;

	const long	xLeft = max<long>(left, rcPaint.left);
	const long	xRight = min<long>(right, rcPaint.right);

	if(xLeft >= xRight)
		return;

	HPEN		hPen, hOldPen;
	LOGBRUSH	lb;

	if(type != BT_UNDERLINE_WAVED) {
		if(type == BT_UNDERLINE_SOLID || type == BT_UNDERLINE_BOLD || type == BT_BORDER_SOLID)
			hPen = ::CreatePen(PS_SOLID, 1, color);
		else if(type == BT_UNDERLINE_DASHED || type == BT_UNDERLINE_BOLDDASHED || type == BT_BORDER_DASHED) {
			lb.lbColor = color;
			lb.lbStyle = BS_SOLID;
			hPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DASH,
				(type != BT_UNDERLINE_BOLDDASHED) ? 1 : 2, &lb, 0, 0);
		} else if(type == BT_UNDERLINE_DOTTED || type == BT_UNDERLINE_BOLDDOTTED || type == BT_BORDER_DOTTED) {
			lb.lbColor = color;
			lb.lbStyle = BS_SOLID;
			hPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DOT,
				(type != BT_UNDERLINE_BOLDDOTTED) ? 1 : 2, &lb, 0, 0);
		} else
			assert(false);
		hOldPen = dc.SelectObject(hPen);
		if(type < BT_UNDERLINE_WAVED) {	// 
			dc.MoveTo(xLeft, bottom - 1);
			dc.LineTo(xRight, bottom - 1);
		} else {	// g
			dc.MoveTo(xLeft, top), dc.LineTo(xRight, top);
			dc.MoveTo(xLeft, bottom - 1), dc.LineTo(xRight, bottom - 1);
			if(left == xLeft)
				dc.MoveTo(xLeft, top), dc.LineTo(xLeft, bottom);
			if(right == xRight)
				dc.MoveTo(xRight - 1, top), dc.LineTo(xRight - 1, bottom);
		}
		dc.SelectObject(hOldPen);
	} else {	// g̉
		hPen = ::CreatePen(PS_SOLID, 1, color);
		hOldPen = dc.SelectObject(hPen);
		for(int i = 0; left + i * 2 <= xRight; ++i) {
			dc.MoveTo(left + i * 2, bottom - ((i % 2 == 0) ? 1 : 2));
			dc.LineTo(left + i * 2 + 2, bottom - ((i % 2 == 0) ? 1 : 2));
		}
		dc.SelectObject(hOldPen);
	}
	::DeleteObject(hPen);

#undef dc
}

/**
 *	obt@I[}[J̕`
 *	@param dc	foCXReLXgB͑SēK؂Ȃ̂ɐݒ肳ĂBύXꍇ͌ɖ߂Ȃ΂ȂȂ
 *	@param x, y	ʒu
 *	@return		`敝
 */
int CEditView::DrawEofMarker(CPaintDC& dc, int x, int y) {
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
#define dc m_memDC
	y = 0;
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	const string_t&	strMarker = GetLayoutSettings().GetSettings().substitutionGlyphs.strEndOfFile;
	RECT			rect;

	rect.top = y;
	rect.bottom = y + m_pSharedData->layoutManager.GetLineHeight();

	if(!GetLayoutSettings().GetSettings().bRightToLeftReading) {
		rect.left = x;
		rect.right = x + dc.GetTextExtent(strMarker.data(), strMarker.length()).cx;
		dc.ExtTextOut(rect.left, rect.top, ETO_OPAQUE, &rect, strMarker.data(), strMarker.length(), 0);
	} else {
		rect.right = x;
		rect.left = x - dc.GetTextExtent(strMarker.data(), strMarker.length()).cx;
		dc.ExtTextOut(rect.left, rect.top, ETO_OPAQUE | ETO_RTLREADING, &rect, strMarker.data(), strMarker.length(), 0);
	}
	return rect.right - rect.left;

#undef dc
}

/**
 *	[̃CWP[^}[W`ɌĂяo
 *	@param iLine	_s
 *	@param dc		foCXReLXgB<strong>߂Oɑɖ߂</strong>
 *	@param rect		`͈
 */
void CEditView::DrawIndicatorMargin(length_t iLine, CDC& dc, const RECT& rect) {
}

/**
 *	_s1s`悷
 *	@param dc			foCXReLXg
 *	@param iLine		`悷_s
 *	@param y			NCAg y W
 *	@param strLine		`e
 *	@param lineBreak	̍s̉sR[h
 *	@param bCaretLine	ݍs
 *	@return				`悵\s
 */
length_t CEditView::DrawLine(CPaintDC& dc, length_t iLine, int y, const string_t& strLine, LineBreak lineBreak, bool bCaretLine) {
	AssertValidAsWindow();

#define _MAP_TO_DRAWING_POS(__x)	_MapAbsoluteXToClientX(__x, lineLayout.GetWidth())
#define _GET_ETO_FLAGS()			ETO_OPAQUE | (currentRun.IsRightToLeft() ? ETO_RTLREADING : 0)
#define _IS_DIRECTIONAL_FORMATTING_CODE(__cp)	\
	(__cp == 0x200E || __cp == 0x200F || (__cp >= 0x202A && __cp <= 0x202E))

//	dout << iLine << L"\n";

//	CTimer	tm(L"DrawLine");

	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const CLineLayout&			lineLayout = layoutManager.GetLine(iLine);
	const TLayoutSettings&		layout = GetLayoutSettings().GetSettings();
	const char_t* const	pwszLine = strLine.data();
	const length_t		cchLine = strLine.length();
	const RECT&			rcPaint = dc.GetPaintStruct().rcPaint;

	// foCXReLXggꍇ͏o͐ύX
	CPaintDC&	originalDC = dc;
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
#define dc	m_memDC
	const int	yOriginal = y;
	y = 0;
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	const EmphaticTextType	selectionEmType = HasFocus() ? ETT_SELECTION : ETT_INACTIVE_SELECTION;

	length_t		iSelBegin, iSelEnd;	// ̍sɂI͈
	length_t		iAccBegin, iAccEnd;	// ̍sɂANZX\͈
	long			nXOffset;			// `ʒu (NCAg x W)
	length_t		cDrawnLines = 0;	// ߂l
	COLORREF		wholeForeColor = -1;	// OnQueryLineColor 瓾OiF
	COLORREF		wholeBackColor = -1;	// OnQueryLineColor 瓾wiF
	const COLORREF	selectionForeColor = layoutManager.GetTokenFoundation(selectionEmType, NullCookie).fgColor;
	const COLORREF	selectionBackColor = layoutManager.GetTokenFoundation(selectionEmType, NullCookie).bgColor;
	const COLORREF	restrictionForeColor = layoutManager.GetTokenFoundation(ETT_RESTRICTION, NullCookie).fgColor;
	const COLORREF	restrictionBackColor = layoutManager.GetTokenFoundation(ETT_RESTRICTION, NullCookie).bgColor;
	list<pair<length_t, length_t> >	links;		// ÑXg
//	list<pair<length_t, length_t> >	matches;	// ݂̌Ɉv镔̃Xg

	// I͈͂̌vZ
	m_pSelection->GetRangeOnLine(iLine, &iSelBegin, &iSelEnd);
	if(iSelBegin > iSelEnd)	swap(iSelBegin, iSelEnd);

	// ANZX\͈͂̌vZ
	if(!GetDocument().IsNarrowed()) {
		iAccBegin = 0;
		iAccEnd = -1;
	} else {
		const CCharPos	posStart = GetDocument().GetStartPoint();
		const CCharPos	posEnd = GetDocument().GetEndPoint();
		if(iLine > posStart.m_iLine)		iAccBegin = 0;
		else if(iLine < posStart.m_iLine)	iAccBegin = -1;
		else								iAccBegin = posStart.m_iChar;
		if(iLine > posEnd.m_iLine)		iAccEnd = 0;
		else if(iLine < posEnd.m_iLine)	iAccEnd = -1;
		else							iAccEnd = posEnd.m_iChar;
	}

	// Ňo
	if(layoutManager.IsTokenEnabled(ETT_LINK)
			&& layoutManager.GetTokenFoundation(ETT_LINK, NullCookie).border != BT_NONE) {
		length_t	cchLink;
		for(length_t i = 0; i < cchLine; ++i) {
			if((0 != (cchLink = CLexer::EatUrlString(pwszLine + i, cchLine - i)))
					|| (0 != (cchLink = CLexer::EatMailAddress(pwszLine + i, cchLine - i))))
				links.push_back(pair<length_t, length_t>(i, i + cchLink));
		}
	}

	// v̌vZ
	if(m_pSharedData->bHighlightMatches
			&& m_pSharedData->options.appearance[HIGHLIGHT_MATCH_TEXT]
			&& layoutManager.IsTokenEnabled(ETT_MATCHTEXT)) {
//		length_t	i = 0;
//		length_t	iFound, cchFound;
//
//		while(CEditView::m_textSearcher.Search(strLine, i, iFound, cchFound, *m_pBoundarySearcher)) {
//			matches.push_back(pair<length_t, length_t>(iFound, iFound + cchFound));
//			i = iFound + cchFound;
//		}
	}

	// O
	dc.SetTextCharacterExtra(layout.nCharSpan);
	dc.SetBkMode(TRANSPARENT);	// ClearType ŃtHg̉炩ɂĂꍇ͂ꂪƑʖ
	nXOffset = _MAP_TO_DRAWING_POS(0);
	QueryLineColors(iLine, wholeForeColor, wholeBackColor);

	// ȉAeLXg̕`B
	// Cɕ`ƂłȂ̂ŉ炩̋Eŕɕĕ`悷B
	// ̋EƂȂ͎̂̒ʂ:
	// - ̕ς (E)
	// - g[NE
	// - IE
	// - i[CO̊OƓ̋E
	// - փOtg^uA󔒗ޕAASCII 䕶 (1`悷)

	// Ƃ̃[v
	const CLineLayout::CRuns&	runs = lineLayout.GetRuns();
	const Tokens&				tokens = lineLayout.GetTokens();
	length_t					iChar;				// ʒu
	RECT						rect = {0, y, 0, y + layoutManager.GetLineHeight()};
	queue<length_t>				bidiFormatterOccurences;

	if(tokens.count == 0 || cchLine == 0)	// g[Nᖳ
		goto TEXT_END;
	for(size_t iRun = 0, iToken = 0; iRun < runs.GetCount(); ++iRun) {
		const CLineLayout::CRun&	currentRun = runs.GetAt(iRun);	// `撆̃
		const bool	bLastRun = iRun == runs.GetCount() - 1;			// Ō̃
		const int	nRunWidth = (currentRun.GetWidth() != CLineLayout::CRun::LINE_WIDTH) ? currentRun.GetWidth() : lineLayout.GetWidth();
		const length_t	iNextRun = !bLastRun ? runs.GetAt(iRun + 1).GetIndex() : cchLine;	// ̃̊Jnʒu
		int	nNextDrawStart =
			_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(currentRun.GetIndex()));	// `JnʒuBrcPaint Ƃ̔rɎgp

		// `悪Kv`FbN
		if(!currentRun.IsRightToLeft() && (nNextDrawStart >= rcPaint.right || nNextDrawStart + nRunWidth < rcPaint.left))
			continue;
		else if(currentRun.IsRightToLeft() && (nNextDrawStart - nRunWidth >= rcPaint.right || nNextDrawStart < rcPaint.left))
			continue;

		iChar = currentRun.GetIndex();

		// `悷郉܂ލŏ̃g[N܂ňړ
		while(iToken < tokens.count && tokens.array[iToken].GetIndex() <= iChar)
			++iToken;
		--iToken;

		// g[NƂ̃[v (E̓g[NEƓʒuɌƂ͌ȂŒ)
		while(iToken < tokens.count) {
			const CToken&	currentToken = tokens.array[iToken];
			const length_t	iNextToken = (iToken != tokens.count - 1) ? tokens.array[iToken + 1].GetIndex() : cchLine;
			const int		tokenType = (iNextToken - iChar == 1
				&& layoutManager.IsTokenEnabled(ETT_MATCH_BRACKETS)
				&& ((iLine == m_posHilightedBrackets[0].m_iLine && iChar == m_posHilightedBrackets[0].m_iChar)
				|| (iLine == m_posHilightedBrackets[1].m_iLine && iChar == m_posHilightedBrackets[1].m_iChar))) ?
				ETT_MATCH_BRACKETS : currentToken.GetType();
			const TTextFoundation	foundation = layoutManager.GetTokenFoundation(tokenType, currentToken.GetCookie());
			HFONT	hOldFont = dc.SelectObject(layoutManager.GetFontForRenderingToken(tokenType, currentToken.GetCookie()));
			const int	nTokenEdge = nNextDrawStart;

			do {
				enum {NORMAL, SELECTION, RESTRICTION} regionalOverlay = NORMAL;
				if(iChar >= iSelBegin && iChar < iSelEnd)
					regionalOverlay = SELECTION;
				else if(GetDocument().IsNarrowed() && (iChar < iAccBegin || iChar >= iAccEnd))
					regionalOverlay = RESTRICTION;

#define _SELECT_FG_COLOR(selectionColor, restrictionColor, normalColor)			\
	if(regionalOverlay == SELECTION && selectionColor != 0x80000000)			\
		dc.SetTextColor(selectionColor);										\
	else if(regionalOverlay == RESTRICTION && restrictionColor != 0x80000000)	\
		dc.SetTextColor(restrictionColor);										\
	else																		\
		dc.SetTextColor((wholeForeColor == -1) ? normalColor : wholeForeColor)
#define _SELECT_BG_COLOR(selectionColor, restrictionColor, normalColor)			\
	if(regionalOverlay == SELECTION && selectionColor != 0x80000000)			\
		dc.SetBkColor(selectionColor);											\
	else if(wholeBackColor != -1)												\
		dc.SetBkColor(wholeBackColor);											\
	else if(regionalOverlay == RESTRICTION && restrictionColor != 0x80000000)	\
		dc.SetBkColor(restrictionColor);										\
	else																		\
		dc.SetBkColor(normalColor)

				// ^u
				if(pwszLine[iChar] == L'\t') {
					// `̈̌vZ
					if(!currentRun.IsRightToLeft()) {	// LTR
						rect.left = _MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar));
						nNextDrawStart = rect.right = _MAP_TO_DRAWING_POS(
							layoutManager.GetNextTabStop(_MapClientXToAbsoluteX(rect.left, lineLayout.GetWidth()), true));
					} else {	// RTL
						rect.right = _MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar));
						nNextDrawStart = rect.left = _MAP_TO_DRAWING_POS(
							layoutManager.GetNextTabStop(_MapClientXToAbsoluteX(rect.left, lineLayout.GetWidth()), false));
					}

					if(rect.right >= rcPaint.left && rect.left <= rcPaint.right) {
						_SELECT_FG_COLOR(selectionForeColor, restrictionForeColor,
							layoutManager.GetTokenFoundation(TT_TAB, NullCookie).fgColor);
						_SELECT_BG_COLOR(selectionBackColor, restrictionBackColor,
							layoutManager.GetTokenFoundation(tokenType, currentToken.GetCookie()).bgColor);
						dc.ExtTextOut(rect.left, y, _GET_ETO_FLAGS(),
							&rect, &layout.substitutionGlyphs.chHorizontalTab,
							(regionalOverlay == SELECTION || !m_pSharedData->options.appearance[SHOW_WHITESPACE_ALTERNATIVE]) ? 0 : 1, 0);
					}
					++iChar;
				}

				// ASCII 䕶
				else if(CLexer::IsAsciiControl(pwszLine[iChar])) {
					char_t	wszSubstitution[2];
					CLexer::GetAsciiControlSubstitutionGlyph(static_cast<uchar>(pwszLine[iChar]), wszSubstitution);

					if(currentRun.IsRightToLeft())	// ŋt܂ɂႦ
						swap(wszSubstitution[0], wszSubstitution[1]);

					// `̈̌vZ
					(!currentRun.IsRightToLeft() ? rect.left : rect.right) = _MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar));
					if(!currentRun.IsRightToLeft())	// LTR
						nNextDrawStart = rect.right = (iNextRun - iChar > 1) ?
							_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar + 1))
							: rect.left + dc.GetTextExtent(wszSubstitution, 2).cx;
					else	// RTL
						nNextDrawStart = rect.left = (iNextRun - iChar > 1) ?
							_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar + 1))
							: rect.right - dc.GetTextExtent(wszSubstitution, 2).cx;

					if(rect.right >= rcPaint.left && rect.left <= rcPaint.right) {
						_SELECT_FG_COLOR(0x80000000, restrictionForeColor,
							layoutManager.GetTokenFoundation(TT_ASCII_CONTROL, NullCookie).fgColor);
						_SELECT_BG_COLOR(selectionBackColor, restrictionBackColor,
							layoutManager.GetTokenFoundation(tokenType, currentToken.GetCookie()).bgColor);
						dc.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect, wszSubstitution, 2, 0);
					}
					++iChar;
				}

				// 󔒗ޕ
				else if(GetLexer().IsWhiteSpace(pwszLine[iChar], false)) {
					// փOtƑOiF߂
					char_t	chSubstitution;
					if(!m_pSharedData->options.appearance[SHOW_WHITESPACE_ALTERNATIVE])
						chSubstitution = L' ';
					else if(pwszLine[iChar] == L'\x1680') {	// Ogham Space Mark
						chSubstitution = L'\x1680';
						_SELECT_FG_COLOR(0x80000000, restrictionForeColor,
							layoutManager.GetTokenFoundation(TT_WHITESPACE, NullCookie).fgColor);
					} else {
						if(pwszLine[iChar] == L'\x3000')	// Ideographic Space
							chSubstitution = layout.substitutionGlyphs.chIdeographicSpace;
						else
							chSubstitution = layout.substitutionGlyphs.chGeneralWhiteSpace;
						_SELECT_FG_COLOR(0x80000000, restrictionForeColor,
							layoutManager.GetTokenFoundation(TT_WHITESPACE, NullCookie).fgColor);
					}

					// `̈̌vZ
					(!currentRun.IsRightToLeft() ? rect.left : rect.right) = _MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar));
					if(!currentRun.IsRightToLeft())	// LTR
						nNextDrawStart = rect.right = (iNextRun - iChar > 1) ?
							_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar + 1))
							: rect.left + dc.GetTextExtent(pwszLine + iChar, 1).cx;
					else	// RTL
						nNextDrawStart = rect.left = (iNextRun - iChar > 1) ?
							_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar + 1))
							: rect.right - dc.GetTextExtent(pwszLine + iChar, 1).cx;
					if(rect.right >= rcPaint.left && rect.left <= rcPaint.right) {
						_SELECT_BG_COLOR(selectionBackColor, restrictionBackColor,
							layoutManager.GetTokenFoundation(tokenType, currentToken.GetCookie()).bgColor);
						dc.ExtTextOut(rect.left, y, _GET_ETO_FLAGS(), &rect, &chSubstitution,
							(regionalOverlay == SELECTION || !m_pSharedData->options.appearance[SHOW_WHITESPACE_ALTERNATIVE]) ? 0 : 1, 0);
					}
					++iChar;
				}

				// Unicode R[h͌ł܂Ƃ߂ĕ`
				else if(_IS_DIRECTIONAL_FORMATTING_CODE(pwszLine[iChar])) {
					if(m_pSharedData->options.appearance[SHOW_UNICODE_CONTROLS])
						bidiFormatterOccurences.push(iChar);
					++iChar;
				}

				// ȊO͉炩̋EɒB܂ł܂Ƃ߂ĕ`悷
				else {
					// `悷镶߂
					length_t		cchDraw = 1;
					const length_t	iNextRunOrTokenBoundary = min(iNextRun, iNextToken);
					while(iChar + cchDraw < iNextRunOrTokenBoundary) {
						if(GetLexer().IsWhiteSpace(pwszLine[iChar + cchDraw], true)
								|| CLexer::IsAsciiControl(pwszLine[iChar + cchDraw])
								|| iChar + cchDraw == iSelBegin
								|| iChar + cchDraw == iSelEnd
								|| (GetDocument().IsNarrowed() && (iChar + cchDraw == iAccBegin || iChar + cchDraw == iAccEnd))
								|| _IS_DIRECTIONAL_FORMATTING_CODE(pwszLine[iChar + cchDraw]))
							break;
						++cchDraw;
					}

					// `̈̌vZ
					if(!currentRun.IsRightToLeft()) {	// LTR
						rect.left = _MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar));
						nNextDrawStart = rect.right =
							(runs.GetCount() == 1 || iNextRun > iChar + cchDraw) ?
								_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar + cchDraw))
								: rect.left + dc.GetTextExtent(pwszLine + iChar, cchDraw).cx;
					} else {	// RTL
						rect.right = _MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar));
						nNextDrawStart = rect.left =
							(runs.GetCount() == 1 || iNextRun > iChar + cchDraw) ?
								_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iChar + cchDraw))
								: rect.right - dc.GetTextExtent(pwszLine + iChar, cchDraw).cx;
					}

					if(rect.right >= rcPaint.left && rect.left <= rcPaint.right) {
						_SELECT_FG_COLOR(selectionForeColor, restrictionForeColor, foundation.fgColor);
						_SELECT_BG_COLOR(selectionBackColor, restrictionBackColor, foundation.bgColor);
						if(currentRun.IsRightToLeft() && iChar > 0) {
							//  RTL ɂ...
							const char_t	chOriginal = pwszLine[iChar - 1];
							const_cast<char_t*>(pwszLine)[iChar - 1] = 0x202E;	// RLO
							dc.ExtTextOut(rect.left, y, _GET_ETO_FLAGS(), &rect, pwszLine + iChar - 1, cchDraw + 1, 0);
							const_cast<char_t*>(pwszLine)[iChar - 1] = chOriginal;
						} else
							dc.ExtTextOut(rect.left, y, _GET_ETO_FLAGS(), &rect, pwszLine + iChar, cchDraw, 0);
					}
					iChar += cchDraw;
				}

				if((!currentRun.IsRightToLeft() && nNextDrawStart > rcPaint.right)
						|| (currentRun.IsRightToLeft() && nNextDrawStart < rcPaint.left))
					iChar = iNextRun;	// ȏケ̃`͖̂
			} while(iChar < iNextToken && iChar < iNextRun);

			if(iChar == iNextToken) {	// g[NI[ɒB
				++iToken;
				dc.SelectObject(hOldFont);
				if(foundation.border != BT_NONE)	// /g
					DrawBorder(originalDC, min(nTokenEdge, nNextDrawStart), rect.top,
						max(nTokenEdge, nNextDrawStart), rect.bottom - layout.nLineSpan,
						foundation.border, foundation.borderColor);
			}

			if(iChar == iNextRun)	// I[ɒB
				break;
		}
	}

TEXT_END:

	// N̋\
	const TTextFoundation	tfLink = layoutManager.GetTokenFoundation(ETT_LINK, NullCookie);
	for(list<pair<length_t, length_t> >::const_iterator it = links.begin(); it != links.end(); ++it) {
		DrawBorder(originalDC, PosFromChar(CCharPos(iLine, it->first)).x, y,
			PosFromChar(CCharPos(iLine, it->second)).x,
			y + layoutManager.GetLineHeight() - layout.nLineSpan, tfLink.border, tfLink.borderColor);
	}

	// I}[N (obt@I[AsI[)
	int	cxEndMark = 0;
	if((!layout.bRightToLeftReading && _MAP_TO_DRAWING_POS(lineLayout.GetWidth()) <= rcPaint.right)
			|| (layout.bRightToLeftReading && _MAP_TO_DRAWING_POS(lineLayout.GetWidth()) >= rcPaint.left)) {

		// obt@I[
		if(iLine == GetDocument().GetLineCount() - 1) {
			if(!layout.substitutionGlyphs.strEndOfFile.empty()
					&& m_pSharedData->options.appearance[SHOW_END_OF_FILE]) {	// [EOF] }[N
				const TTextFoundation&	foundation = layoutManager.GetTokenFoundation(ETT_END_OF_FILE, NullCookie);
				HFONT	hOldFont = dc.SelectObject(layoutManager.GetFontForRenderingToken(ETT_END_OF_FILE, NullCookie));

				dc.SetTextColor(foundation.fgColor);
				dc.SetBkColor(foundation.bgColor);
				cxEndMark = DrawEofMarker(originalDC, _MAP_TO_DRAWING_POS(lineLayout.GetWidth()), y);
				dc.SelectObject(hOldFont);
			}
		}

		// sI[
		else if(m_pSharedData->options.appearance[SHOW_BREAK_ARROWS]) {
			COLORREF	bgColor;

			if(iSelBegin != -1 && iSelEnd == -1
					&& m_pSharedData->options.appearance[SHOW_SELECTION_ON_BREAK])
				bgColor = selectionBackColor;
			else if(wholeBackColor != -1)
				bgColor = wholeBackColor;
			else
				bgColor = layoutManager.GetTokenFoundation(ETT_NORMAL, NullCookie).bgColor;
			cxEndMark = DrawLineTerminator(originalDC,
				_MAP_TO_DRAWING_POS(!layout.bRightAlign ? lineLayout.GetWidth() : 0), y, lineBreak,
				layoutManager.GetTokenFoundation(
					(iAccBegin != -1 && iAccEnd == -1) ? ETT_END_OF_LINE : ETT_RESTRICTION, NullCookie).fgColor,
				bgColor, layout.bRightAlign);
		}
	}

	// 㑱̗]
	const int	xEnd = _MAP_TO_DRAWING_POS(!layout.bRightAlign ? lineLayout.GetWidth() : 0) + (!layout.bRightAlign ? cxEndMark : -cxEndMark);
	if(!layout.bRightAlign && xEnd <= rcPaint.right)	// 
		dc.FillSolidRect(xEnd, y, rcPaint.right - xEnd,
			layoutManager.GetLineHeight(), (wholeBackColor == -1) ?
			layoutManager.GetTokenFoundation(ETT_NORMAL, NullCookie).bgColor : wholeBackColor);
	else if(layout.bRightAlign && xEnd >= rcPaint.left)	// E
		dc.FillSolidRect(rcPaint.left, y, xEnd - rcPaint.left,
			layoutManager.GetLineHeight(), (wholeBackColor == -1) ?
			layoutManager.GetTokenFoundation(ETT_NORMAL, NullCookie).bgColor : wholeBackColor);

	// Unicode R[h
	if(m_pSharedData->options.appearance[SHOW_UNICODE_CONTROLS] && !bidiFormatterOccurences.empty()) {
		const CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver&
				sub = layoutManager.GetFontForBidirectionalFormatterSubstitution();
		HFONT	hOldFont = dc.SelectObject(sub.GetFont());

		while(!bidiFormatterOccurences.empty()) {
			const length_t	iOccurence = bidiFormatterOccurences.front();
			const ushort	glyph = sub.GetGlyphIndex(dc, pwszLine[iOccurence]);
			if(glyph != 0xFFFF) {
				const TTextFoundation	foundation = layoutManager.GetTokenFoundation(
					(iOccurence >= iSelBegin && iOccurence < iSelEnd) ? ETT_SELECTION :
						((iOccurence < iAccBegin || iOccurence > iAccEnd) ? ETT_RESTRICTION : TT_UNICODE_CONTROL), NullCookie);
				dc.SetTextColor(foundation.fgColor);
				dc.SetBkColor(foundation.bgColor);
				dc.ExtTextOut(_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iOccurence)),
					y, ETO_GLYPH_INDEX, 0, reinterpret_cast<char_t*>(const_cast<ushort*>(&glyph)), 1, 0);
//				dc.ExtTextOut(_MAP_TO_DRAWING_POS(lineLayout.GetCaretPosition(iOccurence)),
//					y, ETO_IGNORELANGUAGE, 0, pwszLine + iOccurence, 1, 0);
			}
			bidiFormatterOccurences.pop();
		}
		dc.SelectObject(hOldFont);
	}

	// ݍs̉
	if(bCaretLine) {
		RECT	rcClient;
		HPEN	hOldPen = dc.SelectObject(HasFocus() ?
			m_pSharedData->gdiObjects.hCaretLinePen : m_pSharedData->gdiObjects.hIACaretLinePen);

		GetClientRect(rcClient);
		dc.MoveTo(!layout.bRightAlign ?
			rcClient.left + layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin : rcClient.left,
			y + layoutManager.GetLineHeight() - 1);
		dc.LineTo(!layout.bRightAlign ?
			rcClient.right : rcClient.right - layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin,
			y + layoutManager.GetLineHeight() - 1);
		dc.SelectObject(hOldPen);
	}

#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	// ʏ̕`rbg}bvɕ`e]
#undef dc
	RECT		rcClient;
	GetClientRect(rcClient);
	const int	nLeft = max(!layout.bRightAlign ?
		rcClient.left + layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin : rcClient.left, rcPaint.left);
	const int	nRight = min(!layout.bRightAlign ?
		rcClient.right : rcClient.right - layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin, rcPaint.right);
	dc.BitBlt(nLeft, yOriginal, nRight - nLeft, layoutManager.GetLineHeight() * 1, m_memDC, nLeft, 0, SRCCOPY);
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	return 1;

#undef _MAP_TO_DRAWING_POS
#undef _GET_ETO_FLAGS
#undef _IS_DIRECTION_FORMATTER
#undef _SELECT_FG_COLOR
#undef _SELECT_BG_COLOR
}

/**
 *	s}[N̕`
 *	@param dc			foCXReLXg
 *	@param x, y			`ʒu
 *	@param lineBreak	`悷s
 *	@param fgColor		OiF
 *	@param bgColor		wiF
 *	@param bMirrored	E]邩
 *	@return				`敝
 */
int CEditView::DrawLineTerminator(CPaintDC& dc,
		int x, int y, LineBreak lineBreak, COLORREF fgColor, COLORREF bgColor, bool bMirrored) {
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
#define dc m_memDC
	y = 0;
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();

	if((lineBreak == LB_LF && layout.substitutionGlyphs.chUnixEol == 0xFFFF)
			|| (lineBreak == LB_CR && layout.substitutionGlyphs.chMacintoshEol == 0xFFFF)
			|| (lineBreak == LB_CRLF && layout.substitutionGlyphs.chWindowsEol == 0xFFFF)) {
		HPEN	hPen = ::CreatePen(PS_SOLID, 1, fgColor);
		HPEN	hOldPen = dc.SelectObject(hPen);
		int		cx = layoutManager.GetAverageCharacterWidth();
		int		cy = layoutManager.GetLineHeight();
		int		hx, hy;

		// ŏl̐ݒ
		cx = max(cx, 7);

		// RTL ̏ꍇ͔]
		if(GetLayoutSettings().GetSettings().bRightToLeftReading)
			x -= cx;

		// wiFh
		dc.FillSolidRect(x, y, cx, cy, bgColor);

		// ɑƕ`Ղ?
		cx -= (cx % 2 == 0) ? 1 : 0;
		cy -= (cy % 2 == 0) ? 1 : 0;

		// ̈ʒu
		hx = x + cx / 2;
		hy = y + cy / 2;

/*
		ȑOgĂE̕`R[h
		dc.MoveTo(x + 1, hy);
		dc.LineTo(x + cx, hy);
		dc.MoveTo(hx + 1, hy - cx / 2 + 1);
		dc.LineTo(x + cx, hy + 1);
		dc.MoveTo(hx + 1, hy + cx / 2 - 1);
		dc.LineTo(x + cx, hy - 1);
*/

		if(lineBreak == LB_LF) {	// 
			dc.MoveTo(x + cx - 1, hy);
			dc.LineTo(x, hy);
			dc.MoveTo(hx - 0, hy - cx / 2 + 1);
			dc.LineTo(x + 0, hy + 1);
			dc.MoveTo(hx - 0, hy + cx / 2 - 1);
			dc.LineTo(x + 0, hy - 1);
		} else if(lineBreak == LB_CR) {	// 
			dc.MoveTo(hx, hy - cx / 2);
			dc.LineTo(hx, hy + cx / 2 + 1);
			dc.MoveTo(x + 1, hy + 1);
			dc.LineTo(hx, hy + cx / 2);
			dc.MoveTo(x + cx - 2, hy + 1);
			dc.LineTo(hx, hy + cx / 2);
		} else {	// p
			dc.MoveTo(x + cx - 1, hy - cx / 2);
			dc.LineTo(x + cx - 1, hy + cy / 4);
			dc.LineTo(x, hy + cy / 4);
			dc.MoveTo(hx - 0, hy - cx / 2 + 1 + cy / 4);
			dc.LineTo(x + 0, hy + 1 + cy / 4);
			dc.MoveTo(hx - 0, hy + cx / 2 - 1 + cy / 4);
			dc.LineTo(x + 0, hy - 1 + cy / 4);
		}
		dc.SelectObject(hOldPen);
		::DeleteObject(hPen);
		return cx;
	} else {
		HFONT	hOldFont = dc.SelectObject(layoutManager.GetRegularFont());
		RECT	rect;
		int		nWidth;
		char_t	chGlyph;

		switch(lineBreak) {
		case LB_LF:		chGlyph = layout.substitutionGlyphs.chUnixEol;				break;
		case LB_CR:		chGlyph = layout.substitutionGlyphs.chMacintoshEol;			break;
		case LB_CRLF:	chGlyph = layout.substitutionGlyphs.chWindowsEol;			break;
		case LB_NEL:	chGlyph = layout.substitutionGlyphs.chEbcdicEol;			break;
		case LB_LS:		chGlyph = layout.substitutionGlyphs.chLineSeparator;		break;
		case LB_PS:		chGlyph = layout.substitutionGlyphs.chParagraphSeparator;	break;
		default:		assert(false);
		}

		dc.GetCharWidth(chGlyph, chGlyph, &nWidth);
		::SetRect(&rect, x, y, x + nWidth, y + layoutManager.GetLineHeight());
		dc.SetTextColor(layoutManager.GetTokenFoundation(ETT_END_OF_LINE, NullCookie).fgColor);
		dc.SetBkColor(bgColor);
		dc.SetBkMode(OPAQUE);
		dc.ExtTextOut(x, y, ETO_OPAQUE, &rect, &chGlyph, 1, 0);
		dc.SelectObject(hOldFont);

		return nWidth;
	}

#undef dc
}

/**
 *	[`
 *	@param dc			foCXReLXg
 *	@param iStart, iEnd	`JnsƏIs (\sB̍s`Ɋ܂܂)
 */
void CEditView::DrawVerticalRuler(CPaintDC& dc, length_t iStart, length_t iEnd) {
	AssertValidAsWindow();//static _; dout << L"\n" << _++ << L": " << iStart << L" - " << iEnd;

	if(iStart > iEnd)
		swap(iStart, iEnd);

	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = GetLayoutSettings().GetSettings();
	const ushort				nLineHeight = layoutManager.GetLineHeight();
	RECT		rcClient;
	const int	yStart = layout.nTopMargin + (iStart - m_scrollInfo.position.y) * nLineHeight;

	GetClientRect(rcClient);

	const int	yEnd = min<int>(yStart + (iEnd - iStart + 1) * nLineHeight, dc.GetPaintStruct().rcPaint.bottom);
	const long	nBottomSpace = rcClient.bottom - yStart -
					(GetDocument().GetLineCount() - iStart) * nLineHeight;

	// CWP[^}[W
	if(layout.lineNumberLayout.bShowIndicatorMargin) {
		const ushort	nWidth = layout.lineNumberLayout.nIMWidth;
		HPEN			hOldPen = dc.SelectObject(m_pSharedData->gdiObjects.hLeftIndicatorPen);
		const COLORREF	bgColor = layoutManager.GetTokenFoundation(ETT_INDICATOR_MARGIN, NullCookie).bgColor;

		// ]
		if(layout.nTopMargin != 0) {
			dc.FillSolidRect(!layout.bRightAlign ?
				rcClient.left : rcClient.right - nWidth + 1, rcClient.top, nWidth, layout.nTopMargin, bgColor);
			dc.MoveTo(!layout.bRightAlign ? rcClient.left + nWidth - 1 : rcClient.right - nWidth, rcClient.top);
			dc.LineTo(!layout.bRightAlign ?
				rcClient.left + nWidth - 1 : rcClient.right - nWidth, rcClient.top + layout.nTopMargin);
		}

		// esɑΉ镔
		if(layout.wrapMode == WPM_NONE) {
			dc.FillSolidRect(!layout.bRightAlign ?
				rcClient.left : rcClient.right - nWidth + 1, yStart, nWidth, yEnd - yStart, bgColor);
			dc.MoveTo(!layout.bRightAlign ? rcClient.left + nWidth - 1 : rcClient.right - nWidth, yStart);
			dc.LineTo(!layout.bRightAlign ? rcClient.left + nWidth - 1 : rcClient.right - nWidth, yEnd);

			// hNXɃCWP[^}[W̕`@^
			RECT	rect = {!layout.bRightAlign ? rcClient.left : rcClient.right - nWidth,
							yStart, !layout.bRightAlign ? rcClient.left + nWidth : rcClient.right, yEnd};
			for(length_t iLine = iStart; iLine <= iEnd; ++iLine) {
				DrawIndicatorMargin(iLine, dc, rect);
				::OffsetRect(&rect, 0, nLineHeight);
			}
		}

		// ]
		if(nBottomSpace > 0) {
			dc.FillSolidRect(!layout.bRightAlign ?
				rcClient.left : rcClient.right - nWidth + 1, rcClient.bottom - nBottomSpace, nWidth, nBottomSpace, bgColor);
			dc.MoveTo(!layout.bRightAlign ?
				rcClient.left + nWidth - 1 : rcClient.right - nWidth, rcClient.bottom - nBottomSpace);
			dc.LineTo(!layout.bRightAlign ? rcClient.left + nWidth - 1 : rcClient.right - nWidth, rcClient.bottom);
		}

		dc.SelectObject(hOldPen);
		if(!layout.bRightAlign)	rcClient.left += nWidth;
		else					rcClient.right -= nWidth;
	}

	// sԍ
	if(layout.lineNumberLayout.bShowLineNumbers) {
		char_t		wszLineNumber[32];
		const long	nWidth = layoutManager.GetVerticalRulerWidth() - layout.lineNumberLayout.nIMWidth;
		RECT		rect, rcDigits;	// sԍGAŜƐ`̋`
		length_t	iLogicalStart, iDummy;
		const UINT	nDrawTextFlags = DT_NOCLIP | DT_TOP | (!layout.bRightAlign ? DT_RIGHT : DT_LEFT) | DT_SINGLELINE;

		dc.SetTextCharacterExtra(0);	// sԍ\͕Ԋu̐ݒ𖳎
		GetDisplayLineOffsetIndex(iStart, iLogicalStart, iDummy);

		CEditDoc::LineIterator	it = GetDocument().GetLineIterator(iLogicalStart);

		rect = rcClient;
		if(!layout.bRightAlign) {	// 
			rect.right = rect.left + nWidth;
			rcDigits.left = rect.left;
			rcDigits.right = rect.right - 4;
			if(layout.lineNumberLayout.borderStyle != TLineNumberLayout::LNBS_NONE)
				rcDigits.right -= layout.lineNumberLayout.nBorderWidth;
		} else {	// E
			rect.left = rect.right - nWidth + 1;
			rcDigits.right = rect.right;
			rcDigits.left = rect.left + 4;
			if(layout.lineNumberLayout.borderStyle != TLineNumberLayout::LNBS_NONE)
				rcDigits.left += layout.lineNumberLayout.nBorderWidth;
		}
		dc.SetBkMode(OPAQUE);

		// ]
		if(layout.nTopMargin != 0)
			dc.FillSolidRect(rect.left, rcClient.top,
				rect.right - rect.left, layout.nTopMargin,
				layoutManager.GetTokenFoundation(ETT_LINENUMBER, NullCookie).bgColor);

		if(layout.wrapMode == WPM_NONE) {
			// s1s`
			for(length_t iLine = iStart; iLine <= iEnd; ++iLine, ++it) {
				swprintf(wszLineNumber, L"%lu", iLine + layout.lineNumberLayout.iStartLine);
				rect.top = rcDigits.top = (iLine - m_scrollInfo.GetY()) * nLineHeight + layout.nTopMargin;
				rect.bottom = rcDigits.bottom = rect.top + nLineHeight;

				const EmphaticTextType	type = it->IsModified() ? ETT_EMPHATIC_LINENUMBER : ETT_LINENUMBER;
				const TTextFoundation	foundation = layoutManager.GetTokenFoundation(type, NullCookie);

				// tHgȂǂ̑I
				dc.SetTextColor(foundation.fgColor);
				dc.SetBkColor(foundation.bgColor);
				HFONT	hOldFont = dc.SelectObject(layoutManager.GetFontForRenderingToken(type, NullCookie));
				dc.FillSolidRect(rect.left, rect.top,
					rect.right - rect.left, layoutManager.GetLineHeight(), foundation.bgColor);
				dc.DrawText(wszLineNumber, -1, rcDigits, nDrawTextFlags);
				dc.SelectObject(hOldFont);
			}

			// ]
			if(nBottomSpace > 0)
				dc.FillSolidRect(rect.left, rcClient.bottom - nBottomSpace,
					rect.right - rect.left, nBottomSpace,
					layoutManager.GetTokenFoundation(ETT_LINENUMBER, NullCookie).bgColor);
		} else {	// ܂Ԃlꍇ
/*			length_t			iLine = iStart;
			length_t			iLogicalLine;
			length_t			iOffset;
			EmphaticTextType	type;
			TTextFoundation		foundation;

			GetDisplayLineOffsetIndex(iStart * m_scrollInfo.nVerticalRatio, iLogicalLine, iOffset);
			CLineLayout*			pLine = layoutManager.GetLine(iLogicalLine);
			const WrappedOffsets*	pWrappedOffsets = pLine->GetWrappedPoints();
			assert(pWrappedOffsets != 0);
			while(iLine <= iEnd && pLine != 0) {
				type = it->IsModified() ? ETT_EMPHATIC_LINENUMBER : ETT_LINENUMBER;
				if(iOffset >= pWrappedOffsets->size() + 1) {	// ̘_s֐i
					++iLogicalLine;
					++it;
					type = it->IsModified() ? ETT_EMPHATIC_LINENUMBER : ETT_LINENUMBER;
					foundation = layoutManager.GetTokenFoundation(type, NullCookie);
					iOffset = 0;
					pLine = layoutManager.GetLine(iLogicalLine);
					continue;
				}
				if(iOffset == 0) {
					swprintf(wszLineNumber, L"%lu", iLogicalLine + layout.lineNumberLayout.iStartLine);
					rcLineNumber.top = rcLineNumberDraw.top
						= (iLine - m_scrollInfo.GetY()) * layoutManager.GetLineHeight() + layout.nTopMargin;
					rcLineNumber.bottom = rcLineNumberDraw.bottom = rcLineNumber.top + nLineHeight;

					// tHgȂǂ̑I
					dc.SetTextColor(foundation.fgColor);
					dc.SetBkColor(foundation.bgColor);
					HFONT	hOldFont = dc.SelectObject(layoutManager.GetFontForRenderingToken(type, NullCookie));
					dc.FillSolidRect(rcLineNumberDraw.right, rcLineNumber.top,
						rcLineNumber.right - rcLineNumberDraw.right, nLineHeight, foundation.bgColor);
					dc.DrawText(wszLineNumber, -1, rcLineNumberDraw, DT_TOP | DT_RIGHT | DT_SINGLELINE);
					dc.SelectObject(hOldFont);
				}
				++iLine;
				++iOffset;
			}
*/		}

		// sԍ̋E̕`
		if(layout.lineNumberLayout.borderStyle != TLineNumberLayout::LNBS_NONE) {
			const int	xBorder = (!layout.bRightAlign ? rect.right : rect.left) - layout.lineNumberLayout.nBorderWidth / 2 - 1;
			HPEN		hOldPen = dc.SelectObject(m_pSharedData->gdiObjects.hLineNumberPen);
			dc.MoveTo(xBorder, rcClient.top);
			dc.LineTo(xBorder, rcClient.bottom);
			dc.SelectObject(hOldPen);
		}
	}
}

/// @see	IDropTarget::Drop
STDMETHODIMP CEditView::Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	if(pDataObj == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pdwEffect);

	CEditDoc&	document = GetDocument();

	*pdwEffect = DROPEFFECT_NONE;

	if(m_nMouseOperationDisabledCount != 0)
		return S_OK;
	else if(m_leftDownMode == LDM_DRAGANDDROP) {	// Rg[̃f[^
		FORMATETC	fe = {CF_UNICODETEXT, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
		STGMEDIUM	stm = {TYMED_HGLOBAL, 0};
		POINT		ptCaret = {pt.x, pt.y};

		KillTimer(TIMERID_DRAGSCROLL);
		ScreenToClient(ptCaret);
		const CCharPos	pos = CharFromPos(ptCaret,
			!m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
		GetSelection().MoveTo(pos, true);
		const UINT	nBoxClipFormat = ::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT);

		if(pDataObj->QueryGetData(&fe) == S_OK) {	// CF_UNICODETEXT T|[g
			if(SUCCEEDED(pDataObj->GetData(&fe, &stm))) {
				const char_t*	pwsz = static_cast<char_t*>(::GlobalLock(stm.hGlobal));

				document.EndEditCollection();
				Freeze();
				if(fe.cfFormat = nBoxClipFormat, pDataObj->QueryGetData(&fe) == S_OK) {	// `hbv
					document.BeginEditCollection();
					m_pSelection->GetActivePoint().InsertBox(pwsz);
					document.EndEditCollection();
					m_pSelection->Select(pos, m_pSelection->GetActivePoint(), true, true);
				} else {
					m_pSelection->GetActivePoint().Insert(pwsz);
					m_pSelection->Select(pos, m_pSelection->GetActivePoint(), false, true);
				}
				Unfreeze();
				::GlobalUnlock(stm.hGlobal);
				if(stm.pUnkForRelease != 0)
					stm.pUnkForRelease->Release();
				*pdwEffect = DROPEFFECT_COPY;
			}
		} else if(fe.cfFormat = CF_TEXT, pDataObj->QueryGetData(&fe) == S_OK) {	// CF_TEXT T|[g
			if(SUCCEEDED(pDataObj->GetData(&fe, &stm))) {
				const char*		pszText = static_cast<char*>(::GlobalLock(stm.hGlobal));
				const length_t	cch = min<length_t>(strlen(pszText), ::GlobalSize(stm.hGlobal) / sizeof(char));
				char_t*			pwszText = new char_t[cch];

				::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, pszText, -1, pwszText, cch);
				Freeze();
				if(fe.cfFormat = nBoxClipFormat, pDataObj->QueryGetData(&fe) == S_OK) {	// `hbv
					document.BeginEditCollection();
					m_pSelection->GetActivePoint().InsertBox(string_t(pwszText, cch));
					document.EndEditCollection();
					m_pSelection->Select(pos, m_pSelection->GetActivePoint(), true, true);
				} else {
					m_pSelection->GetActivePoint().Insert(string_t(pwszText, cch));
					m_pSelection->Select(pos, m_pSelection->GetActivePoint(), false, true);
				}
				Unfreeze();
				delete[] pwszText;
				::GlobalUnlock(stm.hGlobal);
				if(stm.pUnkForRelease != 0)
					stm.pUnkForRelease->Release();
				*pdwEffect = DROPEFFECT_COPY;
			}
		}
	} else if(m_leftDownMode == LDM_DRAGANDDROPSELF
			|| m_leftDownMode == LDM_DRAGANDDROPBOXSELF) {	// vZX̃f[^ (pDataObj gȂȒPȏ)
		string_t	strText = m_pSelection->GetText();
		POINT		ptCaret = {pt.x, pt.y};

		ScreenToClient(ptCaret);
		const CCharPos	pos = CharFromPos(ptCaret,
			!m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);

		// vZX̃f[^͑I͈͏Ƀhbvs
		if(m_pSelection->IsPointOver(ptCaret)) {
			*pdwEffect = DROPEFFECT_NONE;
			m_leftDownMode = LDM_NONE;
			GetSelection().MoveTo(pos, true);
			return S_OK;
		}

		_BEGIN_OPERATION_SEQUENCE();

		if(toBoolean(grfKeyState & MK_CONTROL)) {	// 
			InvalidateLines(m_pSelection->GetAnchorPoint().GetLineNumber(), m_pSelection->GetActivePoint().GetLineNumber());
			m_pSelection->GetActivePoint().MoveTo(pos);
			if(m_leftDownMode == LDM_DRAGANDDROPBOXSELF) {	// `
				m_pSelection->GetActivePoint().InsertBox(strText);
				m_pSelection->Select(pos, m_pSelection->GetActivePoint(), true, true);
			} else {	// `
				m_pSelection->GetActivePoint().Insert(strText);
				m_pSelection->Select(pos, m_pSelection->GetActivePoint(), false, true);
			}
			*pdwEffect = DROPEFFECT_COPY;
		} else if(m_leftDownMode == LDM_DRAGANDDROPBOXSELF) {	// `ړ
			CSynchronizablePoint*	pInsertPoint = GetDocument().CreateSynchronizablePoint();

			pInsertPoint->SynchronizeWithDocumentUpdate(true);
			pInsertPoint->MoveTo(pos);
			m_pSelection->Delete();
			pInsertPoint->SynchronizeWithDocumentUpdate(false);
			m_pSelection->GetActivePoint().MoveTo(*pInsertPoint);
			m_pSelection->GetActivePoint().InsertBox(strText);
			m_pSelection->Select(*pInsertPoint, m_pSelection->GetActivePoint(), true, true);
			delete pInsertPoint;
			*pdwEffect = DROPEFFECT_MOVE;
		} else {	// ړ
			CEditPoint*		pActivePointOrg = GetDocument().CreateEditPoint();
			const CCharPos	posAnchorOrg = m_pSelection->GetAnchorPoint();

			pActivePointOrg->SynchronizeWithDocumentUpdate(true);
			pActivePointOrg->MoveTo(m_pSelection->GetActivePoint());
			GetSelection().MoveTo(pos, true);
			pActivePointOrg->Delete(posAnchorOrg);
			const CCharPos	pos_ = m_pSelection->GetActivePoint();
			m_pSelection->GetActivePoint().Insert(strText);
			delete pActivePointOrg;
			m_pSelection->Select(pos_, m_pSelection->GetActivePoint(), false, true);
			*pdwEffect = DROPEFFECT_MOVE;
		}
		_END_OPERATION_SEQUENCE();
//		m_pSelection->m_activePoint.Reveal();
		m_lastOperation.set(TEditOperation::PASTE, m_pSelection->GetActivePoint());
	}
	m_leftDownMode = LDM_NONE;
	return S_OK;
}

/**
 *	XN[I
 *	@return	̃\bhĂяoŎXN[Iꍇ true
 */
bool CEditView::EndAutoScroll() {
	AssertValidAsWindow();

	if(m_autoScroll.bScrolling) {
		KillTimer(TIMERID_AUTOSCROLL);
		m_autoScroll.bScrolling = false;
		m_pAutoScrollOriginMark->ShowWindow(SW_HIDE);
		ReleaseCapture();
		return true;
	}
	return false;
}

/**
 *	LbgO̒PZkƂēWJ
 *	@return	WJłꍇ true
 */
bool CEditView::ExpandPrecedingWordAsAbbreviation() {
	if(!m_modeState.bReadyToExpandAbbrev)
		return false;

	bool	bExpanded = false;

	// [Shift] L[ĂƓWJ}~ł
	if(!toBoolean(::GetAsyncKeyState(VK_SHIFT) & 0x8000)) {
		const string_t	strAbbrev = GetPrecedingWord(GetAbbreviations().m_cchMaxAbbreviation);
		const string_t	strExpanded = GetAbbreviations().Expand(strAbbrev);
		if(!strExpanded.empty()) {
			// ̃LXg͑S낤
			m_pSelection->GetActivePoint().Delete(-static_cast<signed_length_t>(strAbbrev.length()), CEditPoint::CCC_UTF16);
			m_pSelection->GetActivePoint().Insert(strExpanded);
			bExpanded = true;
		}
	}
	m_modeState.bReadyToExpandAbbrev = false;
	for(set<IEditViewEventListener*>::iterator it =
			m_pSharedData->eventListeners.begin(); it != m_pSharedData->eventListeners.end(); ++it)
		(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");
	return bExpanded;
}

/**
 *	@brief	ΊʂTB<var>pos</var> ɊʂΏ false Ԃ
 *
 *	̃\bh͒1̃g[NׂȂB
 *	̃\bh̓ANZX\̈̊ʂlȂ
 *
 *	@param pos			ʂ̈ʒu
 *	@param posFound		Ίʂ̈ʒu
 *	@param bRequireBody	Ή銇ʑ΂̊ԂɁA
 *						󔒗ޕȊÕg[NꍇɌȂƂɂꍇ true
 *	@return				Ƃ^
 */
bool CEditView::FindMatchBracket(const CCharPos& pos, CCharPos& posFound, bool bRequireBody) const {
	AssertValid();

	const string_t&	strCurrentLine = GetDocument().GetLine(pos.m_iLine);
	length_t		cchLine = strCurrentLine.length();

	if(pos.m_iChar >= cchLine)
		return false;

	char_t	wchBrace = strCurrentLine.at(pos.m_iChar), wchMatch;	// ʂƑΊ
	bool	bBackward;												// ʂT

	if(!GetLexer().GetBracketTraits(wchBrace, wchMatch, bBackward))
		return false;
	bBackward = !bBackward;

	const CEditDoc&	document = GetDocument();
	length_t		iLine = pos.m_iLine;
	length_t		iChar = !bBackward ? pos.m_iChar + 1 : pos.m_iChar - 1;
	ulong			nNest = 0;			// qx
	length_t		cSearchedLines = 0;	// s
	bool			bFoundRatherThanSpace = !bRequireBody;	// ʂƋ󔒗ޕȊÕg[N
															// xłǂݔ΂

	while(true) {	// _s[v
		const string_t&	strLine = document.GetLine(iLine);
		cchLine = strLine.length();

		if(cchLine != 0) {
			const Tokens&	tokens = m_pSharedData->layoutManager.GetLine(iLine).GetTokens();
			size_t			iToken = !bBackward ? 0 : tokens.count - 1;
			if(cSearchedLines == 0) {
				for(iToken = 0; iToken < tokens.count - 1; ++iToken) {
					if(tokens.array[iToken].GetIndex() == pos.m_iChar)
						break;
				}
			}

			while(true) {	// ʂT
				const CToken&	token = tokens.array[iToken];
				const length_t	cchToken = (iToken != tokens.count - 1) ?
									tokens.array[iToken + 1].GetIndex() - tokens.array[iToken].GetIndex()
									: cchLine - tokens.array[tokens.count - 1].GetIndex();
				if(cchToken == 1
						&& token.GetType() != TT_ANNOTATION
						&& token.GetType() != TT_DOUBLEQUOTATION
						&& token.GetType() != TT_SINGLEQUOTATION) {
					if(strLine[token.GetIndex()] == wchBrace)
						++nNest;
					else if(strLine[token.GetIndex()] == wchMatch && --nNest == 0) {
						if(bFoundRatherThanSpace) {
							posFound = CCharPos(iLine, token.GetIndex());
							return true;
						} else
							return false;
					} else if(token.GetType() != TT_TAB && token.GetType() != TT_WHITESPACE)
						bFoundRatherThanSpace = true;
				} else if(token.GetType() != TT_TAB && token.GetType() != TT_WHITESPACE)
					bFoundRatherThanSpace = true;
				if((!bBackward && iToken == tokens.count - 1) || (bBackward && iToken == 0))
					break;
				iToken += !bBackward ? 1 : -1;
			}
		}

		if(++cSearchedLines >= m_pSharedData->options.cRecognizingLines)
			return false;
		if((bBackward && iLine == 0) || (!bBackward && iLine == document.GetLineCount() - 1))
			return false;
		iLine += !bBackward ? 1 : -1;
	}

	return false;
}

/// `̓
/// @see	CEditView::IsFreezed, CEditView::Unfreeze
void CEditView::Freeze() {
	AssertValidAsWindow();
	_FOR_EACH_CLONES() {
		if(++it->m_freezeInfo.nCount == 1)
			it->m_freezeInfo.scrollPosition.x = it->m_freezeInfo.scrollPosition.y = -1;
	}
}

/**
 *	Ss̃AvP[V`lXgɂĎ擾
 *	@param lines	XgBl0̍s͊O
 */
void CEditView::GetAllLineParams(list<TAppDefinedLine>& lines) const {
	AssertValid();

	const length_t	cLines = GetDocument().GetLineCount();
	TAppDefinedLine	line;

	lines.clear();
	for(length_t iLine = 0; iLine < cLines; ++iLine) {
		const DWORD	dwParam = m_pSharedData->layoutManager.GetLine(iLine).GetUserDefinedValue();
		if(dwParam != 0) {
			line.iLine = iLine;
			line.dwParam = dwParam;
			lines.push_back(line);
		}
	}
}

/// \sԂ
length_t CEditView::GetDisplayLineCount() const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return GetDocument().GetLineCount();
/*
	length_t			cDisplayLines = 0;
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);
	while(pInfo != 0) {
		cDisplayLines += pInfo->m_vecWrappedOffsets.size() + 1;
		pInfo = pInfo->m_pNext;
	}
	return cDisplayLines;*/
}

/**
 *	\s_ŝǂ̃ItZbgɑ邩Ԃ
 *	@param iDisplayLine	\s
 *	@param iLogicalLine	_s (iDisplayLine ȏꍇ-1)
 *	@param iOffset		_sŉԖڂ̕\s (iDisplayLine ȏꍇ-1)
 */
void CEditView::GetDisplayLineOffsetIndex(
		length_t iDisplayLine, length_t& iLogicalLine, length_t& iOffset) const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE) {
		iLogicalLine = iDisplayLine;
		iOffset = 0;
/*		return;
	} else {
		CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);
		length_t			iTotalDisplayLine = 0;

		iLogicalLine = 0;
		while(pInfo != 0) {
			if(iTotalDisplayLine + pInfo->m_vecWrappedOffsets.size() + 1 > iDisplayLine) {
				iOffset = iDisplayLine - iTotalDisplayLine;
				return;
			}
			iTotalDisplayLine += pInfo->m_vecWrappedOffsets.size() + 1;
			pInfo = pInfo->m_pNext;
			++iLogicalLine;
		}
	}
	iLogicalLine = iOffset = -1;*/
}

/**
 *	w肵s̃AvP[V`l擾
 *	@param iLine	_s
 *	@return			s̃AvP[V`l
 */
DWORD CEditView::GetLineParam(length_t iLine) const {
	AssertValid();
	return m_pSharedData->layoutManager.GetLine(iLine).GetUserDefinedValue();
}

/**
 *	@brief	wʒut߂ɂP̈ʒuȂǂԂ
 *
 *	̃\bh͐ݒ肳Ă鎯ʎq̉e󂯁A
 *	Ԃ镶͎ʎq2ڈȍ~ƂėLȕ݂̂ȂB
 *	o͈Ōʂ̕Kv̖̂ null w肵Ă悢
 *	@param pos		ʒu
 *	@param piStart	[out] P̐擪ʒu
 *	@param piEnd	[out] P̏I[ʒu
 *	@param pstrWord	[out] P
 *	@return			PꂪȂꍇ false ԂB̏ꍇeo͈̒l͖`
 *	@see			GetNearesetWordFromCaret, GetNearestWordFromCursor
 */
bool CEditView::GetNearestWord(const CCharPos& pos, length_t* piStart, length_t* piEnd, string_t* pstrWord) const {
	AssertValid();

	const CLexer&	lexer = m_pSharedData->layoutManager.GetLexer();
	length_t		iStart, iEnd;
	const string_t&	strLine = GetDocument().GetLine(m_pSelection->GetActivePoint().GetLineNumber());
	const char_t*	pwszLine = strLine.data();
	length_t		cchLine = strLine.length();
	CodePoint		cp;

	iStart = iEnd = pos.m_iChar;

	// Jnʒu𒲂ׂ
	if(piStart != 0 || pstrWord != 0) {
		while(iStart > 0) {
			if(IsUtf16LowSurrogate(pwszLine[iStart - 1])
					&& iStart > 1
					&& IsUtf16HighSurrogate(pwszLine[iStart - 2]))
				cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + iStart - 2, 2);
			else
				cp = pwszLine[iStart - 1];
			if(lexer.IsIdentifierContinueCodePoint(cp))
				iStart -= ((cp >= 0x010000) ? 2 : 1);
			else
				break;
		}
		if(piStart!= 0)
			*piStart = iStart;
	}

	// Iʒu𒲂ׂ
	if(piEnd != 0 || pstrWord != 0) {
		while(true) {
			if(IsUtf16HighSurrogate(pwszLine[iEnd])
					&& iEnd < cchLine - 1
					&& IsUtf16LowSurrogate(pwszLine[iEnd + 1]))
				cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + iEnd, 2);
			else
				cp = pwszLine[iEnd];
			if(lexer.IsIdentifierContinueCodePoint(cp))
				iEnd += ((cp >= 0x010000) ? 2 : 1);
			else
				break;
		}
		if(piEnd != 0)
			*piEnd = iEnd;
	}

	if(pstrWord != 0)
		pstrWord->assign(pwszLine + iStart, iEnd - iStart);
	return true;
}

/**
 *	Lbgt߂ɂP̈ʒuȂǂԂ
 *	@param pStartPos	[out] P̐擪ʒu
 *	@param pEndPos		[out] P̏I[ʒu
 *	@param pstrWord		[out] P
 *	@return				PꂪȂꍇAIꍇ false ԂB̏ꍇeo͈̒l͖`
 *	@see				GetNearestWordFromCursor, GetPrecedingWord
 */
bool CEditView::GetNearestWordFromCaret(CCharPos* pStartPos, CCharPos* pEndPos, string_t* pstrWord) const {
	AssertValid();

	if(!m_pSelection->IsEmpty())
		return false;
	if(GetNearestWord(m_pSelection->GetActivePoint(),
			(pStartPos != 0) ? &pStartPos->m_iChar : 0, (pEndPos != 0) ? &pEndPos->m_iChar : 0, pstrWord)) {
		if(pStartPos != 0)	pStartPos->m_iLine = m_pSelection->GetActivePoint().GetLineNumber();
		if(pEndPos != 0)	pEndPos->m_iLine = m_pSelection->GetActivePoint().GetLineNumber();
		return true;
	}
	return false;
}

/**
 *	J[\t߂ɂP̈ʒuȂǂԂ
 *	@param pStartPos	[out] P̐擪ʒu
 *	@param pEndPos		[out] P̏I[ʒu
 *	@param pstrWord		[out] P
 *	@return				PꂪȂꍇ false ԂB̏ꍇeo͈̒l͖`
 *	@see	GetNearestWordFromCaret, GetPrecedingWord
 */
bool CEditView::GetNearestWordFromCursor(CCharPos* pStartPos, CCharPos* pEndPos, string_t* pstrWord) const {
	AssertValidAsWindow();

	POINT	ptCursor;
	::GetCursorPos(&ptCursor);
	ScreenToClient(ptCursor);
	const CCharPos	posCursor = CharFromPos(ptCursor, false);

	if(GetNearestWord(posCursor,
			(pStartPos != 0) ? &pStartPos->m_iChar : 0, (pEndPos != 0) ? &pEndPos->m_iChar : 0, pstrWord)) {
		if(pStartPos != 0)	pStartPos->m_iLine = posCursor.m_iLine;
		if(pEndPos != 0)	pEndPos->m_iLine = posCursor.m_iLine;
		return true;
	}
	return false;
}

/**
 *	@brief	Lbg̒OɂPԂ
 *
 *	̃\bh͐ݒ肳Ă鎯ʎq̉e󂯁A
 *	Ԃ镶͎ʎq2ڈȍ~ƂėLȕ݂̂ȂB
 *	PꂪȂꍇAIꍇA
 *	͒Pꂪw肵ō𒴂ꍇ͋󕶎Ԃ
 *	@see	GetNearestWordFromCaret, GetNearestWordFromCursor
 */
string_t CEditView::GetPrecedingWord(length_t cchLimit) const {
	AssertValid();

	if(!m_pSelection->IsEmpty()
			|| m_pSelection->GetActivePoint().GetCharNumber() == 0
			|| (GetDocument().IsNarrowed() && m_pSelection->GetActivePoint().GetPosition() == GetDocument().GetStartPoint()))
		return L"";
	length_t		iChar = m_pSelection->GetActivePoint().GetCharNumber();
	const string_t&	strLine = GetDocument().GetLine(m_pSelection->GetActivePoint().GetLineNumber());
	const char_t*	pwszLine = strLine.data();
	CodePoint		cp;

	while(iChar != 0) {
		if(m_pSelection->GetActivePoint().GetCharNumber() - iChar + 1 > cchLimit)
			return L"";
		if(IsUtf16LowSurrogate(pwszLine[iChar - 1])
				&& iChar > 1
				&& IsUtf16HighSurrogate(pwszLine[iChar - 2]))
			cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + iChar - 2, 2);
		else
			cp = pwszLine[iChar - 1];
		if(GetLexer().IsIdentifierContinueCodePoint(cp))
			iChar -= ((cp >= 0x010000) ? 2 : 1);
		else
			break;
	}
	return strLine.substr(iChar, m_pSelection->GetActivePoint().GetCharNumber() - iChar);
}

/// @see	IDropSource::GiveFeedback
STDMETHODIMP CEditView::GiveFeedback(DWORD dwEffect) {
	AssertValid();
	return DRAGDROP_S_USEDEFAULTCURSORS;	// VXẽftHg̃J[\g 
}

///	\̃c[`bv\ɂ
void CEditView::HideToolTip() {
	AssertValidAsWindow();

	if(m_pwszTipText == 0)
		m_pwszTipText = new char_t[1];
	wcscpy(m_pwszTipText, L"");
	KillTimer(TIMERID_CALLTIP);	// Ô...
	::SendMessageW(m_hwndToolTip, TTM_UPDATE, 0, 0L);
}

/**
 *	݂̌ɈveLXg\
 *	@param bHighlight	\Lɂꍇ trueBɂꍇ false
 */
void CEditView::HighlightMatchTexts(bool bHighlight) {
	AssertValid();
	if(this != m_pOriginalView)
		m_pOriginalView->HighlightMatchTexts(bHighlight);
	else {
		m_pSharedData->bHighlightMatches = true;
		if(m_pSharedData->options.appearance[HIGHLIGHT_MATCH_TEXT]) {
			InvalidateRect(0, false);
			_FOR_EACH_CLONES()
				it->InvalidateRect(0, false);
		}
	}
}

/**
 *	wʒuGfB^EBhÊǂ̕ɂ邩𒲂ׂ
 *	@param pt	ׂʒuBNCAgW
 *	@return		
 *	@see		HitTestResult
 */
HitTestResult CEditView::HitTest(const POINT& pt) const {
	AssertValidAsWindow();

	const TLayoutSettings&	layout = GetLayoutSettings().GetSettings();
	RECT					rcClient;

	GetClientRect(rcClient);
	if(!toBoolean(::PtInRect(&rcClient, pt)))
		return HTR_OUTOFVIEW;

	if(layout.lineNumberLayout.bShowIndicatorMargin
			&& ((!layout.bRightAlign && pt.x < layout.lineNumberLayout.nIMWidth)
			|| (layout.bRightAlign && pt.x >= rcClient.right - layout.lineNumberLayout.nIMWidth)))
		return HTR_INDICATORMARGIN;
	else if(layout.lineNumberLayout.bShowLineNumbers
			&& ((!layout.bRightAlign && pt.x < GetLayoutSettings().GetVerticalRulerWidth())
			|| (layout.bRightAlign && pt.x >= rcClient.right - GetLayoutSettings().GetVerticalRulerWidth())))
		return HTR_LINENUMBERS;
	else if((!layout.bRightAlign && pt.x < GetLayoutSettings().GetVerticalRulerWidth() + layout.nLeadMargin)
			|| (layout.bRightAlign && pt.x >= rcClient.right - GetLayoutSettings().GetVerticalRulerWidth() - layout.nLeadMargin))
		return HTR_LEADMARGIN;
	else if(pt.y < layout.nTopMargin)
		return HTR_TOPMARGIN;
	else
		return HTR_TEXT;
}

/**
 *	EBhȄ
 *	@param bCopyConstructing	r[Ăяoꍇ true
 */
void CEditView::InitializeWindow(bool bCopyConstructing) {
	AssertValidAsWindow();

	// ReLXgj[̃x
	static const WCHAR* menuLabels[] = {
		L"&Undo",								L"ɖ߂(&U)",
		L"&Redo",								L"蒼(&R)",
		0,										0,
		L"Cu&t",								L"؂(&T)",
		L"&Copy",								L"Rs[(&C)",
		L"&Paste",								L"\t(&P)",
		L"&Delete",								L"폜(&D)",
		0,										0,
		L"Select &All",							L"ׂđI(&A)",
		0,										0,
		L"&Right to left Reading order",		L"E獶ɓǂ(&R)",
		L"&Show Unicode control characters",	L"Unicode 䕶̕\(&S)",
		L"&Insert Unicode control character",	L"Unicode 䕶̑}(&I)",
		L"Insert Unicode &whitespace character",L"Unicode 󔒕̑}(&W)",
	};																		

#define INSERT_MENU(id, index)															\
	mii.wID = (id);																		\
	mii.dwTypeData = const_cast<WCHAR*>(menuLabels[(index) * 2 + (bJapanese ? 1 : 0)]);	\
	::InsertMenuItemW(m_pSharedData->hContextMenu, (index), true, &mii)
#define INSERT_TO_SUBMENU(id, index, caption)	\
	mii.wID = (id);								\
	mii.dwTypeData = (caption);					\
	::InsertMenuItemW(hSubMenu, (index), true, &mii);

	// WReLXgj[̍쐬BAscension ł
	// GUI ŃeLXggȂB{ȊOɂΉĂ݂
	// pȊOɖ|󂵂ĂlW (^^
	if(!bCopyConstructing) {
		AutoZeroCB<MENUITEMINFOW>	mii;
		HMENU						hSubMenu;
		const bool					bJapanese = PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE;

		m_pSharedData->hContextMenu = ::CreatePopupMenu();
		mii.fMask = MIIM_FTYPE | MIIM_ID | MIIM_STRING;

		mii.fType = MFT_STRING;
		INSERT_MENU(WM_UNDO, 0);
		INSERT_MENU(WM_REDO, 1);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(m_pSharedData->hContextMenu, 2, true, &mii);

		mii.fType = MFT_STRING;
		INSERT_MENU(WM_CUT, 3);
		INSERT_MENU(WM_COPY, 4);
		INSERT_MENU(WM_PASTE, 5);
		INSERT_MENU(WM_CLEAR, 6);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(m_pSharedData->hContextMenu, 7, true, &mii);

		mii.fType = MFT_STRING;
		INSERT_MENU(WM_SELECTALL, 8);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(m_pSharedData->hContextMenu, 9, true, &mii);

		mii.fType = MFT_STRING;
		INSERT_MENU(ID_RTLREADING, 10);
		INSERT_MENU(ID_SHOWDIRECTIONALFORMATTERS, 11);
		INSERT_MENU(0, 12);
		INSERT_MENU(0, 13);

		// [Unicode 䕶̑}] ȉ
		hSubMenu = ::CreatePopupMenu();
		INSERT_TO_SUBMENU(ID_INSERT_LRM, 0, L"LRM\t&Left-To-Right Mark");
		INSERT_TO_SUBMENU(ID_INSERT_RLM, 1, L"RLM\t&Right-To-Left Mark");
		INSERT_TO_SUBMENU(ID_INSERT_ZWJ, 2, L"ZWJ\t&Zero Width Joiner");
		INSERT_TO_SUBMENU(ID_INSERT_ZWNJ, 3, L"ZWNJ\tZero Width &Non-Joiner");
		INSERT_TO_SUBMENU(ID_INSERT_LRE, 4, L"LRE\tLeft-To-Right &Embedding");
		INSERT_TO_SUBMENU(ID_INSERT_RLE, 5, L"RLE\tRight-To-Left E&mbedding");
		INSERT_TO_SUBMENU(ID_INSERT_LRO, 6, L"LRO\tLeft-To-Right &Override");
		INSERT_TO_SUBMENU(ID_INSERT_RLO, 7, L"RLO\tRight-To-Left O&verride");
		INSERT_TO_SUBMENU(ID_INSERT_PDF, 8, L"PDF\t&Pop Directional Formatting");
		INSERT_TO_SUBMENU(ID_INSERT_WJ, 9, L"WJ\t&Word Joiner");
		INSERT_TO_SUBMENU(ID_INSERT_NADS, 10, L"NADS\tN&ational Digit Shapes (deprecated)");
		INSERT_TO_SUBMENU(ID_INSERT_NODS, 11, L"NODS\tNominal &Digit Shapes (deprecated)");
		INSERT_TO_SUBMENU(ID_INSERT_ASS, 12, L"ASS\tActivate &Symmetric Swapping (deprecated)");
		INSERT_TO_SUBMENU(ID_INSERT_ISS, 13, L"ISS\tInhibit S&ymmetric Swapping (deprecated)");
		INSERT_TO_SUBMENU(ID_INSERT_AAFS, 14, L"AAFS\tActivate Arabic &Form Shaping (deprecated)");
		INSERT_TO_SUBMENU(ID_INSERT_IAFS, 15, L"IAFS\tInhibit Arabic Form S&haping (deprecated)");
		INSERT_TO_SUBMENU(ID_INSERT_RS, 16, L"RS\tRe&cord Separator");
		INSERT_TO_SUBMENU(ID_INSERT_US, 17, L"US\tUnit &Separator");
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(hSubMenu, 18, true, &mii);
		mii.fType = MFT_STRING;
		INSERT_TO_SUBMENU(ID_INSERT_IAA, 19, L"IAA\tInterlinear Annotation Anchor");
		INSERT_TO_SUBMENU(ID_INSERT_IAA, 20, L"IAT\tInterlinear Annotation Terminator");
		INSERT_TO_SUBMENU(ID_INSERT_IAA, 21, L"IAS\tInterlinear Annotation Separator");
		mii.fMask = MIIM_SUBMENU;
		mii.hSubMenu = hSubMenu;
		::SetMenuItemInfoW(m_pSharedData->hContextMenu, 12, true, &mii);

		// [Unicode 󔒕̑}] ȉ
		hSubMenu = ::CreatePopupMenu();
		mii.fMask = MIIM_FTYPE | MIIM_ID | MIIM_STRING;
		INSERT_TO_SUBMENU(ID_INSERT_U0020, 0, L"U+0020\tSpace");
		INSERT_TO_SUBMENU(ID_INSERT_NBSP, 1, L"NBSP\tNo-Break Space");
		INSERT_TO_SUBMENU(ID_INSERT_U1680, 2, L"U+1680\tOgham Space Mark");
		INSERT_TO_SUBMENU(ID_INSERT_MVS, 3, L"MVS\tMongolian Vowel Separator");
		INSERT_TO_SUBMENU(ID_INSERT_U2000, 4, L"U+2000\tEn Quad");
		INSERT_TO_SUBMENU(ID_INSERT_U2001, 5, L"U+2001\tEm Quad");
		INSERT_TO_SUBMENU(ID_INSERT_U2002, 6, L"U+2002\tEn Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2003, 7, L"U+2003\tEm Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2004, 8, L"U+2004\tThree-Per-Em Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2005, 9, L"U+2005\tFour-Per-Em Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2006, 10, L"U+2006\tSix-Per-Em Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2007, 11, L"U+2007\tFigure Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2008, 12, L"U+2008\tPunctuation Space");
		INSERT_TO_SUBMENU(ID_INSERT_U2009, 13, L"U+2009\tThin Space");
		INSERT_TO_SUBMENU(ID_INSERT_U200A, 14, L"U+200A\tHair Space");
		INSERT_TO_SUBMENU(ID_INSERT_ZWSP, 15, L"ZWSP\tZero Width Space");
		INSERT_TO_SUBMENU(ID_INSERT_NNBSP, 16, L"NNBSP\tNarrow No-Break Space");
		INSERT_TO_SUBMENU(ID_INSERT_MMSP, 17, L"MMSP\tMedium Mathematical Space");
		INSERT_TO_SUBMENU(ID_INSERT_U3000, 18, L"U+3000\tIdeographic Space");
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(hSubMenu, 19, true, &mii);
		mii.fType = MFT_STRING;
		INSERT_TO_SUBMENU(ID_INSERT_NEL, 20, L"NEL\tNext Line");
		INSERT_TO_SUBMENU(ID_INSERT_LS, 21, L"LS\tLine Separator");
		INSERT_TO_SUBMENU(ID_INSERT_PS, 22, L"PS\tParagraph Separator");
		mii.fMask = MIIM_SUBMENU;
		mii.hSubMenu = hSubMenu;
		::SetMenuItemInfoW(m_pSharedData->hContextMenu, 13, true, &mii);

		// bidi T|[g邩?
		if(!m_pSharedData->layoutManager.IsRtlSupported()) {
			::EnableMenuItem(m_pSharedData->hContextMenu, ID_RTLREADING, MF_BYCOMMAND | MF_GRAYED);
			::EnableMenuItem(m_pSharedData->hContextMenu, ID_SHOWDIRECTIONALFORMATTERS, MF_BYCOMMAND | MF_GRAYED);
			::EnableMenuItem(m_pSharedData->hContextMenu, 12, MF_BYPOSITION | MF_GRAYED);
			::EnableMenuItem(m_pSharedData->hContextMenu, 13, MF_BYPOSITION | MF_GRAYED);

			// ̃R}hgps
//			::EnableMenuItem(m_pSharedData->hContextMenu, ID_RTLREADING, MF_BYCOMMAND | MF_GRAYED);
		}
	} else {	// ̃r[畡ꍇ
		if(m_pSharedData->layoutManager.GetSettings().bRightToLeftReading)
			OnChangedTextDirection();
		if(m_pSharedData->layoutManager.GetSettings().bRightAlign)
			OnChangedTextAlignment();
	}

#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	// foCXReLXg̗p
	m_memDC.CreateCompatibleDC(GetDC().GetSafeHdc());
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	UpdateGdiObjects();
//	if(bCopyConstructing)
//		RecalcLeftTabWidth();

	// c[`bv̍쐬
	m_hwndToolTip = ::CreateWindowExW(
		WS_EX_TOOLWINDOW | WS_EX_TOPMOST, TOOLTIPS_CLASSW, 0,
		WS_POPUP | TTS_ALWAYSTIP | TTS_NOPREFIX,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		m_hWnd, 0, reinterpret_cast<HINSTANCE>(GetWindowLong(GWL_HINSTANCE)), 0);
	if(m_hwndToolTip != 0) {
		AutoZeroCB<TOOLINFOW>	ti;
		RECT					rcMargins = {1, 1, 1, 1};

		ti.hwnd = m_hWnd;
		ti.lpszText = LPSTR_TEXTCALLBACKW;
		ti.uFlags = TTF_SUBCLASS;
		ti.uId = 1;
		::SetRect(&ti.rect, 0, 0, 0, 0);
		::SendMessageW(m_hwndToolTip, TTM_ADDTOOLW, 0, reinterpret_cast<LPARAM>(&ti));
		::SendMessageW(m_hwndToolTip, TTM_SETDELAYTIME, TTDT_AUTOPOP, 30000);	// 30bԕ\悤
//		::SendMessageW(m_hwndToolTip, TTM_SETDELAYTIME, TTDT_INITIAL, 1500);
		::SendMessageW(m_hwndToolTip, TTM_SETMARGIN, 0, reinterpret_cast<LPARAM>(&rcMargins));
		::SendMessageW(m_hwndToolTip, TTM_ACTIVATE, true, 0L);
	}

	// ͌EBhE̍쐬
	m_pCompletionWindow->Create();

	// XN[̌_EBhE̍쐬
	m_pAutoScrollOriginMark = new CAutoScrollOriginMark;
	m_pAutoScrollOriginMark->Create(*this);
	
	// hbvΏۂɓo^
	RegisterDragDrop(*this);

	// hLg΍s𓯊
	if(!bCopyConstructing)
		m_pSharedData->layoutManager.ReconstructAll();

#undef INSERT_MENU
#undef INSERT_TO_SUBMENU
}

/**
 *	@brief	Lbgʒu1͂
 *
 *	͂󔒗ޕłΒZk`̓WJsB
 *	܂Aݒɉē̓V[PX̃`FbNs
 *
 *	Iꍇ͂̒uɂȂB㏑[h̏ꍇ1̒uɂȂ
 *
 *	ꕔĐ䕶͓͂łȂB^u (U+0009) ͓͉\ŁAIꍇ̓^uCfgɂȂ

 *	GfB^ɃeLXg}Ƃ͏ɂ̃\bhŝŁA
 *	̃\bhI[o[Ch邱ƂłeLXg̓͂ߑł
 *	@param cp	̃R[h|Cg
 *	@return		͂eꂽꍇ false
 */
bool CEditView::InputCharacter(CodePoint cp) {
	AssertValid();

	CEditDoc&	document = GetDocument();

	if(document.IsReadOnly())
		return false;

//	bool	bDoneSmartIndent = false;

	// ASCII 䕶͖ ( TAB ARS AUS ȊO)
	if(!m_pSharedData->options.behavior[ACCEPT_CONTROL_CHAR_INPUT]
			&& cp <= 0xFF && cp != 0x09
			&& cp != 0x1E && cp != 0x1F
			&& toBoolean(iscntrl(static_cast<int>(cp)))) {
//		Beep();
		return false;
	}

	// ̓V[PX`FbN
	if(m_pSharedData->options.sequenceCheckingLanguages != 0) {
		const InputSequenceCheckLanguage	languages = m_pSharedData->options.sequenceCheckingLanguages;
		const CEditPoint&					topPoint = m_pSelection->GetStartPoint();
		const char_t* const					pwszLine = document.GetLine(topPoint.GetLineNumber()).c_str();

		if(toBoolean(languages & ISCL_AINU)
				&& !CheckCharSequence<ISCL_AINU>(pwszLine, topPoint.GetCharNumber(), cp)) {
			Beep();
			return false;
		} else if(toBoolean(languages & ISCL_THAI)
				&& !CheckCharSequence<ISCL_THAI>(pwszLine, topPoint.GetCharNumber(), cp)) {
			Beep();
			return false;
		} else if(toBoolean(languages & ISCL_VIETNAMESE)
				&& !CheckCharSequence<ISCL_VIETNAMESE>(pwszLine, topPoint.GetCharNumber(), cp)) {
			Beep();
			return false;
		}
	}

	if(cp == 0x0009 && !m_pSelection->IsEmpty()) {	// [Tab]
		StandardCommands::CIndentationCommand(
			*this, !toBoolean(::GetKeyState(VK_SHIFT) & 0x8000), true, 1).Execute();
		return true;
	} else {
		char_t	wsz[2];

		// 󔒗ޕS BMP ɂƉ肵Ă
		if(cp < 0x010000)
			wsz[0] = CEditView::ConvertCharacter(static_cast<char_t>(cp), m_nextCharVariation);
		else
			EncodeCodePointToUtf16Surrogates(cp, wsz);
		if(!m_pSelection->IsEmpty()) {	// Iꍇ -> PȒu
//			if(!m_modeState.bSmartIndent || !SmartIndent(nCodePoint))
				GetSelection().Replace(wsz, wsz + ((cp < 0x10000) ? 1 : 2), false);
			m_lastOperation.set(TEditOperation::REPLACE, m_pSelection->GetActivePoint());
		} else if(m_modeState.bOvertype) {	// ㏑[h̏ꍇ
			if(!document.IsCollectingEdit())
				document.BeginEditCollection();
			Freeze();
			m_pSelection->GetAnchorPoint().DestructiveInsert(wsz, wsz + ((cp < 0x10000) ? 1 : 2));
//			GetSelection().MoveTo(m_pSelection->GetAnchorPoint(), true);
			Unfreeze();
			UpdateCaretPosition();
		} else {
			const bool	bCharIsAlpha = GetLexer().IsIdentifierContinueCodePoint(cp);
			bool		bAbbrIsExpanded = false;

			// P\ȊOȂ͕⊮I
			if(!bCharIsAlpha && m_pCompletionWindow->IsRunning())
				m_pCompletionWindow->Complete();

			// 󔒗ޕ̏ꍇAZkWJ
			if(GetLexer().IsWhiteSpace(cp, true)) {
				Freeze();
				document.BeginEditCollection();
				ExpandPrecedingWordAsAbbreviation();
				document.EndEditCollection();
				bAbbrIsExpanded = true;
			}

			// AP\̓͂1ɂ܂Ƃ߂悤Ə׍HB
			// ܂IĂȂ
			if(m_lastOperation.type != TEditOperation::TYPING
					|| m_lastOperation.pos != m_pSelection->GetActivePoint()
					|| !bCharIsAlpha)
				document.EndEditCollection();
			if(bCharIsAlpha && !document.IsCollectingEdit())
				document.BeginEditCollection();

			// 
			m_pSelection->GetAnchorPoint().Insert(wsz, wsz + ((cp < 0x10000) ? 1 : 2));
			m_pSelection->MoveTo(m_pSelection->GetAnchorPoint(), true);	// <-- ͖Ă͂... (Win2000 Ƒʖ)
			if(m_pCompletionWindow->IsWindowVisible())
				m_pCompletionWindow->UpdateListCursel();
			m_lastOperation.set(TEditOperation::TYPING, m_pSelection->GetActivePoint());

			if(bAbbrIsExpanded)
				Unfreeze();

			// LbgO̒PꂪZkƂēWJ\ׂ
			if(bCharIsAlpha && !IsFreezed() && !GetAbbreviations().m_abbreviations.empty()) {
				const string_t	strPrecWord = GetPrecedingWord(GetAbbreviations().m_cchMaxAbbreviation);

				m_modeState.bReadyToExpandAbbrev = false;
				if(!strPrecWord.empty()) {
					map<string_t, string_t>::const_iterator	it = GetAbbreviations().m_abbreviations.find(strPrecWord);
					m_modeState.bReadyToExpandAbbrev = it != GetAbbreviations().m_abbreviations.end();
				}
				_FOR_EACH_LISTENERS()
					(*it)->OnChangedAbbreviationExpansionReadyState(
						m_modeState.bReadyToExpandAbbrev,
							m_modeState.bReadyToExpandAbbrev ? strPrecWord : L"");
			}
		}
		m_pSelection->GetActivePoint().Reveal(*this);
	}

	return true;
}

/**
 *	@brief	LbgʒuɃeLXg}
 *
 *	Iꍇ㏑[hł͒uɂȂB
 *	̓V[PX̃`FbNZk`̓WJ͍sȂ
 *
 *	GfB^ɃeLXg}Ƃ͏ɂ̃\bhŝŁA
 *	̃\bhI[o[Ch邱ƂłeLXg̓͂ߑł
 *	@param first, last	}eLXg
 *	@param bAsRectangle	`eLXgƂđ}ꍇ true
 *	@return				͂eꂽꍇ false
 *	@see				CEditView::InputCharacter, StandardCommand::CTextInputCommand
 */
bool CEditView::InsertText(const char_t* first, const char_t* last, bool bAsRectangle) {
	AssertValid();
	assert(first != 0 && last != 0 && first <= last);
	if(GetDocument().IsReadOnly())
		return false;

	if(IsOvertypeMode() && m_pSelection->IsEmpty())	// ㏑[h̏ꍇ (K)
		m_pSelection->Select(m_pSelection->GetAnchorPoint(),
			CCharPos(m_pSelection->GetAnchorPoint().GetLineNumber(),
				m_pSelection->GetActivePoint().GetCharNumber() + (last - first)),
			false, false);

	if(!m_pSelection->IsEmpty())
		m_pSelection->Replace(first, last, bAsRectangle);
	else {
		_BEGIN_OPERATION_SEQUENCE();
		if(bAsRectangle)
			m_pSelection->GetAnchorPoint().InsertBox(first, last);
		else
			m_pSelection->GetAnchorPoint().Insert(first, last);
		m_pSelection->MoveTo(m_pSelection->GetAnchorPoint(), true);
		_END_OPERATION_SEQUENCE();
	}
	return true;
}

/// LbgʒuɃeLXg}
bool CEditView::InsertText(const string_t& text, bool bAsRectangle) {
	AssertValid();
	return InsertText(text.data(), text.data() + text.length(), bAsRectangle);
}

/**
 *	wԍs`𖳌
 *	@param iLine	_s
 */
void CEditView::InvalidateLine(length_t iLine) {
	InvalidateLines(iLine, iLine);
}

/**
 *	ws`𖳌Bsw͂_sB<var>iStart</var>
 *	 <var>iEnd</var> ̑召֌Wɐ͖
 *	@param iStart	Jns
 *	@param iEnd		Is
 */
void CEditView::InvalidateLines(length_t iStart, length_t iEnd) {
	AssertValidAsWindow();

	const length_t	cVisibleLines = GetVisibleLineCount();

	if(iStart > iEnd)
		std::swap(iStart, iEnd);
	iEnd = min<length_t>(iEnd, m_scrollInfo.position.y + cVisibleLines);

	if(IsFreezed()) {	// 
		for(length_t i = iStart; i <= iEnd; ++i)
			m_freezeInfo.invalidLines.insert(i);
		return;
	}

	RECT			rectInvalid;
	length_t		iDisplayStart, iDisplayEnd;
	const length_t	cLines = GetDocument().GetLineCount();

	// \sɕϊ
	if(iStart > iEnd)
		std::swap(iStart, iEnd);
	iDisplayStart = DisplayLineFromLogicalLine(min(iStart, cLines - 1));
	if(iStart >= cLines)
		iDisplayStart += iStart - cLines + 1;
	iDisplayEnd = DisplayLineFromLogicalLine(min(iEnd, cLines - 1));
	if(iEnd >= cLines)
		iDisplayEnd += iEnd - cLines + 1;
	GetClientRect(rectInvalid);

	// [
	if(iDisplayStart > m_scrollInfo.position.y + cVisibleLines)
		return;
	rectInvalid.top += GetLayoutSettings().GetSettings().nTopMargin;
	if(static_cast<long>(iDisplayStart) > m_scrollInfo.position.y)
		rectInvalid.top += (iDisplayStart - m_scrollInfo.position.y) * m_pSharedData->layoutManager.GetLineHeight();

	// [
	rectInvalid.bottom =
		rectInvalid.top + (iDisplayEnd - iDisplayStart + 1) * m_pSharedData->layoutManager.GetLineHeight();

	InvalidateRect(&rectInvalid, false);
}

/**
 *	wʒuNƏdȂĂ邩ǂԂ
 *	@param pt	NCAgW
 *	@param pwsz	[out] <var>pt</var> Nɂ΂̕
 *				([AhX̏ꍇ͎I "mailto:" 擪ɒǉ)B
 *				Ăяoō폜Ȃ΂ȂȂ
 *	@return		<var>pt</var> Nɂ true 
 */
bool CEditView::IsOverInvokableLink(const POINT& pt, char_t*& pwsz) const {
	// !̎͐܂Ԃ̂ƂlĂȂ!
	AssertValidAsWindow();

	bool			bTruncated;
	const CCharPos	pos = CharFromPos(pt, true, &bTruncated);	// J[\ʒuɍł߂ʒu

	if(bTruncated)	// wʒuɕ
		return false;

	const char_t*	pwszLine = GetDocument().GetLine(pos.m_iLine).data();
	const length_t	cchLine = GetDocument().GetLineLength(pos.m_iLine);
	length_t		iChar = (pos.m_iChar > 200) ? pos.m_iChar - 200 : 0;
	length_t		cch;	// CLexer  EatMailAddress AEatUrlString Ō

	while(iChar <= pos.m_iChar) {
		if(iChar != 0) {
			const char_t	ch = pwszLine[iChar - 1];
			if((ch >= L'A' && ch <= L'Z')
					|| (ch >= L'a' && ch <= L'z')
					|| ch == L'_') {
				++iChar;
				continue;
			}
		}
		if(0 != (cch = CLexer::EatUrlString(pwszLine + iChar, cchLine - iChar))) {
			if(iChar + cch > pos.m_iChar) {	// J[\ʒuz
				pwsz = new char_t[cch + 1];
				wcsncpy(pwsz, pwszLine + iChar, cch);
				pwsz[cch] = 0;
				return true;
			}
			iChar += cch;	// ͂Ȃꍇ͑s
		} else if(0 != (cch = CLexer::EatMailAddress(pwszLine + iChar, cchLine - iChar))) {
			if(iChar + cch > pos.m_iChar) {	// J[\ʒuz
				pwsz = new char_t[cch + 7 + 1];
				wcsncpy(pwsz, L"mailto:", 7);
				wcsncpy(pwsz + 7, pwszLine + iChar, cch);
				pwsz[cch + 7] = 0;
				return true;
			}
			iChar += cch;	// ͂Ȃꍇ͑s
		} else
			++iChar;
	}
	pwsz = 0;
	return false;
}

/**
 *	\ʒu_ʒuɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param posDisplay	ϊ\ʒu
 *	@return				ϊꂽ_ʒu (łȂo-1)
 */
CCharPos CEditView::LogicalCharFromDisplayChar(const CCharPos& posDisplay) const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return posDisplay;
/*
	CCharPos			posLogical(0, 0);
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	// s̊m
	length_t	iTotalDisplayLine = 0;
	while(true) {
		iTotalDisplayLine += pInfo->m_vecWrappedOffsets.size() + 1;
		if(iTotalDisplayLine > posDisplay.iLine)
			break;
		pInfo = pInfo->m_pNext;
		if(pInfo == 0)
			return CCharPos(-1, -1);
		++posLogical.iLine;
	}

	// ̊m
	vector<length_t>::size_type	cOffsets = pInfo->m_vecWrappedOffsets.size();
	if(cOffsets == 0)	// ̍sł͐܂Ԃ͋NĂȂ
		return CCharPos(posLogical.iLine, posDisplay.iChar);
	for(vector<length_t>::size_type iOffset = 0; iOffset < cOffsets; ++iOffset) {
		if(posLogical.iChar + pInfo->m_vecWrappedOffsets[iOffset] >= posDisplay.iChar) {
			posLogical.iChar += posDisplay.iChar - posLogical.iChar;
			return posLogical;
		}
		posLogical.iChar += pInfo->m_vecWrappedOffsets[iOffset];
	}

	return CCharPos(posLogical.iLine, -1);*/
}

/**
 *	LbguȂꏊɂLbg𐳂ʒuɂ炷B
 *	UTF-16 TQ[g╡̉ɎgB
 *	@param pwsz			
 *	@param cch			
 *	@param nCaretPos	Lbgʒu
 *	@param bBackward	Lbgǂɓ
 *	@return				ړ (wchar_t P)B͌
 */
int CEditView::MakeCaretPosValid(const char_t* pwsz,
		length_t cch, length_t nCaretPos, bool bBackward) {
	assert(pwsz != 0);

	// P[X
	if(nCaretPos == 0 || nCaretPos >= cch)
		return 0;

	int			nOffset = 0;
	CodePoint	cp;
	while(true) {
		if(IsUtf16LowSurrogate(pwsz[nCaretPos + nOffset])
				&& nCaretPos + nOffset > 0
				&& IsUtf16HighSurrogate(pwsz[nCaretPos + nOffset - 1]))
			nOffset += bBackward ? -1 : 1;
		if(IsUtf16HighSurrogate(pwsz[nCaretPos + nOffset])
				&& IsUtf16LowSurrogate(pwsz[nCaretPos + nOffset + 1]))
			cp = DecodeUtf16SurrogatesToCodePoint(pwsz + nCaretPos + nOffset, 2);
		else
			cp = pwsz[nCaretPos + nOffset];
		if(CBoundarySearcher::IsGraphemeBase(cp))
			break;
		// 炷
		nOffset += bBackward ? -1 : 1;
		if(nCaretPos + nOffset == 0 || nCaretPos + nOffset == cch)
			return nOffset;
	}
	return nOffset;
}

/**
 *	CLineLayout::GetCaretPosition 瓾ʒu𕶎ԍɕϊ
 *	@param iLine			_s
 *	@param x				s̍[̋
 *	@param bIgnoreExtenders	extender ₩珜O
 *	@param pbTruncated		[out] wʒuɕꍇ trueBKvꍇ null ł悢
 *	@return					ʒu
 */
length_t CEditView::_MapAbsoluteXToCharacter(length_t iLine, int x, bool bIgnoreExtenders, bool* pbTruncated /* = 0 */) const {
	assert(iLine < GetDocument().GetLineCount());

	const CLineLayout&			layout = m_pSharedData->layoutManager.GetLine(iLine);
	const CLineLayout::CRuns&	runs = layout.GetRuns();
	const string_t&				strLine = GetDocument().GetLine(iLine);
	const char_t*				pwszLine = strLine.data();
	const length_t				cchLine = strLine.length();

	if(pbTruncated != 0)
		*pbTruncated = x < 0 || x > layout.GetWidth();

	// ł߂_T
	length_t	iNearest = 0;										// ܂łōł߂
	ulong		nMinimumDistance = numeric_limits<ulong>::max();	// ̋
	for(size_t iRun = 0; iRun < runs.GetCount(); ++iRun) {
		const CLineLayout::CRun&	run = runs.GetAt(iRun);
		const length_t				iNextRun = (iRun != runs.GetCount() - 1) ? runs.GetAt(iRun + 1).GetIndex() : cchLine;
		const int					nRunWidth = (run.GetWidth() != CLineLayout::CRun::LINE_WIDTH) ? run.GetWidth() : layout.GetWidth();

		// ̊O`FbN
		const nLeftBorder = run.IsRightToLeft() ?
			layout.GetCaretPosition(run.GetIndex()) - nRunWidth : layout.GetCaretPosition(run.GetIndex());
		const nRightBorder = run.IsRightToLeft() ?
			layout.GetCaretPosition(run.GetIndex()) : layout.GetCaretPosition(run.GetIndex()) + nRunWidth;
		if(x < nLeftBorder) {
			if(static_cast<ulong>(nLeftBorder - x) < nMinimumDistance) {
				iNearest = !run.IsRightToLeft() ? run.GetIndex() : iNextRun - 1;
				nMinimumDistance = dif(layout.GetCaretPosition(iNearest), x);
			}
			continue;
		} else if(x > nRightBorder) {
			if(static_cast<ulong>(x - nRightBorder) < nMinimumDistance) {
				iNearest = !run.IsRightToLeft() ? iNextRun - 1 : run.GetIndex();
				nMinimumDistance = dif(layout.GetCaretPosition(iNearest), x);
			}
			continue;
		}

		// ̒𑖍
		for(length_t iChar = run.GetIndex(); iChar < ((iNextRun != cchLine) ? iNextRun : iNextRun + 1); ++iChar) {
			// 镶
			if(iChar != 0 && iChar != cchLine) {
				// ʃTQ[g
				if(IsUtf16LowSurrogate(pwszLine[iChar]) && IsUtf16HighSurrogate(pwszLine[iChar - 1]))
					continue;
				// extender
				else if(bIgnoreExtenders) {
					const CodePoint	cp = (iChar >= cchLine - 1) ? pwszLine[iChar] :
							DecodeUtf16SurrogatesToCodePoint(pwszLine + iChar, cchLine - iChar);
					if(!m_pBoundarySearcher->IsGraphemeBase(cp))
						continue;
				}
			}

			const ulong	nDistance = dif(layout.GetCaretPosition(iChar), x);

			// SɈv̂΂Ŋm
			if(nDistance == 0)
				return iChar;
			// ߂Ƃ
			else if(nDistance < nMinimumDistance) {
				iNearest = iChar;
				nMinimumDistance = nDistance;
			}
		}
	}
	return (dif(layout.GetCaretPosition(cchLine), x) < nMinimumDistance) ? cchLine : iNearest;	// ŌɍsƂr
}

/**
 *	CLineLayout::GetCaretPosition 瓾ʒuNCAg x Wɕϊ
 *	@param x			s̍[̋
 *	@param nLineWidth	s̕
 *	@return				NCAg x WBlɂȂ邱Ƃ
 */
inline int CEditView::_MapAbsoluteXToClientX(int x, int nLineWidth) const {
	const int	nScrollOffset = m_scrollInfo.GetX() * m_pSharedData->layoutManager.GetAverageCharacterWidth();
	const int	nMarginWidth = GetLayoutSettings().GetSettings().nLeadMargin + GetLayoutSettings().GetVerticalRulerWidth();
	if(!GetLayoutSettings().GetSettings().bRightAlign)	// 
		return x + (nMarginWidth - nScrollOffset);
	else {	// E
		RECT	rcClient;
		GetClientRect(rcClient);
		return (rcClient.right - rcClient.left) - (nLineWidth - nScrollOffset) + x - nMarginWidth;
	}
}

/**
 *	NCAg x W CLineLayout::GetCaretPosition 瓾悤ȃLbgʒuɕϊ
 *	@param x			NCAgW
 *	@param nLineWidth	s̕
 *	@return				s̍[̈ʒuBlɂȂ邱Ƃ
 */
int CEditView::_MapClientXToAbsoluteX(int x, int nLineWidth) const {
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();
	const int	nMarginWidth = layout.nLeadMargin + layoutManager.GetVerticalRulerWidth();
	const int	nScrollOffset = m_scrollInfo.GetX() * layoutManager.GetAverageCharacterWidth();
	if(!layout.bRightAlign)
		return x - nMarginWidth + nScrollOffset;
	else {
		RECT	rcClient;
		GetClientRect(rcClient);
		return nLineWidth - (rcClient.right - rcClient.left - x - nMarginWidth) - nScrollOffset;
	}
}

/// @see	CLineLayoutManager::IEventListener::OnChangedBookmark
void CEditView::OnChangedBookmark(length_t iLine) {
	InvalidateLine(iLine);
}

/// @see	CLineLayoutManager::IEventListener::OnChangedLayout
void CEditView::OnChangedLayout() {
	if(!IsFreezed())
		UpdateScrollInfo(true, true);
	UpdateCaretPosition();
	UpdateGdiObjects();
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	_UpdateMemoryDeviceContext();
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	m_iFirstVisibleLine =
		m_pOriginalView->LogicalCharFromDisplayChar(CCharPos(m_scrollInfo.position.y, 0)).m_iLine;
	InvalidateLines(m_iFirstVisibleLine, -1);
	OnSelectionChanged(m_pSelection->GetRange(), m_pSelection->IsRectangle(), false);

	if(!IsFreezed()
			&& (HasFocus() || m_hWnd == CEditView::m_pCompletionWindow->GetSafeHwnd())) {
		RecreateCaret();
		UpdateCaretPosition();
		_FOR_EACH_LISTENERS()
			(*it)->OnMoveCaret(m_pSelection->GetActivePoint());
	}
}

/// @see	CLineLayoutManager::IEventListener::OnChangedMaximumWidthLine
void CEditView::OnChangedMaximumWidthLine() {
	UpdateScrollInfo(true, false);
}

/// @see	CLineLayoutManager::IEventListener::OnChangedTextAlignment
void CEditView::OnChangedTextAlignment() {
	const bool	bRightAlign = m_pSharedData->layoutManager.GetSettings().bRightAlign;
	ModifyStyleEx(
		bRightAlign ? WS_EX_RIGHTSCROLLBAR : WS_EX_LEFTSCROLLBAR,
		bRightAlign ? WS_EX_LEFTSCROLLBAR : WS_EX_RIGHTSCROLLBAR);
	SetScrollPos(SB_HORZ, _MapInternalXToScrollBoxX(m_scrollInfo.position.x));
}

/// @see	CLineLayoutManager::IEventListener::OnChangedTextDirection
void CEditView::OnChangedTextDirection() {
}

/// @see	CLineLayoutManager::IEventListener::OnChangedVerticalRulerWidth
void CEditView::OnChangedVerticalRulerWidth() {
	InvalidateRect(0, false);
	UpdateCaretPosition();
}

/// @see	CLineLayoutManager::IEventListener::OnClearedAllBookmarks
void CEditView::OnClearedAllBookmarks() {
	InvalidateLines(0, -1);
}

/// hLgꂽƂɌĂяo
void CEditView::OnDocumentClosed() {
	delete m_pSelection;
	m_pSelection = new _CSelection(*this);
	if(this == m_pOriginalView)
		m_pSharedData->layoutManager.ResetConfigurations();
	SetTextDirection(false);
}

/// hLgۑꂽɌĂяo
void CEditView::OnDocumentSaved() {
	InvalidateRect(0, false);
}

/// @see	CViewBase::OnDocumentSetup
void CEditView::OnDocumentSetup() {
	m_pSharedData->layoutManager.ReconstructAll();
	GetSelection().MoveTo(CCharPos(0, 0), true);
	_FOR_EACH_LISTENERS()
		(*it)->OnLoadFile();
	UpdateScrollInfo(true, true);
	UpdateCaretPosition();
	InvalidateRect(0, false);
}

/// @see	CViewBase::OnInitialUpdate
void CEditView::OnInitialUpdate() {
}

/// @see	CLineLayoutManager::IEventListener::OnQueryDeviceContext
CClientDC CEditView::OnQueryDeviceContext() {
	return GetDC();
}

/**
 *	IύXꂽƂ _CSelection CX^XĂяo
 *	@param oldRange			ړO͈̔
 *	@param bWasRectangle	ύXOɋ`ꍇ true
 *	@param bReveal			IɂȂ悤ɃXN[
 */
void CEditView::OnSelectionChanged(const CTextRange& oldRange, bool bWasRectangle, bool bReveal) {
	if(!IsWindowVisible())
		return;
	const CTextRange	newRange = m_pSelection->GetRange();
	bool				bChanged = false;

	// Lbg̒
	if(IsOvertypeMode())	RecreateCaret();
	else					UpdateCaretPosition();

	// I̋\̍ĕ`
	if(bWasRectangle || m_pSelection->IsRectangle()) {
		InvalidateLines(
			min(oldRange.GetTop(), newRange.GetTop()).m_iLine,
			max(oldRange.GetBottom(), newRange.GetBottom()).m_iLine);
		bChanged = true;
	} else if(newRange != oldRange) {	// {ɔ͈͂ω
		if(oldRange.IsEmpty()) {	// XI󂾂ꍇ
			if(!m_pSelection->IsEmpty()) {	// I쐬
				if(m_pSharedData->options.appearance[SHOW_CURRENT_UNDERLINE]
						&& (oldRange.m_pos1.m_iLine < newRange.GetTop().m_iLine
						|| oldRange.m_pos1.m_iLine > newRange.GetBottom().m_iLine)) {
					InvalidateLine(oldRange.m_pos1.m_iLine);
					if(!IsFreezed()) UpdateWindow();
				}
				InvalidateLines(newRange.GetTop().m_iLine, newRange.GetBottom().m_iLine);
			} else if(oldRange.GetBottom().m_iLine != newRange.GetBottom().m_iLine	// {͕\sɕϊKv...
					&& m_pSharedData->options.appearance[SHOW_CURRENT_UNDERLINE]) {
				InvalidateLine(newRange.m_pos1.m_iLine);
				if(!IsFreezed()) UpdateWindow();
				InvalidateLine(oldRange.m_pos1.m_iLine);
			}
		} else {	// XIꍇ
			if(newRange.IsEmpty()) {	// I
				InvalidateLines(oldRange.GetTop().m_iLine, oldRange.GetBottom().m_iLine);
				if(!IsFreezed()) UpdateWindow();
				if(m_pSharedData->options.appearance[SHOW_CURRENT_UNDERLINE]
						&& (newRange.m_pos1.m_iLine < oldRange.GetTop().m_iLine
						|| newRange.m_pos1.m_iLine > oldRange.GetBottom().m_iLine))
					InvalidateLine(newRange.m_pos1.m_iLine);
			} else if(oldRange.GetTop() == newRange.GetTop())	// n_Œ
				InvalidateLines(oldRange.GetBottom().m_iLine, newRange.GetBottom().m_iLine);
			else if(oldRange.GetBottom() == newRange.GetBottom())	// I_Œ
				InvalidateLines(oldRange.GetTop().m_iLine, newRange.GetTop().m_iLine);
			else {	// ω
				if((oldRange.GetTop().m_iLine >= newRange.GetTop().m_iLine
						&& oldRange.GetTop().m_iLine <= newRange.GetBottom().m_iLine)
						|| (oldRange.GetBottom().m_iLine >= newRange.GetTop().m_iLine
						&& oldRange.GetBottom().m_iLine <= newRange.GetBottom().m_iLine))
					InvalidateLines(
						min(oldRange.GetTop().m_iLine, newRange.GetTop().m_iLine),
						max(oldRange.GetBottom().m_iLine, newRange.GetBottom().m_iLine));
				else {
					InvalidateLines(oldRange.GetTop().m_iLine, oldRange.GetBottom().m_iLine);
					if(!IsFreezed()) UpdateWindow();
					InvalidateLines(newRange.GetTop().m_iLine, newRange.GetBottom().m_iLine);
				}
			}
		}
		bChanged = true;
	}

	if(bChanged) {
		// Ίʂ̋\
		CheckMatchBrackets();

		// Zk̓WJ҂ԂI
		if(m_modeState.bReadyToExpandAbbrev) {
			m_modeState.bReadyToExpandAbbrev = false;
			_FOR_EACH_LISTENERS()
				(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");
		}

		// ⊮𒆎~
		if(m_pCompletionWindow->IsWindowVisible()) {
			const CEditPoint&	caret = m_pSelection->GetActivePoint();
			const CTextRange	completionContext = m_pCompletionWindow->GetContextRange();
			if(caret < completionContext.GetTop() || caret > completionContext.GetBottom())
				CloseCompletionWindow();
		}
		
		// CxgXiɒʒm
		if(!IsFreezed()) {
			_FOR_EACH_LISTENERS()
				(*it)->OnMoveCaret(m_pSelection->GetActivePoint());
		}
	}

	if(bReveal)	// IɂȂ悤ɃXN[
		m_pSelection->GetActivePoint().Reveal(*this);
	if(m_bActiveImeComposition)	// IME œ͒̏ꍇ͕ҏWEBhËʒuC
		UpdateImeCompositionWindowPosition();
}

/**
 *	@brief	hLg̕ύX󂯎
 *
 *	hNX͂̃\bhI[o[ChłȂB
 *	 OnDocumentClosed AOnDocumentSaved I[o[ChƂ悢
 *	@param update	XVe
 *	@see			CViewBase::OnUpdate
 */
void CEditView::OnUpdate(const TDocumentUpdate& update) {
	const bool			bFocused = HasFocus();
	length_t			cModifiedLines = 0;
	CLineLayoutManager&	layout = m_pSharedData->layoutManager;

	if(update.summary == TDocumentUpdate::INSERT_OPERATION && this == m_pOriginalView) {	// } (update.posBegin == update.posEnd)
		if(m_incrementalSearcher.IsRunning())
			m_incrementalSearcher.AbortSearch();
		if(update.posEnd.m_iLine == update.posResult.m_iLine) {	// s܂܂ĂȂ
			if(layout.GetLineParseStage(update.posEnd.m_iLine) >= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				cModifiedLines = layout.ModifyLine(update.posEnd.m_iLine);
			if(cModifiedLines != 0) {
				_FOR_EACH_LISTENERS()
					(*it)->OnLineOperationEvent(IEditViewEventListener::LOE_MODIFIED, update.posEnd.m_iLine, cModifiedLines);
			}
		} else {	// s
			layout.InsertLines(update.posEnd.m_iLine + 1, update.posResult.m_iLine);
			if(layout.GetLineParseStage(update.posEnd.m_iLine) >= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				cModifiedLines = layout.ModifyLine(update.posEnd.m_iLine);
			_FOR_EACH_LISTENERS() {
				if(cModifiedLines != 0)
					(*it)->OnLineOperationEvent(IEditViewEventListener::LOE_MODIFIED, update.posEnd.m_iLine, cModifiedLines);
				(*it)->OnLineOperationEvent(IEditViewEventListener::LOE_CREATED, update.posEnd.m_iLine + 1,
					update.posResult.m_iLine - update.posEnd.m_iLine);
			}
			if(m_scrollInfo.position.y * m_scrollInfo.nVerticalRatio > update.posBegin.m_iLine)
				SetScrollPos(SB_VERT,
					m_scrollInfo.position.y += (update.posResult.m_iLine - update.posEnd.m_iLine) / m_scrollInfo.nVerticalRatio,
					!IsFreezed());
			if(IsFreezed()) {	// ̕`҂sƃXN[ʒu炷
				set<length_t>::iterator	it;
				for(it = m_freezeInfo.invalidLines.begin(); it != m_freezeInfo.invalidLines.end(); ++it) {
					if(*it >= update.posEnd.m_iLine)
						*it += update.posResult.m_iLine - update.posEnd.m_iLine;
				}
				if(m_freezeInfo.scrollPosition.y != -1
						&& static_cast<ulong>(m_freezeInfo.scrollPosition.y) >= update.posEnd.m_iLine)
					m_freezeInfo.scrollPosition.y += update.posResult.m_iLine - update.posEnd.m_iLine;
			}
			cModifiedLines = GetVisibleLineCount() /*- (update.posBegin.m_iLine - m_ptScroll.y) + 1*/;
		}
	} else if(update.summary == TDocumentUpdate::DELETE_OPERATION && this == m_pOriginalView) {	// 폜
		if(m_incrementalSearcher.IsRunning())
			m_incrementalSearcher.AbortSearch();
		if(update.posBegin.m_iLine == update.posEnd.m_iLine) {	// s܂܂ĂȂ
			if(layout.GetLineParseStage(update.posEnd.m_iLine) >= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				cModifiedLines = layout.ModifyLine(update.posEnd.m_iLine);
			if(cModifiedLines != 0) {
				_FOR_EACH_LISTENERS()
					(*it)->OnLineOperationEvent(IEditViewEventListener::LOE_MODIFIED, update.posEnd.m_iLine, cModifiedLines);
			}
		} else {	// s
			layout.DeleteLines(update.posBegin.m_iLine + 1, update.posEnd.m_iLine);
			if(layout.GetLineParseStage(update.posBegin.m_iLine) >= CLineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				cModifiedLines = layout.ModifyLine(update.posBegin.m_iLine);
			_FOR_EACH_LISTENERS() {
				if(cModifiedLines != 0)
					(*it)->OnLineOperationEvent(IEditViewEventListener::LOE_MODIFIED, update.posBegin.m_iLine, cModifiedLines);
				(*it)->OnLineOperationEvent(IEditViewEventListener::LOE_DELETED,
					update.posBegin.m_iLine + 1, update.posEnd.m_iLine - update.posBegin.m_iLine);
			}
			if(IsFreezed()) {	// ̕`҂sƃXN[ʒu炷
				set<length_t>::iterator	it = m_freezeInfo.invalidLines.begin();
				while(it != m_freezeInfo.invalidLines.end()) {
					if(*it > update.posBegin.m_iLine && *it <= update.posEnd.m_iLine)
						it = m_freezeInfo.invalidLines.erase(it);
					else {
						if(*it >= update.posEnd.m_iLine)
							*it -= update.posEnd.m_iLine - update.posBegin.m_iLine;
						++it;
					}
				}
				if(m_freezeInfo.scrollPosition.y != -1) {
					if(static_cast<ulong>(m_freezeInfo.scrollPosition.y) > update.posBegin.m_iLine
							&& static_cast<ulong>(m_freezeInfo.scrollPosition.y) <= update.posEnd.m_iLine)
						m_freezeInfo.scrollPosition.y = update.posBegin.m_iLine;
					else if(static_cast<ulong>(m_freezeInfo.scrollPosition.y) >= update.posEnd.m_iLine) {
						m_freezeInfo.scrollPosition.y -= update.posEnd.m_iLine - update.posBegin.m_iLine;
						m_freezeInfo.scrollPosition.y = max<long>(0, m_freezeInfo.scrollPosition.y);
					}
				}
			}
/*			if(bFocused && !m_bFreezed) {
				m_pAnchorPoint->MoveToPoint(update.posResult);
				m_pActivePoint->MoveToPoint(update.posResult);
				OnMoveCaret();
			}
*/			cModifiedLines = GetVisibleLineCount() /*- (update.posBegin.m_iLine - m_ptScroll.y) + 1*/;
		}
	} else if(update.summary == TDocumentUpdate::CLOSED) {	// hLgꂽ
		OnDocumentClosed();
		return;
	} else if(update.summary == TDocumentUpdate::SAVED) {	// hLg̕ۑ
		OnDocumentSaved();
		return;
	} else if(update.summary == TDocumentUpdate::BEGIN_UNDO_OPERATION) {
		Freeze();
		return;
	} else if(update.summary == TDocumentUpdate::END_UNDO_OPERATION) {
		if(update.posResult != CCharPos(-1, -1)) {
			UpdateScrollInfo(true, true);
			if(bFocused)
				GetSelection().MoveTo(update.posResult, true);
			CheckMatchBrackets();
		}
		Unfreeze();
		CloseCompletionWindow();
		return;
	} else if(update.summary == TDocumentUpdate::CHANGED_NARROWING) {
		if(GetDocument().IsNarrowed()) {
			OnHScroll(SB_SETPOS, _MapInternalXToScrollBoxX(m_scrollInfo.position.x), 0);
			OnVScroll(SB_SETPOS, m_scrollInfo.position.y, 0);
		}
		InvalidateRect(0, false);
		return;
	} else
		return;

	// XN[ʒȕC
	if(!IsFreezed())
		UpdateScrollInfo(true, true);
	if(update.posBegin.m_iLine < m_iFirstVisibleLine)	// 擪s̍XV
		m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_scrollInfo.position.y, 0)).m_iLine;

/*	if(m_pOriginalView != this) {
		InvalidateLine(m_pSelection->GetAnchorPoint().m_iLine);
		if(m_pSelection->GetAnchorPoint().GetLineNumber() != m_pSelection->GetActivePoint().GetLineNumber()) {
			UpdateWindow();
			InvalidateLine(m_pSelection->GetActivePoint().GetLineNumber());
		}
	}
*/	if((bFocused || CEditView::m_pCompletionWindow->HasFocus())
			&& !IsFreezed()
//			&& (pSender == this
//			|| pSender == m_pOriginalView
		/*	|| m_clones.find(reinterpret_cast<CEditView*>(pSender)) != m_clones.end())*/)
/*		GetSelection().MoveTo(update.posResult, true)*/;
	else if(!IsFreezed())
		OnSelectionChanged(m_pSelection->GetRange(), m_pSelection->IsRectangle(), false);

//	RecalcLeftTabWidth();
	if(m_pOriginalView == this) {
		if(cModifiedLines == 1) {
			InvalidateLine(update.posBegin.m_iLine);
//			if(!IsFreezed())
//				UpdateWindow();	// sƂ݂͂̕
			for(set<CEditView*>::iterator it = m_pClones->begin(); it != m_pClones->end(); ++it) {
				(*it)->InvalidateLine(update.posBegin.m_iLine);
//				(*it)->UpdateWindow();
			}
		} else {
			InvalidateLines(update.posBegin.m_iLine, -1);
			for(set<CEditView*>::iterator it = m_pClones->begin(); it != m_pClones->end(); ++it)
				(*it)->InvalidateLines(update.posBegin.m_iLine, -1);
		}
	}

	if(!IsFreezed() && (bFocused || CEditView::m_pCompletionWindow->HasFocus())) {
		UpdateCaretPosition();
		_FOR_EACH_LISTENERS()
			(*it)->OnMoveCaret(m_pSelection->GetActivePoint());
	}
}

/// ⊮EBhEJA⊮[hɓ
void CEditView::OpenCompletionWindow() {
	if(!m_pSelection->IsEmpty()) {	// Iꍇ͉邾
		GetSelection().MoveTo(static_cast<CCharPos>(m_pSelection->GetActivePoint()), true);
		return;
	} else if(GetDocument().IsReadOnly())
		return;

	// <<Iȓ>>
	// ӂ̍s环ʎqWĂ݂
	set<string_t>	candidateWords;
	const length_t	cRecogLines = 100;	// Ỏsl邩
	for(length_t iLine = (m_pSelection->GetActivePoint().GetLineNumber() > cRecogLines) ?
			m_pSelection->GetActivePoint().GetLineNumber() - cRecogLines : 0;
			iLine < m_pSelection->GetActivePoint().GetLineNumber(); ++iLine) {
		const Tokens&	tokens = m_pSharedData->layoutManager.GetLine(iLine).GetTokens();
		const string_t&	strLine = GetDocument().GetLine(iLine);
		for(size_t i = 0; i < tokens.count; ++i) {
			const CToken&	token = tokens.array[i];
			if(token.GetType() == TT_IDENTIFIER) {
				if(i < tokens.count - 1)
					candidateWords.insert(strLine.substr(token.GetIndex(),
						tokens.array[i + 1].GetIndex() - token.GetIndex()));
				else /* if(i == tokens.count - 1) */ {
					candidateWords.insert(strLine.substr(token.GetIndex()));
					break;
				}
			}
		}
	}
	// L[[hW
/*	const KeywordsMap&	keywords = GetLexer().GetKeywords();
	for(KeywordsMap::const_iterator it = keywords.begin(); it != keywords.end(); ++it) {
		for(KeywordSet::const_iterator itWords = it->second.begin(); itWords != it->second.end(); ++itWords)
			candidateWords.insert(*itWords);
	}
*/
	// ₪1ΏI
	if(candidateWords.empty()) {
		Beep();
		return;
	}

	// Jn
	m_pCompletionWindow->Start(candidateWords);

	if(m_pCompletionWindow->UpdateListCursel())	// ₪iꂽ -> EBhEoɕ⊮
		m_pCompletionWindow->Complete();
	else {
		// ʒu (܂sS)
		POINT	ptCaret;	// Lbgʒu
		CRect	rcClient;	// NCAg`
		RECT	rcList;		// ⊮EBhE̋`

		GetClientRect(rcClient);
		::GetCaretPos(&ptCaret);

		const int	nIdealWidth = 170;
		const int	nIdealHeight = rcClient.Height() / 3;

		// ʒuƕ
		if(!IsTextDirectionRightToLeft()) {	// LTR
			rcList.left = ptCaret.x;
			rcList.right = rcList.left + nIdealWidth;
			if(rcList.right > rcClient.right) {
				rcList.left = max(rcList.left - (rcList.right - rcClient.right), rcClient.left);
				rcList.right = rcClient.right;
			}
		} else {	// RTL
		}

		// ʒuƍ
		if(rcClient.bottom - (ptCaret.y + m_pSharedData->layoutManager.GetLineHeight()) >= nIdealHeight) {	// Lbg̉ɕ\
			rcList.top = ptCaret.y + m_pSharedData->layoutManager.GetLineHeight();
			rcList.bottom = rcList.top + nIdealHeight;
		} else if(ptCaret.y - rcClient.top >= nIdealHeight) {	// Lbg̏ɕ\
			rcList.top = ptCaret.y - nIdealHeight;
			rcList.bottom = ptCaret.y;
		} else if(rcClient.bottom - (ptCaret.y + m_pSharedData->layoutManager.GetLineHeight()) >= ptCaret.y - rcClient.top) {
			rcList.top = ptCaret.y + m_pSharedData->layoutManager.GetLineHeight();
			rcList.bottom = rcClient.bottom;
		} else {
			rcList.top = rcClient.top;
			rcList.bottom = ptCaret.y;
		}

		m_pCompletionWindow->MoveWindow(rcList, false);
		m_pCompletionWindow->SetFont(
			m_pSharedData->options.appearance[USE_EDITOR_FONT_FOR_COMPLETION] ?
				m_pSharedData->layoutManager.GetRegularFont() : 0);
		m_pCompletionWindow->ShowWindow(SW_SHOW);
	}
}

/**
 *	wʒũNCAgW擾
 *	@param col	_ʒu
 *	@return		NCAgW
 */
POINT CEditView::PosFromChar(const CCharPos& col) const {
	AssertValidAsWindow();
	POINT						pt;	// ߂l
	const length_t				iLine = min(col.m_iLine, GetDocument().GetLineCount() - 1);
	const CLineLayout&			lineLayout = m_pSharedData->layoutManager.GetLine(iLine);
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = GetLayoutSettings().GetSettings();
	length_t					iStart = 0;

	// ܂Ԃlꍇ
	if(layout.wrapMode != WPM_NONE) {
		const CCharPos					colDisplay = DisplayCharFromLogicalChar(col);
		const CLineLayout::WrapOffsets*	pWrapOffsets = lineLayout.GetWrapPoints();
		assert(pWrapOffsets != 0);
		const size_t	cWraps = pWrapOffsets->count;

		// y W̊m
		pt.y = layout.nTopMargin
				+ layoutManager.GetLineHeight() * (colDisplay.m_iLine - m_scrollInfo.GetY());
		if(cWraps != 0) {
			vector<length_t>::size_type	i;
			for(i = 0; i < cWraps && col.m_iChar > pWrapOffsets->array[i]; ++i)
				pt.y += layoutManager.GetLineHeight();
			if(i == cWraps)
				--i;
			iStart = (i != 0) ? pWrapOffsets->array[i - 1] : 0;
		}
		// x W̊m

	} else {
		// y W̊m
		pt.y = layout.nTopMargin + layoutManager.GetLineHeight() * (iLine - m_scrollInfo.GetY());

		// x W̊m
		pt.x = _MapAbsoluteXToClientX(
			lineLayout.GetCaretPosition(min(col.m_iChar, GetDocument().GetLineLength(iLine))),
			lineLayout.GetWidth());
	}

	return pt;
}

/// @see	IDropSource::QueryContinueDrag
STDMETHODIMP CEditView::QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState) {
	AssertValid();

	if(fEscapePressed || toBoolean(grfKeyState & MK_RBUTTON))	// LZ
		return DRAGDROP_S_CANCEL;
	if(!toBoolean(grfKeyState & MK_LBUTTON))	// hbv
		return DRAGDROP_S_DROP;

	return S_OK;
}

/**
 *	NeLXgɃJ[\ړƂɃ|bvAbveLXgԂ
 *	@param strUri	N URI
 *	@return			eLXgB󕶎񂾂ƃ|bvAbv͕\Ȃ
 */
string_t CEditView::QueryInvokableLinkMessage(const string_t& strUri) {
	return L"";
}

/**
 *	s`OɑOiFƔwiF₢킹
 *	@param iLine			_s
 *	@param bgColor, bgColor	[out] OiFƔwiFB-1ԂƒʏʂF (Ăяoɂ-1ZbgĂ)
 */
void CEditView::QueryLineColors(length_t iLine, COLORREF& fgColor, COLORREF& bgColor) {
}

/**
 *	@brief	r[̐ݒ񂩂Lbg쐬
 *
 *	r[tH[JXĂȂΉȂB쐬ꂽLbg͎Iɕ\
 */
void CEditView::RecreateCaret() {
	AssertValidAsWindow();

	if(!HasFocus())
		return;

	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const ushort	nCharHeight = layoutManager.GetLineHeight() - GetLayoutSettings().GetSettings().nLineSpan;
	const bool		bOvertype = m_modeState.bOvertype && m_pSelection->IsEmpty();
	
	::DestroyCaret();
	::DeleteObject(m_pSharedData->gdiObjects.hCaretBitmap);
	m_pSharedData->gdiObjects.hCaretBitmap = 0;

	if(!bOvertype)
		m_pSharedData->nCaretWidth = m_pSharedData->options.appearance[THIN_CARET] ? 1 : 2;
	else {	// ㏑[ĥƂ̓Lbg̕Ɠɂ
		const string_t&	strLine = GetDocument().GetLine(m_pSelection->GetActivePoint().GetLineNumber());
		const char_t*	pwszLine = strLine.data();

		if(m_pSelection->GetActivePoint().IsEndOfLine())	// s
			m_pSharedData->nCaretWidth = layoutManager.GetAverageCharacterWidth();
		else if(pwszLine[m_pSelection->GetActivePoint().GetCharNumber()] == L'\t') {	// ^u
			// ̃^u܂ރ̕𒲂ׂ
			const length_t				iChar = m_pSelection->GetActivePoint().GetCharNumber();
			const CLineLayout&			lineLayout = layoutManager.GetLine(m_pSelection->GetActivePoint().GetLineNumber());
			const CLineLayout::CRuns&	runs = lineLayout.GetRuns();
			bool						bLtr;
			for(size_t iRun = 0; iRun < runs.GetCount(); ++iRun) {
				if(iChar >= runs.GetAt(iRun).GetIndex()
						&& iChar < ((iRun < runs.GetCount() - 1) ? runs.GetAt(iRun + 1).GetIndex() : strLine.length())) {
					bLtr = !runs.GetAt(iRun).IsRightToLeft();
					break;
				}
			}

			// ̃^uʒu
			const ulong	x = lineLayout.GetCaretPosition(iChar);
			m_pSharedData->nCaretWidth = dif(x, layoutManager.GetNextTabStop(x, bLtr));
		} else {
			CDC&			dc = GetDC();
			HFONT			hOldFont = dc.SelectObject(layoutManager.GetRegularFont());
			const CCharPos	pos = m_pBoundarySearcher->SearchGraphemeBase(m_pSelection->GetActivePoint(), true);

			m_pSharedData->nCaretWidth = dc.GetTextExtent(
				pwszLine + m_pSelection->GetActivePoint().GetCharNumber(),
				pos.m_iChar - m_pSelection->GetActivePoint().GetCharNumber()).cx;
			dc.SelectObject(hOldFont);
		}
	}

	if(m_pSharedData->options.appearance[LOCALE_SPECIFIC_CARET_SHAPE]) {
		HIMC		hImc = ::ImmGetContext(m_hWnd);
		const bool	bImeOpened = toBoolean(::ImmGetOpenStatus(hImc));

		::ImmReleaseContext(m_hWnd, hImc);
		if(bImeOpened) {	// CJK and IME is open
			const RGBQUAD	red = {0xFF, 0xFF, 0x80, 0x00};
			m_pSharedData->gdiObjects.hCaretBitmap =
				_CreateSolidCaretBitmap(m_pSharedData->nCaretWidth, nCharHeight, red);
		} else if(!bOvertype && nCharHeight > 3) {
			const RGBQUAD	black = {0xFF, 0xFF, 0xFF, 0x00};
			const WORD	nLangId = PRIMARYLANGID(LOWORD(::GetKeyboardLayout(::GetCurrentThreadId())));

			if(nLangId == LANG_ARABIC || nLangId == LANG_FARSI
					|| nLangId == LANG_HEBREW || nLangId == LANG_SYRIAC || nLangId == LANG_URDU)	// RTL
				m_pSharedData->gdiObjects.hCaretBitmap =
					_CreateRtlCaretBitmap(nCharHeight, m_pSharedData->options.appearance[THIN_CARET], black);
			else if(nLangId == LANG_THAI /*|| nLangId == LANG_LAO*/)	// Thai relations
				m_pSharedData->gdiObjects.hCaretBitmap =
					_CreateThaiLaoCaretBitmap(nCharHeight, m_pSharedData->options.appearance[THIN_CARET], black);
		}
	}

	if(m_pSharedData->gdiObjects.hCaretBitmap == 0)
		CreateSolidCaret(m_pSharedData->nCaretWidth, nCharHeight);
	else
		CreateCaret(m_pSharedData->gdiObjects.hCaretBitmap, 0, 0);
	ShowCaret();
	UpdateCaretPosition();
}

/**
 *	@brief	Nbv{[h̃R[hy[W̐ݒ
 *
 *	Ascension ̓Nbv{[ȟ`ƂāAUTF-16 \ł CF_UNICODETEXT
 *	̎gpz肵ĂBNbv{[h̃f[^QƂۂ CF_UNICODETEXT
 *	`̃f[^΃lCeBuGR[h CF_TEXT ɎQƂB
 *	邢̓f[^ނƂ CF_UNICODETEXT łȂACF_TEXT `̃f[^ɏށB
 *	 CF_TEXT `̃eLXg̃GR[h́Aʏ̓VXe̊̃lCeBuR[hgp邪A
 *	̃\bhɂẴGR[h㏑邱Ƃł
 *	@param cp						R[hy[W
 *	@throw std::invalid_argument	<var>cp</var> sȂƂX[
 *	@see							CEditView::GetClipboardNativeCodePage
 */
void CEditView::SetClipboardNativeCodePage(Encodings::CodePage cp) throw(invalid_argument) {
}

/**
 *	AvP[V`l̐ݒ
 *	@param iLine	ݒs
 *	@param dwParam	AvP[V`l
 *	@param dwMask	}XNlB̃rbgɂe
 */
void CEditView::SetLineParam(length_t iLine, DWORD dwParam, DWORD dwMask /* = 0xFFFFFFFF */) {
	AssertValid();
	CLineLayout&	line = m_pSharedData->layoutManager.GetLine(iLine);
	DWORD			dwParam_ = line.GetUserDefinedValue();

	dwParam_ &= ~dwMask;
	dwParam_ |= (dwParam & dwMask);
	line.SetUserDefinedValue(dwParam_);
	if(IsWindowVisible())
		InvalidateLines(iLine, iLine);
}

/**
 *	ɓ͂镶̕ϊݒ肷
 *	@param variation	ϊ̎
 */
void CEditView::SetNextCharacterVariation(NextCharVariation variation) {
	AssertValid();
	m_nextCharVariation = variation;
}

/**
 *	̑̐ݒ
 *	@param options	ݒ
 */
void CEditView::SetOptions(TOptions& options) {
	AssertValid();

	const CLineLayout::ParseStage	parseStage = CLineLayout::PARSE_STAGE_UNPARSED;

	m_pSharedData->options = options;

	if(parseStage >= CLineLayout::PARSE_STAGE_TOKENS)
		m_pSharedData->layoutManager.Invalidate(parseStage);
	_FOR_EACH_CLONES() {
		if(it->IsWindow()) {
			if(it->HasFocus())
				it->RecreateCaret();
			it->InvalidateRect(0, false);
		}
	}
}

/**
 *	㏑[h̐ݒ
 *	@param bOvertype	true: ㏑Afalse: }
 */
void CEditView::SetOvertypeMode(bool bOvertype /* = true */) {
	AssertValid();

	m_modeState.bOvertype = bOvertype;
	RecreateCaret();
	if(IsWindow())
		SetFocus();
	_FOR_EACH_LISTENERS()
		(*it)->OnChangedOvertypeMode();
}

/**
 *	@brief	eLXg̐̕ݒ
 *
 *	̃\bh̓eLXg̕łȂAȉɂĂݒs
 *	<ul>
 *		<li>eLXg̈ʒu : LTR ̏ꍇ͍񂹁ARTL ̏ꍇ͉E</li>
 *		<li>XN[o[̈ʒu : LTR ̏ꍇ͉EARTL ̏ꍇ͍</li>
 *	</ul>
 *	@see	CEditView::IsTextDirectionRightToLeft
 */
void CEditView::SetTextDirection(bool bRightToLeft) {
	if(m_pSharedData->layoutManager.IsRtlSupported()) {
		TLayoutSettings	settings = m_pSharedData->layoutManager.GetSettings();
		settings.bRightToLeftReading = bRightToLeft;
		settings.bRightAlign = bRightToLeft;
		m_pSharedData->layoutManager.SetSettings(settings);
	}
}

/**
 *	J[\ʒuɃc[`bv\
 *	@param strText				\eLXgBCR+LF ŉsBNUL ͊܂߂Ȃ
 *	@param nTimeToWait			\܂ł̎ (~b)B-1ƃVXe
 *	@param nTimeRemainsVisible	\鎞 (~b)B-1ƃVXe
 */
void CEditView::ShowToolTip(const string_t& strText, ulong nTimeToWait /* = -1 */, ulong nTimeRemainsVisible /* = -1 */) {
	AssertValidAsWindow();

	delete[] m_pwszTipText;
	m_pwszTipText = new wchar_t[strText.length() + 1];
	HideToolTip();
	if(nTimeToWait == -1)
		nTimeToWait = ::GetDoubleClickTime();
	wcscpy(m_pwszTipText, strText.c_str());
	SetTimer(TIMERID_CALLTIP, nTimeToWait, 0);
}

#if 0
/**
 *	@brief	݃LbĝsX}[gCfg
 *
 *	<strong>Bgp֎~</strong>
 *
 *	̃\bh <var>ch</var> ̑}s (ۂɃX}[gCfgƂ̂)A
 *	̂Ƃɂ͑Ŝ̑삪 OCF_PREVENTALL ƂȂ悤ɏB
 *	݂̃\bh͈ꕔ̌łӖB
 *	̌ǉɂ̓|V[NXKvB
 *	X}[gCfg̋ ߂.txt ɂ܂Ƃ߂Ă
 *	@param ch	X}[gCfgs͕ (s L'\n' g)
 *	@return		X}[gCfgsǂ
 */
bool CEditView::SmartIndent(wchar_t ch) {
/*	AssertValidAsWindow();

	ulong	nNest = 1;	// ʂ̃lXgx

	if(ch == L'{' || ch == L'}') {	// '{' T
		if(m_posActive.iLine == 0)
			return false;
		if(-1 == FindBrace(m_posActive.iLine, L'{', nNest, m_posActive.iChar - 1)) {	// ݍsT
			for(length_t iLine = m_posActive.iLine - 1;	// skĒT
					m_posActive.iLine - iLine < m_modeState.cFindLimit; --iLine) {
				if(-1 != FindBrace(iLine, L'{', nNest))
					break;
				if(iLine == 0)
					break;
			}
			CEditDoc*		pDoc = GetDocument();
			const string_t&	strLine = pDoc->GetLine(iLine);
			length_t		cchIndent = IsWhiteSpace(strLine.data(), strLine.length(), true);
			string_t		strIndent = strLine.substr(0, cchIndent);

			strLine = pDoc->GetLine(m_posActive.iLine);
			length_t	cchIndentOld = IsWhiteSpace(strLine.data(), strLine.length(), true);
			if(ch == L'{') {
				strIndent.insert(0, L'\t');
				cchIndent += 1;
			}
			if(cchIndentOld != 0)
				pDoc->DeleteText(this,
					CCharPos(m_posActive.iLine, 0), CCharPos(m_posActive.iLine, cchIndentOld),
					static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));
			pDoc->InsertText(this, CCharPos(m_posActive.iLine, 0), strIndent,
				(cchIndentOld != 0) ? OCF_CONCATALL
				: static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));
			SetSelWithoutSelection(m_posActive.iLine, m_posActive.iChar + cchIndent - cchIndentOld);
			InsertText(string_t(&ch, 1),
				static_cast<OperationConcatenationFlag>(OCF_CONCATFORWARD | OCF_PREVENTCONCATBACKWARD));
			return true;
		}
	} else if(ch == L'\n') {	// O̍s𒲂ׂ
		const string_t&	strPrevLine = GetDocument()->GetLine(m_posActive.iLine).substr(0, m_posActive.iChar);
		length_t		cchPrevLine = strPrevLine.length();
		const char_t*	pwszPrevLine = strPrevLine.c_str();
		length_t		iChar = 0;					// ݈ʒu
		MCommentType	mct = m_pLineLayoutManager->FindByLineNumber(m_posActive.iLine)->m_mctFromPrev;
		bool			bMCommentContinued = mct != MCT_NOTCOMMENT;
		ulong			nBraceLevel = 0;			// ʂ̓qx
		ulong			nParenLevel = 0;			// ۊʂ̓qx
		bool			bLastIsSemicolon = false;	// ŌɒׂZ~R
		length_t		cchToken;					// g[N̒
		
		// ʂĂ邩AŌ̕𒲂ׂ
		while(iChar < cchPrevLine) {
			if(iChar == 0 && mct == MCT_1) {
				cchToken = IsMComment1(pwszPrevLine, cchPrevLine, bMCommentContinued);
				if(bMCommentContinued)
					break;
				bLastIsSemicolon = false;
				iChar += cchToken;
			} else if(iChar == 0 && mct == MCT_2) {
				cchToken = IsMComment2(pwszPrevLine, cchPrevLine, bMCommentContinued);
				if(bMCommentContinued)
					break;
				bLastIsSemicolon = false;
				iChar += cchToken;
			} else if(0 != IsSComment1(pwszPrevLine + iChar) || 0 != IsSComment2(pwszPrevLine + iChar))
				break;
			else if(0 != (cchToken = IsMComment1(pwszPrevLine + iChar, cchPrevLine - iChar, bMCommentContinued))
					|| 0 != (cchToken = IsMComment2(pwszPrevLine + iChar, cchPrevLine - iChar, bMCommentContinued))) {
				if(bMCommentContinued)
					break;
				iChar += cchToken;
				bLastIsSemicolon = false;
			} else if(0 != (cchToken = IsSingleQuotation(pwszPrevLine + iChar, cchPrevLine - iChar))
					|| 0 != (cchToken = IsDoubleQuotation(pwszPrevLine + iChar, cchPrevLine - iChar))) {
				iChar += cchToken;
				bLastIsSemicolon = false;
			} else if(0 != (cchToken = IsWhiteSpace(pwszPrevLine + iChar, cchPrevLine - iChar, true)))
				iChar += cchToken;
			else {	// ̑̕
				wchar_t	wch = *(pwszPrevLine + iChar);
				if(wch == L';')
					bLastIsSemicolon = true;
				else {
					bLastIsSemicolon = false;
					if(wch == L'{')								++nBraceLevel;
					else if(wch == L'(')						++nParenLevel;
					else if(wch == L'}' && nBraceLevel != 0)	--nBraceLevel;
					else if(wch == L')' && nParenLevel != 0)	--nParenLevel;
				}
				++iChar;
			}
		}

		// X}[gCfg邩?
		length_t	cchIndentOld = IsWhiteSpace(strPrevLine.c_str(), cchPrevLine, true);
		if((nBraceLevel != 0 || nParenLevel != 0)
				|| (!bLastIsSemicolon && cchIndentOld != 0)) {
			ReplaceSel(CEditDoc::m_arrBreakStrings[GetDocument()->GetBreakType()],
				static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));

			length_t		iCharOrg = m_posActive.iChar;
			CEditDoc*		pDoc = GetDocument();
			const string_t&	strCurrentLine = pDoc->GetLine(m_posActive.iLine);
			length_t		cchIndent = IsWhiteSpace(strCurrentLine.c_str(), strCurrentLine.length(), true);
			string_t		strIndent = L"\t" + strPrevLine.substr(0, cchIndentOld);

			pDoc->DeleteText(this, m_posActive, CCharPos(m_posActive.iLine, cchIndent), OCF_CONCATALL);
			InsertText(strIndent,
				static_cast<OperationConcatenationFlag>(OCF_CONCATFORWARD | OCF_PREVENTCONCATBACKWARD));
			SetSelWithoutSelection(m_posActive.iLine, iCharOrg);
			return true;
		}
	}
*/
	return false;
}
#endif /* 0 */

/// Unfreeze ̖{
void CEditView::_Unfreeze() {
	AssertValidAsWindow();

	if(!m_freezeInfo.invalidLines.empty()) {
		length_t		iAnchor = -1;
		const length_t	cVisibleLines = GetVisibleLineCount();

//		RecalcLeftTabWidth();
		for(ulong i = m_scrollInfo.position.y; i <= m_scrollInfo.position.y + cVisibleLines; ++i) {
			set<length_t>::iterator	it = m_freezeInfo.invalidLines.find(i);

			if(it != m_freezeInfo.invalidLines.end()) {
				m_freezeInfo.invalidLines.erase(it);
				if(iAnchor == -1)
					iAnchor = i;
			} else if(iAnchor != -1) {
				InvalidateLines(iAnchor, i - 1);
				iAnchor = -1;
			}
		}
		if(iAnchor != -1)
			InvalidateLines(iAnchor, m_scrollInfo.position.y + cVisibleLines);
		m_freezeInfo.invalidLines.clear();
	}
	UpdateScrollInfo(true, true);
	if(m_freezeInfo.scrollPosition.x != -1)
		OnHScroll(SB_SETPOS, _MapInternalXToScrollBoxX(m_freezeInfo.scrollPosition.x), 0);
	if(m_freezeInfo.scrollPosition.y != -1)
		OnVScroll(SB_SETPOS, m_freezeInfo.scrollPosition.y, 0);
	m_freezeInfo.scrollPosition.x = m_freezeInfo.scrollPosition.y = -1;
	OnSelectionChanged(m_pSelection->GetRange(), m_pSelection->IsRectangle(), false);
	_FOR_EACH_LISTENERS()									// ̑Oňʒu
		(*it)->OnMoveCaret(m_pSelection->GetActivePoint());	// OnSelectionChanged ŒʒmȂ̂
	UpdateWindow();
}

/// `̓
/// @see	CEditView::Freeze, CEditView::IsFreezed
void CEditView::Unfreeze() {
	AssertValidAsWindow();
	_FOR_EACH_CLONES() {
		if(it->m_freezeInfo.nCount > 0) {
			if(--it->m_freezeInfo.nCount == 0)
				it->_Unfreeze();
		}
	}
}

/// ݂̐ݒg GDI IuWFNgXV
void CEditView::UpdateGdiObjects() {
	const CLayoutSettings&	layoutManager = GetLayoutSettings();
	const TLayoutSettings&	layout = layoutManager.GetSettings();

	::DeleteObject(m_pSharedData->gdiObjects.hCaretLinePen);
	::DeleteObject(m_pSharedData->gdiObjects.hIACaretLinePen);
	::DeleteObject(m_pSharedData->gdiObjects.hLeftIndicatorPen);
	::DeleteObject(m_pSharedData->gdiObjects.hLineNumberPen);

	m_pSharedData->gdiObjects.hCaretLinePen = ::CreatePen(PS_SOLID, 1,
		(layout.caretLineColor != -1) ? layout.caretLineColor : ::GetSysColor(COLOR_HIGHLIGHT));
	m_pSharedData->gdiObjects.hIACaretLinePen = ::CreatePen(PS_SOLID, 1,
		(layout.inactiveCaretLineColor != -1) ? layout.inactiveCaretLineColor : ::GetSysColor(COLOR_INACTIVECAPTION));
	m_pSharedData->gdiObjects.hLeftIndicatorPen =
		::CreatePen(PS_SOLID, 1, layoutManager.GetTokenFoundation(ETT_INDICATOR_MARGIN, NullCookie).fgColor);

	// sԍ̋؂`y
	if(layout.lineNumberLayout.bShowLineNumbers) {
		if(layout.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_NONE
				|| layout.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_SOLID)	// 
			m_pSharedData->gdiObjects.hLineNumberPen =
				::CreatePen(PS_SOLID, layout.lineNumberLayout.nBorderWidth,
					layoutManager.GetTokenFoundation(ETT_LINENUMBER, NullCookie).fgColor);
		else {
			LOGBRUSH	lb;
			lb.lbColor = layoutManager.GetTokenFoundation(ETT_LINENUMBER, NullCookie).fgColor;
			lb.lbStyle = BS_SOLID;
			if(layout.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_DASHED)	// j
				m_pSharedData->gdiObjects.hLineNumberPen =
					::ExtCreatePen(PS_GEOMETRIC | PS_DASH | PS_ENDCAP_FLAT,
						layout.lineNumberLayout.nBorderWidth, &lb, 0, 0);
			else if(layout.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_DASHED_ROUNDED)	// ۔j
				m_pSharedData->gdiObjects.hLineNumberPen =
					::ExtCreatePen(PS_GEOMETRIC | PS_DASH | PS_ENDCAP_ROUND,
						layout.lineNumberLayout.nBorderWidth, &lb, 0, 0);
			else if(layout.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_DOTTED)	// _
				m_pSharedData->gdiObjects.hLineNumberPen =
					::ExtCreatePen(PS_GEOMETRIC | PS_DOT, layout.lineNumberLayout.nBorderWidth, &lb, 0, 0);
		}
	}
}

#ifndef ASCENSION_NO_DOUBLE_BUFFERING
/// 1`p̌݊foCXReLXg̍XV
void CEditView::_UpdateMemoryDeviceContext() {
	if(m_memDC.GetSafeHdc() == 0)	// ܂łĂȂ...
		return;

	BITMAP	bitmap;
	bool	bNeedRecreate = false;
	RECT	rect;

	GetClientRect(rect);
	if(::GetObject(m_hLineBitmap, sizeof(BITMAP), &bitmap) != 0) {
		if(bitmap.bmWidth < rect.right - rect.left	// ̃rbg}bvꍇ
				|| bitmap.bmHeight < m_pSharedData->layoutManager.GetLineHeight())
			bNeedRecreate = true;
		else if(bitmap.bmWidth / 2 > rect.right - rect.left	// ̃rbg}bv傫ꍇ
				|| bitmap.bmHeight / 2 > m_pSharedData->layoutManager.GetLineHeight())
			bNeedRecreate = true;
	} else
		bNeedRecreate = true;

	if(bNeedRecreate) {
		m_memDC.SelectObject(m_hOldLineBitmap);
		::DeleteObject(m_hLineBitmap);
		m_hLineBitmap = ::CreateCompatibleBitmap(GetDC().GetSafeHdc(),
			rect.right - rect.left + 20, m_pSharedData->layoutManager.GetLineHeight());	// 傫߂...
		m_memDC.SelectObject(m_hLineBitmap);
	}
}
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

/// ݈ʒuƃXN[󋵁AtHgȂǂLbgK؂ȈʒuɈړ
void CEditView::UpdateCaretPosition() {
	if(!HasFocus() || IsFreezed())
		return;

	POINT	pt = PosFromChar(m_pSelection->GetActivePoint());
	const CLineLayoutManager&	layout = m_pSharedData->layoutManager;

	// LbguBv
	if(pt.y < static_cast<long>(layout.GetSettings().nTopMargin))
		pt.y = -static_cast<long>(layout.GetLineHeight());
	else if(!layout.GetSettings().bRightAlign
			&& pt.x < static_cast<long>(layout.GetVerticalRulerWidth() + layout.GetSettings().nLeadMargin))
		pt.x = -static_cast<long>(layout.GetAverageCharacterWidth());
	else if(layout.GetSettings().bRightAlign) {
		RECT	rcClient;
		GetClientRect(rcClient);
		if(pt.x > rcClient.right - static_cast<long>(layout.GetVerticalRulerWidth() + layout.GetSettings().nLeadMargin))
			pt.x = -static_cast<long>(layout.GetAverageCharacterWidth());
	}

	if(!m_modeState.bOvertype || !m_pSelection->IsEmpty()) {
		--pt.x;
		if(m_pSharedData->options.appearance[LOCALE_SPECIFIC_CARET_SHAPE]) {
			// RTL Lbg̓zbgX|bgĂ (CEditView::RecreateCaret  _CreateRtlCaretBitmap Q)
			const WORD	nLangId = PRIMARYLANGID(LOWORD(::GetKeyboardLayout(::GetCurrentThreadId())));
			if(nLangId == LANG_ARABIC || nLangId == LANG_FARSI
					|| nLangId == LANG_HEBREW || nLangId == LANG_SYRIAC || nLangId == LANG_URDU)
				pt.x -= 3;
		}
	} else {
		const CCharPos				caret = m_pSelection->GetActivePoint();
		const CLineLayout::CRuns&	runs = layout.GetLine(caret.m_iLine).GetRuns();
		for(size_t i = 0; ; ++i) {
			if(i == runs.GetCount() - 1
					|| caret.m_iChar >= runs.GetAt(i).GetIndex() && caret.m_iChar < runs.GetAt(i + 1).GetIndex()) {
				if(runs.GetAt(i).IsRightToLeft())
					pt.x -= m_pSharedData->nCaretWidth;
				break;
			}
		}
	}
	SetCaretPos(pt);
}

/// IME tH[𐳂ʒuɈړ
void CEditView::UpdateImeCompositionWindowPosition() {
	AssertValidAsWindow();
	if(!m_bActiveImeComposition)
		return;

	COMPOSITIONFORM	cf;
	HIMC			hIMC = ::ImmGetContext(m_hWnd);

	if(hIMC != 0) {
		cf.dwStyle = CFS_POINT;
		cf.ptCurrentPos = PosFromChar(m_pSelection->GetStartPoint());
	//	cf.ptCurrentPos.x -= 1;
		cf.ptCurrentPos.y -= 1;
		::ImmSetCompositionWindow(hIMC, &cf);
		::ImmReleaseContext(m_hWnd, hIMC);
	}
}

/**
 *	AXN[o[̏XV
 *	@param bHorizontal	XN[o[XVꍇ true
 *	@param bVertical	XN[o[XVꍇ true
 */
void CEditView::UpdateScrollInfo(bool bHorizontal, bool bVertical) {
	AssertValidAsWindow();

	const CEditDoc&				document = GetDocument();
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = GetLayoutSettings().GetSettings();
	AutoZeroCB<SCROLLINFO>		scroll;
	const length_t				cLines = GetDisplayLineCount();

	scroll.fMask = SIF_DISABLENOSCROLL | SIF_PAGE | SIF_RANGE;

	// XN[o[
	if(bVertical) {
		m_scrollInfo.nVerticalRatio = cLines / numeric_limits<int>::max() + 1;
		assert(m_scrollInfo.nVerticalRatio != 0);
		scroll.nMax = cLines / m_scrollInfo.nVerticalRatio - 1;
		scroll.nPage = GetVisibleLineCount();

		// XN[o[ȂOɏ[ɃXN[...
		if((scroll.nMax - scroll.nMin) * m_scrollInfo.nVerticalRatio <= scroll.nPage) {
			OnVScroll(SB_TOP, 0, 0);
			InvalidateLines(0, -1);
			UpdateCaretPosition();
		}
		SetScrollInfo(SB_VERT, scroll, true);
	}

	// XN[o[
	if(bHorizontal) {
		assert(layoutManager.GetAverageCharacterWidth() != 0);
		const ulong	nMaxPixelLength = (layout.wrapMode == WPM_NONE) ?
			layoutManager.GetMaxDisplayWidth() / layoutManager.GetAverageCharacterWidth() : 0;
		m_scrollInfo.nHorizontalRatio = nMaxPixelLength / numeric_limits<int>::max() + 1;
		assert(m_scrollInfo.nHorizontalRatio != 0);
		scroll.nMax = nMaxPixelLength / m_scrollInfo.nHorizontalRatio;
		scroll.nPage = GetVisibleCharCount();
		if(layout.bRightAlign && GetScrollPos(SB_HORZ) != _MapInternalXToScrollBoxX(m_scrollInfo.position.x)) {
			scroll.fMask |= SIF_POS;
			scroll.nPos = _MapInternalXToScrollBoxX(m_scrollInfo.position.x);
		}

		// XN[o[ȂOɍ[ (E[) ɃXN[...
		if((scroll.nMax - scroll.nMin) * m_scrollInfo.nHorizontalRatio <= scroll.nPage) {
			OnHScroll(SB_LEFT, _MapInternalXToScrollBoxX(0), 0);
			InvalidateLines(0, -1);
			UpdateCaretPosition();
		}
		SetScrollInfo(SB_HORZ, scroll, true);
	}
}

/// sI̊Jn
/// @see	_CSelection::BeginWordSelection, _CSelection::GetLineSelectionAnchorLine
void CEditView::_CSelection::BeginLineSelection() {
	m_iTemporaryAnchorLine = m_pAnchorPoint->GetLineNumber();
}

/// PI̊Jn
/// @see	_CSelection::BeginLineSelectionAnchorLine, _CSelection::GetWordSelectionOriginalWord
void CEditView::_CSelection::BeginWordSelection() {
	m_iTemporaryAnchorLine = m_pActivePoint->GetLineNumber();
	m_iWordSelectionChars[0] = m_pAnchorPoint->GetCharNumber();
	m_iWordSelectionChars[1] = m_pActivePoint->GetCharNumber();
}

/// @see	CSelection::Copy
void CEditView::_CSelection::Copy(bool bAlsoSendToClipboardRing) {
	if(IsEmpty())
		return;

	CWaitCursor		wc;
	const string_t	str = GetText();

	if(!IsRectangle())
		CClipboard::SetClipboardText(m_view, str.data(), str.length());
	else {
		if(!toBoolean(::OpenClipboard(m_view)))
			return;

		HGLOBAL	hGlobal = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, (str.length() + 1) * sizeof(char_t));
		char*	pszData = reinterpret_cast<char*>(::GlobalLock(hGlobal));

		::WideCharToMultiByte(CP_ACP, 0, str.c_str(), str.length() + 1, pszData, (str.length() + 1) * 2, 0, 0);
		::GlobalUnlock(hGlobal);
		::SetClipboardData(CF_TEXT, hGlobal);

		char_t*	pwszSelection = reinterpret_cast<char_t*>(::GlobalLock(hGlobal));
		wcscpy(pwszSelection, str.c_str());
		::GlobalUnlock(hGlobal);
		::SetClipboardData(CF_UNICODETEXT, hGlobal);

		if(const UINT nClipFormat = ::RegisterClipboardFormat(RECTANGLE_TEXT_CLIP_FORMAT)) {
			hGlobal = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, 1);
			pszData = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			pszData[0] = 0;
			::GlobalUnlock(hGlobal);
			::SetClipboardData(nClipFormat, hGlobal);
		}
		::CloseClipboard();
	}

	// Nbv{[hOɂ]
	if(bAlsoSendToClipboardRing)
		m_view.GetClipboardRing().Add(str, IsRectangle());
}

/// @see	CSelection::Cut
void CEditView::_CSelection::Cut(bool bAlsoSendToClipboardRing) {
	if(m_view.GetDocument().IsReadOnly())
		return;
	m_view.CloseCompletionWindow();
	Copy(bAlsoSendToClipboardRing);
	m_view.Freeze();
	m_view.GetDocument().BeginEditCollection();
	Delete();
	m_view.GetDocument().EndEditCollection();
	m_view.Unfreeze();
}

/// @see	CSelection::Delete
/// ̃\bh͕`̓AhDO[v̍쐬sȂ
void CEditView::_CSelection::Delete() {
	CEditDoc&	document = m_view.GetDocument();
	if(document.IsReadOnly() || IsEmpty())
		return;

	if(!IsRectangle())	// `
		MoveTo(document.DeleteText(*m_pAnchorPoint, *m_pActivePoint), true);
	else {	// `
		const length_t	iTopLine = GetStartPoint().GetLineNumber();
		const length_t	iBottomLine = GetEndPoint().GetLineNumber();
		CCharPos		posResult;

		for(length_t iLine = iTopLine; iLine <= iBottomLine; ++iLine)
			posResult = document.DeleteText(
				CCharPos(iLine, m_view._MapAbsoluteXToCharacter(iLine,
					min(m_xBoxSelectionAnchor, m_xBoxSelectionActive),
					!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE])),
				CCharPos(iLine, m_view._MapAbsoluteXToCharacter(iLine,
					max(m_xBoxSelectionAnchor, m_xBoxSelectionActive),
					!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE])));
		CSelection::MoveTo(posResult, true);
	}
	m_view.SetNextCharacterVariation(NCV_NONE);	// ɖ߂
}

/**
 *	sIJnɑIĂsԍԂ
 *	@return	ϗsԍ
 *	@see	_CSelection::BeginLineSelectionAnchorLine, _CSelection::GetWordSelectionOriginalWord
 */
length_t CEditView::_CSelection::GetLineSelectionOriginalLine() const {
	return m_iTemporaryAnchorLine;
}

/// @see	CSelection::GetRangeOnLine
void CEditView::_CSelection::GetRangeOnLine(length_t iLine, length_t* piStart, length_t* piEnd) const {
	if(IsEmpty()) {
		if(piStart != 0)	*piStart = -1;
		if(piEnd != 0)		*piEnd = -1;
	} else if(!IsRectangle()) {	// `
		if(piStart != 0) {
			if(iLine == GetStartPoint().GetLineNumber())
				*piStart = GetStartPoint().GetCharNumber();
			else
				*piStart = (iLine < GetStartPoint().GetLineNumber()) ? -1 : 0;
		}
		if(piEnd != 0) {
			if(iLine == GetEndPoint().GetLineNumber())
				*piEnd = GetEndPoint().GetCharNumber();
			else
				*piEnd = (iLine < GetEndPoint().GetLineNumber()) ? -1 : 0;
		}
	} else {	// `
		if(iLine >= GetStartPoint().GetLineNumber() && iLine <= GetEndPoint().GetLineNumber()) {
			if(piStart != 0)
				*piStart = m_view._MapAbsoluteXToCharacter(iLine, m_xBoxSelectionAnchor,
					!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
			if(piEnd != 0)
				*piEnd = m_view._MapAbsoluteXToCharacter(iLine, m_xBoxSelectionActive,
					!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
		} else {
			if(piStart != 0)	*piStart = 0;
			if(piEnd != 0)		*piEnd = 0;
		}
	}
}

/// @see	CSelection::GetText
string_t CEditView::_CSelection::GetText() const {
	if(IsEmpty())
		return L"";

	wostringstream	ssSelection;
	const CEditDoc&	document = m_view.GetDocument();
	const CCharPos	posTop = GetStartPoint();
	const CCharPos	posBottom = GetEndPoint();
	length_t		iLine = posTop.m_iLine;

	if(!IsRectangle()) {	// `IłȂꍇ
		if(posTop.m_iLine == posBottom.m_iLine)	// I1s̏ꍇ
			return document.GetLine(posTop.m_iLine).substr(posTop.m_iChar, posBottom.m_iChar - posTop.m_iChar);
		else {								// I2sȏ̏ꍇ
			CEditDoc::LineIterator	itLines = document.GetLineIterator(iLine);
			while(true) {	// I𒆂̊es1̕ɂȂ
				if(iLine == posTop.m_iLine)		// IJns
					ssSelection << itLines->GetLine().substr(posTop.m_iChar);
				else if(iLine == posBottom.m_iLine) {	// IIs
					ssSelection << itLines->GetLine().substr(0, posBottom.m_iChar);
					break;
				} else
					ssSelection << document.GetLine(iLine);
				ssSelection << CEditDoc::GetLineBreakString(itLines->GetLineBreak());
				++iLine;
				++itLines;
			}
		}
	} else {	// `Ȉꍇ
		CEditDoc::LineIterator	itLines = document.GetLineIterator(iLine);
		const ulong	xLeft = min(m_xBoxSelectionAnchor, m_xBoxSelectionActive);
		const ulong	xRight = max(m_xBoxSelectionAnchor, m_xBoxSelectionActive);
		length_t	iBegin;

		while(true) {
			iBegin = m_view._MapAbsoluteXToCharacter(iLine, xLeft,
				!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
			ssSelection << itLines->GetLine().substr(iBegin,
				m_view._MapAbsoluteXToCharacter(iLine, xRight,
					!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]) - iBegin);
			ssSelection << CEditDoc::GetLineBreakString(itLines->GetLineBreak());
			if(iLine == posBottom.m_iLine)
				break;
			++iLine;
			++itLines;
		}
	}

	return ssSelection.str();
}

/**
 *	PIJnɑIĂP̈ʒuԂ
 *	@param word	[out] P͈̔
 *	@see		_CSelection::BeginWordSelection, _CSelection::GetLineSelectionOriginalLine
 */
void CEditView::_CSelection::GetWordSelectionOriginalWord(CTextRange& word) const {
	word.m_pos1 = CCharPos(m_iTemporaryAnchorLine, m_iWordSelectionChars[0]);
	word.m_pos2 = CCharPos(m_iTemporaryAnchorLine, m_iWordSelectionChars[1]);
}

/// @see	CSelection::IsPointOver
bool CEditView::_CSelection::IsPointOver(const POINT& pt) const {
	assert(m_view.IsWindow());

	const CLineLayoutManager&	layoutManager = m_view.m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = m_view.GetLayoutSettings().GetSettings();
	const HitTestResult			htr = m_view.HitTest(pt);

	// IA}[WłΖ
	if(IsEmpty() || htr != HTR_TEXT)
		return false;

	RECT	rect;

	m_view.GetClientRect(rect);
	if(pt.x > rect.right || pt.y > rect.bottom)
		return false;
	
	const CCharPos	pos = m_view.CharFromPos(pt,
		!m_view.m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);

	if(!IsRectangle())	// `
		return GetStartPoint().GetPosition() <= pos && GetEndPoint().GetPosition() >= pos;
	else {	// `
		const int		xView = m_view._MapClientXToAbsoluteX(pt.x, layoutManager.GetLine(pos.m_iLine).GetWidth());
		const length_t	iDisplayLine =
			m_view.m_scrollInfo.GetY() + (pt.y - layout.nTopMargin) / layoutManager.GetLineHeight();
		return xView >= min(m_xBoxSelectionAnchor, m_xBoxSelectionActive)
			&& xView <= max(m_xBoxSelectionAnchor, m_xBoxSelectionActive)
			&& iDisplayLine >= min(m_iTemporaryAnchorLine, m_iBoxSelectionActiveLine)
			&& iDisplayLine <= max(m_iTemporaryAnchorLine, m_iBoxSelectionActiveLine);
	}
}

/// @see	CEditPoint::IEventListener::OnEditPointMoved
void CEditView::_CSelection::OnEditPointMoved(const CEditPoint& self, const CCharPos& oldPosition) {
	// self ̓ANeBu|Cg (RXgN^Q)

	if(m_bIgnoreActiveMovement)
		m_bIgnoreActiveMovement = false;
	else {
		const CCharPos	oldAnchor = *m_pAnchorPoint;
		if(m_bSynchronizeAnchorWithActive) {
			m_bSynchronizeAnchorWithActive = false;
			m_pAnchorPoint->MoveTo(*m_pActivePoint);
		}
		UpdateRectangleRegion();
		m_view.OnSelectionChanged(CTextRange(oldAnchor, oldPosition), IsRectangle(), &self == m_pActivePoint);
	}
}

/// @see	CSelection::Paste
void CEditView::_CSelection::Paste(bool bFromClipboardRing) {
	if(m_view.GetDocument().IsReadOnly()
			|| (bFromClipboardRing && m_view.GetClipboardRing().GetCount() == 0))
		return;

	m_view.CloseCompletionWindow();
	m_view.GetDocument().BeginEditCollection();	// `\t͕XebvɂȂ\
	m_view.Freeze();

	if(!bFromClipboardRing) {
		m_pActivePoint->Paste(*m_pAnchorPoint);
		CSelection::MoveTo(*m_pActivePoint, true);
	} else {
		string_t					str;
		bool						bIsBox;
		CClipboardRing::SizeType	iActiveItem = m_view.GetClipboardRing().GetActiveItem();

		if(toBoolean(m_type & PASTING_FROM_CLIPBOARD_RING)
				&& ++iActiveItem == m_view.GetClipboardRing().GetCount())
			iActiveItem = 0;
		m_view.GetClipboardRing().GetText(iActiveItem, str, bIsBox);
		m_view.GetClipboardRing().SetActiveItem(iActiveItem);
		if(!IsEmpty()) {
			if(toBoolean(m_type & PASTING_FROM_CLIPBOARD_RING))
				m_view.GetDocument().Undo();
			Delete();
		}
		if(!bIsBox)
			m_pActivePoint->Insert(str);
		else
			m_pActivePoint->InsertBox(str);
		m_type = static_cast<_Type>(m_type | PASTING_FROM_CLIPBOARD_RING);
	}
	m_view.GetDocument().EndEditCollection();
	m_view.Unfreeze();
}

/**
 *	@brief	IeLXg̒u
 *
 *	̃\bh̓AhDO[v쐬ALbgɂȂ悤Ƀr[XN[
 *	@see	CSelection::Replace
 */
void CEditView::_CSelection::Replace(const char_t* first, const char_t* last, bool bRectangleInsertion /* = false */) {
	if(m_view.GetDocument().IsReadOnly())
		return;
	m_view.m_nextCharVariation = NCV_NONE;
	m_view.GetDocument().BeginEditCollection();
	m_view.Freeze();
	if(!IsEmpty())
		Delete();
	if(bRectangleInsertion)
		m_pActivePoint->InsertBox(first, last);
	else
		m_pActivePoint->Insert(first, last);
	m_view.Unfreeze();
	m_view.GetDocument().EndEditCollection();
}

/// @see	CSelection::Select
void CEditView::_CSelection::Select(
		const CCharPos& anchorPosition, const CCharPos& activePosition, bool bRectangle, bool bReveal) {
	if(anchorPosition != *m_pAnchorPoint
			|| activePosition != *m_pActivePoint
			|| bRectangle != IsRectangle()
			|| bReveal) {
		const CTextRange	oldRange(*m_pAnchorPoint, *m_pActivePoint);
		const bool			bWasRectangle = IsRectangle();
		m_bIgnoreActiveMovement = true;
		m_pAnchorPoint->MoveTo(anchorPosition);
		m_pActivePoint->MoveTo(activePosition);
		m_bIgnoreActiveMovement = false;	// Ăяo (OnEditPointMoved) ŎIɌɖ߂Ȃꍇ
		m_type = bRectangle ? _CSelection::RECTANGLE : _CSelection::LINEAR;
		UpdateRectangleRegion();
		m_view.OnSelectionChanged(oldRange, bWasRectangle, bReveal);
	}
}

/// `I͈̔͂XV (̃\bh CEditView::OnSelectionChanged ĂяoȂ)
void CEditView::_CSelection::UpdateRectangleRegion() {
	if(IsRectangle()) {
		m_iTemporaryAnchorLine = m_view.DisplayLineFromLogicalLine(m_pAnchorPoint->GetLineNumber());
		m_iBoxSelectionActiveLine = m_view.DisplayLineFromLogicalLine(m_pActivePoint->GetLineNumber());
		m_xBoxSelectionAnchor = m_view.m_pSharedData->layoutManager.GetLine(
			m_pAnchorPoint->GetLineNumber()).GetCaretPosition(m_pAnchorPoint->GetCharNumber());
		m_xBoxSelectionActive = m_view.m_pSharedData->layoutManager.GetLine(
			m_pActivePoint->GetLineNumber()).GetCaretPosition(m_pActivePoint->GetCharNumber());
	}
}

/* [EOF] */